;;;; -*- Mode:LISP; Syntax: COMMON-LISP; Package:GBB; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]QUEUE.LISP *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:47:39; Edited-By: Cork *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *         QUEUE-UNIT DEFINITION and QUEUE MANIPULATION FUNCTIONS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  07-20-88 Queue manipulation functions moved from SIMPLE-SHELL.LISP.
;;;           (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(provide "GBB QUEUE-UNIT")

(in-package "GBB")

(export '(build-queue
          initial-queue-unit
          insert-on-queue
          insert-on-queue-end
          map-queue
          next-queue-unit
          on-queue-p
          previous-queue-unit
          remove-from-queue))

#-TI
(require "GBB")
#+TI
;; Improve TI's REQUIRE error message ::
(unless (member "GBB" user::*modules* :TEST 'string=)
  (error "Module GBB is not loaded."))

(use-package '("LISP" "UMASS-EXTENDED-LISP"))

(proclaim '(optimize (speed 3) (safety 1)))

;;; --------------------------------------------------------------------------
;;;
;;; Queue Unit Unit Definition ::
;;;
;;; --------------------------------------------------------------------------

(define-unit (QUEUE-UNIT :EXPORT :UNNAMED)
  
  "QUEUE-UNIT

This unit type is represents the most primitive queue unit.
It is used as a special ``header'' or ``sentinel'' node and as an included
unit in other queue units."
  
  :LINKS
  ((next-queue-unit :SINGULAR (queue-unit previous-queue-unit :SINGULAR))
   (previous-queue-unit :SINGULAR (queue-unit next-queue-unit :SINGULAR)))

  :PATHS
  ((:PATH)))

;;; --------------------------------------------------------------------------
;;;
;;; Queue Unit Management Functions :::
;;;
;;; --------------------------------------------------------------------------

(defmacro INITIAL-QUEUE-UNIT (queue-header)

  "INITIAL-QUEUE-UNIT queue-header

This macro returns the first unit in the queue headed by `queue-header' or
nil if the queue is empty.  The queue itself is not changed."

  `(queue-unit$next-queue-unit ,queue-header))

;;; --------------------------------------------------------------------------

(defmacro BUILD-QUEUE (queue)

  "BUILD-QUEUE queue

This macro creates a doubly-linked list header queue-unit unit pointing to
itself as both next and previous KSI and assigns it to the symbol `queue'."

  `(let ((queue-header (make-queue-unit)))
     (setf ,queue queue-header)
     (linkf (queue-unit$next-queue-unit queue-header) queue-header)))

;;; --------------------------------------------------------------------------

(defun INSERT-ON-QUEUE (queue-header queue-unit key &OPTIONAL (test '>))

  "INSERT-ON-QUEUE queue-header queue-unit key [test]

This function inserts `queue-unit' at the proper place in the doubly-linked 
queue headed by `queue-header' based on the field selected by `key'.
`Test' is the comparison function used to determine where to insert the 
unit (e.g., > would yield a numerically decreasing queue)."

  (let ((pointer (initial-queue-unit queue-header))
        (test-value (funcall key queue-unit)))
    
    ;; Find the proper position ::
    (until (or (eq pointer queue-header)        ; We've reached the end.
               (funcall test test-value
                  (funcall key pointer)))       ; We're here!
      (setf pointer (queue-unit$next-queue-unit pointer)))
      
      ;; Do the insertion (order is crucial) ::
      (let ((previous-queue-unit
              (queue-unit$previous-queue-unit pointer)))
        (unlinkf-all (queue-unit$previous-queue-unit pointer))
        (linkf (queue-unit$previous-queue-unit queue-unit)
               previous-queue-unit))
      (linkf (queue-unit$next-queue-unit queue-unit) pointer)))

;;; --------------------------------------------------------------------------

(defun INSERT-ON-QUEUE-END (queue-header queue-unit)
  
  "INSERT-ON-QUEUE-END queue-header queue-unit 

This function inserts `queue-unit' at the end of the doubly-linked queue 
headed by `queue-header'."
  
  ;; Do the insertion (order is crucial) ::
  (let ((previous-queue-unit
          (queue-unit$previous-queue-unit queue-header)))
    (unlinkf-all (queue-unit$previous-queue-unit queue-header))
    (linkf (queue-unit$previous-queue-unit queue-unit)
           previous-queue-unit))
  (linkf (queue-unit$next-queue-unit queue-unit) queue-header))

;;; --------------------------------------------------------------------------

(defun REMOVE-FROM-QUEUE (queue-unit)

  "REMOVE-FROM-QUEUE queue-unit 

This function removes `queue-unit' from the doubly-linked queue on which 
it resides."

  (let ((previous-queue-unit
          (queue-unit$previous-queue-unit queue-unit))
        (next-queue-unit
          (queue-unit$next-queue-unit queue-unit)))
    (unlinkf-all (queue-unit$next-queue-unit previous-queue-unit))
    (unlinkf-all (queue-unit$previous-queue-unit next-queue-unit))
    (linkf (queue-unit$next-queue-unit previous-queue-unit)
           next-queue-unit)))

;;; --------------------------------------------------------------------------

(defun ON-QUEUE-P (queue-unit)

  "ON-QUEUE-P queue-unit 

This function returns a non-nil value if `queue-unit' is not on a queue.
Otherwise, nil is returned."

  (queue-unit$previous-queue-unit queue-unit))

;;; --------------------------------------------------------------------------

(defun MAP-QUEUE (function queue-header)

  "MAP-QUEUE function queue-header

This function applys `function' to each unit in the queue headed by
`queue-header' in queue order."

  (let ((pointer (initial-queue-unit queue-header)))
    (until (eq pointer queue-header)                 ; We've reached the end.
      (funcall function pointer)                     ; Apply the function.
      (setf pointer (queue-unit$next-queue-unit pointer)))))

;;; **************************************************************************
;;;                                End of File
;;; **************************************************************************


