;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-UTIL.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:29:22 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                        OPS5 Utility Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains utility definitions that are needed by other OPS5
;;; modules.  It must be loaded second (after ops-globals) to make its macro
;;; definitions available to  other modules.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

;;; ASSQ is included in some Common Lisp implementations as extensions.
;;; We'll use ASSOC if it's not there.

(eval-when (compile load eval)
  (unless (fboundp 'assq)
    (defmacro ASSQ (i l)
      `(assoc ,i ,l :TEST #'eq))))

;;; DELQ is included in some Common Lisp implementations as extensions.
;;; We'll use DELETE if it's not there.

(eval-when (compile load eval)
  (unless (fboundp 'delq)
    (defmacro DELQ (i l)
      `(delete ,i ,l :TEST #'eq))))


;;; Spdelete "special delete" is a function which deletes every occurence
;;; of element from list. This function was defined because Common Lisp's
;;; DELETE function only deletes top level elements from a list, not entire
;;; trees.

(defun SPDELETE (element list)
  (cond ((null list) nil)
	((equal element (car list)) (spdelete element (cdr list)))
	(t (cons (car list) (spdelete element (cdr list))))))


;;; Functions that were revised so that they would compile efficiently

(eval-when (compile eval load)
  (defmacro == (x y)
    `(= (the fixnum ,x) (the fixnum ,y)))

;;; =ALG returns T if A and B are algebraically equal.
;;; This corresponds to equalp - Dario Giuse
;;; But equalp uses eql for comparison if the things are numbers - Skef Wholey
;;;
  (defmacro =ALG (a b)
    `(eql ,a ,b))

  (defmacro FAST-SYMEVAL (&body z)
    `(aref (global-registers) ,(car z)))

; getvector and putvector are fast routines for using ONE-DIMENSIONAL
; arrays.  these routines do no checking; they assume
;	1. the array is a vector with 0 being the index of the first
;	   element
;	2. the vector holds arbitrary list values

; Example call: (putvector array index value)
;;; Dario Giuse - 6/20/84
  
  (defmacro PUTVECTOR (array index value)
    `(setf (aref ,array ,index) ,value))

;;; Example call: (getvector name index)
;;;
  (defmacro GETVECTOR (array index)
    `(aref ,array ,index))

;;; The following were used to remove references to symbol plists.

  (defmacro GET-OPS-PROP (indicator global-slot-accessor)

    "GET-OPS-PROP indicator global-slot-accessor

This macro looks on the properties in GLOBAL-SLOT-ACCESSOR for the 
specified INDICATOR.  If this is found, return the associated value,
else return nil."

    `(rest (assoc ,indicator ,global-slot-accessor :TEST #'eq)))

  (defmacro PUT-OPS-PROP (indicator value global-slot-accessor)

    "GET-OPS-PROP indicator global-slot-accessor

This macro looks on the properties in GLOBAL-SLOT-ACCESSOR for the 
specified INDICATOR.  If this is found, return the associated value,
else return nil."

    (let ((indicator-sym (gensym))
          (value-sym (gensym)))
      `(let ((,indicator-sym ,indicator)
             (,value-sym ,value))
         (pushnew-acons ,global-slot-accessor ,indicator-sym ,value-sym)
         ,value-sym)))
   
  (defmacro REM-OPS-PROP (indicator global-slot-accessor)

    "REM-OPS-PROP indicator global-slot-accessor

This macro removes the specified INDICATOR from GLOBAL-SLOT-ACCESSOR."

    (let ((indicator-sym (gensym)))
      `(let ((,indicator-sym ,indicator))
         (setf ,global-slot-accessor
               (delete ,indicator-sym ,global-slot-accessor
                       :TEST #'eq
                       :KEY #'first
                       :COUNT 1)))))
  
  (defmacro CE-GELM (x k)
    `(nth (the fixnum (- (the fixnum ,k) 1)) ,x))

  (defmacro GELM (x k)
    `(multiple-value-bind (ce sub)
         (truncate (the fixnum ,k) *encode-factor*)
       (nth (the fixnum sub) (nth (the fixnum ce) ,x))))

  (defmacro INTERQ (x y)
    ;; intersect two lists using eq for the equality test
    `(intersection ,x ,y :TEST #'eq))

  (defmacro VARIABLEP (x)
    (let ((x-sym (gensym)))
      `(let ((,x-sym ,x))
         (and (symbolp ,x-sym)
              (char= (char (symbol-name ,x-sym) 0) #\< )))))
) ;eval-when

(defun %WARN (what where &OPTIONAL offending)
  (format t "~%WARNING~@[ (in ~A)~] --- ~@[~A: ~]~A~@[ (offending value ~A)~]."
          (global-p-name) where what offending)
  where)

(defun %ERROR (what where &OPTIONAL offending)
  (%warn what where offending)
  (throw '!error! '!error!))

(defun TOP-LEVELS-EQ (la lb)
  (loop
    (cond ((eq la lb) (return t))
          ((null la) (return nil))
          ((null lb) (return nil))
          ((not (eq (car la) (car lb))) (return nil)))
    (setf la (cdr la))
    (setf lb (cdr lb))))

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------

