;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-SIMPLE-SHELL-EXAMPLE.LISP *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:30:04; Edited-By: Cork *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                 OPS/SIMPLE-SHELL Example Application
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1988 by COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-18-88 File Created.  (Cork)
;;;  09-06-88 Updated to V1.2 ops-simple-shell-interface.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package :OPS)

(use-package '(:lisp :umass-extended-lisp :gbb :simple-shell))

;;; ---------------------------------------------------------------------------
;;;
;;; Global Variable Definitions :::
;;;
;;; ---------------------------------------------------------------------------

(defvar *LAST-HYP-NUMBER* :UNINITIALIZED

  "*LAST-HYP-NUMBER*

This variable contains the instance counter for the last generated HYP unit.")

;;; ---------------------------------------------------------------------------
;;;
;;; Define The Blackboard Structure :::
;;;
;;; ---------------------------------------------------------------------------

(define-space SPACE1
  "A space."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-spaces (SPACE2 SPACE3)
  "More spaces."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-spaces (SPACE4)
  "One more space."
  :UNITS      (hyp)
  :DIMENSIONS ((value :ORDERED (0 100))))

(define-blackboard BLACKBOARD (space1 space2 space3 space4)
  "Basic blackboard structure.")

;;; ---------------------------------------------------------------------------
;;;
;;; Blackboard Unit Definitions :::
;;;
;;; ---------------------------------------------------------------------------

;;; The following UNIT definitions include the basic definitions created by the
;;; control shell for hypotheses, knowledge sources, and knowledge source
;;; instances.  Application-specific slots should be added to these 
;;; definitions.

;;; ---------------------------------------------------------------------------

(defevent-printer CREATED-HYP-EVENT-PRINTER (hyp)

   "CREATED-HYP-EVENT-PRINTER hyp

This print event is signalled whenever a stimulus hyp is created."

  :PRINT-SPEC ("~A ~A {~S}"
               (basic-unit$name hyp)
               (hyp$level hyp)
               (hyp$belief hyp)))

;;; ---------------------------------------------------------------------------

(defun GENERATE-HYP-NAME (hyp)
  
  "GENERATE-HYP-NAME hyp

This function returns the name string for a HYP unit."
  
  (declare (ignore hyp))
  (format nil "h.~5,'0D" (incf *last-hyp-number*)))

;;; ---------------------------------------------------------------------------

(define-unit (HYP (:INCLUDE basic-unit)
                  (:NAME-FUNCTION generate-hyp-name)
                  (:CREATION-EVENTS created-hyp-event-printer)
                  ;; The following must be included to trigger KSs when this
                  ;; unit is added to any space ::
                  (:ADD-TO-SPACE-EVENTS add-unit-to-space-event-handler))
             
  "HYP (Hypothesis)"

  :SLOTS
  (belief
   level
   value)

  :LINKS
  ((supporting-hyps (hyp supported-hyps))
   (supported-hyps (hyp supporting-hyps)))

  :DIMENSIONAL-INDEXES
  ((value value :TYPE :point))

  :PATH-INDEXES
  ((level level :TYPE :label))

  :PATHS
  ((:PATHS `(blackboard ,level))))

;;; ---------------------------------------------------------------------------

(define-unit (KS (:INCLUDE basic-ks))
             
  "KS (Knowledge Source)

This unit type contains knowledge source information.")

;;; ---------------------------------------------------------------------------

(define-unit (KSI (:INCLUDE basic-ksi))
             
  "KSI (Knowledge Source Instance)

This unit type represents a knowledge source instantiation (or activation)
record on the scheduling queue.")

;;; --------------------------------------------------------------------------
;;;
;;; The Knowledge Source Code :::
;;;
;;; --------------------------------------------------------------------------

(define-ops-system SYN-KS-PRECONDITION
  ((literalize count count)
   (literalize belief value)
   (literalize supporting-hyps hyps)
   (literalize counting-hyps hyps)
   
   (startup (watch 0)
            (disable back)
            (disable halt)
            (disable break))

   (p initial
      (stimulus <stimulus-hyp>)
      -->
      (bind <found-hyps>
            (cl-call find-units
                     hyp
                     (cl-call make-paths :unit-instances <stimulus-hyp>)
                     ($list :ELEMENT-MATCH :within
                            :PATTERN-OBJECT
                            ($list :INDEX-TYPE // (:DIMENSION value :TYPE :point)
                                   :INDEX-OBJECT (cl-call hyp$value <stimulus-hyp>)
                                   :DELTA // ((value 3))))))
      (make supporting-hyps ^hyps <found-hyps>)
      (make counting-hyps ^hyps <found-hyps>)
      (make count ^count 0)
      (make belief ^value 0))

   (p count-found-hyps
      {(counting-hyps ^hyps {<hyps> <> nil})          <counting-hyps>}
      {(count ^count {<value> <=> 0})                         <count>}
      {(belief ^value {<belief-value>})                      <belief>}
      -->
      (modify <belief>
              ^value (cl-call max (cl-call hyp$value ($first <hyps>))
                              <belief-value>))
      (modify <count> ^count (compute <value> + 1))
      (modify <counting-hyps> ^hyps ($rest <hyps>)))

   (p fail
      (counting-hyps ^hyps = nil)
      (count ^count <= 2)
      -->
      (return-values 0 nil))

   (p succeed
      (counting-hyps ^hyps = nil)
      {(supporting-hyps ^hyps {<hyps> <> nil})          <supporting-hyps>}
      (count ^count {<count> > 2})
      (belief ^value <belief>)
      (stimulus <stimulus-hyp>)
      -->
      (return-values <belief> ($list <stimulus-hyp> <hyps>)))))

;;; ---------------------------------------------------------------------------

(define-ops-system SYN-KS-SYSTEM
  ((literalize supporting-hyps hyps)
   (literalize belief value)

   (startup (watch 0)
            (disable back)
            (disable halt))

   (p initial
      (ksi <ksi>)
      -->
      (bind <response-frame> (cl-call ksi$response-frame <ksi>))
      (make supporting-hyps ^hyps ($first ($rest <response-frame>)))
      (make input-level (cl-call hyp$level ($first <response-frame>)))
      (make belief ^value 0))

   (p sum-beliefs
      {(supporting-hyps ^hyps {<hyps> <> nil})      <supporting-hyps>}
      {(belief ^value {<belief-value> >= 0})                 <belief>}
      -->
      (bind <hyp-value> (cl-call hyp$value ($first <hyps>)))
      (modify <belief> ^value (compute <belief-value> + <hyp-value>))
      (modify <supporting-hyps> ^hyps ($rest <hyps>)))

   (p create-hyp
      (belief ^value <belief>)
      (ksi <ksi>)
      (output-level <level>)
      -->
      (bind <response-frame> (cl-call ksi$response-frame <ksi>))
      (cl-call make-hyp
               :LEVEL <level>
               :SUPPORTING-HYPS ($first ($rest <response-frame>))
               :VALUE (cl-call hyp$value ($first <response-frame>))
               :BELIEF <belief>))

   ;; The following rules compute the output level from the stimulus hyp's
   ;; level ::

   (p level1-input
      {(input-level = space1)                        <input-level>}
      -->
      (remove <input-level>)
      (make output-level space2))

   (p level2-input
      {(input-level = space2)                        <input-level>}
      -->
      (remove <input-level>)
      (make output-level space3))

   (p level3-input
      {(input-level = space3)                        <input-level>}
      -->
      (remove <input-level>)
      (make output-level space4))))

;;; ---------------------------------------------------------------------------

(defun SOLUTION-FAILURE-KS-PRECONDITION (ks always-nil)

  "SOLUTION-FAILURE-KS-PRECONDITION ks always-nil

This KS precondition returns a rating of MOST-POSITIVE-FIXNUM if fewer than
36 hyps have been created on space1.  This indicates that more hyps should
be created to attempt a solution."

  (declare (ignore ks always-nil))
  (flet ((count-units (paths &AUX (result 0))
           ;; Returns the number of units on the given paths ::
           (map-space #'(lambda (ignored)
                          (declare (ignore ignored))
                          (incf result))
                      'hyp
                      paths)
           result))
    
    ;; Instantiate a KS to make more input data unless we have
    ;; already inserted at least 36 initial hypotheses on SPACE1 ::
    (if (< (count-units (make-paths :PATHS '(blackboard space1)))
           36)
        most-positive-fixnum
        0)))

;;; ---------------------------------------------------------------------------

(defun PP-SOLUTION-SUPPORTS (hyp)

  "PP-SOLUTION-SUPPORTS hyp

This function pprints the solution support structure rooted in `hyp'."

  (labels
    ((pp-solution-supports#1 (hyps indent)
       (when hyps
         (dolist (hyp hyps)
           (format t "~&~VT~A ~A {~S}"
                   indent
                   (hyp$name hyp)
                   (hyp$level hyp)
                   (hyp$belief hyp))
           (pp-solution-supports#1
             (hyp$supporting-hyps hyp)
             (+ 2 indent))))))

    (format t "~& ***** Solution Supports *****")
    (pp-solution-supports#1 (list hyp) 2)))

;;; -------------------------------------------------------------------------
;;;
;;; Inform GBB About The Knowledge Sources :::
;;;
;;; -------------------------------------------------------------------------

(define-ops-ks INITIAL
  :OPS-KS
  ((literalize counter
      value)

   (startup (watch 0)
            (disable back)
            (disable halt))

   (p initial
      (ksi)
      -->
      (make counter ^value 16))

   (p loop-body
      {(counter ^value {<count> >= 1})        <counter>}
      -->
      (cl-call make-hyp
               :LEVEL space1
               :VALUE (cl-call random 100)
               :BELIEF (cl-call random 10))
      (modify <counter> ^value (compute <count> - 1)))

   (p exit-loop
      {(counter)                              <counter>}
      -->
      (remove <counter>))))
   
(define-ops-ks SYN-SPACE1-SPACE2
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         ((hyp) ((blackboard space1)))))
  :OPS-PRECONDITION-SYSTEM syn-ks-precondition
  :OPS-KS-SYSTEM syn-ks-system)

(define-ops-ks SYN-SPACE2-SPACE3
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space2)))))
  :OPS-PRECONDITION-SYSTEM syn-ks-precondition
  :OPS-KS-SYSTEM syn-ks-system)

(define-ops-ks SYN-SPACE3-SPACE4
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space3)))))
  :OPS-PRECONDITION-SYSTEM syn-ks-precondition
  :OPS-KS-SYSTEM syn-ks-system)

(define-ops-ks SOLUTION-FINDER
  :TRIGGER-CONDITIONS ((:unit-addition-to-space
                         (hyp ((blackboard space4)))))
  :OPS-PRECONDITION
  ((startup (watch 0)
            (disable back)
            (disable halt))

   (p initial
      (stimulus <stimulus-hyp>)
      -->
      (bind <rating> (cl-call hyp$belief <stimulus-hyp>))
      (return-values <rating> ($list <stimulus-hyp>))))

  :OPS-KS
  ((startup (watch 0)
            (disable back)
            (disable halt))

   (p initial
      (ksi <ksi>)
      -->
      (bind <solution-hyp>
            ($first (cl-call ksi$response-frame <ksi>)))
      (write (crlf) (crlf) "***** SOLUTION FOUND *****"
             (crlf) "Hyp:" (cl-call hyp$name <solution-hyp>)
                           (cl-call hyp$level <solution-hyp>)
                           (cl-call hyp$belief <solution-hyp>))
      (cl-call pp-solution-supports <solution-hyp>)
      (return-values :STOP))))

(define-ops-ks SOLUTION-FAILURE
  :TRIGGER-CONDITIONS ((:queue-quiescence))
  :PRECONDITION-FUNCTION 'solution-failure-ks-precondition
  :OPS-KS
  ((literalize counter
      value)

   (startup (watch 0)
            (disable back)
            (disable halt))

   (p initial
      (ksi <ksi>)
      -->
      (write (crlf) (crlf) "***** NO SOLUTION FOUND *****"
             (crlf) " The initial data did not support a complete solution."
             (crlf) " Adding more random data...." (crlf) (crlf))
      (make counter ^value 9))

   (p loop-body
      {(counter ^value {<count> >= 1})        <counter>}
      -->
      (cl-call make-hyp
               :LEVEL space1
               :VALUE (cl-call random 100)
               :BELIEF (cl-call random 10))
      (modify <counter> ^value (compute <count> - 1)))

   (p exit-loop
      {(counter)                              <counter>}
      -->
      (remove <counter>))))

;;; --------------------------------------------------------------------------
;;;
;;; Function To Run The OPS Simple Shell Example :::
;;;
;;; --------------------------------------------------------------------------

(defun OPS-SIMPLE-SHELL-EXAMPLE (&KEY (event-print-stream *standard-output*))

  "SIMPLE-SHELL-EXAMPLE &KEY event-print-stream

Runs the OPS simple shell example.  An alternate stream for printing simple
shell events can be optionally specified (the default is *standard-output*)."
 
  (let ((*event-print-stream* event-print-stream))
    (format *event-print-stream*
            "~2&;;; Running the OPS Simple Shell Example....~%")
    (ops-init)
    (clear-blackboard-database t)
    (setf *last-hyp-number* 0)
    (instantiate-simple-control-shell 'blackboard :MODE :overwrite)
    (pp-blackboard-database)
    (format *event-print-stream*
            "~2&;;; Rerun by evaluating (ops-simple-shell-example).")
    (simple-control-shell 'initial)))


;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------


