;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-MAIN.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:24:23 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; * OPS5 Top-Level, Literalization, and Conflict Set Management Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains the top-level functions, function to literalize
;;; and access attributes, and functions to manage the conflict set.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package :OPS)

(export '(broken
           cs
           disable
           disjoint
           enable
           excise
           external
           have-compiled-production
           instantiation
           is-vector-attribute
           literal
           literalize
           matches
           order-part
           p
           pbreak
           pm
           pname-instantiation
           ppwm
           run
           startup
           strategy
           vector-attribute
           watch
           wm))

;;; Global variables also used by other modules.
;;; *HALT-FLAG*, *CYCLE-COUNT*, *P-NAME*, *PTRACE*, and *WTRACE*.


;;; Global variables used in this module only.
;;; *LIMIT-TOKEN*, *TOTAL-WM*, *MAX-TOKEN*, *TOTAL-TOKEN*, *BRKPTS*,
;;; *PHASE*, *BREAK-FLAG*, *REMAINING-CYCLES*, *CONFLICT-SET*, 
;;; *MAX-CS*, *TOTAL-CS*, *LIMIT-CS*, *STRATEGY*, *CLASS-LIST*, 
;;; and *BUCKETS*.


;;; ---------------------------------------------------------------------------

(defun OPS-INIT ()

  "OPS-INIT nil

This function initializes OPS."

  ; Allows ^ , { , and } operators to be right next to another symbol.
  (set-macro-character #\{ #'(lambda (s c)
			       (declare (ignore s c))
			       '\{))
  (set-macro-character #\} #'(lambda (s c)
			       (declare (ignore s c))
			       '\}))
  (set-macro-character #\^ #'(lambda (s c)
			       (declare (ignore s c))
			       '\^))
  (prog1 (global-init)   ; Must return the globals structure.
         (backup-init)
         (compile-init)
         (main-init)
         (match-init)
         (io-init)
         (rhs-init)))

;;; ---------------------------------------------------------------------------

(defun OPS-REINIT ()

  "OPS-REINIT nil

This function reinitializes OPS for the next OPS invocation instance."

  (remove *)
  (global-reinit)
  (backup-reinit)
  (compile-reinit)
  (main-reinit)
  (match-reinit)
  (io-reinit)
  (rhs-reinit))

;;; ---------------------------------------------------------------------------

(defun MAIN-INIT ()

  "MAIN-INIT nil

This function initializes the MAIN file constants."

  (main-reinit)
  (setf (global-buckets) (1- *ops-maximum-field-count*))
  (setf (global-class-list) nil)
  (setf (global-startup-forms) nil))

;;; ---------------------------------------------------------------------------

(defun MAIN-REINIT ()

  "MAIN-REINIT nil

This function reinitializes the MAIN file constants for the next
OPS invocation instance."

  (setf (global-cycle-count) 0)
  (setf (global-p-name) nil)
  (setf (global-ptrace) t)
  (setf (global-wtrace) nil)
  (setf (global-halt-messages) t)
  (setf (global-limit-token) 1000000)
  (setf (global-limit-cs) 1000000)
  (setf (global-total-wm) 0)
  (setf (global-total-token) 0)
  (setf (global-max-token) 0)
  (setf (global-max-cs) 0)
  (setf (global-total-cs) 0)
  (setf (global-conflict-set) nil)
  (setf (global-strategy) 'lex)
  (setf (global-brkpts) nil)
  (setf (global-remaining-cycles) 1000000)
  (mapc #'eval (global-startup-forms)))

;;;;---------------------------------------------------------------------------
;;;;
;;;; Top level commands.
;;;;
;;;;---------------------------------------------------------------------------

(defmacro CS (&body z)

  "CS

Displays the contents of the conflict set."

  `(ops-cs ',z))

;;; ---------------------------------------------------------------------------

(defmacro DISABLE (&body z)

  "DISABLE keyword

Disables run-time features.  The legal features are:
  BACK     BACK command;
  BREAK    break on invocation of a GBB/OPS KS or precondition;
  HALT     printing of execution statistics."

  (ecase (first z)
    (back '(setf (global-recording-disabled) t))
    (break '(setf (global-break-on-entry) nil))
    (halt '(setf (global-halt-messages) nil))))

;;; ---------------------------------------------------------------------------

(defmacro ENABLE (&body z)

  "ENABLE keyword

Enables run-time features.  The legal features are:
  BACK     BACK command;
  BREAK    break on invocation of a GBB/OPS KS or precondition;
  HALT     printing of execution statistics."

  (ecase (first z)
    (back '(setf (global-recording-disabled) nil))
    (break '(setf (global-break-on-entry) t))
    (halt '(setf (global-halt-messages) t))))

;;; ---------------------------------------------------------------------------

(defmacro EXCISE (&body z)

  "EXCISE {production-name}*

Disables productions so they cannot execute.  Once excised, the productions
cannot be enabled."

  `(ops-excise ',z))

;;; ---------------------------------------------------------------------------

(defmacro EXTERNAL (&body z)

  "EXTERNAL {external-routine-name}+

Declares external routines (written in Common Lisp)."

  `(ops-external ',z))

;;; ---------------------------------------------------------------------------

(defmacro LITERAL (&body z)

  "LITERAL {attribute-name = field}+

Assigns specified fields of a working-memory element to attribute names."

  `(ops-literal ',z))

;;; ---------------------------------------------------------------------------

(defmacro LITERALIZE (&body z)

  "LITERALIZE class-name {attribute-name}+

Associates a class with a list of attribute names and assigns working memory
element fields to the supplied attribute names."

  `(ops-literalize ',z))

;;; ---------------------------------------------------------------------------

(defmacro MATCHES (&body rule-list)

  "MATCHES {rule-name}+

Displays the time tags of working-memory elements that match the condition 
elements in the named productions."

  `(ops-matches ',rule-list))

;;; ---------------------------------------------------------------------------

(defmacro PBREAK (&body z)

  "PBREAK {rule-name}*

Establishes and removes breakpoints from productions (toggles).  Also displays 
productions with breakpoints set if given no arguments."

  `(ops-pbreak ',z))

;;; ---------------------------------------------------------------------------

(defmacro P (&body z)

  "P rule-name lhs --> rhs

Defines a production rule."

  `(ops-p ',z))

;;; ---------------------------------------------------------------------------

(defmacro PM (&body z)

  "PM [rule-name]

Pretty prints the production `rule-name'."

  `(ops-pm ',z))

;;; ---------------------------------------------------------------------------

(defmacro PPWM (&body avlist)

  "PPWM [class-name] {scalar-attribute value}* {vector-attribute value}*

Prints working memory elements that match a pattern.  The pattern can
include a class name and scalar and vector attributes."

  `(ops-ppwm ',avlist))

;;; ---------------------------------------------------------------------------

(defmacro RUN (&body z)

  "RUN [integer]

Executes recognize-act cycles.  A number of cycles to run (`integer') can be
specified."

  `(ops-run ',z))

;;; ---------------------------------------------------------------------------

(defmacro STARTUP (&BODY z)

  "STARTUP {action | command}*

Executes actions and commands at the start of each GBB/OPS KS or precondition.
Only one STARTUP statement should be used.  If a second STARTUP appears, it 
removes the actions and commands defined by an earlier STARTUP statement."

  `(setf (global-startup-forms) ',z))

;;; ---------------------------------------------------------------------------

(defmacro STRATEGY (&body z)

  "STRATEGY [LEX | MEA]

Sets or displays the conflict-resolution strategy."

  `(ops-strategy ',z))

;;; ---------------------------------------------------------------------------

(defmacro VECTOR-ATTRIBUTE (&body l)

  "VECTOR-ATTRIBUTE {attribute-name}+

Assigns a predefined field of working-memory elements to specified
vector-attribute names."

  `(ops-vector-attribute ',l))

;;; ---------------------------------------------------------------------------

(defmacro WATCH (&body z)

  "WATCH [trace-level]

Displays or sets the trace level.  Trace levels 0-2 are supported:
   0 -- none
   1 -- instances selected for execution
   2 -- instances for execution and elements added/deleted from working
        memory."

  `(ops-watch ',z))

;;; ---------------------------------------------------------------------------

(defmacro WM (&body a)

  "WM {time-tag}*

Prints working memory elements with specified time tags."

  `(ops-wm ',a))

;;; ---------------------------------------------------------------------------

(defun TOP-LEVEL-REMOVE (z)
  (cond ((equal z '(*)) (process-changes nil (get-wm nil)))
	(t (process-changes nil (get-wm z))))) 

;;; ---------------------------------------------------------------------------

(eval-when (compile eval load)

(defmacro DISJOINT (la lb)
  `(not (find-common-atom ,la ,lb))) 

(defmacro BROKEN (rule)
  `(member ,rule (global-brkpts)))

(defmacro HAVE-COMPILED-PRODUCTION ()
  '(not (zerop (global-pcount)))) 

(defmacro PNAME-INSTANTIATION (conflict-elem)
  `(first ,conflict-elem)) 

(defmacro ORDER-PART (conflict-elem)
  `(rest ,conflict-elem)) 

(defmacro INSTANTIATION (conflict-elem)
  `(rest (pname-instantiation ,conflict-elem)))

(defmacro IS-VECTOR-ATTRIBUTE (att)
  `(get-ops-prop ,att (global-vector-attribute-props)))

) ; end eval-when


;;; ---------------------------------------------------------------------------
;;;
;;; Functions for run command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-RUN (z)
  (setf (global-return-values) nil)
  (cond ((atom z)
         (setf (global-remaining-cycles) 1000000)
         (do-continue nil)
         (apply #'values (global-return-values)))
	((and (atom (rest z)) (numberp (first z)) (> (first z) 0))
	 (setf (global-remaining-cycles) (first z))
	 (do-continue nil)
         (apply #'values (global-return-values)))
	(t 'what?))) 

;;; ---------------------------------------------------------------------------

(defun DO-CONTINUE (wmi)
  (cond ((global-critical)
	 (format t "~%WARNING: network may be inconsistent")))
  (process-changes wmi nil)
  (print-times (main)))

;;; ---------------------------------------------------------------------------

(defun PROCESS-CHANGES (adds dels)
  (mapc #'remove-from-wm dels)
  (dolist (x adds)
    (add-to-wm x nil)))

;;; ---------------------------------------------------------------------------

(defun MAIN ()
  (prog (instance r)
        (setf (global-halt-flag) nil)
        (setf (global-break-flag) nil)
        (setf instance nil)
   dil
        (setf (global-phase) 'conflict-resolution)
        (cond ((global-halt-flag)
               (setf r "END -- Explicit halt.")
               (go finis))
              ((zerop (global-remaining-cycles))
               (setf r "***break***")
               (setf (global-break-flag) t)
               (go finis))
              ((global-break-flag)
               (setf r "***break***")
               (go finis)))
        (decf (global-remaining-cycles))
        (setf instance (conflict-resolution))
        (unless instance
          (setf r "END -- No production true.")
          (go finis))
        (setf (global-phase) (first instance))
        (accum-stats)
        (eval-rhs (first instance) (rest instance))
        (check-limits)
        (when (broken (first instance))
          (setf (global-break-flag) t))
        (go dil)
   finis
        (setf (global-p-name) nil)
        (return r))) 

;;; ---------------------------------------------------------------------------

(defun ACCUM-STATS ()
  (incf (global-cycle-count))
  (incf (global-total-token) (global-current-token))
  (when (> (global-current-token) (global-max-token))
    (setf (global-max-token) (global-current-token)))
  (incf (global-total-wm) (global-current-wm))
  (when (> (global-current-wm) (global-max-wm))
         (setf (global-max-wm) (global-current-wm))))

;;; ---------------------------------------------------------------------------

(defun CHECK-LIMITS ()
  (when (> (length (global-conflict-set)) (global-limit-cs))
    (format t "~%~%conflict set size exceeded the limit of ~D after ~D~%"
            (global-limit-cs) (global-p-name))
    (setf (global-halt-flag) t))
  (when (> (global-current-token) (global-limit-token))
    (format t "~%~%token memory size exceeded the limit of ~D after ~D~%"
            (global-limit-token) (global-p-name))
    (setf (global-halt-flag) t)))

;;; ---------------------------------------------------------------------------

(defun PRINT-TIMES (mess)
  (cond ((global-break-flag)
         (terpri)
         mess)
        ((global-halt-messages) 
         (let ((cc))
           (setf cc (+ (float (global-cycle-count)) 1.0e-20))
           (format t "~%~A~%" mess)
           (format t "~3D productions (~D // ~D nodes)~%"
                   (global-pcount) (global-real-cnt) (global-virtual-cnt))
           (format t "~3D firings (~D rhs actions)~%"
                   (global-cycle-count) (global-action-count))
           (format t "~3D mean working memory size (~D maximum)~%"
                   (round (float (global-total-wm)) cc) (global-max-wm))
           (format t "~3D mean conflict set size (~D maximum)~%"
                   (round (float (global-total-cs)) cc) (global-max-cs))
           (format t "~3D mean token memory size (~D maximum)~%"
                   (round (float (global-total-token)) cc)
                   (global-max-token))))))

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for strategy command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-STRATEGY (z)
  (cond ((atom z)
         (global-strategy))
	((equal z '(lex))
         (setf (global-strategy) 'lex))
	((equal z '(mea))
         (setf (global-strategy) 'mea))
	(t 'what?))) 

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for watch command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-WATCH (z)
  (cond ((equal z '(0))
	 (setf (global-wtrace) nil)
	 (setf (global-ptrace) nil)
	 0)
	((equal z '(1))
         (setf (global-wtrace) nil)
         (setf (global-ptrace) t)
         1)
	((equal z '(2))
         (setf (global-wtrace) t)
         (setf (global-ptrace) t)
         2)
	((equal z '(3))
	 (setf (global-wtrace) t)
	 (setf (global-ptrace) t)
	 '(2 -- conflict set trace not supported))
	((and (atom z) (null (global-ptrace)))
         0)
	((and (atom z) (null (global-wtrace)))
         1)
	((atom z) 2)
	(t 'what?))) 

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for excise command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-EXCISE (z)
  (mapc #'excise-p z))

;;; ---------------------------------------------------------------------------

(defun EXCISE-P (name)
  (cond ((and (symbolp name) (get-ops-prop name (global-topnode-props)))
	 (format t "~S is excised~%" name)
	 (decf (global-pcount))
	 (remove-from-conflict-set name)
	 (fill (get-ops-prop name (global-topnode-props)) '&old)
	 (rem-ops-prop name (global-production-props))
	 (rem-ops-prop name (global-backpointers-props))
	 (rem-ops-prop name (global-topnode-props)))))

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for external command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-EXTERNAL (z)
  (catch '!error!
    (mapc #'(lambda (x) 
              (cond ((symbolp x)
                     (put-ops-prop x t (global-external-routine-props)))
                    (t (%error "not a legal function name" x))))
          z)))

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for pbreak command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-PBREAK (z)
  (cond ((atom z)
         (terpri)
         (global-brkpts))
	(t (mapc
             #'(lambda (rule)
                 (cond ((not (symbolp rule))
                        (%warn "illegal name" rule))
                       ((not (get-ops-prop rule (global-topnode-props)))
                        (%warn "not a production" rule))
                       ((member rule (global-brkpts) :TEST #'eq)
                        (setf (global-brkpts)
                              (lisp::remove rule (global-brkpts) :TEST #'eq)))
                       (t (push rule (global-brkpts)))))
             z) nil)))

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for matches command
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-MATCHES (rule-list)
  (dolist (p rule-list)
    (when (atom p)
      (format t "~2&~A" p)
      (matches2 (get-ops-prop p (global-backpointers-props)) 2 (list 1))))
  (terpri))

;;; ---------------------------------------------------------------------------

(defun MATCHES2 (nodes ce part)
  (unless (null nodes)
    (format t "~% ** matches for ~A **" part)
    (mapc #'write-elms (find-left-mem (first nodes)))
    (format t "~% ** matches for (~A) **" ce)
    (mapc #'write-elms (find-right-mem (first nodes)))
    (matches2 (rest nodes) (1+ ce) (cons ce part))))

;;; ---------------------------------------------------------------------------

(defun WRITE-ELMS (wme-or-count)
  (when (consp wme-or-count)
    (terpri)
    (dolist (x wme-or-count)
      (format t " ~A" (creation-time x)))))

;;; ---------------------------------------------------------------------------

(defun FIND-LEFT-MEM (node)
  (cond ((eq (first node) '&and)
         (memory-part (third node)))
	(t (first (third node)))))

;;; ---------------------------------------------------------------------------

(defun FIND-RIGHT-MEM (node)
  (memory-part (fourth node))) 

;;; ---------------------------------------------------------------------------
;;;
;;; Function for cs command.
;;;
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-CS (z)
  (cond ((atom z)
         (conflict-set))
	(t 'what?))) 

;;; ---------------------------------------------------------------------------
;;;
;;; Functions for literalize and related operations.
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-LITERAL (z)
  (prog (atm val old)
     top
        (when (atom z)
          (return 'bound))
        (unless (eq (second z) '=)
          (return (%warn "wrong format" z)))
        (setf atm (first z))
        (setf val (third z))
        (setf z (cdddr z))
        (cond ((not (numberp val))
               (%warn "can bind only to numbers" val))
              ((or (not (symbolp atm)) (variablep atm))
               (%warn "can bind only constant atoms" atm))
              ((and (setf old (literal-binding-of atm)) (not (equal old val)))
               (%warn "attempt to rebind attribute" atm))
              (t (put-ops-prop atm val (global-ops-bind-props))))
        (go top))) 

;;; ---------------------------------------------------------------------------

(defun OPS-LITERALIZE (l)
  (prog (class-name atts)
        (setf class-name (first l))
        (cond ((have-compiled-production)
               (%warn "literalize called after p" class-name)
               (return nil))
              ((get-ops-prop class-name (global-att-list-props))
               (%warn "attempt to redefine class" class-name)
               (return nil)))
        (push class-name (global-class-list))
        (setf atts (remove-duplicates (rest l)))    ; ??? should this
                                                   ; warn of dup atts?
        (test-attribute-names atts)
        (mark-conflicts atts atts)
        (put-ops-prop class-name atts (global-att-list-props)))) 

;;; ---------------------------------------------------------------------------

(defun OPS-VECTOR-ATTRIBUTE (l)
  (cond ((have-compiled-production)
	 (%warn "VECTOR-ATTRIBUTE called after p" l))
	(t 
	 (test-attribute-names l)
	 (dolist (att l)
           (put-ops-prop att t (global-vector-attribute-props))))))

;;; ---------------------------------------------------------------------------

(defun TEST-ATTRIBUTE-NAMES (l)
  (dolist (atm l)
    (when (or (not (symbolp atm)) (variablep atm))
      (%warn "can bind only constant atoms" atm))))

;;; ---------------------------------------------------------------------------

(defun FINISH-LITERALIZE ()
  (when (global-class-list)
    (mapc #'note-user-assigns (global-class-list))
    (mapc #'assign-scalars (global-class-list))
    (mapc #'assign-vectors (global-class-list))
    (mapc #'put-ppdat (global-class-list))
    (mapc #'erase-literal-info (global-class-list))
    (setf (global-class-list) nil)
    (setf (global-buckets) nil)))

;;; ---------------------------------------------------------------------------
	   
(defun PUT-PPDAT (class)
  (prog (al att ppdat)
        (setf ppdat nil)
        (setf al (get-ops-prop class (global-att-list-props)))
     top  (cond ((not (atom al))
                 (setf att (first al))
                 (setf al (rest al))
                 (setf ppdat
                       (cons (cons (literal-binding-of att) att)
                             ppdat))
                 (go top)))
        (put-ops-prop class ppdat (global-ppdat-props)))) 

;;; ---------------------------------------------------------------------------
;; note-user-assigns and note-user-vector-assigns are needed only when
;; literal and literalize are both used in a program.  They make sure that
;; the assignments that are made explicitly with literal do not cause problems
;; for the literalized classes.

(defun NOTE-USER-ASSIGNS (class)
  (dolist (att (get-ops-prop class (global-att-list-props)))
    (prog (num conf buck clash)
          (setf num (literal-binding-of att))
          (when (null num)
            (return nil)) ;; only return from PROG
          (setf conf (get-ops-prop att (global-conflicts-props)))
          (setf buck (store-binding att num))
          (setf clash (find-common-atom buck conf))
          (when clash
            (%warn "attributes in a class assigned the same number"
                   (cons att clash)))
          (return nil)))) ;; only return from PROG

;;; ---------------------------------------------------------------------------

(defun NOTE-USER-VECTOR-ASSIGNS (att given needed)
  (when (> needed given)
    (%warn "vector attribute assigned too small a value in literal" att)))

;;; ---------------------------------------------------------------------------

(defun ASSIGN-SCALARS (class)
  (dolist (att (get-ops-prop class (global-att-list-props)))
    (prog (tlist num bucket conf)
          (when (literal-binding-of att)
            (return nil)) ;; only return from PROG
          (when (is-vector-attribute att)
            (return nil)) ;; only return from PROG
          (setf tlist (buckets))
          (setf conf (get-ops-prop att (global-conflicts-props)))
       top
          (cond ((atom tlist)
                 (%warn "could not generate a binding" att)
                 (store-binding att -1.)
                 (return nil))) ;; only return from PROG
          (setf num (caar tlist))
          (setf bucket (cdar tlist))
          (setf tlist (rest tlist))
          (cond ((disjoint bucket conf) (store-binding att num))
                (t (go top))))))

;;; ---------------------------------------------------------------------------

(defun ASSIGN-VECTORS (class)
  (dolist (att (get-ops-prop class (global-att-list-props)))
    (prog (big conf new old need)
          (when (not (is-vector-attribute att))
            (return nil)) ;; only return from PROG
          (setf big 1)
          (setf conf (get-ops-prop att (global-conflicts-props)))
       top
          (cond ((not (atom conf))
                 (setf new (first conf))
                 (setf conf (rest conf))
                 (cond ((is-vector-attribute new)
                        (%warn "class has two vector attributes"
                               (list att new)))
                       (t (setf big (max (literal-binding-of new) big))))
                 (go top)))
          (setf need (1+ big))
          (setf old (literal-binding-of att))
          (cond (old (note-user-vector-assigns att old need))
                (t (store-binding att need)))
          (return nil)))) ;; only return from PROG

;;; ---------------------------------------------------------------------------

(defun FIND-COMMON-ATOM (la lb)
  (first (some #'(lambda (la-element)
                   (member la-element lb))
               la)))

;;; ---------------------------------------------------------------------------

(defun MARK-CONFLICTS (rem all)
  (unless (null rem)
    (let ((atm (first rem)))
      (dolist (l all)
        (conflict atm l)))
    (mark-conflicts (rest rem) all)))

;;; ---------------------------------------------------------------------------

(defun CONFLICT (a b)
  (let ((old (get-ops-prop a (global-conflicts-props))))
    (when (and (not (eq a b))
               (not (member b old)))
      (put-ops-prop a (cons b old) (global-conflicts-props)))))

;;; ---------------------------------------------------------------------------
 
(defun LITERAL-BINDING-OF (name)
  ;; Called as a function.
  (get-ops-prop name (global-ops-bind-props)))

;;; ---------------------------------------------------------------------------

(defun STORE-BINDING (name lit)
  (put-ops-prop name lit (global-ops-bind-props))
  (add-bucket name lit)) 

;;; ---------------------------------------------------------------------------

(defun ADD-BUCKET (name num)
  (let ((buc (assoc num (buckets))))
    (unless (member name buc)
      (rplacd buc (cons name (rest buc))))
    buc))

;;; ---------------------------------------------------------------------------

(defun BUCKETS ()
  (when (atom (global-buckets))
    (setf (global-buckets) (make-nums (global-buckets))))
  (global-buckets))

;;; ---------------------------------------------------------------------------

(defun MAKE-NUMS (k)
  (let ((result nil))
    (loop (when (< k 2) (return result))
          (push (list k) result)
          (decf k))))

;;; ---------------------------------------------------------------------------

(defun ERASE-LITERAL-INFO (class)
  (dolist (att (get-ops-prop class (global-att-list-props)))
    (rem-ops-prop att (global-conflicts-props)))
  (rem-ops-prop class (global-att-list-props)))

;;; ---------------------------------------------------------------------------
;;; Functions for conflict set management and resolution.
;;;
;;; Each conflict set element is a list of the following form:
;;; ((p-name . data-part) (sorted wm-recency) special-case-number)
;;;
;;; ---------------------------------------------------------------------------

(defun CONFLICT-RESOLUTION ()
  (let ((len (length (global-conflict-set))))
    (when (> len (global-max-cs))
      (setf (global-max-cs) len))
    (incf (global-total-cs) len)
    (when (global-conflict-set)
      (let ((best (best-of (global-conflict-set))))
        (setf (global-conflict-set)
              (delq best (global-conflict-set)))
        (pname-instantiation best)))))

;;; ---------------------------------------------------------------------------

(defun REMOVECS (name data)
  (prog (cr-data inst cs)
        (setf cr-data (cons name data))
        (setf cs (global-conflict-set))
     loop
        (cond ((null cs) 
               (record-refract name data)
               (return nil)))
        (setf inst (first cs))
        (setf cs (rest cs))
        (unless (top-levels-eq (first inst) cr-data)
          (go loop))
        (setf (global-conflict-set) (delq inst (global-conflict-set)))))

;;; ---------------------------------------------------------------------------

(defun INSERTCS (name data rating)
  (unless (refracted name data)
    (let ((instan (list (cons name data) (order-tags data) rating)))
      (when (atom (global-conflict-set))
        (setf (global-conflict-set) nil))
       (push instan (global-conflict-set)))))

;;; ---------------------------------------------------------------------------

(defun REMOVE-FROM-CONFLICT-SET (name)
  (prog (cs entry)
     l1
        (setf cs (global-conflict-set))
     l2
        (cond ((atom cs) (return nil)))
        (setf entry (first cs))
        (setf cs (rest cs))
        (cond ((eq name (caar entry))
               (setf (global-conflict-set) (delq entry (global-conflict-set)))
               (go l1))
              (t (go l2))))) 

;;; ---------------------------------------------------------------------------

(defun ORDER-TAGS (dat)
  (prog (tags)
        (setf tags nil)
     l1p
        (when (atom dat)
          (go l2p))
        (setf tags (cons (creation-time (first dat)) tags))
        (setf dat (rest dat))
        (go l1p)
     l2p
        (cond ((eq (global-strategy) 'mea)
               (return (cons (first tags) (dsort (rest tags)))))
              (t (return (dsort tags)))))) 

;;; ---------------------------------------------------------------------------

(defun DSORT (x)
  ;; Destructively sort x into decending order.
  (sort x #'>)
  x)

;;; ---------------------------------------------------------------------------

(defun BEST-OF (set)
  (best-of* (first set) (rest set)))

;;; ---------------------------------------------------------------------------

(defun BEST-OF* (best rem)
  (cond ((not rem) best)
	((conflict-set-compare best (first rem))
	 (best-of* best (rest rem)))
	(t (best-of* (first rem) (rest rem))))) 

;;; ---------------------------------------------------------------------------

(defun CONFLICT-SET-COMPARE (x y)
  (prog (x-order y-order xl yl xv yv)
        (setf x-order (order-part x))
        (setf y-order (order-part y))
        (setf xl (first x-order))
        (setf yl (first y-order))
     data
        (cond ((and (null xl) (null yl)) (go ps))
              ((null yl) (return t))
              ((null xl) (return nil)))
        (setf xv (first xl))
        (setf yv (first yl))
        (cond ((> xv yv) (return t))
              ((> yv xv) (return nil)))
        (setf xl (rest xl))
        (setf yl (rest yl))
        (go data)
     ps
        (setf xl (rest x-order))
        (setf yl (rest y-order))
     psl
        (cond ((null xl) (return t)))
        (setf xv (first xl))
        (setf yv (first yl))
        (cond ((> xv yv) (return t))
              ((> yv xv) (return nil)))
        (setf xl (rest xl))
        (setf yl (rest yl))
        (go psl))) 

;;; ---------------------------------------------------------------------------

(defun CONFLICT-SET ()
  (prog (cnts cs p z best)
        (setf cnts nil)
        (setf cs (global-conflict-set))
     l1p
        (when (atom cs)
          (go l2p))
        (setf p (caaar cs))
        (setf cs (rest cs))
        (setf z (assq p cnts))
        (cond ((null z) (setf cnts (cons (cons p 1) cnts)))
              (t (rplacd z (1+ (rest z)))))
        (go l1p)
     l2p
        (cond ((atom cnts)
               (setf best (best-of (global-conflict-set)))
               (terpri)
               (return (list (caar best) 'dominates))))
        (terpri)
        (princ (caar cnts))
        (when (> (cdar cnts) 1)
          (format t "	(~A occurrences)" (cdar cnts)))
        (setf cnts (rest cnts))
        (go l2p)))

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------

