;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-IO.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  16:34:58 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                     OPS5 Input/Output Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains input/output functions.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard)
;;; system at the Department of Computer and Information Science (COINS),
;;; University of Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")
(shadow '(write))    ; Should get this by requiring ops-rhs


;;; Internal global variables.
;;; *WRITE-FILE*, *TRACE-FILE*, *ACCEPT-FILE*, *PPLINE*, 
;;; *SUZE-RESULT-ARRAY*, and *FILTERS*.

;;; ---------------------------------------------------------------------------
;;; Initialization
;;; ---------------------------------------------------------------------------

(defun IO-INIT ()

  "IO-INIT nil

This function initializes the IO file constants."

  (io-reinit))

;;; ---------------------------------------------------------------------------

(defun IO-REINIT ()

  "IO-REINIT nil

This function reinitializes the IO file constants for the next
OPS invocation instance."

  (setf (global-write-file) nil)
  (setf (global-trace-file) nil)
  (setf (global-accept-file) nil))

;;; ---------------------------------------------------------------------------
;;; User I/O commands
;;; ---------------------------------------------------------------------------

(eval-when (compile eval load)

(defmacro APPEND-STRING (x)
  `(setf wrstring (concatenate 'simple-string wrstring ,x)))

) ;; end eval-when

(defun OPS-WRITE (z)
  (prog (port max lastcol k x)
        (cond ((not (global-in-rhs))
               (%warn "cannot be called at top level" 'write)
               (return nil)))
        ($reset)
        (eval-args z)
        (setf lastcol 0)
        (setf max ($parametercount))
        (cond ((< max 1)
               (%warn "WRITE: nothing to print" z)
               (return nil)))
        (setf x ($parameter 1))
        (cond ((and (symbolp x) ($ofile x)) 
               (setf port ($ofile x))
               (set k 2))
              (t
               (setf port (default-write-file))
               (setf k 1)))
        ;; Analyze and output all the parameters (write) was passed.
        (do* ((wrstring "")
              (x ($parameter k) ($parameter k))
              (field-width))
             ((> k max)
              (format port wrstring)
              (force-output))              ; Dario Giuse - added to force output
          (incf k)
          (case x
            (|=== C R L F ===|
             (format port "~A~%" wrstring) ; Flush the previous line
             (setf wrstring ""))
            (|=== R J U S T ===|
             (setf field-width ($parameter k))     ; Number following (tabto)
             (incf k)
             (setf x (format nil "~A" ($parameter k)))     ; Next field to print
             (when (<= (length x) field-width)
               ;; Right-justify field
               (append-string (format nil "~V@A" field-width x))
               (incf k)))                  ; Skip next field, since we printed it already
            (|=== T A B T O ===|
             (setf x ($parameter k))       ; Position to tab to
             (incf k)
             (when (< x (length wrstring))
               ;; Flush line, start a new one
               (format port "~A~%" wrstring)
               (setf wrstring ""))
             (append-string (format nil "~V,@T" (- x (length wrstring) 1))))
            (t
             (append-string (format nil "~A " x)))))))


(defun OPS-OPENFILE (z)
  (prog (file mode id)
        ($reset)
        (eval-args z)
        (cond ((not (equal ($parametercount) 3.))
               (%warn '"OPENFILE: wrong number of arguments" z)
               (return nil)))
        (setf id ($parameter 1))
        (setf file ($parameter 2))
        (setf mode ($parameter 3))
        (cond ((not (symbolp id))
               (%warn "OPENFILE: file id must be a symbolic atom" id)
               (return nil))
              ((null id)
               (%warn "OPENFILE: 'nil' is reserved for the terminal" nil)
               (return nil))
              ((or ($ifile id)($ofile id))
               (%warn "OPENFILE: name already in use" id)
               (return nil)))
;@@@	(cond ((eq mode 'in) (put-ops-prop id (infile file) (global-inputfile-props)))
;@@@	      ((eq mode 'out) (put-ops-prop id (outfile file) (global-outputfile-props)))
; dec 7 83 gdw added setf : is put-ops-prop needed ? )
        (cond ((eq mode 'in) (put-ops-prop id (setf id (infile file)) (global-inputfile-props)))
              ((eq mode 'out) (put-ops-prop id (setf id (outfile file)) (global-outputfile-props)))
              (t (%warn "OPENFILE: illegal mode" mode)
                 (return nil)))
        (return nil)))

(defun INFILE (f_name)
  (open f_name :DIRECTION :input))

(defun OUTFILE (f_name)
  (open f_name :DIRECTION :output :IF-EXISTS :new-version))

(defun OPS-CLOSEFILE (z)
  ($reset)
  (eval-args z)
  (dolist (file (use-result-array))
    (prog (port)
          (cond ((not (symbolp file))
                 (%warn "CLOSEFILE: illegal file identifier" file))
                ((setf port ($ifile file))
                 (close port)
                 (rem-ops-prop file (global-inputfile-props)))
                ((setf port ($ofile file))
                 (close port)
                 (rem-ops-prop file (global-outputfile-props))))
          (return nil))))  ;; only return from PROG


(defun OPS-DEFAULT (z)
  (prog (file use)
        ($reset)
        (eval-args z)
        (cond ((not (equal ($parametercount) 2.))
               (%warn "DEFAULT: wrong number of arguments" z)
               (return nil)))
        (setf file ($parameter 1))
        (setf use ($parameter 2))
        (cond ((not (symbolp file))
               (%warn "DEFAULT: illegal file identifier" file)
               (return nil))
              ((not (member use '(write accept trace) :TEST #'eq))
               (%warn "DEFAULT: illegal use for a file" use)
               (return nil))
              ((and (member use '(write trace) :TEST #'eq)
                    (not (null file))
                    (not ($ofile file)))
               (%warn "DEFAULT: file has not been opened for output" file)
               (return nil))
              ((and (equal use 'accept) 
                    (not (null file))
                    (not ($ifile file)))
               (%warn "DEFAULT: file has not been opened for input" file)
               (return nil))
              ((eq use 'write) (setf (global-write-file) file))
              ((eq use 'accept) (setf (global-accept-file) file))
              ((eq use 'trace) (setf (global-trace-file) file)))
        (return nil)))


(defun OPS-ACCEPT (z)
  (prog (port arg)
        (cond ((> (length z) 1.)
               (%warn "ACCEPT: wrong number of arguments" z)
               (return nil)))
        (setf port *standard-input*)
        (cond ((global-accept-file)
               (setf port ($ifile (global-accept-file)))
               (cond ((null port) 
                      (%warn "ACCEPT: file has been closed" (global-accept-file))
                      (return nil)))))
        (cond ((= (length z) 1)
               (setf arg ($varbind (first z)))
               (cond ((not (symbolp arg))
                      (%warn "ACCEPT: illegal file name" arg)
                      (return nil)))
               (setf port ($ifile arg))
               (cond ((null port) 
                      (%warn "accept: file not open for input" arg)
                      (return nil)))))
        (cond ((equal (peek-char t port nil "eof" ) "eof" )
               ($value 'end-of-file)
               (return nil)))
        (flat-value (read port)))) 



;;; Dario Giuse - completely changed the algorithm. It now uses one read-line
;;; and the read-from-string.
;;;
(defun OPS-ACCEPTLINE (z)
  (let ((port *standard-input*)
	(def z))
    (cond ((global-accept-file)
	   (setf port ($ifile (global-accept-file)))
	   (cond ((null port) 
		  (%warn "ACCEPTLINE: file has been closed"
			 (global-accept-file))
		  (return-from ops-acceptline nil)))))
    (cond ((> (length def) 0)
	   (let ((arg ($varbind (first def))))
	     (cond ((and (symbolp arg) ($ifile arg))
		    (setf port ($ifile arg))
		    (setf def (rest def)))))))
    (let ((line (read-line port nil 'eof)))
      (declare (simple-string line))
      ;; Strip meaningless characters from start and end of string.
      (setf line (string-trim '(#\( #\) #\, #\tab #\space) line))
      (when (equal line "")
	(mapc #'$change def)
	(return-from ops-acceptline nil))
      (setf line (concatenate 'simple-string "(" line ")"))
      ;; Read all items from the line
      (flat-value (read-from-string line)))))

(defun OPS-RJUST (z)
  (prog (val)
    (cond ((not (= (length z) 1.))
	   (%warn "RJUST: wrong number of arguments" z)
	   (return nil)))
    (setf val ($varbind (first z)))
    (cond ((or (not (numberp val)) (< val 1.) (> val 127.))
	   (%warn "RJUST: illegal value for field width" val)
	   (return nil)))
    ($value '|=== R J U S T ===|)
    ($value val)))


(defun OPS-CRLF (z)
  (cond  (z (%warn "CRLF: does not take arguments" z))
	 (t ($value '|=== C R L F ===|))))

(defun OPS-TABTO (z)
  (prog (val)
        (cond ((not (= (length z) 1.))
               (%warn "TABTO: wrong number of arguments" z)
               (return nil)))
        (setf val ($varbind (first z)))
        (cond ((or (not (numberp val)) (< val 1.) (> val 127.))
               (%warn "TABTO: illegal column number" z)
               (return nil)))
        ($value '|=== T A B T O ===|)
        ($value val)))


(defun DO-RJUST (width value port)
  (prog (size)
        (cond ((eq value '|=== T A B T O ===|)
               (%warn "RJUST cannot precede this function" 'tabto)
               (return nil))
              ((eq value '|=== C R L F ===|)
               (%warn "RJUST cannot precede this function" 'crlf)
               (return nil))
              ((eq value '|=== R J U S T ===|)
               (%warn "RJUST cannot precede this function" 'rjust)
               (return nil)))
        ;original->        (setf size (flatc value (1+ width)))
        (setf size (min value (1+ width))) ;### KLUGE
        (cond ((> size width)
               (princ " " port)
               (princ value port)
               (return nil)))
        (princ value port)))

(defun DO-TABTO (col port)
  (prog (pos)
        (finish-output port)               ;kluge
        (setf pos 0)                       ;kluge
        (cond ((> pos col)
               (terpri port)
               (setf pos 1)))
        (return nil)))

(defun FLAT-VALUE (x)
  (cond ((atom x) ($value x))
	(t (mapc #'flat-value x)))) 

;;; Printing WM

(defun OPS-PPWM (avlist)
  (prog (next a)
        (setf (global-filters) nil)
        (setf next 1)
     loop
        (and (atom avlist) (go print))
        (setf a (first avlist))
        (setf avlist (rest avlist))
        ;this must be expecting (ppwm class ^ attr ^ attr2 ...) not ^attr
        (cond ((eq a '^)
               (setf next (first avlist))
               (setf avlist (rest avlist))
               (setf next ($litbind next))
               (and (floatp next) (setf next (floor next)))
               (cond ((or (not (numberp next))
                          (> next (global-size-result-array))
                          (> 1. next))
                      (%warn "illegal index after ^" next)
                      (return nil))))
              ((variablep a)
               (%warn "PPWM: does not take variables" a)
               (return nil))
              (t (setf (global-filters) (cons next (cons a (global-filters))))
                 (setf next (1+ next))))
        (go loop)
     print
        (mapwm #'ppwm2)
        (terpri)
        (return nil))) 


(defun PPWM2 (elm-tag)
  (cond ((filter (first elm-tag))
	 (terpri) (ppelm (first elm-tag) (default-write-file))))) 


(defun DEFAULT-WRITE-FILE ()
  (prog (port)
        (setf port *standard-output*)
        (cond ((global-write-file)
               (setf port ($ofile (global-write-file)))
               (cond ((null port) 
                      (%warn "WRITE: file has been closed" (global-write-file))
                      (setf port *standard-output*)))))
        (return port)))


(defun TRACE-FILE ()
  (prog (port)
        (setf port *standard-output*)
        (cond ((global-trace-file)
               (setf port ($ofile (global-trace-file)))
               (cond ((null port)
                      (%warn "TRACE: file has been closed" (global-trace-file))
                      (setf port *standard-output*)))))
        (return port)))


(defun FILTER (elm)
  (prog (fl indx val)
        (setf fl (global-filters))
     top
        (and (atom fl) (return t))
        (setf indx (first fl))
        (setf val (second fl))
        (setf fl (cddr fl))
        (and (ident (nth (1- indx) elm) val) (go top))
        (return nil))) 

(defun IDENT (x y)
  (cond ((eq x y) t)
	((not (numberp x)) nil)
	((not (numberp y)) nil)
	((=alg x y) t)
	(t nil))) 

; the new ppelm is designed especially to handle literalize format
; however, it will do as well as the old ppelm on other formats

(defun PPELM (elm port)
  (prog (ppdat sep val att mode lastpos)
        (format port "~4d:  " (creation-time elm))
        (setf mode 'vector)
        (setf ppdat (get-ops-prop (first elm) (global-ppdat-props)))
        (and ppdat (setf mode 'a-v))
        (setf sep "(")
        (setf lastpos 0)
        (do ((curpos 1 (1+ curpos)) (vlist elm (rest vlist)))
            ((atom vlist) nil)               ; terminate
          (setf val (first vlist))           ; tagbody begin
          (setf att (assoc curpos ppdat))    ; should ret (curpos attr-name) 
          (if att
              (setf att (rest att))          ; att = (attr-name) ??
              (setf att curpos))
          (when (and (symbolp att) (is-vector-attribute att))
            (setf mode 'vector))
          (cond ((or (not (null val)) (eq mode 'vector))
                 (princ sep port)
                 (ppval val att lastpos port)
                 (setf sep "   ")
                 (setf lastpos curpos))))
        (princ ")" port)))

;;; ---------------------------------------------------------------------------

(defun PPVAL (val att lastpos port)
  (unless (equal att (1+ lastpos))
    (format port "^~A " att))
  (princ val port))

;;; ---------------------------------------------------------------------------
;;; Printing production memory

(defun OPS-PM (z)
  (mapc #'pprule z)
  (terpri)
  nil)

;;; ---------------------------------------------------------------------------

(defun PPRULE (name)
  (unless (symbolp name)
    (return-from pprule nil))
  (prog (matrix next lab)
        (setf matrix (get-ops-prop name (global-production-props)))
        (when (null matrix)
          (return-from pprule nil))
        (format t "~&(p ~A" name)
     top
	(when (atom matrix)
          (go fin))
        (setf next (first matrix))
        (setf matrix (rest matrix))
        (setf lab nil)
        (terpri)
        (cond ((eq next '-)
               (princ "  - ")
               (setf next (first matrix))
               (setf matrix (rest matrix)))
              ((eq next '-->)
               (princ "  "))
              ((and (eq next '{) (atom (first matrix)))
               (princ "   {")
               (setf lab (first matrix))
               (setf next (second matrix))
               (setf matrix (cdddr matrix)))
              ((eq next '{)
               (princ "   {")
               (setf lab (second matrix))
               (setf next (first matrix))
               (setf matrix (cdddr matrix)))
              (t (princ "    ")))
        (ppline next)
        (cond (lab (princ " ") (princ lab) (princ "}")))
        (go top)
     fin
	(princ ")")))

(defun PPLINE (line)
  (prog ()
        (cond ((atom line) (princ line))
              (t
               (princ "(")
               (setf (global-ppline) line)
               (ppline2)
               (princ ")")))
        (return nil)))

(defun PPLINE2 ()
  (prog (needspace)
        (setf needspace nil)
     top
        (and (atom (global-ppline)) (return nil))
        (and needspace (princ " "))
        (cond ((eq (first (global-ppline)) '^) (ppattval))
              (t (pponlyval)))
        (setf needspace t)
        (go top)))

(defun PPATTVAL ()
  (prog (att val)
        (setf att (second (global-ppline)))
        (setf (global-ppline) (cddr (global-ppline)))
        (setf val (getval))
        (princ "^")
        (princ att)
        (mapc #'(lambda (z) (princ " ") (princ z)) val)))

(defun PPONLYVAL ()
  (prog (val needspace)
        (setf val (getval))
        (setf needspace nil)
     top
	(and (atom val) (return nil))
        (and needspace (princ " "))
        (setf needspace t)
        (princ (first val))
        (setf val (rest val))
        (go top)))

(defun GETVAL ()
  (prog (res v1)
        (setf v1 (first (global-ppline)))
        (setf (global-ppline) (rest (global-ppline)))
        (cond ((member v1 '(= <> < <= => > <=>) :TEST #'eq)
               (setf res (cons v1 (getval))))
              ((eq v1 '{)
               (setf res (cons v1 (getupto '}))))
              ((eq v1 '<<)
               (setf res (cons v1 (getupto '>>))))
              ((eq v1 '//)
               (setf res (list v1 (first (global-ppline))))
               (setf (global-ppline) (rest (global-ppline))))
              (t (setf res (list v1))))
        (return res)))

(defun GETUPTO (end)
  (prog (v)
        (and (atom (global-ppline)) (return nil))
        (setf v (first (global-ppline)))
        (setf (global-ppline) (rest (global-ppline)))
        (cond ((eq v end) (return (list v)))
              (t (return (cons v (getupto end))))))) 

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------
