;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-GLOBALS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:23:35 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                    OPS5 ``Global Variable'' Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains the conversion code required to localize all OPS global
;;; references into a single structure.
;;;
;;; Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

(export '(*ops-globals-structure*))

;;; ---------------------------------------------------------------------------

(defconstant *OPS-MAXIMUM-FIELD-COUNT* 64

  "*OPS-MAXIMUM-FIELD-COUNT*

Sets the maximum number of field names available in OPS.  Changes require
recompilation of all OPS files.")

;;; ---------------------------------------------------------------------------

(defconstant *ENCODE-FACTOR* (expt 2 13)

  "*ENCODE-FACTOR*

The multiplication factor used to encode numeric pairs.  Changes require
recompilation of all OPS files.")

;;; ---------------------------------------------------------------------------

(defparameter *OPS-EXTERNAL-DECLARATION-REQUIRED* nil

  "*OPS-EXTERNAL-DECLARATION-REQUIRED*

Specifies whether or not an EXTERNAL declaration is required before using
a routine in a CALL statement.")

;;; ---------------------------------------------------------------------------

(defvar *OPS-GLOBALS-STRUCTURE* :uninitialized

  "*OPS-GLOBALS-STRUCTURE*

Contains the global variable structure.")

;;; ---------------------------------------------------------------------------

(defvar *OPS-SAVED-RESULT-RESOURCE* `()

  "*OPS-SAVED-RESULT-RESOURCE*

A list of saved result elements treated as a resource.")

;;; ---------------------------------------------------------------------------

(eval-when (eval compile load)
  (defconstant *OPS-GLOBALS*
               '(accept-file
                  action-count
                  action-type
                  alpha-data-part
                  alpha-flag-part
                  break-flag
                  break-on-entry
                  brkpts
                  build-trace
                  buckets
                  class-list 
                  conflict-set
                  ce-count
                  ce-variable-memory
                  ce-vars
                  critical
                  cur-vars
                  curcond
                  current-token
                  current-wm
                  cycle-count
                  data-matched
                  data-part
                  feature-count
                  filters
                  first-node
                  flag-part
                  halt-flag
                  halt-messages
                  in-rhs
                  last
                  last-branch
                  last-node
                  limit-cs
                  limit-token
                  matrix
                  max-cs
                  max-index
                  max-record-index
                  max-token
                  max-wm
                  next-index
                  p-name
                  pcount
                  phase
                  ppline
                  ptrace
                  real-cnt
                  record
                  record-array
                  record-index
                  recording
                  recording-disabled
                  refracts
                  registers
                  remaining-cycles
                  rest
                  result-array
                  return-values     ; used to return values from OPS
                  rhs-bound-ce-vars
                  rhs-bound-vars
                  sendtocall
                  side
                  size-result-array
                  startup-forms
                  strategy
                  subnum
                  total-token
                  total-cs
                  total-wm
                  trace-file
                  variable-memory
                  vars
                  virtual-cnt
                  wmpart-list
                  write-file
                  wtrace

                  ;; PROPERTIES
                  att-list-props
                  backpointers-props
                  conflicts-props
                  external-routine-props
                  inputfile-props
                  ops-bind-props
                  outputfile-props
                  ppdat-props
                  production-props         ; contains all productions
                  topnode-props
                  vector-attribute-props
                  wmpart*-props)))

(eval-when (compile load eval)
  (eval `(defstruct (GLOBAL (:CONC-NAME "%OPS-GLOBAL$"))
           ,@*ops-globals*))

  (defun CONSTRUCT-GLOBAL-ACCESSOR (slot)
    (let* ((slot-pname (symbol-name slot))
           (function-name (intern (concatenate
                                    'simple-string
                                    "GLOBAL-"
                                    slot-pname)))
           (defstruct-accessor-name
             (intern (concatenate
                       'simple-string
                       "%OPS-GLOBAL$"
                       slot-pname))))
      `(defmacro ,function-name ()
         '(,defstruct-accessor-name *ops-globals-structure*))))

  (defmacro CONSTRUCT-GLOBAL-ACCESSORS (slots)
    `(progn
       ,@(mapcar #'construct-global-accessor slots)))

  (construct-global-accessors #.*ops-globals*))

;;; ---------------------------------------------------------------------------

(defun GLOBAL-INIT ()

  "GLOBAL-INIT nil

This function initializes the GLOBAL file constants."

  (global-reinit)
  (setf *ops-globals-structure* (make-global)))

;;; ---------------------------------------------------------------------------

(defun GLOBAL-REINIT ()

  "GLOBAL-REINIT nil

This function reinitializes the GLOBAL file constants for the next
OPS invocation instance."

  nil)


;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------

