;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-COMPILE.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:23:08 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                OPS5 Production Compilation Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains functions for compiling productions.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

(shadow '(remove write))

(export '(--> ))


;;; External global variables
;;; *REAL-CNT*, *VIRTUAL-CNT*, *LAST-NODE*, *FIRST-NODE*, *P-NAME*, and *PCOUNT*.


;;; Internal global variables
;;; *MATRIX*, *CURCOND*, *FEATURE-COUNT*, *CE-COUNT*, *VARS*, *CE-VARS*, 
;;; *RHS-BOUND-VARS*, *RHS-BOUND-CE-VARS*, *LAST-BRANCH*, *SUBNUM*, 
;;; *CUR-VARS*, and *ACTION-TYPE*.


(eval-when (compile eval load)

  (defmacro PEEK-LEX ()
    '(first (global-matrix))) 
  
  (defmacro END-OF-P ()
    '(atom (global-matrix))) 
  
  (defmacro REST-OF-P ()
    '(global-matrix)) 
  
  (defmacro PREPARE-LEX (prod)
    `(setf (global-matrix) ,prod)) 
  
  (defmacro PEEK-SUBLEX ()
    '(first (global-curcond))) 
  
  (defmacro END-OF-CE ()
    '(atom (global-curcond))) 
  
  (defmacro REST-OF-CE ()
    '(global-curcond)) 
  
  (defmacro PREPARE-SUBLEX (ce)
    `(setf (global-curcond) ,ce)) 
  
  (defmacro MAKE-BOTTOM-NODE ()
    '(setf (global-first-node) (list '&bus nil))) 
  
  (defmacro RATING-PART (pnode)
    `(second ,pnode)) 
  
  (defmacro VAR-PART (pnode)
    `(fourth ,pnode))
  
  (defmacro CE-VAR-PART (pnode)
    `(fifth ,pnode))
  
  (defmacro RHS-PART (pnode)
    `(sixth ,pnode))
  
  (defmacro CMP-NEGCE ()
    '(progn
       (lex)
       (cmp-ce)))
  
  (defmacro INCR-SUBNUM ()
    '(incf (global-subnum)))
  
  (defmacro CURRENT-FIELD ()
    '(field-name (global-subnum))) 
  
  (defmacro VAR-DOPE (var)
    `(assq ,var (global-vars)))
  
  (defmacro CE-VAR-DOPE (var)
    `(assq ,var (global-ce-vars)))
  
  (defmacro CMP-NEW-VAR (name test)
    `(push (list ,name ,test (global-subnum)) (global-cur-vars)))
  
  (defmacro CMP-NOT ()
    '(cmp-beta '&not)) 
  
  (defmacro CMP-NOBETA ()
    '(cmp-beta nil)) 
  
  (defmacro CMP-AND ()
    '(cmp-beta '&and)) 

  ; the following two functions encode indices so that GELM can
  ; decode them as fast as possible
  
  (defmacro ENCODE-PAIR (a b)
    `(+ (* (1- ,a) *encode-factor*) (1- ,b))) 
  
  (defmacro ENCODE-SINGLETON (a)
    `(1- ,a)) 
  
  (defmacro PROTOMEM ()
    '(list nil)) 
  
  (defmacro MEMORY-PART (mem-node)
    `(first (fourth ,mem-node)))
  
  (defmacro RIGHT-OUTS (node)
    `(third ,node)) 
  
  (defmacro LEFT-OUTS (node)
    `(second ,node)) 
  
  (defmacro CHECK-CRLF (x) 
    `(check-0-args ,x)) 
  
  (defmacro CHECK-GENATOM (x) 
    `(check-0-args ,x)) 
  
  (defmacro CHECK-COMPUTE (x)
    `(check-arithmetic (rest ,x)))
  
  (defmacro NOTE-VARIABLE (var)
    `(push ,var (global-rhs-bound-vars)))
  
  (defmacro NOTE-CE-VARIABLE (ce-var)
    `(push ,ce-var (global-rhs-bound-ce-vars)))
  
  ) ; end eval-when

;;; ---------------------------------------------------------------------------

(defun COMPILE-INIT ()

  "COMPILE-INIT nil

This function initializes the COMPILE file constants."

  (compile-reinit)
  (setf (global-real-cnt) 0)
  (setf (global-virtual-cnt) 0)
  (setf (global-pcount) 0)
  (make-bottom-node))

;;; ---------------------------------------------------------------------------

(defun COMPILE-REINIT ()

  "COMPILE-REINIT nil

This function reinitializes the COMPILE file constants for the next
OPS invocation instance."

  nil)

;;; ---------------------------------------------------------------------------
;;;
;;; LHS Compiler
;;;
;;; ---------------------------------------------------------------------------

(defun OPS-P (z) 
  (finish-literalize)
  (force-output)
  (compile-production (first z) (rest z))) 

;;; ---------------------------------------------------------------------------

(defun COMPILE-PRODUCTION (name matrix)
  (setf (global-p-name) name)
  (catch '!error! (cmp-p name matrix))
  (setf (global-p-name) nil))

;;; ---------------------------------------------------------------------------

(defun LEX ()
  (pop (global-matrix)))

;;; ---------------------------------------------------------------------------

(defun SUBLEX ()
  (pop (global-curcond)))

;;; ---------------------------------------------------------------------------

(defun CMP-P (name matrix)
  (prog (m bakptrs)
        (cond ((or (null name) (consp name))
               (%error "Illegal production name:" nil name))
              ((equal (get-ops-prop name (global-production-props)) matrix)
               (return nil)))
        (prepare-lex matrix)
        (excise-p name)
        (setf bakptrs nil)
        (incf (global-pcount))
        (setf (global-feature-count) 0)
        (setf (global-ce-count) 0)
        (setf (global-vars) nil)
        (setf (global-ce-vars) nil)
        (setf (global-rhs-bound-vars) nil)
        (setf (global-rhs-bound-ce-vars) nil)
        (setf (global-last-branch) nil)
        (setf m (rest-of-p))
     l1
        (and (end-of-p) (%error "No ``-->'' in production:" nil m))
        (cmp-prin)
        (setf bakptrs (cons (global-last-branch) bakptrs))
        (or (eq '--> (peek-lex)) (go l1))
        (lex)
        (check-rhs (rest-of-p))
        (link-new-node (list '&p
                             (global-feature-count)
                             name
                             (encode-dope)
                             (encode-ce-dope)
                             (cons 'progn (rest-of-p))))
        (put-ops-prop name (rest (nreverse bakptrs)) (global-backpointers-props))
        (put-ops-prop name matrix (global-production-props))
        (put-ops-prop name (global-last-node) (global-topnode-props)))) 

;;; ---------------------------------------------------------------------------

(defun CMP-PRIN ()
  (setf (global-last-node) (global-first-node))
  (cond ((null (global-last-branch))
         (cmp-posce)
         (cmp-nobeta))
        ((eq (peek-lex) '-)
         (cmp-negce)
         (cmp-not))
        (t
         (cmp-posce)
         (cmp-and))))

;;; ---------------------------------------------------------------------------

(defun CMP-POSCE ()
  (incf (global-ce-count))
  (cond ((eq (peek-lex) '\{)
         (cmp-ce+cevar))
	(t
         (cmp-ce)))) 

;;; ---------------------------------------------------------------------------

(defun CMP-CE+CEVAR ()
  (prog (z)
    (lex)
    (cond ((atom (peek-lex)) (cmp-cevar) (cmp-ce))
	  (t (cmp-ce) (cmp-cevar)))
    (setf z (lex))
    (or (eq z '\}) (%error "Missing ``}'':" nil z)))) 

;;; ---------------------------------------------------------------------------

(defun NEW-SUBNUM (k)
  (unless (numberp k)
    (%error "Tab must be a number:" nil k))
  (setf (global-subnum) (floor k)))

;;; ---------------------------------------------------------------------------

(defun CMP-CE ()
  (prog (z)
        (new-subnum 0)
        (setf (global-cur-vars) nil)
        (setf z (lex))
        (and (atom z)
             (%error "Atomic conditions are not allowed:" nil z))
        (prepare-sublex z)
     la
        (when (end-of-ce)
          (return nil))
        (incr-subnum)
        (cmp-element)
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun CMP-ELEMENT ()
  (when (eq (peek-sublex) '^)
    (cmp-tab))
  (cond ((eq (peek-sublex) '\{)
         (cmp-product))
	(t (cmp-atomic-or-any))))

;;; ---------------------------------------------------------------------------

(defun CMP-ATOMIC-OR-ANY ()
  (cond ((eq (peek-sublex) '<<)
         (cmp-any))
	(t (cmp-atomic))))

;;; ---------------------------------------------------------------------------

(defun CMP-ANY ()
  (prog (a z)
        (sublex)
        (setf z nil)
     la
        (when (end-of-ce)
          (%error "Missing ``>>'':" nil a))
        (setf a (sublex))
        (unless (eq '>> a)
          (setf z (cons a z))
          (go la))
        (link-new-node `(&any nil ,(current-field) ,z))))

;;; ---------------------------------------------------------------------------

(defun CMP-TAB ()
  (sublex)
  (new-subnum ($litbind (sublex))))

;;; ---------------------------------------------------------------------------

(defun GET-BIND (x)
  (when (symbolp x)
    (literal-binding-of x)))

;;; ---------------------------------------------------------------------------

(defun CMP-ATOMIC ()
  (let ((x (peek-sublex)))
    (cond ((eq x '= ) (sublex) (cmp-symbol 'eq))
	  ((eq x '<>) (sublex) (cmp-symbol 'ne))
	  ((eq x '<) (sublex) (cmp-symbol 'lt))
	  ((eq x '<=) (sublex) (cmp-symbol 'le))
	  ((eq x '>) (sublex) (cmp-symbol 'gt))
	  ((eq x '>=) (sublex) (cmp-symbol 'ge))
	  ((eq x '<=>) (sublex) (cmp-symbol 'xx))
	  (t (cmp-symbol 'eq)))))

;;; ---------------------------------------------------------------------------

(defun CMP-PRODUCT ()
  (prog (save)
        (setf save (rest-of-ce))
        (sublex)
     la
        (cond ((end-of-ce)
               (cond ((member '\} save :TEST #'eq) 
                      (%error "Wrong context for ``}'':" nil save))
                     (t (%error "Missing ``}'':" nil save))))
              ((eq (peek-sublex) '\})
               (sublex)
               (return nil)))
        (cmp-atomic-or-any)
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun CMP-SYMBOL (test)
  (let ((flag t))
    (when (eq (peek-sublex) '//)
      (sublex)
      (setf flag nil))
    (cond ((and flag (variablep (peek-sublex)))
           (cmp-var test))
          ((numberp (peek-sublex))
           (cmp-number test))
          ((symbolp (peek-sublex))
           (cmp-constant test))
          (t (%error "Unrecognized symbol:" nil (sublex)))))) 

;;; ---------------------------------------------------------------------------

(defun CMP-CONSTANT (test)
  (link-new-node
    (list
      (case test
        (eq 'teqa)
        (ne 'tnea)
        (xx 'txxa)
        (otherwise
         (%error "Non-numeric constant after numeric predicate:" nil
                 (sublex))))
      nil
      (current-field)
      (sublex))))

;;; ---------------------------------------------------------------------------

(defun CMP-NUMBER (test)
  (link-new-node
    (list
      (case test
        (eq 'teqn)
        (ne 'tnen)
        (xx 'txxn)
        (lt 'tltn)
        (gt 'tgtn)
        (ge 'tgen)
        (le 'tlen)
        (otherwise
         (%error "Unknown predicate:" nil (sublex))))
      nil
      (current-field)
      (sublex))))

;;; ---------------------------------------------------------------------------

(defun FIELD-NAME (num)
  (unless (< 0 num *ops-maximum-field-count*)
    (%error "Condition is too long:" nil (rest-of-ce)))
  num)

;;;; ---------------------------------------------------------------------------
;;;; Compiling variables
;;;;
;;;;
;;;;
;;;; *cur-vars* are the variables in the condition element currently 
;;;; being compiled.  *vars* are the variables in the earlier condition
;;;; elements.  *ce-vars* are the condition element variables.  note
;;;; that the interpreter will not confuse condition element and regular
;;;; variables even if they have the same name.
;;;;
;;;; *cur-vars* is a list of triples: (name predicate subelement-number)
;;;; eg:		( (<x> eq 3)
;;;;		  (<y> ne 1)
;;;;		  . . . )
;;;;
;;;; *vars* is a list of triples: (name ce-number subelement-number)
;;;; eg:		( (<x> 3 3)
;;;;		  (<y> 1 1)
;;;;		  . . . )
;;;;
;;;; *ce-vars* is a list of pairs: (name ce-number)
;;;; eg:		( (ce1 1)
;;;;		  (<c3> 3)
;;;;		  . . . )

(defun CMP-VAR (test)
  (let* ((name (sublex))
         (old (assq name (global-cur-vars))))
    (cond ((and old (eq (second old) 'eq))
	   (cmp-old-eq-var test old))
	  ((and old (eq test 'eq))
           (cmp-new-eq-var name old))
	  (t (cmp-new-var name test)))))

;;; ---------------------------------------------------------------------------

(defun CMP-OLD-EQ-VAR (test old)
  (link-new-node
    (list
      (case test
        (eq 'teqs)
        (ne 'tnes)
        (xx 'txxs)
        (lt 'tlts)
        (gt 'tgts)
        (ge 'tges)
        (le 'tles)
        (otherwise
         (%error "Unknown predicate:" nil test))) 
      nil
      (current-field)
      (field-name (third old))))) 

;;; ---------------------------------------------------------------------------

(defun CMP-NEW-EQ-VAR (name old)
  (setf (global-cur-vars) (delq old (global-cur-vars)))
  (let (pred
        (next (assq name (global-cur-vars))))
    (cond (next (cmp-new-eq-var name next))
          (t (cmp-new-var name 'eq)))
    (setf pred (second old))
    (link-new-node
      (list
        (case pred
          (eq 'teqs)
          (ne 'tnes)
          (xx 'txxs)
          (lt 'tlts)
          (gt 'tgts)
          (ge 'tges)
          (le 'tles)
          (otherwise
           (%error "Unknown predicate:" nil pred)))
        nil
        (field-name (third old))
        (current-field)))))

;;; ---------------------------------------------------------------------------

(defun CMP-CEVAR ()
  (let* ((name (lex))
         (old (assq name (global-ce-vars))))
    (when old
      (%error "Condition element variable used twice:" nil name))
    (push (list name 0) (global-ce-vars))))

;;; ---------------------------------------------------------------------------

(defun CMP-BETA (kind)
  (prog (tlist vdope vname old)
        (setf tlist nil)
     la
        (and (atom (global-cur-vars)) (go lb))
        (setf vdope (first (global-cur-vars)))
        (setf (global-cur-vars) (rest (global-cur-vars)))
        (setf vname (first vdope))
        (setf old (assq vname (global-vars)))
        (cond (old
               (setf tlist (add-test tlist vdope old)))
              ((not (eq kind '&not))
               (promote-var vdope)))
        (go la)
     lb
        (when kind
          (build-beta kind tlist))
        (unless (eq kind '&not)
          (fudge))
        (setf (global-last-branch) (global-last-node)))) 

;;; ---------------------------------------------------------------------------

(defun ADD-TEST (list new old)
  (incf (global-feature-count))
  (list* 
    (let ((test (second new)))
      (case test
        (eq 'teqb)
        (ne 'tneb)
        (xx 'txxb)
        (lt 'tltb)
        (gt 'tgtb)
        (ge 'tgeb)
        (le 'tleb)
        (otherwise
         (%error "Unknown predicate:" nil (second new)))))
    (encode-pair (second old) (third old))
    (encode-singleton (third new))
    list))

;;; ---------------------------------------------------------------------------

(defun PROMOTE-VAR (dope)
  (let ((vname (first dope))
        (vpred (second dope))
        (vpos (third dope)))
    (unless (eq 'eq vpred)
      (%error "Illegal predicate for first occurrence:" nil
              (list vname vpred)))
    (push (list vname 0 vpos) (global-vars))))

;;; ---------------------------------------------------------------------------

(defun FUDGE ()
  (mapc #'fudge* (global-vars))
  (mapc #'fudge* (global-ce-vars))) 

;;; ---------------------------------------------------------------------------

(defun FUDGE* (z)
  (rplaca (rest z) (1+ (first (rest z)))))

;;; ---------------------------------------------------------------------------

(defun BUILD-BETA (type tests)
  (link-new-node (list '&mem nil nil (protomem)))
  (prog (rpred lpred lnode lef)
        (setf rpred (global-last-node))
        (cond ((eq type '&and)
               (setf lnode (list '&mem nil nil (protomem))))
              (t (setf lnode (list '&two nil nil))))
        (setf lpred (link-to-branch lnode))
        (cond ((eq type '&and) (setf lef lpred))
              (t (setf lef (protomem))))
        (link-new-beta-node (list type nil lef rpred tests)))) 

;;; ---------------------------------------------------------------------------

(defun ENCODE-DOPE ()
  (prog (r all z)
        (setf r nil)
        (setf all (global-vars))
     la
        (and (atom all) (return r))
        (setf z (first all))
        (setf all (rest all))
        (setf r (cons (first z) (cons (encode-pair (second z) (third z)) r)))
        (go la))) 

;;; ---------------------------------------------------------------------------

(defun ENCODE-CE-DOPE ()
  (prog (r all z)
        (setf r nil)
        (setf all (global-ce-vars))
     la
        (and (atom all) (return r))
        (setf z (first all))
        (setf all (rest all))
        (setf r (cons (first z) (cons (second z) r)))
        (go la))) 

;;;; ---------------------------------------------------------------------------
;;;; Linking the nodes

(defun LINK-NEW-NODE (r)
  (cond ((not (member (first r) '(&p &mem &two &and &not) :TEST #'eq))
	 (incf (global-feature-count))))
  (incf (global-virtual-cnt))
  (setf (global-last-node) (link-left (global-last-node) r))) 

;;; ---------------------------------------------------------------------------

(defun LINK-TO-BRANCH (r)
  (incf (global-virtual-cnt))
  (setf (global-last-branch) (link-left (global-last-branch) r))) 

;;; ---------------------------------------------------------------------------

(defun LINK-NEW-BETA-NODE (r)
  (incf (global-virtual-cnt))
  (setf (global-last-node) (link-both (global-last-branch) (global-last-node) r))
  (setf (global-last-branch) (global-last-node))) 

;;; ---------------------------------------------------------------------------

(defun LINK-LEFT (pred succ)
  (prog (a r)
    (setf a (left-outs pred))
    (setf r (find-equiv-node succ a))
    (and r (return r))
    (incf (global-real-cnt))
    (attach-left pred succ)
    (return succ))) 

;;; ---------------------------------------------------------------------------

(defun LINK-BOTH (left right succ)
  (prog (a r)
    (setf a (interq (left-outs left) (right-outs right)))
    (setf r (find-equiv-beta-node succ a))
    (and r (return r))
    (incf (global-real-cnt))
    (attach-left left succ)
    (attach-right right succ)
    (return succ))) 

;;; ---------------------------------------------------------------------------

(defun ATTACH-RIGHT (old new)
  (rplaca (cddr old) (cons new (third old)))) 

;;; ---------------------------------------------------------------------------

(defun ATTACH-LEFT (old new)
  (rplaca (rest old) (cons new (second old)))) 

;;; ---------------------------------------------------------------------------

(defun FIND-EQUIV-NODE (node list)
  (prog (a)
        (setf a list)
     l1
        (cond ((atom a) (return nil))
              ((equiv node (first a)) (return (first a))))
        (setf a (rest a))
        (go l1))) 

;;; ---------------------------------------------------------------------------

(defun FIND-EQUIV-BETA-NODE (node list)
  (prog (a)
        (setf a list)
     l1
        (cond ((atom a) (return nil))
              ((beta-equiv node (first a)) (return (first a))))
        (setf a (rest a))
        (go l1))) 

; do not look at the predecessor fields of beta nodes; they have to be
; identical because of the way the candidate nodes were found

;;; ---------------------------------------------------------------------------

(defun EQUIV (a b)
  (and (eq (first a) (first b))
       (or (eq (first a) '&mem)
	   (eq (first a) '&two)
	   (equal (third a) (third b)))
       (equal (cdddr a) (cdddr b)))) 

;;; ---------------------------------------------------------------------------

(defun BETA-EQUIV (a b)
  (and (eq (first a) (first b))
       (equal (cddddr a) (cddddr b))
       (or (eq (first a) '&and)
           (equal (third a) (third b))))) 

; the equivalence tests are set up to consider the contents of
; node memories, so they are ready for the build action


;;; ---------------------------------------------------------------------------
;;;
;;; Check the RHSs of productions 
;;;
;;; ---------------------------------------------------------------------------

(defun CHECK-RHS (rhs)
  (mapc #'check-action rhs))

;;; ---------------------------------------------------------------------------

(defun CHECK-ACTION (x)
  (prog (a)
        (cond ((atom x)
               (%warn "atomic action" x)
               (return nil)))
        (setf a (setf (global-action-type) (first x)))
        (case a
          (bind (check-bind x))
          (cbind (check-cbind x))
          (make (check-make x))
          (modify (check-modify x))
          (remove (check-remove x))
          (write (check-write x))	
          (call (check-call x))		
          (cl-call (check-call x))		
          (return-values (check-return-values x))		
          (halt (check-halt x))
          (openfile (check-openfile x))
          (closefile (check-closefile x))
          (default (check-default x))
          (build (check-build x))

          ;; Ignore macro displacing on TI Explorers ::
#+TI
          (sys::displaced nil)

          (t (%warn "Undefined rhs action:" a)))))

;;; ---------------------------------------------------------------------------

(defun CHECK-BUILD (z)
  (check-for-args z)
  (check-build-collect (rest z)))

;;; ---------------------------------------------------------------------------

(defun CHECK-BUILD-COLLECT (args)
  (prog (r)
     top
	(and (null args) (return nil))
        (setf r (first args))
        (setf args (rest args))
        (cond ((consp  r) (check-build-collect r))
              ((eq r '\\)
               (and (null args) (%warn "Nothing to evaluate:" r))
               (check-rhs-value (first args))
               (setf args (rest args))))
        (go top)))

;;; ---------------------------------------------------------------------------

(defun CHECK-REMOVE (z)
  (check-for-args z)
  (mapc #'check-rhs-ce-var (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-MAKE (z)
  (check-for-args z)
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-OPENFILE (z)
  (check-for-args z)
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-CLOSEFILE (z)
  (check-for-args z)
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-DEFAULT (z)
  (check-for-args z)
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-MODIFY (z)
  (check-for-args z)
  (check-rhs-ce-var (second z))
  (and (null (cddr z)) (%warn "No changes to make:" z))
  (check-change& (cddr z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-WRITE (z)
  (check-for-args z) 
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-CALL (z)
  (check-for-args z) 
  (let ((f (second z)))
    (when (variablep f)
      (%warn "Function name must be a constant:" z))
    (unless (symbolp f)
      (%warn "Function name must be a symbolic atom:" f))
    (when (and *ops-external-declaration-required*
               (not (externalp f)))
      (%warn "Function name not declared external:" f))
    (check-change& (cddr z))) )

;;; ---------------------------------------------------------------------------

(defun CHECK-RETURN-VALUES (z)
  (check-for-args z) 
  (check-change& (rest z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-HALT (z)
  (or (null (rest z))
      (%warn "Does not take arguments:" z))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-CBIND (z)
  (prog (v)
    (or (= (length z) 2) (%warn "Takes only one argument:" z))
    (setf v (second z))
    (or (variablep v) (%warn "Takes variable as argument:" z))
    (note-ce-variable v))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-BIND (z)
  (prog (v)
        (check-for-args z) 
        (setf v (second z))
        (or (variablep v) (%warn "Takes variable as argument:" z))
        (note-variable v)
        (check-change& (cddr z)))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-CHANGE& (z)
  (prog (r tab-flag)
    (setf tab-flag nil)
    la   (and (atom z) (return nil))
    (setf r (first z))
    (setf z (rest z))
    (cond ((eq r '^)
	   (and tab-flag
		(%warn "No value before this tab:" (first z)))
	   (setf tab-flag t)
	   (check-tab-index (first z))
	   (setf z (rest z)))
	  ((eq r '//) (setf tab-flag nil) (setf z (rest z)))
	  (t (setf tab-flag nil) (check-rhs-value r)))
    (go la))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-RHS-CE-VAR (v)
  (cond ((and (not (numberp v)) (not (ce-bound? v)))
	 (%warn "Unbound element variable:" v))
	((and (numberp v) (or (< v 1) (> v (global-ce-count))))
	 (%warn "Numeric element designator out of bounds:" v)))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-RHS-VALUE (x)
  (cond ((consp x) (check-rhs-function x))
	(t (check-rhs-atomic x)))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-RHS-ATOMIC (x)
  (and (variablep x) 
       (not (bound? x)) 
       (%warn "Unbound variable:" x)))

;;; ---------------------------------------------------------------------------

(defun CHECK-RHS-FUNCTION (x)
  (prog (a)
    (setf a (first x))
    (cond ((eq a 'compute) (check-compute x))
	  ((eq a 'arith) (check-compute x))
	  ((eq a 'substr) (check-substr x))
	  ((eq a 'accept) (check-accept x))
	  ((eq a 'acceptline) (check-acceptline x))
	  ((eq a 'crlf) (check-crlf x))
	  ((eq a 'genatom) (check-genatom x))
	  ((eq a 'litval) (check-litval x))
	  ((eq a 'tabto) (check-tabto x))
	  ((eq a 'rjust) (check-rjust x))
	  ((and *ops-external-declaration-required*
               (not (externalp a)))
	   (%warn '"RHS function not declared external:" a)))))

;;; ---------------------------------------------------------------------------

(defun EXTERNALP (x)
  (cond ((symbolp x) (get-ops-prop x (global-external-routine-props)))
	(t (%warn "Not a legal function name:" x) nil)))

;;; ---------------------------------------------------------------------------

(defun CHECK-LITVAL (x) 
  (check-number-of-args x 2)
  (check-rhs-atomic (second x)))

;;; ---------------------------------------------------------------------------

(defun CHECK-ACCEPT (x)
  (cond ((= (length x) 1) nil)
	((= (length x) 2) (check-rhs-atomic (second x)))
	(t (%warn "Too many arguments:" x))))

;;; ---------------------------------------------------------------------------

(defun CHECK-ACCEPTLINE (x)
  (mapc #'check-rhs-atomic (rest x)))

;;; ---------------------------------------------------------------------------

(defun CHECK-TABTO (x)
  (check-number-of-args x 2)
  (check-print-control (second x)))

;;; ---------------------------------------------------------------------------

(defun CHECK-RJUST (x)
  (check-number-of-args x 2)
  (check-print-control (second x)))

;;; ---------------------------------------------------------------------------

(defun CHECK-0-ARGS (x)
  (or (= (length x) 1) (%warn "Should not have arguments:" x))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-SUBSTR (x)
  (check-number-of-args x 4)
  (check-rhs-ce-var (second x))
  (check-substr-index (third x))
  (check-last-substr-index (fourth x))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-ARITHMETIC (l)
  (cond ((atom l)
	 (%warn "Syntax error in arithmetic expression:" l))
	((atom (rest l)) (check-term (first l)))
	((not (member (second l) '(+ - * // \\)))
	 (%warn "Unknown operator:" l))
	(t (check-term (first l)) (check-arithmetic (cddr l))))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-TERM (x)
  (cond ((consp x) (check-arithmetic x))
	(t (check-rhs-atomic x)))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-LAST-SUBSTR-INDEX (x)
  (or (eq x 'inf)
      (check-substr-index x))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-SUBSTR-INDEX (x)
  (prog (v)
    (cond ((bound? x) (return x)))
    (setf v ($litbind x))
    (cond ((not (numberp v))
	   (%warn "Unbound symbol used as index in substr:" x))
	  ((or (< v 1) (> v 127))
	   (%warn "Index out of bounds in tab:" x))))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-PRINT-CONTROL (x)
  (prog ()
    (cond ((bound? x) (return x)))
    (cond ((or (not (numberp x)) (< x 1) (> x 127))
	   (%warn "Illegal value for printer control:" x))))) 

;;; ---------------------------------------------------------------------------

(defun CHECK-TAB-INDEX (x)
  (prog (v)
    (cond ((bound? x) (return x)))
    (setf v ($litbind x))
    (cond ((not (numberp v))
	   (%warn "Unbound symbol occurs after ^:" x))
	  ((or (< v 1) (> v 127))
	   (%warn "Index out of bounds after ^:" x))))) 

;;; ---------------------------------------------------------------------------

(defun BOUND? (var)
  (or (member var (global-rhs-bound-vars))
      (var-dope var)))

;;; ---------------------------------------------------------------------------

(defun CE-BOUND? (ce-var)
  (or (member ce-var (global-rhs-bound-ce-vars))
      (ce-var-dope ce-var)))

;;; ---------------------------------------------------------------------------
;;;
;;; Common Warning Messages :::
;;;
;;; ---------------------------------------------------------------------------

(defun CHECK-FOR-ARGS (z)
  (when (null (rest z))
    (%warn "Needs arguments:" z)))

;;; ---------------------------------------------------------------------------

(defun CHECK-NUMBER-OF-ARGS (x n)
  (or (= (length x) n)
      (%warn "Wrong number of arguments:" x)))

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------


