;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:OPS; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.OPS]OPS-BACKUP.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  14:22:40 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                    OPS5 Backup Operation Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; This file contains definitions and functions for the backing up operation.
;;;
;;; OPS5 Modifications Written by: 
;;;             Daniel Corkill
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; These modifications were written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Modifications Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; This GBB version of OPS5 was modified from the public domain version based
;;; in part on based on a Franz Lisp implementation done by Charles L. Forgy
;;; at Carnegie Mellon University.  The public domain version was also
;;; modified by George Wood, Dario Giuse, Skef Wholey, Michael Parzen,
;;; and Dan Kuokka.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments;
;;;    ONR URI grant N00014-86-K-0764;
;;;    a contract with Digital Equipment Corporation.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  04-07-88 File Released.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "OPS")

(export '(back))

;;; Internal Global Variables
;;; *REFRACTS*, *RECORD*, *RECORD-ARRAY*, *RECORDING*, *MAX-RECORD-INDEX*,
;;; and *RECORD-INDEX*.


(defun BACKUP-INIT ()

  "BACKUP-INIT nil

This function initializes the MAIN routine constants."

  (backup-reinit))

;;; ---------------------------------------------------------------------------

(defun BACKUP-REINIT ()

  "BACKUP-REINIT nil

This function reinitializes the BACKUP file constants for the next
OPS invocation instance."

  (setf (global-recording-disabled) t)
  (setf (global-recording) nil)
  (setf (global-refracts) nil)
  (setf (global-record-array) (make-array 256 :INITIAL-ELEMENT '()))
  (initialize-record))

;;; ---------------------------------------------------------------------------

(defun BACK (k)

  "BACK [cycles]

Restores working memory and the conflict set to the state of a previous
recognize-act cycle.  BACK requires that recording be enabled using
the (ENABLE BACK) command."

  (dotimes (i k)
    (let ((r (getvector (global-record-array) (global-record-index))))
      (when (null r)
        (return "Nothing more stored."))
      (putvector (global-record-array) (global-record-index) nil)
      (record-index-plus -1)
      (undo-record r))))


; (global-max-record-index) holds the maximum legal index for record-array
; so it and the following must be changed at the same time

(defun BEGIN-RECORD (p data)
  (unless (global-recording-disabled)
    (setf (global-recording) t)
    (setf (global-record) (list '=>refract p data))))

(defun END-RECORD ()
  (when (global-recording)
    (setf (global-record)
          (cons (global-cycle-count) (cons (global-p-name) (global-record))))
    (record-index-plus 1)
    (putvector (global-record-array) (global-record-index) (global-record))
    (setf (global-record) nil)
    (setf (global-recording) nil)))

(defun RECORD-CHANGE (direct time elm)
  (cond ((global-recording)
	 (setf (global-record)
	       (cons direct (cons time (cons elm (global-record)))))))) 

; to maintain refraction information, need keep only one piece of information:
; need to record all unsuccessful attempts to delete things from the conflict
; set.  unsuccessful deletes are caused by attempting to delete refracted
; instantiations.  when backing up, have to avoid putting things back into the
; conflict set if they were not deleted when running forward

(defun RECORD-REFRACT (rule data)
  (and (global-recording)
       (setf (global-record) (cons '<=refract (cons rule (cons data (global-record)))))))

(defun REFRACTED (rule data)
  (prog (z)
        (and (null (global-refracts)) (return nil))
        (setf z (cons rule data))
        (return (member z (global-refracts) :TEST #'equal))))


(defun RECORD-INDEX-PLUS (k)
  (incf (global-record-index) k)
  (cond ((< (global-record-index) 0)
	 (setf (global-record-index) (global-max-record-index)))
	((> (global-record-index) (global-max-record-index))
	 (setf (global-record-index) 0)))) 

; the following routine initializes the record.  putting nil in the
; first slot indicates that that the record does not go back further
; than that.  (when the system backs up, it writes nil over the used
; records so that it will recognize which records it has used.  thus
; the system is set up anyway never to back over a nil.)

(defun INITIALIZE-RECORD ()
  (setf (global-record-index) 0)
  (setf (global-recording) nil)
  (setf (global-max-record-index) 31)
  (putvector (global-record-array) 0 nil)) 

(defun UNDO-RECORD (r)
  (prog (save act a b rate)
        ;; (global-recording) must be off during back up.
        (setf save (global-recording))
        (setf (global-refracts) nil)
        (setf (global-recording) nil)
        (when (global-ptrace)
          (format (trace-file) "~&Undoing ~s ~s...." (first r) (second r)))
        (setf r (cddr r))
     top
        (and (atom r) (go fin))
        (setf act (first r))
        (setf a (second r))
        (setf b (third r))
        (setf r (cdddr r))
        (when (global-wtrace)
          (format (trace-file) "~&Undoing ~s ~s...." act a))
        (cond ((eq act '<=wm) (add-to-wm b a))
              ((eq act '=>wm) (remove-from-wm b))
              ((eq act '<=refract)
               (setf (global-refracts) (cons (cons a b) (global-refracts))))
              ((and (eq act '=>refract) (still-present b))
               (setf (global-refracts) (spdelete (cons a b) (global-refracts)))
               (setf rate (rating-part (get-ops-prop a (global-topnode-props))))
               (removecs a b)
               (insertcs a b rate))
              (t (%warn "BACK: cannot undo action" (list act a))))
        (go top)
     fin
        (setf (global-recording) save)
        (setf (global-refracts) nil)
        (return nil))) 



; still-present makes sure that the user has not deleted something
; from wm which occurs in the instantiation about to be restored; it
; makes the check by determining whether each wme still has a time tag.

(defun STILL-PRESENT (data)
  (prog nil
     loop
        (cond ((atom data) (return t))
              ((creation-time (first data))
               (setf data (rest data))
               (go loop))
              (t (return nil))))) 

;;; ---------------------------------------------------------------------------
;;;                                 End of File
;;; ---------------------------------------------------------------------------
