;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB; Base:10; Patch-File:T -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL]MORE-METERS.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Monday, January 30, 1989  18:16:14 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                      GBB METER SUPPORT FUNCTIONS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1988 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  02-19-88 File Created.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'GBB :use '(lisp umass-extended-lisp))

(export '(report-more-meters))

(proclaim '(optimize (speed 3) (safety 1)))



;;;; --------------------------------------------------------------------------
;;;;   More Metering Stuff
;;;; --------------------------------------------------------------------------


(defun update-average (average new-data n)
  (/ (+ (* average (1- n)) new-data) n))

(defstruct (find-stats-record
             (:conc-name "FIND-STATS.")
             (:print-function print-find-stats-record))

  (space-instance nil)   ;; The space instance of this record

  ;; Counts::
  (touched1  0)          ;; Touched during primary retrieval
                         ;;   (including multiple touches of same unit)
  (touched2  0)          ;; Touched during primary retrieval
                         ;;   (each unit counted only once)
  (primary   0)          ;; Passed primary retrieval
  (before    0)          ;; Passed before filters
  (pattern   0)          ;; Passed pattern match
  (after     0)          ;; Passes after filters (returned by find)

  ;; Times::
  (mark-all-time   0)
  (primary-time    0)
  (before-time     0)
  (pattern-time    0)
  (after-time      0)
  )

(defun print-find-stats-record (record stream depth)
  (declare (ignore depth))
  (format stream "#<FIND-STATS-RECORD ~s~6@{ ~6d~}>"
          (and (find-stats.space-instance record)
               (space-instance.name (find-stats.space-instance record)))
          (find-stats.touched1 record)
          (find-stats.touched2 record)
          (find-stats.primary record)
          (find-stats.before record)
          (find-stats.pattern record)
          (find-stats.after record)))

(defun empty-find-stats-record (record)
  (and (zerop (find-stats.touched1 record))
       (zerop (find-stats.touched2 record))
       (zerop (find-stats.primary record))
       (zerop (find-stats.before record))
       (zerop (find-stats.pattern record))
       (zerop (find-stats.after record))))


(defvar *find-stats-array* nil)

(defvar *current-find-stats-record* nil)

(defvar *current-find-stats-record-stack*
        (make-array 32 :fill-pointer 0 :element-type t))

(defun make-find-stats-array (&optional (size 32) old-array)
  "Return an array of find-stats-records which is at least SIZE
   long.  If OLD-ARRAY is supplied it is reused if possible."
  (when (and old-array
             (< size (array-total-size old-array)))
    (return-from make-find-stats-array old-array))
  (let ((new-array (make-array size :element-type t :fill-pointer t)))
    (cond ((null old-array)
           (setf (fill-pointer new-array) 0))
          (t
           (dotimes (i (fill-pointer old-array))
             (setf (aref new-array i) (aref old-array i)))
           (setf (fill-pointer new-array) (fill-pointer old-array))))
    (do ((i (fill-pointer new-array) (1+ i)))
        ((>= i size))
      (setf (aref new-array i) (make-find-stats-record)))
    new-array))

(defun clear-find-stats ()
  (cond ((null *find-stats-array*)
         (setf *find-stats-array* (make-find-stats-array)))
        (t
         (setf (fill-pointer *find-stats-array*) 0)
         (dolist (si *space-instance-list*)
           (add-find-stats-record si))
         ;; For neatness.  Clean up any unused records.
         (do ((i (fill-pointer *find-stats-array*) (1+ i)))
             ((>= i (array-total-size *find-stats-array*)))
           (clear-find-stats-record (aref *find-stats-array* i)))
         *find-stats-array*)))

(defun reset-meters ()
  (dolist (i *simple-meters*)
    (setf (symbol-value i) 0))
  (dolist (i *simple-counters*)
    (setf (symbol-value i) 0))
  (setf *find-units-count* nil)
  (setf *find-units-meter* nil)
  (clear-find-stats))

(defun clear-find-stats-record (record &optional space-instance)
  (setf (find-stats.space-instance record) space-instance)
  (setf (find-stats.touched1       record) 0)
  (setf (find-stats.touched2       record) 0)
  (setf (find-stats.primary        record) 0)
  (setf (find-stats.before         record) 0)
  (setf (find-stats.pattern        record) 0)
  (setf (find-stats.after          record) 0)
  (setf (find-stats.mark-all-time  record) 0)
  (setf (find-stats.primary-time   record) 0)
  (setf (find-stats.before-time    record) 0)
  (setf (find-stats.pattern-time   record) 0)
  (setf (find-stats.after-time     record) 0)
  record)

(defun add-find-stats-record (space-instance)
  (let ((index (fill-pointer *find-stats-array*))
        (size (array-total-size *find-stats-array*)))
    (when (>= (1+ index) size)
      (setf *find-stats-array*
            (make-find-stats-array (+ size 32) *find-stats-array*)))
    (incf (fill-pointer *find-stats-array*))
    (clear-find-stats-record (aref *find-stats-array* index) space-instance)))


(defun push-current-find-stats-record (space-instance)
  (vector-push *current-find-stats-record* *current-find-stats-record-stack*)
  (setf *current-find-stats-record*
        (find space-instance *find-stats-array*
              :test #'eq :key #'find-stats.space-instance)))

(defun pop-current-find-stats-record ()
  (setf *current-find-stats-record* (vector-pop *current-find-stats-record-stack*)))

(defmacro continue-find-stats-runtime (field &optional (start-runtime 'start-runtime))
  (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
    `(continue-runtime (,accessor *current-find-stats-record*)
                       ,start-runtime)))

(defmacro increment-find-stats-count (field &optional (count 1))
  "Increment the count in FIELD for the current find-stats record.
   This form always returns T."
  (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
    `(progn
       (and *metering-enabled*
            (incf (,accessor *current-find-stats-record*) ,count))
       t)))


(defun report-more-meters ()
  (flet ((sort-meter (meter)
             (sort meter
                   #'>
                   :key #'(lambda (record)
                            (or (position (find-stats.space-instance record)
                                          *space-instance-list*
                                          :test #'eq)
                                0)))))
    (setf *find-stats-array* (sort-meter *find-stats-array*))
    (show-find-stats-average-counts *find-stats-array*)
    (terpri) (terpri)
    (show-find-stats-times *find-stats-array*)
    (show-find-stats-times-totals)
    (terpri) (terpri)
    (show-find-stats-average-times *find-stats-array*)
    (terpri)))


(defparameter *find-stats-totals* (make-find-stats-record)
  "Global used in reporting functions.")


(defun show-find-stats-average-counts (array)

  (macrolet
    ((field-average (field &optional (total 'count))
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(float (/ (,accessor record) ,total)))))

    (flet
      ((show-one-record (record)
         (let* ((si (find-stats.space-instance record))
                (count (cdr (assoc si *find-units-count* :test #'eq))))
           (unless (empty-find-stats-record record)
             (format t "~%  ~a~30,10t~6d~@{ ~8,2f~}"
                     (short-bb/space-path si)
                     (count-units-on-space-instance si)
                     (field-average touched1)
                     (field-average touched2)
                     (field-average primary)
                     (field-average before)
                     (field-average pattern)
                     (field-average after))))))

      ;;               654321  7654321  7654321  7654321  7654321  7654321  7654321
      (format t "~%~30t              Average number of units after each phase~%~@
                   ~30t Units      P1       P2       P*    Before  Pattern    After~@
                   ~30t------  -------  -------  -------  -------  -------  -------")
      (map nil #'show-one-record array))))


(defun show-find-stats-times (array)

  (macrolet
    ((field-pretty (field)
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(pretty-time (,accessor record))))
     (percentage (field)
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(if (zerop total-time)
              "    "
              (format nil "~[~4@t~:;~:*(~2d)~]"
                      (round (* 100 (,accessor record))
                             total-time))))))

    (flet
      ((show-one-record (record)
         (let* ((si (find-stats.space-instance record))
                (total-time (+ (find-stats.mark-all-time record)
                               (find-stats.primary-time record)
                               (find-stats.before-time record)
                               (find-stats.pattern-time record)
                               (find-stats.after-time record))))
           (unless (empty-find-stats-record record)
             (format t "~%  ~a~30,10t~6d~@{ ~a~^ ~a~}"
                     (short-bb/space-path si)
                     (cdr (assoc si *find-units-count* :test #'eq))
                     (field-pretty mark-all-time)  (percentage mark-all-time)
                     (field-pretty primary-time)   (percentage primary-time)
                     (field-pretty before-time)    (percentage before-time)
                     (field-pretty pattern-time)   (percentage pattern-time)
                     (field-pretty after-time)     (percentage after-time)
                     (pretty-time total-time))))))

      (format t "~%~30t                          Total Time Spent In Each Phase~%~@
                   ~30t Finds     Clear        Primary        Before       Pattern        After       Total~@
                   ~30t------ ------------- ------------- ------------- ------------- ------------- --------")
      (map nil #'show-one-record array))))



(defun show-find-stats-times-totals ()

  (macrolet
    ((inc-field (field)
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(incf (,accessor *find-stats-totals*) (,accessor record))))
     (field-pretty (field)
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(pretty-time (,accessor *find-stats-totals*))))
     (percentage (field)
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(if (zerop total-time)
              "    "
              (format nil "~[~4@t~:;~:*(~2d)~]"
                      (round (* 100 (,accessor *find-stats-totals*))
                             total-time))))))

    (let ((total-finds 0)
          total-time)

      (clear-find-stats-record *find-stats-totals*)
      (map nil #'(lambda (record)
                   (let ((si (find-stats.space-instance record)))
                     (when si
                       (incf total-finds
                             (or (cdr (assoc si *find-units-count* :test #'eq))
                                 0))
                       (inc-field mark-all-time)
                       (inc-field primary-time)
                       (inc-field before-time)
                       (inc-field pattern-time)
                       (inc-field after-time))))
           *find-stats-array*)

      (setf total-time (+ (find-stats.mark-all-time *find-stats-totals*)
                          (find-stats.primary-time  *find-stats-totals*)
                          (find-stats.before-time   *find-stats-totals*)
                          (find-stats.pattern-time  *find-stats-totals*)
                          (find-stats.after-time    *find-stats-totals*)))
      (format t "~2%~30t~6d~@{ ~a ~a~}~%"
              total-finds
              (field-pretty mark-all-time)  (percentage mark-all-time)
              (field-pretty primary-time)   (percentage primary-time)
              (field-pretty before-time)    (percentage before-time)
              (field-pretty pattern-time)   (percentage pattern-time)
              (field-pretty after-time)     (percentage after-time)))))


(defun show-find-stats-average-times (array)

  (macrolet
    ((field-pretty (field &optional (total 'count))
       (let ((accessor (form-gbb-symbol "FIND-STATS." field)))
         `(pretty-time (float (/ (,accessor record) ,total)) t))))

    (flet
      ((show-one-record (record)
         (let* ((si (find-stats.space-instance record))
                (total-time (+ (find-stats.mark-all-time record)
                               (find-stats.primary-time record)
                               (find-stats.before-time record)
                               (find-stats.pattern-time record)
                               (find-stats.after-time record)))
                (count (cdr (assoc si *find-units-count* :test #'eq))))
           (unless (empty-find-stats-record record)
             (format t "~%  ~a~30,10t~@{ ~a~}"
                     (short-bb/space-path si)
                     (field-pretty mark-all-time)
                     (field-pretty primary-time)
                     (field-pretty before-time)
                     (field-pretty pattern-time)
                     (field-pretty after-time)
                     (pretty-time (float (/ total-time count)) t))))))

      (format t "~%~30t      Average Time (per Find) Spent In Each Phase~%~@
                   ~30t   Clear   Primary   Before  Pattern   After    Total~@
                   ~30t -------- -------- -------- -------- -------- --------")
      (map nil #'show-one-record array))))


(defvar *bb/space-path-abbreviation-fn* nil
  "Optional function that may be used to produce an abbreviation
   for the BB/Space path in meter reports.  The function will be
   given a single argument (a list) and should return a string.")

(defun short-bb/space-path (si)
  (let* ((path-list (get-path-from-space-instance si))
         (path-string (if *bb/space-path-abbreviation-fn*
                        (funcall *bb/space-path-abbreviation-fn* path-list)
                        (format nil "~a" path-list)))
         (len (length path-string))
         space-pos)
    (cond ((or *bb/space-path-abbreviation-fn*
               (<= len 28))
           path-string)
          ((setf space-pos (position #\space path-string
                                      :test #'char=
                                      :start (- len 24)))
           (format nil "(...~a" (subseq path-string space-pos)))
          (t
           (format nil "(...~a" (subseq path-string (- len 24)))))))

(defun count-units-on-space-instance (si)
  (let ((count 0))
    (map-space-instance
      #'(lambda (u) (declare (ignore u)) (incf count))
      t
      si)
    count))


;;;; --------------------------------------------------------------------------
;;;;   Patched GBB Definitions
;;;; --------------------------------------------------------------------------


(defun OVERWRITE-EXISTING-BLACKBOARD (descriptions)
  "Sets up a new blackboard database and clobbers the previous one, if it exists."

  (clear-blackboard-database t)
  ;; This may not always be the right thing to do (but where
  ;; else would I do it).
  (clear-unit-hash-tables)
  (setf *blackboard-database*
        (mapcar #'instantiate-blackboard-database-1 descriptions))
  (build-bb-storage *blackboard-database*)
  (update-space-instance-variables *blackboard-database*)
  (clear-find-stats)
  (mapcar #'add-find-stats-record *space-instance-list*)
  )


(defun APPEND-TO-EXISTING-BLACKBOARD (descriptions)
  "Adds the new blackboard to the previously existing one."
  
  (let ((new-bb-nodes (mapcar #'instantiate-blackboard-database-1 descriptions)))
    (build-bb-storage new-bb-nodes)
    (update-space-instance-variables new-bb-nodes)
    (setf *blackboard-database* (nconc *blackboard-database* new-bb-nodes))
    (dolist (si *space-instance-list*)
      (unless (find si *find-stats-array*
                    :test #'eq :key #'find-stats.space-instance)
        (add-find-stats-record si)))))



(defun find-units-internal
       (unit-types space-instance search-pattern options)

  (when (eq search-pattern :all)
    (return-from find-units-internal
      (find-units-all unit-types space-instance options)))

  (let* ((start-runtime (gbb-runtime))
         (units-to-return nil)
	 (space (space-instance.space space-instance))
	 unit-mapping)
    (declare (special units-to-return))

    (push-current-find-stats-record space-instance)

    ;; Each space instance can have several unit-mappings associated with it.
    ;; A `storage entry' is a list:
    ;;    (unit-mapping . <alist of (index-symbols . storage array)>).
    (dolist (storage-entry (space-instance.data space-instance))
      
      (setf unit-mapping (storage-entry.unit-mapping storage-entry))
      (cond
	;; Skip if this unit-mapping doesn't store these units.
	((not (or (eq unit-types t)
		  (overlapp unit-types (unit-mapping.units unit-mapping))))
	 nil)
	;; Unstructured space.
	((unstructured-unit-mapping-p (storage-entry.unit-mapping storage-entry))
	 (find-units-on-unstructured-mapping
	   unit-types space
	   (storage-entry.data storage-entry)
	   search-pattern
	   options))
	;; Normal, structured space.
	(t (find-units-on-structured-mapping
	     unit-types space storage-entry search-pattern options))))

    (update-runtime *find-units-meter* start-runtime space-instance)
    (update-count *find-units-count* space-instance)
    (pop-current-find-stats-record)
    units-to-return))



(defun filter-and-compare-unit-instance
       (unit-instance candidate-mark search-pattern space unit-types options
        &aux (start-runtime (gbb-runtime)))


  (declare (special units-to-return))

  (macrolet ((reject (instance)
               `(progn (setf (get-unit-mark ,instance) *find-rejected*)
                       (return-from filter-and-compare-unit-instance nil)))
             (skip (instance)
               (declare (ignore instance))
               '(return-from filter-and-compare-unit-instance nil)))

    (increment-find-stats-count touched1)
    ;; If the mark is not equal to the previous count then skip this
    ;; instance.  This will be the case if the unit has already been
    ;; rejected, or it's already passed this iteration or it wasn't
    ;; selected by the primary retrieval in some earlier iteration.
    (unless (= candidate-mark (get-unit-mark unit-instance))
      (skip unit-instance))

    (increment-find-stats-count touched2)
    ;; Make sure that this is one of the desired units.
    (unless (or (eq unit-types t)
                (member (type-of unit-instance) unit-types :test #'eq))
      (reject unit-instance))

    (continue-find-stats-runtime primary-time)
    (increment-find-stats-count primary)
    ;; Do the before filters.  If the any fail then mark this unit
    ;; as rejected because we might come across it again in another
    ;; bucket.
    (unless (do-filters (find-options.filter-before options) unit-instance)
      (reject unit-instance))

    (continue-find-stats-runtime before-time)
    (increment-find-stats-count before)
    ;; Now, if we get here then this unit is a candidate.
    ;; It is the right type, and it's passed the before filters; so
    ;; compare the unit to the pattern.
    (cond ((simple-search-pattern-p search-pattern)
           (unless (compare-unit-instance-to-pattern-1
                     unit-instance search-pattern space)
             (continue-find-stats-runtime pattern-time)
             (reject unit-instance)))
          (t ;; Compound Pattern:
           (dolist (pattern (compound-search-pattern.patterns search-pattern))
             (unless (compare-unit-instance-to-pattern-1
                       unit-instance pattern space)
               (continue-find-stats-runtime pattern-time)
               (reject unit-instance)))))

    (continue-find-stats-runtime pattern-time)
    (increment-find-stats-count pattern)
    ;; Finally, do the after filters.
    (cond ((do-filters (find-options.filter-after options) unit-instance)
           (push unit-instance units-to-return)
           (setf (get-unit-mark unit-instance) *find-succeeded*)
           (continue-find-stats-runtime after-time)
           (increment-find-stats-count after)
           )
          (t
           (continue-find-stats-runtime after-time)
           (reject unit-instance)))))


(defun find-units-on-unstructured-mapping
             (unit-types space unit-instances search-pattern options
              &aux start-runtime)

  ;; Find units on an unstructured space.

  (declare (special units-to-return))

  (dolist (unit-instance unit-instances)
    (setf start-runtime (gbb-runtime))
    (when (or (eq unit-types t)
	      (member (type-of unit-instance) unit-types :test #'eq))
      (when (and
              (progn
                (continue-find-stats-runtime primary-time)
                (increment-find-stats-count primary)
                t)
              (prog1
                (do-filters (find-options.filter-before options) unit-instance)
                (continue-find-stats-runtime before-time))
              (increment-find-stats-count before)
              (prog1
                (unstructured-compare-unit-instance-to-search-pattern
                  unit-instance search-pattern space)
                (continue-find-stats-runtime pattern-time))
              (increment-find-stats-count pattern)
              (prog1
                (do-filters (find-options.filter-after options)
                            unit-instance)
                (continue-find-stats-runtime after-time)))
        (increment-find-stats-count after)
	(push unit-instance units-to-return))))

  units-to-return)


(defun intersect-storage-arrays
       (space overlap-predicate unit-mapping
        storage-alist search-pattern simple-pattern?
        &aux (t1 0) (t2 0) (start-runtime (gbb-runtime)))

  "Do the intersection of several storage arrays."
  
  (flet ((mark-units-in-pattern (storage-element search-pattern current-count)
           (let* ((storage-indexes  (storage-element.indexes storage-element))
                  (storage-array (storage-element.array storage-element))
                  (sp (if simple-pattern?
                          search-pattern
                          (find storage-indexes
                                (compound-search-pattern.patterns search-pattern)
                                :key #'search-pattern-indexes
                                :test #'overlapp)))
                  (pattern-object  (pattern.pattern-object sp))
                  (previous-count (1- current-count))
                  (regions (get-regions-from-pattern-object
                             pattern-object storage-indexes space unit-mapping)))
             (dolist (region regions)
               (do-array-region (subscripts region)
                 (dolist (unit (apply #'aref storage-array subscripts))
                   (incf t1)
                   (when (= (get-unit-mark unit) previous-count)
                     (incf t2)
                     (setf (get-unit-mark unit) current-count))))))))

    (let ((storage-entry-list
            ;; Skip over the first entry because that is the one that
            ;; will be used in the secondary retreival (when we actually
            ;; look at the unit to see if it satisfies the pattern).
            (cdr (member-if overlap-predicate storage-alist
                            :key #'storage-element.indexes))))

      (do ((storage-entries (member-if overlap-predicate storage-entry-list
                                       :key #'storage-element.indexes)
                            (member-if overlap-predicate (cdr storage-entries)
                                       :key #'storage-element.indexes))
           (current-count 1 (1+ current-count)))

          ((null storage-entries)
           (update-runtime (find-stats.primary-time *current-find-stats-record*)
                           start-runtime)
           (increment-find-stats-count touched1 t1)
           (increment-find-stats-count touched2 t2)
           current-count)
        ;; Now:
        ;;   1. Get a search pattern.
        ;;   2. Mark the units that may satisfy the pattern
        ;;       2a. Compute the region based on the pattern.
        ;;       2b. Mark the units that fall into the region.
        (mark-units-in-pattern (car storage-entries)
                               search-pattern
                               current-count)))))


	   
(defun mark-all-units (array value
		       &optional (region (entire-array-region array))
                       &aux (start-runtime (gbb-runtime)))

  "MARK-ALL-UNITS array value &optional region

   Set the mark of every unit stored in a region of ARRAY to VALUE.
   REGION is a list of upper and lower bound pairs suitable for
   DO-ARRAY-REGION which specifies what part of the array is
   affected.  If REGION is not supplied it defaults to the entire
   array."

  (do-array-region (subscripts region)
    (dolist (unit (apply #'aref array subscripts))
      (setf (basic-unit.%%mark-1%% unit) value)))
  (when *current-find-stats-record*
    (update-runtime (find-stats.mark-all-time *current-find-stats-record*)
                    start-runtime)))

;;; --------------------------------------------------------------------------
;;;                                End of File
;;; --------------------------------------------------------------------------

