;;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package:UMASS-EXTENDED-LISP; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL]LUCID-EXTENSIONS.LISP *-*
;;;; *-* Last-Edit: Friday, January 6, 1989  19:26:44 *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *       Implementation Dependent Extensions for Lucid Common Lisp
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1987, 1988, 1989 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains extensions to Common Lisp needed by GBB.  The functions
;;;  in this file depend on the implementation details of the Lucid Common
;;;  Lisp.  The file UMASS-EXTENDED-LISP.LISP contains extensions to Common
;;;  Lisp that are written in Common Lisp.
;;;
;;;  07-10-87 File Created.  Lucid Development Environment Version 2.0.3.
;;;           (Kevin Gallagher)
;;;  01-06-89 Updated to Lucid Development Environment Version 3.0.1.
;;;           (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'umass-extended-lisp
	    :use '(lisp))

(export '(defstruct-p
	  defstruct-conc-name
	  structure-slot-names
	  structure-slot-p
	  get-structure-slot
	  deftransform
	  delete-transform
	  %pass%
	  %pointer))

(use-package '(lisp))

(import #+LCL3.0  '(system::structure-ref)
        #-LCL3.0  '(lucid::structure-ref)
        )

(proclaim '(optimize (speed 3) (safety 1)))

;;; The functions that must be defined in this file are:
;;;
;;;     defstruct-p
;;;     get-defstruct-description
;;;     defstruct-conc-name
;;;     structure-slot-names
;;;     structure-slot-p
;;;     get-structure-slot  (and corresponding setf method)
;;;     deftransform
;;;     delete-transform
;;;     %pointer
;;;
;;; See the documentation with each function for arguments and purpose.



;;;; --------------------------------------------------------------------------
;;;;   Generic Defstruct Functions
;;;; --------------------------------------------------------------------------

;;; It is a hole in Common Lisp that you can't access a slot in a structure
;;; via the slot name.  For example, if I have an instance of the following
;;; defstruct,
;;;
;;;    (defstruct (foo (:conc-name FOO->))
;;;      (a nil)
;;;      (b nil))
;;;
;;; I want to be able to get the value of slot A with a call like:
;;;
;;;    (get-structure-slot object 'A).
;;;
;;; This is because I may not know what the accessor function is for that
;;; slot.  Even if I did know the name of the accessor function, I wouldn't
;;; be able to use it to alter the value of the slot because Setf needs to
;;; know the function name at compile time.  This means that code such as
;;; the following won't work.
;;;
;;;    (defun set-structure-slot (object slot-accessor new-value)
;;;      (setf (funcall slot-accessor object) new-value))
;;;
;;; Obviously, setf shouldn't need to handle that as a place form.  This
;;; just points out the need for a general slot accessor function which
;;; will work as a place form for setf.

;;; GBB uses the functions Get-Structure-Slot and Defstruct-Conc-Name
;;; which are defined below.

;;; Lucid seems to have tried very hard to hide the information
;;; necessary to implement these functions in a reasonably efficient
;;; manner.  For example, I haven't been able to find the names of the
;;; accessor functions for the defstruct description itself, so I've
;;; implemented my own accessors.  Obviously, these will not work if
;;; lucid changes their defstruct description.

(defun lucid-defstruct.name (structure)
  (structure-ref structure 0 'lucid::defstruct))

(defun lucid-defstruct.conc-name (structure)
  (structure-ref structure 2 'lucid::defstruct))

(defun lucid-defstruct.slot-vector (structure)
  (structure-ref structure 7 'lucid::defstruct))

(defun lucid-defstruct-slot.name (structure)
  (structure-ref structure 0 'lucid::defstruct-slot))

(defun lucid-defstruct-slot.index (structure)
  (structure-ref structure 1 'lucid::defstruct-slot))

(defun lucid-defstruct-slot.accessor (structure)
  (structure-ref structure 2 'lucid::defstruct-slot))



(defun get-defstruct-description (name)

  "GET-DESFSTRUCT-DESCRIPTION name

   If NAME has been defined as a structure then return its
   description.  Otherwise signal an error.  This function is
   used internally by the other generic defstruct functions."
  
  (or (get-defstruct-description-1 name)
      (error "GET-DESFSTRUCT-DESCRIPTION: ~A is not a defstruct type" name)))


(defun get-defstruct-description-1 (name)

  "GET-DEFSTRUCT-DESCRIPTION-1 name

   If NAME has been defined as a structure then return a structure
   which describes the defstruct.  Otherwise, return nil."

  (declare (special lucid::*defstructs*))
  (gethash name lucid::*defstructs* nil))


(defun defstruct-p (name)

  "DEFSTRUCT-P name

   This predicate returns true if NAME is the name of a
   defstruct type; nil otherwise.  NAME must be a symbol."

  (and (symbolp name)
       (get-defstruct-description-1 name)
       t))


(defun defstruct-conc-name (structure)

  "DEFSTRUCT-CONC-NAME structure

   Return a string which is the prefix for building defstruct slot
   accessors for this structure.  STRUCTURE must be a symbol which
   names a structure type."
                                                         
  (let ((description (get-defstruct-description structure)))
    (string (lucid-defstruct.conc-name description))))


(defun structure-slot-names (type)

  "STRUCTURE-SLOT-NAMES type

   This function returns a list of slot names for the structure
   named by TYPE, which must be a symbol."

  (let* ((description (get-defstruct-description type))
	 (slot-vector (lucid-defstruct.slot-vector description)))
    (map 'list #'lucid-defstruct-slot.name slot-vector)))
    

(defun structure-slot-p (type slot)

  "STRUCTURE-SLOT-P type slot

   This function returns true if SLOT is the name of a slot in the
   defstruct type named by TYPE."

  (let* ((description (get-defstruct-description type))
	 (slot-vector (lucid-defstruct.slot-vector description)))
    (find slot slot-vector
	  :key #'lucid-defstruct-slot.name
	  :test #'string=)))


;;;
;;; Structure Slot Access Functions :::
;;;

(defun get-structure-slot (object slot)

  "GET-STRUCTURE-SLOT object slot

Returns the value of a slot in a structure
given the name of the slot.

This function may be used as a place form for SETF."

  (let* ((type (type-of object))
	 (description (get-defstruct-description type))
	 (slot-vector (lucid-defstruct.slot-vector description)))
    (structure-ref
       object
       (lucid-defstruct-slot.index
         (or (find slot slot-vector
                   :key #'lucid-defstruct-slot.name
                   :test #'string=)
             (error "~s is not a slot in ~s." slot object)))
       type)))

;;;
;;; Structure Slot Setting Functions :::
;;;

(defun set-structure-slot (object slot value)

  ;; SET-STRUCTURE-SLOT object slot value
  ;;
  ;; Sets the value of a slot in a structure
  ;; given the name of the slot."

  (let* ((type (type-of object))
	 (description (get-defstruct-description type))
	 (slot-vector (lucid-defstruct.slot-vector description)))
    (setf (structure-ref
	     object
	     (lucid-defstruct-slot.index
               (or (find slot slot-vector
                         :key #'lucid-defstruct-slot.name
                         :test #'string=)
                   (error "~s is not a slot in ~s." slot object)))
	     type)
	  value)))

(defsetf get-structure-slot set-structure-slot)


;;;; --------------------------------------------------------------------------
;;;;   Compiler Transforms.
;;;; --------------------------------------------------------------------------

;;; The body of the transform should return the symbol %PASS% if it
;;; doesn't apply.  If it does apply then it should return the
;;; transformed form.  For example, a common optimization is to do
;;; keyword analysis at compile time.
;;;
;;;     (defun foo (x &key a b)
;;;       ...)
;;;
;;;     (deftransform (foo keyword) (x &rest keyword-args)
;;;       (if (literal-keywords-in-arglist keyword-args)
;;;           (let ((a (getf keyword-args :a))
;;;                 (b (getf keyword-args :b)))
;;;             `(foo-internal ,x ,a ,b))
;;;           '%pass%))
;;;
;;;     (defun foo-internal (x a b)
;;;       ...)


;;; GBB will define several compiler transforms.  If this feature is
;;; not available in your lisp GBB will still run --- it will just run
;;; a little slower than it would if this feature was available.  If
;;; DEFTRANSFORM is defined then DELETE-TRANSFORM must be defined as
;;; well.

(defmacro DEFTRANSFORM ((function transform-name) arglist &body body)
  
  "DEFTRANSFORM (function transform-name) arglist {form}*

   Defines a source level compiler transform for FUNCTION labeled
   TRANSNAME.  If FUNCTION already has a transform labeled
   TRANSFORM-NAME then the old one will be replaced."

  nil)


(defun delete-transform (function transform-name)

  "DELETE-TRANSFORM function transform-name

   This function will remove the compiler transform for FUNCTION
   designated by TRANSFORM-NAME."

  nil)


;;;; --------------------------------------------------------------------------
;;;;   Miscellaneous Non Common Lisp Functions
;;;; --------------------------------------------------------------------------

;;; This function is used when printing internal GBB objects.  If your
;;; implementation doesn't provide an easy way to get the address of
;;; an object it is ok to simply return zero.  GBB doesn't depend on the
;;; value of this function uniquely identifying an object.

(defun %pointer (x)

  "%POINTER x

   Returns the address of X.  This is only used in printing to easily 
   distiguish two objects.  Its value should not be relied on."

  #+LCL3.0 (system::%pointer x)
  #-LCL3.0 (lucid::%pointer x))



;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
