;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:W; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GRAPHICS.COMPATIBLE]WINDOW-SUPPORT.LISP *-*
;;;; *-* Last-Edit: Thursday, July 13, 1989  15:58:49; Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 416) *-*
;;;; *-* Software: TI Common Lisp System 4.105 *-*
;;;; *-* Lisp: TI Common Lisp System 4.105 (0.0) *-*

;;;; ==========================================================================
;;;;
;;;;                   WINDOW SUPPORT FOR GBB DISPLAY GRAPHICS                 
;;;;
;;;; ==========================================================================
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-27-87 File Created.  (Gallagher)
;;;  10-26-88 Adapted to Symbolics window system.  (Brolio)
;;;  
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;; On revising this file for the Symbolics an annoying package problem
;; arose:  What package to use for this file?  Symbolics' TV package
;; inherits from ZL, which makes it difficult to use Common Lisp.  TI's TV
;; and W packages inherit from Common Lisp.  The solution used here is to be
;; in the TV (W) package and explicitly use Common Lisp symbols when
;; necessary.  To be on the safe side, put a package prefix on everything.

#+SYMBOLICS
(lisp:in-package 'tv :nicknames '(w))
;; (in-package 'gbb-graphics)
#+TI
(in-package 'w)

(lisp:export '(mouse-mark-rectangle
	       point-at-a-window
	       point-at-a-point
	       io-buffer-sharers-mixin
	       choose-configuration-mixin
	       w-menu-choose
	       mmc-all/none
	       momentary-multiple-choose))

lisp:(proclaim '(optimize (speed 3) (safety 1)))


(defvar circle-plus #+SYMBOLICS #\arrow:circle-plus
                    #+TI        w::mouse-glyph-circle-plus)

(defvar thin-hollow-cross #+SYMBOLICS #\mouse:times
                          #+TI        w::mouse-glyph-thin-hollow-cross)

;#+SYMBOLICS
;(import 'zl::closure)

;; Symbolics has a %draw-line that gives a warning,
;; TI has no sheet-draw-line, so...
#+TI 
(deff w::sheet-draw-line 'w::%draw-line)


;;; ---------------------------------------------------------------------------
;;;   Useful Window System Macros
;;; ---------------------------------------------------------------------------

(defmacro do-panes ((pane pane-names superior &optional result-form) &body body)
  (let ((remaining-names (gensym))
	(super (gensym)))
    `(do* ((,remaining-names ,pane-names (cdr ,remaining-names))
	   (,super ,superior)
	   (,pane))
	  ((endp ,remaining-names) ,result-form)
       (setf ,pane (send ,super :get-pane (first ,remaining-names)))
       ,@body)))

#+SYMBOLICS
(defvar tv:alu-add tv:alu-xor
  "Alu used for blinkers.")

#+SYMBOLICS
(defun mouse-alu (phase)
  (declare (ignore phase))
  tv::alu-xor)

#+TI
(eval-when (load eval compile)
  (unless (fboundp 'mouse-alu)
    (compile 'mouse-alu #'(lambda (phase)
				  (declare (ignore phase))
				  tv::alu-xor))))


;;; ---------------------------------------------------------------------------
;;;   Mouse Stuff
;;; ---------------------------------------------------------------------------

;;; This is like w:mouse-specify-rectangle.  It allows you to restrict
;;; the mouse's movement to some region in your window.  It doesn't do
;;; the ``right button is smart'' stuff.

(defun mouse-mark-rectangle
       (&optional (sheet w::mouse-sheet)
		  (left-bound 0)
		  (top-bound 0)
		  (right-bound (w::sheet-width sheet))
		  (bottom-bound (w::sheet-height sheet))
		  (left-start left-bound)
		  (top-start top-bound)
		  (minimum-width 4)
		  (minimum-height 4))

  "Ask user to specify a rectangle with the mouse, by clicking at the
   uppper left and lower right corners.  The mouse is restricted to the
   the rectangle specified by left-bound, top-bound, right-bound, and
   bottom-bound during the selection.  The left and right buttons select
   a corner.  The middle button aborts.

   Returns four values: the left, top, right, and bottom of the
   rectangle, all relative to the outside edge of SHEET.  If the user
   aborts (clicks middle) then the function returns nil."


  (and (eq SYS::current-process w::mouse-process)
       (error "MOUSE-MARK-RECTANGLE cannot be called in the mouse process."))
  (or (w::sheet-me-or-my-kid-p sheet w::mouse-sheet)
      (error "MOUSE-MARK-RECTANGLE attempted on ~S~@
              which is not inferior of MOUSE-SHEET."
	sheet))
  (or (< minimum-width (- right-bound left-bound))
      (< minimum-height (- bottom-bound top-bound))
      (error "Initial bounds too small."))

  (let (button x1 y1 x2 y2)

    (#+TI         tv:with-mouse-grabbed-on-sheet
     #+SYMBOLICS  tv:with-mouse-and-buttons-grabbed-on-sheet    (sheet)
      
      (w::mouse-warp left-start top-start)
      (w::mouse-set-blinker-definition :cross-hair 0 0 :on :setup nil nil)
      (setf w::who-line-mouse-grabbed-documentation
	    "L: Select Corner, M: Abort, R: Select Corner")
      
      ;; In case this was called in response to a mouse click, wait for
      ;; the buttons to be released.
      (mouse-release-buttons)
      
      ;; Wait for the user to press a mouse button.
      (lisp:multiple-value-setq (x1 y1 button)
	  (restrict-mouse-and-wait-for-click
	    left-bound top-bound right-bound bottom-bound))
      ;; Wait for the user to release the mouse button.
      (mouse-release-buttons)
      
      (when (lisp:logtest 2 button)
	;; Abort if it's a middle click.
	(return-from mouse-mark-rectangle nil))
      
      (lisp:loop

	(w::mouse-warp (+ x1 minimum-width) (+ y1 minimum-height))
	(w::mouse-set-blinker-definition :mark-rectangle 0 0 :on :setup x1 y1)
	;; Wait for the user to hit a mouse button.
	(lisp:multiple-value-setq (x2 y2 button)
	    (restrict-mouse-and-wait-for-click
	      left-bound top-bound right-bound bottom-bound))
	(mouse-release-buttons)
      
	;; Change the blinker back to a normal one.
	(w::mouse-standard-blinker)
	(setq w::who-line-mouse-grabbed-documentation nil)
	
	(when (lisp:logtest 2 button)
	  ;; Abort if it's a middle click.
	  (return-from mouse-mark-rectangle nil))
	
	(when (and (>= (abs (- x1 x2)) minimum-width) 
		   (>= (abs (- y1 y2)) minimum-height))
	  (return-from mouse-mark-rectangle
	    (values (min x1 x2) (min y1 y2) (max x1 x2) (max y1 y2))))
	
	(w:beep)))))



(defun restrict-mouse-and-wait-for-click
       (left-bound top-bound right-bound bottom-bound)
  "Keep mouse in the region bounded by the arguments LEFT-BOUND,
   TOP-BOUND, RIGHT-BOUND, and BOTTOM-BOUND (which are in terms
   of the mouse-sheet.  Returns when a button is clicked.  The
   return values are x, y, and the button mask."
  (do ((old-x sys::mouse-x)
       (old-y sys::mouse-y)
       (old-buttons 0))
      ((not (zerop old-buttons))
       (values old-x old-y old-buttons))
    (w::mouse-wait old-x old-y old-buttons)
    (setf old-x sys::mouse-x)
    (setf old-y sys::mouse-y)
    (setf old-buttons w::mouse-last-buttons)
    (cond ((< old-x left-bound)
	   (w:mouse-warp left-bound old-y))
	  ((> old-x right-bound)
	   (w:mouse-warp right-bound old-y))
	  (t nil))
    (cond ((< old-y top-bound)
	   (w:mouse-warp old-x top-bound))
	  ((> old-y bottom-bound)
	   (w:mouse-warp old-x bottom-bound))
	  (t nil))))

#+TI
(defun mouse-release-buttons ()
  "Wait until no buttons are down."
  (process-wait "Release Button"
		#'(lambda () (zerop w::mouse-last-buttons))))

#+SYMBOLICS
(deff mouse-release-buttons #'tv:wait-for-mouse-button-up)


(defun point-at-a-window (&optional
			  (who-line-doc
			    "L: Choose a Window, M: Abort, R: Choose a Window")
			  (prompt "Mouse")
			  (char circle-plus)
			  &aux
			  (window nil))

  "Ask the user to choose a window by pointing at it with the mouse."
  
  (w:with-mouse-grabbed
    (mouse-release-buttons)
    (w:mouse-set-blinker-definition ':character 0 0 ':on
				     ':set-character char)
    (setq w:who-line-mouse-grabbed-documentation who-line-doc)
    ;; Wait until a mouse button is pressed.
    (process-wait prompt #'(lambda () (not (zerop w:mouse-last-buttons))))
    ;; Abort (Return NIL) if it was the middle button.
    (unless (lisp:logtest 2 w:mouse-last-buttons)
      ;; Find a window which contains the mouse.
      (setf window (w:window-under-mouse)))
    (setq w:who-line-mouse-grabbed-documentation nil)
    window))



(defun point-at-a-point
       (&optional (sheet w::mouse-sheet)
		  (left-bound 0)
		  (top-bound 0)
		  (right-bound (w::sheet-width sheet))
		  (bottom-bound (w::sheet-height sheet))
		  (left-start left-bound)
		  (top-start top-bound)
                  (who-line-doc
                    "L: Choose a Point, M: Abort, R: Choose a Point")
                  (char thin-hollow-cross))

  "Ask user to choose a point in a window.  The mouse is restricted to the
   the rectangle specified by left-bound, top-bound, right-bound, and
   bottom-bound during the selection.  The left and right buttons select
   a corner.  The middle button aborts.

   Returns x, y (relative to the outside of SHEET) and the button mask."

  (and (eq SYS::current-process w::mouse-process)
       (error "POINT-AT-A-POINT cannot be called in the mouse process."))
  (or (w::sheet-me-or-my-kid-p sheet w::mouse-sheet)
      (error "POINT-AT-A-POINT attempted on ~S~@
              which is not inferior of MOUSE-SHEET."
	sheet))

  (let (button x1 y1)

    (tv:with-mouse-grabbed-on-sheet (sheet)
      
      (w::mouse-warp left-start top-start)
      (w::mouse-set-blinker-definition :character 0 0 :on :set-character char)
      (setf w::who-line-mouse-grabbed-documentation who-line-doc)
      
      ;; In case this was called in response to a mouse click, wait for
      ;; the buttons to be released.
      (mouse-release-buttons)
      
      ;; Wait for the user to press a mouse button.
      (lisp:multiple-value-setq (x1 y1 button)
	  (restrict-mouse-and-wait-for-click
	    left-bound top-bound right-bound bottom-bound))
      
      ;; Change the blinker back to a normal one.
      (w::mouse-standard-blinker)
      (setq w::who-line-mouse-grabbed-documentation nil)
      (if (lisp:logtest 2 button)
          ;; Abort (Return NIL) if it was the middle button.
          nil
          (values x1 y1 button)))))


;;;; --------------------------------------------------------------------------
;;;;   Mouse Blinkers
;;;; --------------------------------------------------------------------------

(defflavor mark-rectangle-blinker
	   ((start-x 0)
	    (start-y 0))
	   (w::mouse-blinker-mixin w::blinker)
  :initable-instance-variables
  :settable-instance-variables
  :gettable-instance-variables)

(defmethod (mark-rectangle-blinker :blink) ()
  (let ((the-alu (mouse-alu phase)))
    ;; Left line
    (w::sheet-draw-line start-x w::y-pos start-x start-y the-alu nil w::sheet)
    ;; Top line
    (w::sheet-draw-line start-x start-y w::x-pos start-y the-alu nil w::sheet)
    ;; Right line
    (w::sheet-draw-line w::x-pos start-y w::x-pos w::y-pos the-alu nil w::sheet)
    ;; Bottom line
    (w::sheet-draw-line w::x-pos w::y-pos start-x w::y-pos the-alu nil w::sheet)))
  
;; This is required by w:blinker.
(defmethod (mark-rectangle-blinker :size) ()
  (values 0 0))

(defmethod (mark-rectangle-blinker :set-start-point) (x y)
  (setf start-x x)
  (setf start-y y))

(defmethod (mark-rectangle-blinker :setup) (new-start-x new-start-y
					    &optional new-x-pos new-y-pos)
  (send self :set-start-point new-start-x new-start-y)
  (setf w::x-pos (or new-x-pos sys::mouse-x))
  (setf w::y-pos (or new-y-pos sys::mouse-y)))

;; Define it as a blinker type.
(w::mouse-define-blinker-type
  :mark-rectangle
  #'(lambda (screen)
      (w::make-blinker screen 'mark-rectangle-blinker
	:visibility nil)))


(defflavor cross-hair-blinker
	   ((x-length nil)
	    (y-length nil))
	   (w::mouse-blinker-mixin w::blinker)
  :initable-instance-variables
  :settable-instance-variables
  :gettable-instance-variables)

(defmethod (cross-hair-blinker :blink) ()

  (let* ((height (1- (tv::sheet-height tv::sheet)))
	 (width  (1- (tv::sheet-width tv::sheet)))
         (the-alu (mouse-alu phase))
	 left top right bottom)

    (cond (x-length
	   (setf left  (max (- w::x-pos x-length) 0))
	   (setf right (min (+ w::x-pos x-length) width)))
	  (t
	   (setf left 0)
	   (setf right width)))
    (cond (y-length
	   (setf top    (max (- w::y-pos y-length) 0))
	   (setf bottom (min (+ w::y-pos y-length) height)))
	  (t
	   (setf top 0)
	   (setf bottom height)))

    ;; Vertical cross-hair
    (w::SHEET-DRAW-LINE w::x-pos top w::x-pos bottom the-alu t w::sheet)
    ;; Horizontal cross-hair
    (w::SHEET-DRAW-LINE left w::y-pos right w::y-pos the-alu t w::sheet)))

(defmethod (cross-hair-blinker :setup) (&optional x-len y-len)
  (setf x-length x-len)
  (setf y-length y-len))

;; This is required by w:blinker.
(defmethod (cross-hair-blinker :size) ()
  (values 0 0))

(w::mouse-define-blinker-type
  :cross-hair
  #'(lambda (screen)
      (w::make-blinker screen 'cross-hair-blinker
	:visibility nil)))


;;;; --------------------------------------------------------------------------
;;;;   Useful Flavors
;;;; --------------------------------------------------------------------------


;;; IO-BUFFER-SHARERS-MIXIN provides a simple way to share an io-buffer
;;; among several panes of a constraint frame.  The external interface
;;; is through the init keywords :IO-BUFFER-SHARERS and
;;; :IO-BUFFER-PROVIDER.

(defflavor IO-BUFFER-SHARERS-MIXIN () ()
  (:init-keywords :io-buffer-sharers
		  :io-buffer-provider)
  (:required-flavors tv:basic-constraint-frame))

(defmethod (IO-BUFFER-SHARERS-MIXIN :AFTER :INIT) (init-plist)

  "Set up an io-buffer shared among some windows."

  ;; Some panes would like to share an IO buffer.  The IO buffer of
  ;; the pane named in the init option :IO-BUFFER-PROVIDER is made the
  ;; IO buffer for all the panes named in :IO-BUFFER-SHARERS.  If no
  ;; IO-BUFFER-PROVIDER is given then an IO buffer is created and used
  ;; by all the sharers.
  (let ((io-buffer-provider (getf (cdr init-plist) :io-buffer-provider))
	(io-buffer-sharers (getf (cdr init-plist) :io-buffer-sharers))
	(io-buffer nil))
    (when io-buffer-sharers
      (setf io-buffer (or (and io-buffer-provider
			       (send self :send-pane io-buffer-provider :io-buffer))
			  (w:make-default-io-buffer)))
      (dolist (pane-name io-buffer-sharers)
	(send self :send-pane pane-name :set-io-buffer io-buffer)))))

;;; ---------------------------------------------------------------------------

;;; CHOOSE-CONFIGURATION-MIXIN provides a simple way to change the
;;; configuration of a frame.  The :CHOOSE-CONFIGURATION method will
;;; pop up a window of all configurations.

(defflavor CHOOSE-CONFIGURATION-MIXIN
	   ((all-configurations            nil)
	    (configuration-menu-item-list  nil))
	   ()
  (:required-flavors tv:basic-constraint-frame))

(defmethod (CHOOSE-CONFIGURATION-MIXIN :configurations) ()
  "Return a list of names of all the panes in the constraint frame."
  (or all-configurations
      (setf all-configurations (mapcar #'car tv:constraints))))

(defmacro w-menu-choose (alist &rest key-value-pairs)
  #+TI
  `(w::menu-choose ,alist ,@key-value-pairs)
  #+SYMBOLICS
  ;; not handling anything funky here
  `(tv::menu-choose ,alist
                    ,(getf key-value-pairs :label)
                    ,(or (getf key-value-pairs :near-mode) ''(:mouse))
                    ,(or (getf key-value-pairs :default-item) nil)	
                    ,(or (getf key-value-pairs :superior) 'tv:mouse-sheet)))
		   
(defmethod (CHOOSE-CONFIGURATION-MIXIN :choose-configuration) (&optional choice)
  "Change the configuration of the frame.
   With no argument, pop up a menu of configurations to choose from.
   If CHOICE is supplied it must be the name of a configuration."
  (unless choice
    (unless configuration-menu-item-list
      (setf configuration-menu-item-list
	    (mapcar #'(lambda (config-name)
			`(,config-name :value ,config-name
			  :font fonts:medfnt
                          :documentation ,(get config-name :configuration-documentation)))
		    (send self :configurations))))
    (setf choice
	  (w-menu-choose
	    configuration-menu-item-list
	    :label '(:string " Configurations Available "
                     #+TI :centered #+TI :font #+TI fonts:medfnb
		     #+SYMBOLICS :character-style #+SYMBOLICS (:fix :roman :large))
            :columns 1
            :item-alignment :left)))
  (when choice
    (send self :set-configuration choice)
    (dolist (w (send self :inferiors))
      (when (and (not (typep w 'w:lisp-listener))
                 (send w :exposed-p))
        (send w :refresh)))))


;;;; --------------------------------------------------------------------------
;;;;   Random Window System Stuff
;;;; --------------------------------------------------------------------------


;;; Add another CVV variable type, :NUMBER-BETWEEN, which is like
;;; :number but restricts the input to be between two numbers.
;;; :NUMBER-BETWEEN takes two arguments: the minimum and maximum
;;; acceptable values.  For example,
;;;
;;; (w:choose-variable-values
;;;    '((some-number
;;;       "Some Number"
;;;       :number-between 0 20
;;;       :documentation "Enter a new value between 0 and 20.")))


(setf (get :number-between 'w:choose-variable-values-keyword-function)
      'cvv-parse-number-between)

(defun cvv-read-number-between (stream)
  (declare (special min max))
  (let ((new-value (read stream)))
    (unless (and (numberp new-value)
		 (<= min new-value max))
      (error "Please enter a number between ~d and ~d." min max))
    new-value))

(defun cvv-parse-number-between (keyword-and-args)
  (let ((min (second keyword-and-args))
	(max (third keyword-and-args)))
    (declare (special min max))
    (values 'prin1
	    (closure '(min max) 'cvv-read-number-between)
	    nil
	    nil
	    nil
	    (or (getf (cdddr keyword-and-args) :documentation)
		(format nil "Enter a number between ~d and ~d." min max)))))

;;; ---------------------------------------------------------------------------

#+TI
(defun mmc-all/none (item-list &key (highlighted-values nil)
                                    (label "Choose")
                                    (all-item  "Select All")
                                    (none-item "Deselect All")
                                    (all-doc   "Turn all choices on.")
                                    (none-doc  "Turn all choices off.")
                                    (item-alignment :left)
                                    (columns 1))

  "Pops up a multiple choice menu with two additional items:
   `Select All' and `Deselect All.'"

  (let* ((new-item-list
           `((,all-item
              :execute (send self :set-highlighted-items
                             (copy-list ',(lisp:remove-if
                                            #'(lambda (item)
                                                (and (consp item)
                                                     (getf  (cdr item) :no-select)))
                                            item-list)))
              :documentation ,all-doc
              :font fonts:hl12i)
             (,none-item
              :execute (send self :set-highlighted-items nil)
              :documentation ,none-doc
              :font fonts:hl12i)
             ("" :no-select t)
             ,@item-list))
         (highlighted-items
           (lisp:remove-if-not #'(lambda (item)
                              (lisp:member (if (consp item)
					       (getf (cdr item) :value)
					       item)
					   highlighted-values
					   :test #'eq))
                          new-item-list)))
    (w:menu-choose
      new-item-list
      :label label
      :highlighting t
      :highlighted-items highlighted-items
      :item-alignment item-alignment
      :columns columns
      :menu-margin-choices '(:doit))))

#+SYMBOLICS
(tv:defwindow-resource momentary-multiple-menu-resource ()
  :make-window (tv:momentary-multiple-menu)
  :reusable-when :deexposed)

#+SYMBOLICS
(defun mmc-all/none (item-list &key (highlighted-values nil)
                                    (label "Choose")
                                    (all-item  "Select All")
                                    (none-item "Deselect All")
                                    (all-doc   "Turn all choices on.")
                                    (none-doc  "Turn all choices off.")
                                    (item-alignment :left)
                                    (columns 1))

  "Pops up a multiple choice menu with two additional items:
   `Select All' and `Deselect All.'"

  (declare (ignore none-doc all-doc none-item all-item item-alignment columns))
  (let ((highlighted-items
	  (lisp:remove-if-not #'(lambda (item)
				  (lisp:member (getf (cdr item) :value)
					       highlighted-values :test #'eq))
			      item-list)))
    (momentary-multiple-choose item-list highlighted-items label)))


#+SYMBOLICS
(defun momentary-multiple-choose (items highlighted &optional label)
  "This exists since symbolics, in its great wisdom, has a multiple-menu-choose
   which allows one from each column, but apparently nothing else."
  (using-resource (menu momentary-multiple-menu-resource)
     (send menu :set-item-list items)
     (send menu :set-highlighted-items highlighted)
     (when label (send menu :set-label label))
     ;; (expose-window-near menu near-mode)
     (send menu :choose)))





(defun color-window-p (window)
  "Returns true if `window' is a color window."
  (let ((screen-array (send window :screen-array))
	(superior (send window :superior)))
    (cond ((and (null screen-array) (null superior))
	   (error "Can't determine whether ~s is a color window." window))
	  ((null screen-array)
	   (color-window-p superior))
	  (t (not (eq (sys::array-type screen-array) 'sys::art-1b))))))


;;; ---------------------------------------------------------------------------
;;;                                End of File
;;; ---------------------------------------------------------------------------

