;;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package:UMASS-EXTENDED-LISP; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.UMASS-EXTENDED-LISP]GENERIC-EXTENSIONS.LISP *-*
;;;; *-* Last-Edit: Tuesday, January 16, 1990  21:06:53 *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 429) *-*
;;;; *-* Software: TI Common Lisp System 6.9 *-*
;;;; *-* Lisp: TI Common Lisp System 6.9 *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                           Generic Extensions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1988, 1989 by COINS. 
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764;
;;;    ONR CDPS contract NR049-041.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains extensions to Common Lisp needed by GBB.  Use this file
;;;  as a last resort.  The functions in this file sacrifice either speed or
;;;  functionality in order to remain within Common Lisp.  They would be better
;;;  written in terms of a specific implementation.  Look for a file called
;;;  xxx-EXTENSIONS.  The file UMASS-EXTENDED-LISP.LISP contains extensions to
;;;  Common Lisp that are written in Common Lisp.
;;;
;;;  04-12-88 File Created.  (GALLAGHER)
;;;  04-25-88 Added (COMPILE LOAD) note to avoid using this file if at all
;;;           possible.  (Cork)
;;;  10-29-89 KCL patch.  Apparently, KCL of June 3, 1987 uses the printed
;;;           representation of a structure to store structure instances in
;;;           a compiled file.  So if your print function is something like
;;;           "#<abc>" you get the cryptic error message "The default dispatch
;;;           macro got an error" when you load the file.
;;;           To get around this the new destruct macro defined here will filter
;;;           out the :print-function option.  This can be disabled by setting
;;;           *REMOVE-PRINT-FUNCTION* to nil.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'umass-extended-lisp
	    :use '(lisp)
            :nicknames '(uel))

(export '(defstruct-p
	  defstruct-conc-name
	  structure-slot-names
	  structure-slot-p
	  get-structure-slot
          #+KCL *remove-print-function*
	  deftransform
	  delete-transform
	  %pass%
	  %pointer))

(use-package '(lisp))

(proclaim '(optimize (speed 3) (safety 1)))

(eval-when (compile load)
  (format *error-output*
"~2%NOTE: This file contains generic extensions to Common Lisp used by GBB.
Use this file until you can write implementation dependent versions of
these functions.  If an implementation-dependent xxx-EXTENSIONS file is
present for your Common Lisp implementation, use it instead of this
GENERIC-EXTENSIONS file.  If an xxx-EXTENSIONS file is not present for
your implementation, consider writing one.~2%"))

;;; The functions that must be defined in this file are:
;;;
;;;     defstruct-p
;;;     get-defstruct-description
;;;     defstruct-conc-name
;;;     structure-slot-names
;;;     structure-slot-p
;;;     get-structure-slot  (and corresponding setf method)
;;;     deftransform
;;;     delete-transform
;;;     %pointer
;;;
;;; See the documentation with each function for arguments and purpose.



;;;; --------------------------------------------------------------------------
;;;;   Generic Defstruct Functions
;;;; --------------------------------------------------------------------------

;;; It is a hole in Common Lisp that you can't access a slot in a structure
;;; via the slot name.  For example, if I have an instance of the following
;;; defstruct,
;;;
;;;    (defstruct (foo (:conc-name FOO->))
;;;      (a nil)
;;;      (b nil))
;;;
;;; I want to be able to get the value of slot A with a call like:
;;;
;;;    (get-structure-slot object 'A).
;;;
;;; This is because I may not know what the accessor function is for that
;;; slot.  Even if I did know the name of the accessor function, I wouldn't
;;; be able to use it to alter the value of the slot because Setf needs to
;;; know the function name at compile time.  This means that code such as
;;; the following won't work.
;;;
;;;    (defun set-structure-slot (object slot-accessor new-value)
;;;      (setf (funcall slot-accessor object) new-value))
;;;
;;; Obviously, Setf shouldn't need to handle that as a place form.  This
;;; just points out the need for a general slot accessor function which
;;; will work as a place form for Setf.


;;; The following code implements a generic defstruct facility which does
;;; not require any special knowledge of the implmentation.  The strategy is
;;; to shadow the system's defstruct and save some information about the
;;; structure.  There are two problems with this approach:
;;;
;;;   1.  This file needs to be loaded before any of your defstructs are
;;;       loaded or compiled.
;;;
;;;   2.  This adds the overhead of another function call to structure
;;;       accesses and updates.  It would probably be faster to use the
;;;       implementation dependent versions of these functions.  (This
;;;       doesn't slow down normal defstruct accesses and updates.)

(eval-when (compile load eval)
  (unless (fboundp '%%original-defstruct)
    (cond ((special-form-p 'defstruct)
           (error "GENERIC-EXTENSIONS won't work in ~a~@
                   because DEFSTRUCT is implemented as a special form."
                  (lisp-implementation-type)))
          ((macro-function 'defstruct)
           (setf (macro-function '%%original-defstruct)
                 (macro-function 'defstruct)))
          ((symbol-function 'defstruct)
           (setf (symbol-function '%%original-defstruct)
                 (symbol-function 'defstruct)))
          (t
           (error "DEFSTRUCT is fboundp but is not a special-form, a macro,~@
	           or a function.  What does this mean?")))))


(%%original-defstruct (defstruct-description
                        (:conc-name "DD.")
                        #-KCL (:print-function dd-print-function))

  (name       nil)      ;; Name of this defstruct -- a symbol
  (conc-name  "")       ;; Conc-name for accessor functions -- a string
  (slot-list  nil)      ;; List of slots (including slots inherited from
                        ;;   an included unit) -- a list of keywords
  (slot-names nil)      ;; List of slot names -- a list of strings
  (getter-function nil) ;; Functions to set and get the value of a slot
  (setter-function nil) ;;   -- symbols naming functions
  )

(defun dd-print-function (object stream depth)
  (declare (ignore depth))
  (format stream "#<DD ~s>" (dd.name object)))


#+KCL
(defvar *remove-print-function* t)

(defmacro defstruct (name-and-options &body slot-specs)

  (unless (consp name-and-options)
    (setf name-and-options (list name-and-options)))

  (let* ((name (car name-and-options))
         (name-string (string name))
         (dd (make-defstruct-description :name name))
         (conc-name (concatenate 'simple-string name-string "-"))
         (documentation (if (stringp (car slot-specs))
                            (pop slot-specs)
                            "No documentation supplied."))
         (included-structure nil)
         (included-slots nil)
         idd slot-setter-and-getter-forms)

    ;; Take note of the :conc-name and :include options.
    (mapc #'(lambda (option)
              (case (first-if-list option)
                (:conc-name
                   (when (and (consp option) (= (length option) 2))
                     (setf conc-name (or (string (second option)) ""))))
                (:include
                   (unless (and (consp option) (> (length option) 1))
                     (error "While defining ~s,~@
                             Defstruct :INCLUDE option must have an argument."
                            name))
                   (setf included-structure (second option)))
                (otherwise nil)))
          (cdr name-and-options))

    #+KCL
    (when *remove-print-function*
      (setf name-and-options
            (remove :print-function name-and-options :key #'first-if-list)))

    (setf (dd.conc-name dd) conc-name)
    (when included-structure
      (setf idd (get included-structure 'defstruct-description))
      (unless idd
        (error "While defining ~s,~@
                The included structure, ~s, is not a defstruct."
               name included-structure))
      (setf included-slots (dd.slot-list idd)))

    ;; Record information about the slots.
    (setf slot-setter-and-getter-forms
          (process-defstruct-slots slot-specs included-slots dd))

    `(progn
       (%%original-defstruct ,name-and-options ,documentation ,@slot-specs)
       ,@slot-setter-and-getter-forms
       (eval-when (load eval compile)
         (setf (get ',name 'defstruct-description) ',dd))
       ',name)))


(defun process-defstruct-slots (slot-specs included-slots dd)

  (macrolet ((form-symbol (&rest strings)
               `(intern (concatenate 'simple-string ,@strings)))
             (form-keyword (&rest strings)
               `(intern (concatenate 'simple-string ,@strings)
                        (find-package "KEYWORD"))))
    (let* ((conc-name (dd.conc-name dd))
           (structure-name (string (dd.name dd)))
           (all-slots (append included-slots
                              (mapcar #'(lambda (x)
                                          (form-keyword (string (first-if-list x))))
                                      slot-specs)))
           (getter-name (form-symbol "%%" structure-name "-GET-SLOT"))
           (setter-name (form-symbol "%%" structure-name "-SET-SLOT"))
           (setter-clauses nil)
           (getter-clauses nil)
           slot-name accessor setter-function getter-function)

      (dolist (slot-keyword all-slots)
        (setf slot-name     (string (first-if-list slot-keyword))
              accessor      (form-symbol conc-name slot-name))
        (push `(,slot-keyword (setf (,accessor object) value))
              setter-clauses)
        (push `(,slot-keyword (,accessor object))
              getter-clauses))
      
      (setf setter-function `(defun ,setter-name (object slot value)
                               (case (intern (string slot) (find-package "KEYWORD"))
                                 ,@(nreverse setter-clauses)
                                 (otherwise
                                  (error "~s is not a slot in ~s." slot object)))))
      (setf getter-function `(defun ,getter-name (object slot)
                               (case (intern (string slot) (find-package "KEYWORD"))
                                 ,@(nreverse getter-clauses)
                                 (otherwise
                                  (error "~s is not a slot in ~s." slot object)))))

      (setf (dd.setter-function dd) setter-name)
      (setf (dd.getter-function dd) getter-name)
      (setf (dd.slot-list dd) all-slots)
      (setf (dd.slot-names dd) (map 'list #'symbol-name all-slots))

      (list setter-function getter-function))))

(defun first-if-list (x)
  "Returns the first element of X if X is a list,
   otherwise simply returns X."
  (if (consp x) (car x) x))


;;; GBB uses the functions Get-Structure-Slot, Set-Structure-Slot, and
;;; Defstruct-Conc-Name which are defined below.


(defun get-defstruct-description (name)

  "GET-DESFSTRUCT-DESCRIPTION name

   If NAME has been defined as a structure then return its
   description.  Otherwise signal an error."

  (or (get name 'defstruct-description)
      (error "~s is not the name of a structure."
             name)))


(defun defstruct-p (name)

  "DEFSTRUCT-P name

   This predicate returns true if NAME is the name of a
   defstruct type; nil otherwise.  NAME must be a symbol."
 
  (and (get name 'defstruct-description)
       t))


(defun defstruct-conc-name (structure)

  "DEFSTRUCT-CONC-NAME structure

   Return a string which is the prefix for building defstruct slot
   accessors for this structure.  STRUCTURE must be a symbol which
   names a structure type."

  (dd.conc-name (get-defstruct-description structure)))


(defun structure-slot-names (structure)

  "STRUCTURE-SLOT-NAMES structure

   This function returns a list of slot names for the structure
   named by STRUCTURE, which must be a symbol."

  (dd.slot-names (get-defstruct-description structure)))


(defun structure-slot-p (structure slot)

  "STRUCTURE-SLOT-P structure slot

   This function returns true if SLOT is the name of a slot in the
   defstruct type named by STRUCTURE."

  (let ((dd (get-defstruct-description structure))
        (key (intern (string slot) (find-package "KEYWORD"))))
    (find key (dd.slot-list dd) :test #'eq)))

;;;
;;; Structure Slot Access Functions :::
;;;

(defun get-structure-slot (object slot)

  "GET-STRUCTURE-SLOT object slot

   Returns the value of a slot in a structure given the name of
   the slot.  OBJECT is a structure instance; SLOT is the name
   of a slot in OBJECT.

   This function may be used as a place form for SETF."

  (let* ((type (type-of object))
         (dd (get-defstruct-description type)))
    (funcall (dd.getter-function dd) object slot)))

;;;
;;; Structure Slot Setting Functions :::
;;;

(defun set-structure-slot (object slot value)

  ;; SET-STRUCTURE-SLOT object slot value
  ;;
  ;; Sets the value of a slot in a structure
  ;; given the name of the slot."

  (let* ((type (type-of object))
         (dd (get-defstruct-description type)))
    (funcall (dd.setter-function dd) object slot value)))

(defsetf get-structure-slot set-structure-slot)


;;;; --------------------------------------------------------------------------
;;;;   Compiler Transforms.
;;;; --------------------------------------------------------------------------

;;; The body of the transform should return the symbol %PASS% if it
;;; doesn't apply.  If it does apply then it should return the
;;; transformed form.  For example, a common optimization is to do
;;; keyword analysis at compile time.
;;;
;;;     (defun foo (x &key a b)
;;;       ...)
;;;
;;;     (deftransform (foo keyword) (x &rest keyword-args)
;;;       (if (literal-keywords-in-arglist keyword-args)
;;;           (let ((a (getf keyword-args :a))
;;;                 (b (getf keyword-args :b)))
;;;             `(foo-internal ,x ,a ,b))
;;;           '%pass%))
;;;
;;;     (defun foo-internal (x a b)
;;;       ...)


;;; GBB will define several compiler transforms.  If this feature is
;;; not available in your lisp GBB will still run --- it will just run
;;; a little slower than it would if this feature was available.  If
;;; DEFTRANSFORM is defined then DELETE-TRANSFORM must be defined as
;;; well.

(defmacro DEFTRANSFORM ((function transform-name) arglist &body body)
  
  "DEFTRANSFORM (function transform-name) arglist {form}*

   Defines a source level compiler transform for FUNCTION labeled
   TRANSNAME.  If FUNCTION already has a transform labeled
   TRANSFORM-NAME then the old one will be replaced."

  ;; Avoid `bound but not used' compiler warnings.
  function transform-name arglist body
  nil)


(defun delete-transform (function transform-name)

  "DELETE-TRANSFORM function transform-name

   This function will remove the compiler transform for FUNCTION
   designated by TRANSFORM-NAME."
  ;; Avoid `bound but not used' compiler warnings.
  function transform-name
  nil)


;;;; --------------------------------------------------------------------------
;;;;   Miscellaneous Non Common Lisp Functions
;;;; --------------------------------------------------------------------------

;;; This function is used when printing internal GBB objects.  If your
;;; implementation doesn't provide an easy way to get the address of
;;; an object it is ok to simply return zero.  GBB doesn't depend on the
;;; value of this function uniquely identifying an object.

(defun %pointer (x)

  "%POINTER x

   Returns the address of X.  This is only used in printing to easily 
   distiguish two objects.  Its value should not be relied on."

  ;; Avoid `bound but not used' compiler warnings.
  x
  0)



;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
