;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:TSP; Base:10; Patch-File:T -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.DEVELOPMENT.GBB1.EXAMPLES]TSP-DEMO-ADDITIONS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:36:56 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                           TSP DEMO ADDITIONS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains modifications to the TSP code so that it will interact
;;;  nicely with the GBB Graphics.  Load the file TSP first, then load this
;;;  file.
;;;
;;;  11-18-87 File Created.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'tsp)

(proclaim '(optimize (speed 3) (safety 0)))

(eval-when (compile load eval)
  ;; Check that GBB Graphics is loaded.  Use intern in the second AND clause
  ;; instead of just typeing the symbol 'gbb-graphics::*gbb-graphics-frames*
  ;; so that the reader won't get an error if the package doesn't exist.
  (unless (and (find-package "GBB-GRAPHICS")
               (boundp (intern "*GBB-GRAPHICS-FRAMES*" "GBB-GRAPHICS")))
    (error "The GBB Graphics must be loaded before ~
            compiling or loading this file.")))

;;;------------------------------------------------------------------------

;;; In order to get the graphics to draw lines between the cites we have
;;; to represent the arcs explicitly.  We define an extra space, called
;;; ARCS, and define another unit type, called ARC, which are stored on
;;; the ARCS space.  This is purely for display purposes -- the TSP
;;; knowledge sources, etc. all work exactly the same.

;;;  An index structures for arcs.

(define-index-structure arc-index
  "A single arc between two cities.
   This is implemented as a set of the two endpoints."
  :composite-type  list
  :composite-index :none
  :element-type    cons
  :indexes         ((x :point car)
		    (y :point cdr)))

(defconstant *null-arc-index* '((0 . 0))
  "The null arc.  Used for initial values in define unit.")

(defun cities->arc-index (from-city to-city)
  "Create an arc-index from two cities."
  (list (cons (city$x from-city) (city$y from-city))
	(cons (city$x to-city) (city$y to-city))))

;;;------------------------------------------------------------------------

;;; Redefine PATH.  Adding an update event on the ARCS slot.
;;; All functions from TSP that modify the ARCS slot must be included
;;; in this file so that they get recompiled to use the new event.

(define-gbb1-unit PATH

  "PATH contains the information about the current state of the solution path."

  :EVENT-CLASSES  (:creation-events)
  
  :SLOTS ((arcs nil :update-events (add-arc-to-arc-space))
	  (x-ave 0)
	  (y-ave 0)
	  (x-min 0)
	  (y-min 0)
	  (x-max 0)
	  (y-max 0)
	  (length 0))

  :LINKS ((cities-to-visit (city free))
	  (cities-visited  (city used)))

  :PATHS ((:path '(solution paths))))

;;;------------------------------------------------------------------------

(defun ADD-ARC-TO-PATH (add-arc-ksar)

  "ADD-ARC-TO-PATH add-arc-ksar

   This action adds the arc indicated by the from and to slot of the ksar
   to the solution path."

  (let ((solution (find-path "Solution Path"))
	(from-city (add-arc-ksar$from-city add-arc-ksar))
	(to-city   (add-arc-ksar$to-city add-arc-ksar)))

    (incf (path$length solution) (distance-between from-city to-city))
    (linkf (path$cities-visited solution) from-city)
    (linkf (path$cities-visited solution) to-city)
    (push (list from-city to-city) (path$arcs solution))
    (incf (city$times-in-path from-city))
    (incf (city$times-in-path to-city))))

;;;------------------------------------------------------------------------

(defun ADD-FINAL-ARC-TO-PATH (add-final-arc-ksar)

  "ADD-FINAL-ARC-TO-PATH add-final-arc-ksar

   Adds the final arc to the path and prints out a message saying so."

  (declare (ignore add-final-arc-ksar))

  (let* ((solution (find-path "Solution Path"))
	(remaining-cities (find-units t (make-paths :paths '(tour-info cities) )
						:all
						:filter-before '(only-once-in-path)))
	 (from-city (first remaining-cities))
	 (to-city (second remaining-cities)))

    (incf (path$length solution) (distance-between from-city to-city))
    (linkf (path$cities-visited solution) from-city)
    (linkf (path$cities-visited solution) to-city)
    (push (list from-city to-city) (path$arcs solution))
    (incf (city$times-in-path from-city))
    (incf (city$times-in-path to-city)))

  (format t "~%The salesman has completed his travels."))

;;;------------------------------------------------------------------------

(define-unit ARC

  "A single arc between two cities."

  :SLOTS ((from-city)
	  (to-city)
	  (arc nil :type arc-index))

  :DIMENSIONAL-INDEXES ((x arc) (y arc))

  :PATHS ((:path '(solution arcs))))

;;;------------------------------------------------------------------------

;;; Add a space for ARCS and modify the solution blackboard to include it.

(define-space ARCS
  "The space which holds the arcs.  This is primarily used for
   display convenience."
  :units (arc)
  :dimensions ((x :ordered #.*longitude-range*)
	       (y :ordered #.*lattitude-range*)))

(define-blackboard SOLUTION (paths arcs)
  "The blackboard to hold the solution path")

;;;------------------------------------------------------------------------

(defun ADD-ARC-TO-ARC-SPACE (solution slot new-value old-value)

  "ADD-ARC-TO-ARC-SPACE unit slot new-value old-value

   This GBB event function creates an ARC unit corresponding to the
   arc that has just been added to the solution."

  (declare (ignore slot solution old-value))
  
  ;; New arcs get pushed onto the front of the list so 
  ;; the new arc is the first element of the new slot value.
  (let* ((the-arc (first new-value))
	 (from-city (first the-arc))
	 (to-city (second the-arc)))
    (make-arc :from-city from-city
	      :to-city to-city
	      :arc (cities->arc-index from-city to-city))))

;;;------------------------------------------------------------------------

(defun tsp-window-setup ()
  (flet ((setup-list (pane-name path &optional title)
           (gbb-graphics::setup-pane
             pane-name path nil nil
             :title title))
	 (setup-level (pane-name path x-dim y-dim &optional title)
          (gbb-graphics::setup-pane
            pane-name path x-dim y-dim
            :title title)))
    (setup-list 1 gbb1::*tri-agenda-path* "Triggered")
    (setup-list 2 gbb1::*exe-agenda-path* "Executable")
    (setup-list 3 gbb1::*exd-agenda-path* "Executed")
    (setup-level 4
		 (make-paths :paths '(tour-info cities))
		 :x :y
                 "Cities")
    (setup-list 5 gbb1::*cpl-agenda-path* "Control Plan")
    (setup-list 6
		(make-paths :paths '(tour-info cities))
                "Cities")
    (setup-level 7
		 (make-paths :paths '(solution arcs))
		 :x :y
                 "Solution Path")
    ))

;;;------------------------------------------------------------------------

(defun print-cycle-and-wait ()
  (loop
    (format t "~&Cycle ~d... " gbb1::*execution-cycle*)
    (case (read-char)
      (#\page (format t "~:|"))
      (otherwise (terpri)
                 (return t)))))

(define-gbb1-output
  :trace-fn                'print-cycle-and-wait
  :trace-print-points      nil
  :print-unit-width        25
  :output-stream           *standard-output*)

;;;------------------------------------------------------------------------

(defun tsp ()
  "Run the Traveling Salesman Problem with the GBB Graphics."
  ;; This clear-blackboard-database is not necessary for the TSP system
  ;; to run correctly.  It is done here to minimize the distracting
  ;; redisplays in the graphics windows.
  (clear-blackboard-database nil)
  (instantiate-blackboard-database 'tour-info 'solution :mode :overwrite)  
  (tsp-window-setup)
  (run-gbb1 :initial-ks 'start-tsp))

;;;-----------------------------------------------------------------------------
;;;                               End of file
;;;-----------------------------------------------------------------------------
