;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.DEVELOPMENT.GBB1.EXAMPLES]SIMPLE-KS-SHELL-TEST.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:35:11 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *       GBB1 KS Shell: Simple KS Shell Test w/Generic Control KSs
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  06-18-87 File Created.  (Johnson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;; ---------------------------------------------------------------------------
;;;
;;; Clear the GBB1 control shell environment
;;;
;;; ---------------------------------------------------------------------------

(reset-gbb1)

;;;-----------------------------------------------------------------------------
;;;
;;;  Initialize Prescription
;;;
;;;-----------------------------------------------------------------------------

(format t "~%~a ~s" (short-date-and-time) "Defining INITIALIZE-PRESCRIPTION")

(define-gbb1-control-ks INITIALIZE-PRESCRIPTION

  "Initialize-prescription is triggered by the addition of a new strategy PO
   to the control blackboard.  It takes the first element of the future-prescription
   slot of the PO (which should be a single KS name or list of KS names)
   and links the PO to these KSs through its current-prescription link. This action
   (automatically) generates a GBB1 event which should be noticed by these KSs and cause them to
   trigger."

  :CONTROL-TYPE       :META
  :TRIGGER-CONDITIONS ((trigger-event-class-p :unit-creation)
		       (strategyp (triggering-unit)))
  :CONTEXT-SLOTS      ((triggering-po) (((gbb1-event$unit-instance *trigger-event*))))
  :ACTION-FUNCTION    #'init-prescription
  :FROM-BB            (make-paths :paths '(gbb1 control control-plan))
  :TO-BB              `(,*str-agenda-path* ,*foc-agenda-path*)
  :AUTHOR             "Philip Johnson")

(defun INIT-PRESCRIPTION  (initialize-prescription-ksar)
  "Initialize the strategy prescription"
  (let* ((strategy-po (initialize-prescription-ksar$triggering-po
			initialize-prescription-ksar))
	 (prescr (first (basic-strategy-po$future-prescription
			  strategy-po))))
    (gbb:dolist-or-atom (ks prescr)
      
      (linkf (basic-strategy-po$current-prescription strategy-po)
	     (find-unit-by-name (string ks) ks))
      (user::printv "in init-pre" strategy-po ks prescr (basic-strategy-po$current-prescription strategy-po)))))

;;;-----------------------------------------------------------------------------
;;;
;;;  Update Prescription
;;;
;;;-----------------------------------------------------------------------------
(format t "~%~a ~s" (short-date-and-time) "Defining UPDATE-PRESCRIPTION")

(define-gbb1-control-ks UPDATE-PRESCRIPTION

  "Update-prescription is triggered by the completion of the current-prescription of a 
   strategy PO.  (this is signalled by the removal of the final PO from the
   current-prescription link of the strategy PO by the terminate-focus KS.)
   Update-prescription will update the current-prescription link of the strategy PO
   to the next focus or set of focii which implement the strategy."

  :CONTROL-TYPE       :META
  :TRIGGER-CONDITIONS ((strategyp (triggering-unit))
		       (trigger-event-class-p :unlink)
		       (eq (gbb1-event$slot-or-link *trigger-event*) 'current-prescription)
		       (null (gbb1-event$new-value *trigger-event*)))
  :CONTEXT-SLOTS      ((triggering-po) (((gbb1-event$unit-instance *trigger-event*))))
  :ACTION-FUNCTION    #'(lambda (update-prescription-ksar)
			  "Update the prescription of the triggering strategy PO, if required."
			  (let* ((strategy-po (update-prescription-ksar$triggering-po update-prescription-ksar)))
			    ;; update the past prescription with the (now-defunct) current-prescription.
			      (push-end (first (basic-strategy-po$future-prescription strategy-po))
					(basic-strategy-po$past-prescription strategy-po))
			      ;; update the future prescription by popping off the current prescription
			      (pop (basic-strategy-po$future-prescription strategy-po))
			      ;; set up the current prescription list.
			      (let ((presc (first (basic-strategy-po$future-prescription strategy-po))))
				(cond ((listp presc)
				       (dolist (ks presc)
					 (linkf (basic-strategy-po$current-prescription strategy-po)
						(find-unit-by-name (string ks)))))
				      (t (linkf (basic-strategy-po$current-prescription strategy-po)
						(find-unit-by-name (string presc))))))))
  :FROM-BB             (make-paths :paths '(gbb1 control control-plan))
  :TO-BB               `(,*str-agenda-path* ,*foc-agenda-path*)
  :AUTHOR              "Philip Johnson")

;;;-----------------------------------------------------------------------------
;;;
;;;  Terminate Strategy
;;;
;;;-----------------------------------------------------------------------------
(format t "~%~a ~s" (short-date-and-time) "Defining TERMINATE-STRATEGY")

(define-gbb1-control-ks TERMINATE-STRATEGY
		  
  "Terminate-strategy will end a strategy when its future-prescription becomes nil.
   This involves:
     Setting the strategy's status slot to inoperative.
     Unlinking this strategy from any the current prescription slot of any higher level
       strategies which it implements."

  :CONTROL-TYPE       :META
  :TRIGGER-CONDITIONS ((strategyp (triggering-unit))
		       (trigger-event-class-p :slot-update)
		       (eq (gbb1-event$slot-or-link *trigger-event*) 'future-prescription)
		       (null (gbb1-event$new-value *trigger-event*)))
  :CONTEXT-SLOTS      ((triggering-po) (((gbb1-event$unit-instance *trigger-event*))))
  :ACTION-FUNCTION    #'(lambda (terminate-strategy-ksar)
			  "End the triggering strategy."
			  (let* ((strategy-po (terminate-strategy-ksar$triggering-po terminate-strategy-ksar)))
			    (setf (basic-strategy-po$status strategy-po) :inoperative)
			    (unlinkf-all (basic-strategy-po$implementor-of strategy-po))))
  :FROM-BB             (make-paths :paths '(gbb1 control control-plan))
  :TO-BB               `(,*str-agenda-path* ,*foc-agenda-path*)
  :AUTHOR              "Philip Johnson")


;;;-----------------------------------------------------------------------------
;;;
;;;  Terminate Focus
;;;
;;;-----------------------------------------------------------------------------
(format t "~%~a ~s" (short-date-and-time) "Defining TERMINATE-FOCUS")
(define-gbb1-control-ks TERMINATE-FOCUS
		  
  "Terminate-focus will end a focus when its goal has been achieved.
   This involves:
     Setting the focus' status slot to inoperative.
     Unlinking this focus from the current-prescription link of any strategies it implements.
     Setting all of its heuristics to inoperative."

  :CONTROL-TYPE       :META
  :TRIGGER-CONDITIONS ((focusp (triggering-unit))
		       (trigger-event-class-p :unit-creation))
  :PRECONDITIONS      ((funcall (basic-focus-po$goal-function
				  (terminate-focus-ksar$triggering-po *this-ksar*))))
  :CONTEXT-SLOTS      ((triggering-po) (((gbb1-event$unit-instance *trigger-event*))))
  :ACTION-FUNCTION    #'(lambda (terminate-focus-ksar)
			  "End the triggering focus."
			  (let* ((focus-po (terminate-focus-ksar$triggering-po terminate-focus-ksar)))
			    (setf (basic-focus-po$status focus-po) :inoperative)
			    (unlinkf-all (basic-focus-po$implementor-of focus-po))
			    (dolist (heuristic-po (basic-focus-po$implemented-by focus-po))
			      (setf (basic-heuristic-po$status heuristic-po) :inoperative))))
  :FROM-BB             (make-paths :paths '(gbb1 control control-plan))
  :TO-BB               `(,*heu-agenda-path* ,*foc-agenda-path*)
  :AUTHOR              "Philip Johnson")

;;;-----------------------------------------------------------------------------
;;;
;;;  Initial KS (adds a strategy PO)
;;;
;;;-----------------------------------------------------------------------------
(format t "~%~a ~s" (short-date-and-time) "Defining INITIAL-KS")
(define-gbb1-control-ks INITIAL-KS

  "Initial-KS is the initialization KS to be run by the KS Shell. It simply
   creates a strategy PO which should trigger the generic KSs."

  :CONTROL-TYPE      :STRATEGY
  :ACTION-FUNCTION   #'(lambda (initial-ks-ksar)
			 (make-initial-ks-po
			   :control-type :strategy
			   :future-prescription '(focus1 focus2)
			   :stability           :stable)))

;;;-----------------------------------------------------------------------------

(defun focus1-integrated-rating  (ksar focus-instance)
  (let ((total 0))
    (map-heuristic-ratings #'(lambda (rating po)
                               (declare (ignore po))
                               (incf total rating))
                           ksar
                           focus-instance)
    total))

(defvar *focus1-goal* nil)
(defun focus1-goal () *focus1-goal*)

(format t "~%~a ~s" (short-date-and-time) "Defining FOCUS1")
(define-gbb1-control-ks FOCUS1

  "Focus1 is the first focus to implement initial-ks"			   

  :CONTROL-TYPE       :FOCUS
  :TRIGGER-CONDITIONS ((strategyp (triggering-unit))
		       (current-prescription-p 'focus1 (triggering-unit)))
  :CONTEXT-SLOTS      ((triggering-strategy) (((triggering-unit))))
  :ACTION-FUNCTION    #'create-focus)

(defun create-focus (focus1-ksar) 
  (make-focus1-po
    :status                      :operative
    :stability                   :stable
    :implementor-of              (focus1-ksar$triggering-strategy focus1-ksar)
    :goal-function               #'focus1-goal
    :integrated-rating-function  #'focus1-integrated-rating
    :heuristics                  '(heuristic1 heuristic1-B)))

;;;-----------------------------------------------------------------------------

(defun create-heuristic (heuristic1-ksar)
  (make-heuristic1-po
    :implementor-of (heuristic1-ksar$triggering-focus heuristic1-ksar)))

(format t "~%~a ~s" (short-date-and-time) "Defining HEURISTIC1")

(define-gbb1-control-ks HEURISTIC1

  "Heuristic1 is the first heuristic to implement focus1."

  :CONTROL-TYPE       :HEURISTIC
  :TRIGGER-CONDITIONS ((focusp (triggering-unit))
		       (member 'heuristic1 (basic-focus-po$heuristics (triggering-unit))))
  :CONTEXT-SLOTS      ((triggering-focus) (((triggering-unit))))
  :ACTION-FUNCTION   #'create-heuristic)

;;;-----------------------------------------------------------------------------
;;;
;;; Start things up.
;;;
;;;-----------------------------------------------------------------------------

(defun default-priority (ksar)

  "DEFAULT-PRIORITY nil

   The default priority function simply is the sum of the default 
   integration values."
  (let ((total 0))
    (map-focus-ratings #'(lambda (integrated-rating po)
			  (declare (ignore po))
			  (incf total integrated-rating))
		      ksar)
    total))  
  
;; Define the execution shell blackboard structures.

;; Specify various execution shell parameters.
(define-gbb1-parameters
  :trace-fn                      #'(lambda () nil)
  :priority-fn                   #'default-priority
  :recommendation-fn             #'first
  :termination-fn                #'(lambda () nil)
  :precondition-recheck-interval nil      ;; since stable, don't need to be rechecked.
  :obviation-recheck-interval    nil)     ;; since they don't exist, don't need to be rechecked.

(define-gbb1-blackboards :max-execution-cycles 5)
(more-bb-defs)
(run-gbb1 :initial-ks 'initial-ks) 


;Things to do:
;1. combine the bb defs into one function.
;3. rate some ksars and make sure the rating function code works. 
;   (note rater dependency on type slot of ksar)
;4. implement the travelling salesman jproblem.
;5. document!!

;;;-----------------------------------------------------------------------------
;;;                               End of file
;;;-----------------------------------------------------------------------------


