;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]KSS-KS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:26:04 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 KS Shell: Knowledge Source Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-12-87 File created.  (Johnson)
;;;  09-16-88 Added :addition-to-space-events and :removal-from-space-events
;;;           (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

(export '(define-gbb1-control-KS
	  define-gbb1-domain-KS))

;;; -----------------------------------------------------------------
;;;
;;;   Define-gbb1-CONTROL-KS 
;;;
;;;  This macro expands into a progn whose primary components are:
;;;    -calls to DEFINE-UNIT to define GBB units representing the KS and KSAR.
;;;    -initializations of vectors for condition testing.
;;;    -accumulation of the phases and unit types for use by SETUP-GBB1.
;;;    -building the MAKE- call to create the KS (though not evaluated until run time)
;;;  
;;; -----------------------------------------------------------------

(defmacro define-gbb1-control-KS (name-and-options &body args &aux documentation)
  
  "DEFINE-GBB1-CONTROL-KS name-and-options [documentation]
     &KEY control-type ksar-print-function
          status stability rating-function weight     <for heuristics>
          rating-integration-function goal            <for focii>
          ks-event-classes ksar-event-classes ks-phases ksar-phases
          trigger-conditions preconditions obviation-conditions 
          context-function action-function from-bb to-bb 
          slots dimensional-indexes links path-indexes paths

   DEFINE-GBB1-CONTROL-KS is used to define either a strategy, focus, or heuristic
   control knowledge source.  Some of the available parameters depend upon the value of the
   CONTROL-TYPE argument.

   The following slots are defined in all three of the control KS types:

   ;; The standard BB1 slots:
   TRIGGER-CONDITIONS:     ({predicate}*) | :NONE
   PRECONDITIONS:          ({predicate | ({:stable | :dynamic} predicate)}*) | :NONE
   OBVIATION-CONDITIONS:   ({predicate | ({:stable | :dynamic} predicate)}*) | :NONE
   CONTEXT-SLOTS:           {(({ksar-slot-name}*) ksar-slot-value-generation-fn)} | NIL
   ACTION-FUNCTION:        {function}
   FROM-BB:                ({make-paths-call}*)
   TO-BB:                  ({make-paths-call}*)
   AUTHOR:                 (name)
   COST:                   integer
   RELIABILITY:            integer

   ;; For the extended optimization facilities in GBB1:
   KS-EVENT-CLASSES:       ({event-class}*) | :ALL
   KSAR-EVENT-CLASSES:     ({event-class}*) | :ALL
   Event-class:            {:creation-events | :deletion-events | 
                            :addition-to-space-events | :removal-from-space-events | 
                            :slot-access-events | :slot-update-events | 
                            :link-access-events | :link-update-events | :unlink-events}
   KS-PHASES:              ({user-defined-phase-name}* | :ALL)
   KSAR-PHASES:            ({user-defined-phase-name}* | :ALL)
   KSAR-UNIT-TYPE:         symbol

   ;; For the old standby GBB slots:
   SLOTS:                  ({(slot-name [init-form {keyword value}*])}*)
   LINKS:                  ({(link-name [:singular]
                                        {:reflexive |
                                         (inverse-link-unit inverse-link-name [:singular])}
                                        {keyword value}*)}*)
   DIMENSIONAL-INDEXES:    ({(index-name slot-name [:type index-element-type])}*)
   PATH-INDEXES:           ({(index-name slot-name [:type index-element-type])}*)
   PATHS:                  ({(path-predicate path-spec)}*)

   CONTROL-TYPE:           {:STRATEGY | :FOCUS | :HEURISTIC | :META}"

  (setf documentation
	(if (stringp (car args)) (pop args) "No Documentation Supplied"))

  (with-keywords-bound ((ks-event-classes       (ks-phases           '(list :default-phase))
			 ksar-event-classes     (ksar-phases         '(list :default-phase))
                         context-slots          (trigger-conditions   (list t))
			 action-function        (preconditions        (list t))
			 from-bb                (obviation-conditions (list nil))
			 to-bb                  (author               "Anonymous")
			 ksar-unit-type         (cost        0)       (weight  1)
			 slots                  (reliability 0)
			 dimensional-indexes    links
			 path-indexes           paths
			 control-type           rating-integration-function  (status :operative)
			 rating-function        po-event-classes      stability
			 (ksar-print-function 'default-ksar-print-function)
                         )
			args
			"~s is not a valid keyword for DEFINE-KS.")
    
    (check-KS-keyword-syntax ks-event-classes ksar-event-classes ks-phases trigger-conditions
			     preconditions obviation-conditions context-slots action-function
			     from-bb to-bb rating-integration-function control-type
                             status stability rating-function weight)

    (let* ((ks-unit-type (first-if-list name-and-options))
	   (make-ks-name (form-symbol "MAKE-" ks-unit-type))
	   (ksar-defined ksar-unit-type)
	   (PO-unit-type (unless (eq control-type :META)
			   (form-symbol ks-unit-type "-PO")))
	   (PO-control-type (unless (eq control-type :META)
			      (make-keyword (form-symbol control-type "-PO")))))

      (unless ksar-unit-type
	(setf ksar-unit-type (form-symbol ks-unit-type "-KSAR")))
    
    `(progn
       ;; we want to know the types of KSs and KSARs at both compile and run time.
       (eval-when (load eval compile) 
	 (pushnew ',ks-unit-type *ks-units*)
	 ,@(when po-unit-type
	     `((pushnew ',po-unit-type *po-units*)))
	 ,@(unless ksar-defined
	   `((pushnew ',ksar-unit-type *ksar-units*)))
	 ,@(when from-bb
	     `((pushnew ',from-bb *triggering-space-labels* :test #'equal))))

       ;; update the set of user defined problem solving phases.
       ,@(unless (eq ks-phases :ALL)
	   `((setf *ks-phases* (union ,(assure-list ks-phases) *ks-phases*))))
       ,@(unless (eq ksar-phases :ALL)
	   `((setf *ksar-phases* (union ,(assure-list ksar-phases) *ksar-phases*))))
       
       ;; build the calls to DEFINE-UNIT.
       ,.(build-ks-define-unit name-and-options ks-event-classes slots dimensional-indexes
			       links path-indexes paths documentation control-type)
       ,.(unless ksar-defined
	   (build-ksar-define-unit ksar-unit-type ksar-event-classes ksar-print-function
				   context-slots :control-ksar))

       ,.(when po-unit-type
	   (build-po-define-unit PO-unit-type PO-event-classes PO-control-type))

       ;; update the list of calls to MAKE; if the call to <make-ks-name> is already
       ;; present in *make-kss*, then we replace it by this (updated) call. If it isn't
       ;; there, then we add it.
       ;; I should use a hash table for *make-kss* rather than a list, then this problem
       ;; would be more easily dealt with.
       (let ((make-call '(,make-ks-name
			  :control-type             ,control-type
			  :ks-type                  :control
			  :trigger-conditions       (list ,@(build-condition-list trigger-conditions))
			  :name                     ,(string ks-unit-type)
			  
			  :active-preconditions     ,(build-condition-vector preconditions)
			  :all-preconditions        ,(build-condition-vector preconditions)
			  :dynamic-preconditions    ,(build-dyn-condition-vector preconditions)
			  :precondition-vector-size ,(length preconditions)
			  
			  :active-obv-conditions    ,(build-condition-vector obviation-conditions)
			  :all-obv-conditions       ,(build-condition-vector obviation-conditions)
			  :dynamic-obv-conditions   ,(build-dyn-condition-vector obviation-conditions)
			  :obviation-vector-size    ,(length obviation-conditions)
			  
			  :context-slots            ',context-slots
			  :action-function           ,action-function
			  :from-bb                  ,`(get-space-instances-from-path-structures ,from-bb)
			  :to-bb                    ,`(get-space-instances-from-path-structures ,to-bb)
			  :author                   ,author
			  :cost                     ,cost
			  :reliability              ,reliability
			  :ks-phases                ,(if (eq ks-phases :ALL)
							 `(list gbb::*ks-phases*)
							 `,(assure-list ks-phases))
			  :ksar-phases              ,(if (eq ksar-phases :ALL)
							 `(list gbb::*ksar-phases*)
							 `,(assure-list ksar-phases))
			  :ksar-unit-type          ',ksar-unit-type
			  :ksar-make-name          ',(form-symbol "MAKE-" ksar-unit-type))))
	 (if (find ',make-ks-name *make-kss* :key #'first)
	     (setf *make-kss*
		   (substitute-if
		     make-call
		     #'(lambda (make-ks-unit-type)
			 (eq make-ks-unit-type ',make-ks-name))
		     *make-KSs*
		     :key #'first))
	     (push make-call *make-kss*)))
       
       ;; Return the unit-type.
       ',ks-unit-type))))

;;; -----------------------------------------------------------------

(defmacro define-gbb1-domain-KS (name-and-options &body args)
  `(define-gbb1-ks ,name-and-options ,@args))


;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
