;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:USER; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-SYSTEM.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Wednesday, February 8, 1989  14:03:54 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 308) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (0.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                   GBB1 System Definition
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  Package and system definitions for GBB1 and examples.
;;;
;;;  03-08-87 File Created.  (Johnson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

#+SYMBOLICS
(in-package "CL-USER")
#-SYMBOLICS
(in-package "USER")

(use-package '(lisp))

;;; --------------------------------------------------------------------------

(unless (find-package "GBB1")
  (make-package "GBB1"
    :use '(lisp umass-extended-lisp gbb)
    :nicknames '("GBB-BB1-Style-Control-Shell")))

;;; --------------------------------------------------------------------------
;;;   Import and Export symbols
;;; --------------------------------------------------------------------------

(import '(gbb::assure-list
	  gbb::first-if-list
	  gbb::with-keywords-bound
	  gbb::form-symbol
	  gbb::make-keyword
	  gbb::get-space-instance-from-path-structure
	  gbb::get-space-instances-from-path-structures
	  gbb::get-path-structure-from-space-instance
	  gbb::get-space-name-from-path-structure
	  gbb::empty-space-p
	  gbb::space-occupied-p
	  gbb::insert-unit-on-space
	  gbb::delete-unit-from-space
	  )
	(find-package "GBB1"))

;;; --------------------------------------------------------------------------
;;;  System Definitions
;;; --------------------------------------------------------------------------

(defparameter *gbb1-source-directory*
              (gbb-subdirectory "gbb1")
  "Directory where the GBB1 source files will be stored.")

(defparameter *gbb1-es-binary-directory*
        (gbb-subdirectory "gbb1" "es")
  "Directory where the GBB1 compiled files for the ES shell will be stored.")

(defparameter *gbb1-ks-binary-directory*
        (gbb-subdirectory "gbb1" "ks")
  "Directory where the GBB1 compiled files for the KS shell will be stored.")

;;; --------------------------------------------------------------------------

#+TI
;; `Old' style Defsystem
(defsystem GBB1-ES
  (:name "GBB1 Execution Shell")
  (:pathname-default #.*gbb1-source-directory*)
  (:default-output-directory #.*gbb1-es-binary-directory*)
  (:package "GBB1")

  (:module exports     ("exports"))
  (:module gbb1-vars   ("gbb1-vars"))
  (:module gbb1-debug  ("gbb1-debug"))
  (:module gbb-defs-1  ("gbb1-gbb"))
  (:module gbb-defs-2  ("es-gbb"))
  (:module ks-defs     ("gbb1-ks-utils" "gbb1-ks" "es-ks"))
  (:module rest        ("gbb1-utils" "gbb1-funs" "es-funs"))
  
  (:compile-load exports)
  (:compile-load gbb1-vars   (:fasload exports))
  (:compile-load gbb1-debug  (:fasload exports gbb1-vars))
  (:compile-load gbb-defs-1  (:fasload exports gbb1-vars gbb1-debug))
  (:compile-load gbb-defs-2  (:fasload exports gbb1-vars gbb1-debug gbb-defs-1))
  (:compile-load ks-defs     (:fasload exports gbb1-vars gbb1-debug gbb-defs-1
				       gbb-defs-2))
  (:compile-load rest        (:fasload exports gbb1-vars gbb1-debug gbb-defs-1
				       gbb-defs-2 ks-defs)))

(defparameter *gbb1-es-files*
    '("exports"      "gbb1-vars"      "gbb1-debug"
      "gbb1-gbb"     "es-gbb"         "gbb1-ks-utils"
      "gbb1-ks"      "es-ks"          "gbb1-utils"
      "gbb1-funs"    "es-funs")
  "Files in the GBB1 Execution Shell.")
      
;;; --------------------------------------------------------------------------

#+TI
(defsystem GBB1-KS
  (:name "GBB1 KS Shell")
  (:pathname-default #.*gbb1-source-directory*)
  (:default-output-directory #.*gbb1-ks-binary-directory*)
  (:package "GBB1")

  (:module exports     ("exports"))
  (:module gbb1-vars   ("gbb1-vars"))
  (:module gbb1-debug  ("gbb1-debug"))
  (:module gbb-defs-1  ("gbb1-gbb"))
  (:module gbb-defs-2  ("kss-gbb"))
  (:module ks-defs     ("gbb1-ks-utils" "gbb1-ks" "es-ks" "kss-ks"))
  (:module rest        ("gbb1-utils" "gbb1-funs" "kss-funs"))
  
  (:compile-load exports)
  (:compile-load gbb1-vars   (:fasload exports))
  (:compile-load gbb1-debug  (:fasload exports gbb1-vars))
  (:compile-load gbb-defs-1  (:fasload exports gbb1-vars gbb1-debug))
  (:compile-load gbb-defs-2  (:fasload exports gbb1-vars gbb1-debug gbb-defs-1))
  (:compile-load ks-defs     (:fasload exports gbb1-vars gbb1-debug gbb-defs-1
				       gbb-defs-2))
  (:compile-load rest        (:fasload exports gbb1-vars gbb1-debug gbb-defs-1
				       gbb-defs-2 ks-defs)))

(defparameter *gbb1-ks-files*
    '("exports"     "gbb1-vars"   "gbb1-debug"
      "gbb1-gbb"    "kss-gbb"     "gbb1-ks-utils"
      "gbb1-ks"     "es-ks"       "kss-ks"
      "gbb1-utils"  "gbb1-funs"   "kss-funs")
  "Files in the GBB1 KS Shell.")
      
;;; --------------------------------------------------------------------------
;;;   Example applications
;;; --------------------------------------------------------------------------

(unless (find-package "TSP")
  (make-package "TSP"
    :use '(lisp umass-extended-lisp gbb1)))

#+TI
(defsystem TSP
  (:name "Traveling Salesman Problem")
  (:pathname-default #.*gbb1-source-directory*)
  (:package "TSP")
  (:module prescription ("prescription-ks") :package "GBB1")
  (:module tsp          ("tsp"))
  (:compile-load prescription)
  (:compile-load tsp         (:fasload prescription)))

(defparameter *tsp-files*
    '("prescription-ks" "tsp")
  "Files in the Traveling Salesman example.")
      
;;;; --------------------------------------------------------------------------
;;;;   Simple Loading Functions
;;;; --------------------------------------------------------------------------

;;; The variables *source-file-type* and *compiled-file-type* are defined
;;; in gbb-system.

(defun LOAD-GBB1 (&optional (shell :ks))

  "Load GBB1.  The argument, SHELL, should be either :KS or :ES
   indicating either the KS shell or the Execution shell.

   If any compiled files exist this function will load them; otherwise
   it will load the source files."
 
  (let ((input-dir (pathname *gbb1-source-directory*))
        (output-dir (pathname (ecase shell
                                (:es *gbb1-es-binary-directory*)
                                (:ks *gbb1-ks-binary-directory*))))
        (files (ecase shell
                 (:es *gbb1-es-files*)
                 (:ks *gbb1-ks-files*))))

    (flet ((load-file (file-name)
	     (let ((source-file (make-pathname :name file-name
					       :type *source-file-type*
					       :defaults input-dir))
		   (compiled-file (make-pathname :name file-name
						 :type *compiled-file-type*
						 :defaults output-dir)))
	       (load (if (probe-file compiled-file)
			 compiled-file
			 source-file)))))
      (mapc #'load-file files))))


(defun COMPILE-GBB1 (&optional (shell :ks) recompile)

  "Compile and load GBB1.  The argument, SHELL, should be either :KS or
   :ES indicating either the KS shell or the Execution shell.

   If a compiled file already exists it will be loaded.  If the optional
   argument RECOMPILE is true then all the files will be compiled
   regardless of whether a compiled file exists."

  (let ((input-dir (pathname *gbb1-source-directory*))
        (output-dir (pathname (ecase shell
                                (:es *gbb1-es-binary-directory*)
                                (:ks *gbb1-ks-binary-directory*))))
        (files (ecase shell
                 (:es *gbb1-es-files*)
                 (:ks *gbb1-ks-files*))))

    (flet ((compile-and-load (file-name)
	     (let ((source-file (make-pathname :name file-name
					       :type *source-file-type*
					       :defaults input-dir))
		   (compiled-file (make-pathname :name file-name
						 :type *compiled-file-type*
						 :defaults output-dir)))
	       (when (or recompile (not (probe-file compiled-file)))
		 (compile-file source-file :output-file compiled-file))
	       (load compiled-file))))

      (mapc #'compile-and-load files))))


;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
