;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]GBB1-KS-UTILS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Friday, September 16, 1988  10:24:19 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 Utilities for KS definition.
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  05-12-87 File created.  (Johnson)
;;;  09-16-88 Added :addition-to-space-events and :removal-from-space-events
;;;           (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;; -----------------------------------------------------------------
;;;
;;;  KS Definition Helper Functions
;;;
;;; -----------------------------------------------------------------

(defun BUILD-KS-DEFINE-UNIT (name-and-options ks-event-classes slots
			     dimensional-indexes
			     links path-indexes paths documentation
			     &optional (control-type :KS))

  "BUILD-KS-DEFINE-UNIT name-and-options ks-event-classes slots
                        dimensional-indexes 
			links path-indexes paths documentation
                        &optional (control-type :domain)

   Return the call to define-unit for this KS."

  `((define-unit
      ;; add event class and included unit to name-and-options 
      ,(update-name-and-options name-and-options ks-event-classes control-type)
      ,documentation
      ,@(if links
	    `(:links ,links))
      ,@(if slots
	    `(:slots ,slots))
      ,@(if dimensional-indexes
	    `(:dimensional-indexes ,dimensional-indexes))
      ,@(if path-indexes
	    `(:path-indexes ,path-indexes))
      ,@(if paths
	    `(:paths ,(append paths `((t ('gbb1 'kb 'kss)))))))))
	    

;;; ----------------------------------------------------------------------

(defun BUILD-KSAR-DEFINE-UNIT (ksar-unit-type ksar-event-classes ksar-print-function context-slots
			       &optional (ksar-type :KSAR))

  "BUILD-KSAR-DEFINE-UNIT ksar-unit-type ksar-event-classes ksar-print-function context-slots
                          &optional (ksar-type :KSAR)

   Returns a call to define-unit for this KSAR.
   This function is called for KSARs implicitly defined by DEFINE-GBB1-KS."

  `((define-unit
     ,(update-name-and-options `(,ksar-unit-type) ksar-event-classes ksar-type ksar-print-function)
      ,@(if context-slots
	  `(:slots ,(mapcar #'list (first context-slots)))))))

;;; ----------------------------------------------------------------------

(defun BUILD-CUSTOM-KSAR-DEFINE-UNIT (name-and-options ksar-event-classes
				      slots dimensional-indexes
				      links path-indexes paths documentation)

  "BUILD-CUSTOM-KSAR-DEFINE-UNIT name-and-options ksar-event-classes
                                 slots dimensional-indexes
			         links path-indexes paths documentation

   This returns a call to define-unit for this ksar.
   This function is called for KSARs defined using DEFINE-GBB1-KSAR."

  `((define-unit
      ,(update-name-and-options name-and-options ksar-event-classes :KSAR)
      ,documentation
      :links ,links
      :slots ,slots
      :dimensional-indexes ,dimensional-indexes
      :path-indexes ,path-indexes
      :paths ,paths)))

;;; ----------------------------------------------------------------------

(defun BUILD-PO-DEFINE-UNIT (po-unit-type po-event-classes po-control-type)

  "BUILD-PO-DEFINE-UNIT po-unit-type po-event-classes po-control-type

   Returns a call to define-unit for this control plan-object.
   This function is called for POs implicitly defined by DEFINE-GBB1-KS."
  
  `((define-unit
     ,(update-name-and-options `(,po-unit-type) po-event-classes po-control-type))))
      
;;; -----------------------------------------------------------------
;;;
;;;  Helper functions for the BUILD functions.
;;;
;;; -----------------------------------------------------------------

(defun UPDATE-NAME-AND-OPTIONS (name-and-options event-classes gbb1-object &optional ksar-print-function)

  "UPDATE-NAME-AND-OPTIONS name-and-options event-classes gbb1-object

   Returns a new list consisting of the passed NAME-AND-OPTIONS list,
   augmented with the event handlers for the stated EVENT-CLASSES, as well as
   including the basic-ks/ksar unit if we've been passed a KS or a KSAR. 
   
   The value of GBB1-OBJECT determines what kind of unit is included into 
   the definition."

  (let* ((new-options (when (listp name-and-options)
			(cdr name-and-options)))
	 (include-option (find :include new-options :key #'first-if-list)))

    (when ksar-print-function
      (push `(:print-function ,ksar-print-function) new-options))
    
    (unless (or include-option (eq gbb1-object :gbb-unit))
      (case gbb1-object
	 (:ks           (push `(:include basic-ks) new-options))
	 (:ksar         (push `(:include basic-ksar) new-options))
	 (:focus        (push `(:include basic-focus-ks) new-options))
	 (:focus-po     (push `(:include basic-focus-po) new-options))
	 (:strategy     (push `(:include basic-strategy-ks) new-options))
	 (:strategy-po  (push `(:include basic-strategy-po) new-options))
	 (:heuristic    (push `(:include basic-heuristic-ks) new-options))
	 (:heuristic-po (push `(:include basic-heuristic-po) new-options))
	 (:meta         (push `(:include basic-control-ks) new-options))
	 (:control-ksar (push `(:include basic-control-ksar) new-options))))

    (dolist (event-class event-classes)
      (let* ((event-option (find event-class new-options :key #'first-if-list))
	     (event-handler (gbb1-event-handler event-class)))

	(if event-option
	    (setf (cdr event-option) `(,event-handler ,@(assure-list (cdr event-option))))
	    (setf new-options `(,@new-options (,event-class ,event-handler))))))
    
    `(,(first-if-list name-and-options) ,@new-options)))

;;; ----------------------------------------------------------------------

(defun GBB1-EVENT-HANDLER (event-class)

  "GBB1-EVENT-HANDLER event-class

   Returns the function to run for the passed event class."

  (case event-class
     (:creation-events            'gbb1-creation)
     (:deletion-events            'gbb1-deletion)
     (:addition-to-space-events   'gbb1-addition-to-space)
     (:removal-from-space-events  'gbb1-removal-from-space)
     (:slot-access-events         'gbb1-slot-access)
     (:slot-update-events         'gbb1-slot-update)
     (:link-access-events         'gbb1-link-access)
     (:link-update-events         'gbb1-link-update)
     (:unlink-events              'gbb1-unlink)
     (:slot-initialization-events 'gbb1-slot-initialization)
     (:link-initialization-events 'gbb1-link-initialization)
     (otherwise
      (error "~s is not an implemented event class" event-class))))

;;; -----------------------------------------------------------------
;;;
;;;   Condition vector/list construction functions
;;;
;;; -----------------------------------------------------------------

(defun BUILD-CONDITION-VECTOR (conditions)

  "BUILD-CONDITION-VECTOR conditions condition-vector-name 

   Returns the condition vector (stripping out the :DYNAMIC/:STABLE qualifiers,
   and wrapping lambdas and functions when necessary."

  `(vector ,@(mapcar #'(lambda (func)
			 ;; filter out the :STABLE or :DYNAMIC prefix
			 (when (and (listp func) (member (first func) '(:STABLE :DYNAMIC)))
			   (setf func (second func)))
			 `(function
			    ,(if (and (listp func) (eq (first func) 'lambda))
				 func
				 `(lambda () ,func))))
		     conditions)))

;;; ----------------------------------------------------------------------

(defun BUILD-DYN-CONDITION-VECTOR (conditions)

  "BUILD-DYN-CONDITION-VECTOR conditions

   Returns a vector consisting of NIL and non-NIL values, depending upon
   whether the corresponding condition is :STABLE or :DYNAMIC."

  `(vector ,@(mapcar #'(lambda (func)
			 ;; return NIL if stable, non-NIL otherwise
			 (and (listp func) (not (eq (first func) :stable))))
		     conditions)))

;;; ----------------------------------------------------------------------

(defun BUILD-CONDITION-LIST (conditions)

  "BUILD-CONDITION-LIST conditions

   Returns a list of conditions, wrapping functions and lambdas when needed."

  (mapcar #'(lambda (func)
		 `(function
		    ,(if (and (listp func) (eq (first func) 'lambda))
			 func
 			 `(lambda () ,func))))
	     conditions))

;;; -----------------------------------------------------------------
;;;
;;;  Miscellaneous Utilities
;;;
;;; -----------------------------------------------------------------

(defun CHECK-KS-KEYWORD-SYNTAX (&rest args)

  "CHECK-KS-KEYWORD-SYNTAX &rest args

   This function checks the syntax of the arguments passed to 
   the KS definition functions.  (Not Yet Implemented)"

  (declare (ignore args)))

;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
