;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB1; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL.GBB1]ES-FUNS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  15:12:20 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *           GBB1 Execution Shell: Function Definitions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Philip Johnson
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst, Massachusetts 01003.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights are reserved.
;;;
;;; Development of this code was partially supported by:
;;;    Donations from Texas Instruments, Inc.;
;;;    NSF CER grant DCR-8500332;
;;;    ONR URI contract N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  03-05-87 File Created.  (Johnson)
;;;  05-19-87 Conversion to GBB1 Execution Shell Version 1.0  (Johnson)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *


(in-package "GBB1")

(use-package '(lisp umass-extended-lisp gbb))

;;; -----------------------------------------------------------------
;;;
;;;     Execution Shell Initialization
;;;
;;; -----------------------------------------------------------------

(defun RESET-GBB1 nil

  "RESET-GBB1 nil

   To be called before redefining a new GBB1 system."

  (reset-execution-shell))

;;; -----------------------------------------------------------------
;;;
;;;   Execution Shell Blackboard Definition
;;;
;;; -----------------------------------------------------------------

(define-space KSs
  :units ((basic-ks :plus-subtypes))
  :dimensions ((ks-phase :enumerated (:default-phase))))

(define-unit-mapping (basic-ks) (KSs)
  :indexes (ks-phase)
  :index-structure ((ks-phase :groups)))

(define-space events
  :units (gbb1-event)
  :dimensions ((execution-cycle :ordered (-1 30))
	       (triggering-space :enumerated (nil))))

(define-unit-mapping (gbb1-event) (events)
  :indexes (execution-cycle triggering-space)
  :index-structure ((execution-cycle :subranges (:start :end (:width 1)))
                    (triggering-space :groups)))

(define-spaces (:triggered :obviated :executable :executed)
  :units ((basic-ksar :plus-subtypes))
  :dimensions ((ksar-phase :enumerated (:default-phase))))

(define-unit-mapping (basic-ksar) (:triggered :obviated :executable :executed)
  :indexes (ksar-phase)
  :index-structure ((ksar-phase :groups)))

(define-blackboard agendas (:triggered :executable :obviated :executed)
  "Holds the 4 agendas.")

(define-blackboard GBB1 (agendas KSs)
  "The top-level control shell blackboard structure of GBB1.")


(defun instantiate-gbb1-blackboards ()
  "Instantiate all the GBB1 KS Shell blackboards.
   Set path variables."

  (update-space-dimension 'KSs 'ks-phase *ks-phases*)
  (update-space-dimension '(:triggered :obviated :executable :executed)
			  'ksar-phase
			  *ksar-phases*)
  (instantiate-blackboard-database 'gbb1 :mode :append)

  (update-space-dimension 'events
			  'triggering-space
			  (get-triggering-space-labels))
  (update-space-dimension 'events
			  'execution-cycle
			  `(-1 ,*max-execution-cycles*))
  (instantiate-blackboard-database 'events :mode :append)

  (setf *exe-agenda-path* (make-paths :paths '(gbb1 agendas :executable))
        *tri-agenda-path* (make-paths :paths '(gbb1 agendas :triggered))
        *obv-agenda-path* (make-paths :paths '(gbb1 agendas :obviated))
        *exd-agenda-path* (make-paths :paths '(gbb1 agendas :executed))
        *eve-agenda-path* (make-paths :paths '(events))
        *KSs-agenda-path* (make-paths :paths '(gbb1 KSs)))

  ;; Make the KSs.  This has the side effect of also putting them on
  ;; the KS space.
  (setf *execution-cycle* 0)
  (mapc #'eval *make-KSs*)

  nil)


(defun gbb1-blackboards-instantiated-p ()
  "Returns true if the GBB1 KS Shell blackboards are instantiated."
  (member 'gbb1 gbb::*blackboard-database*
	  :test #'eq :key #'gbb::db-node.name))


;;; --------------------------------------------------------------------------
;;;				End of File
;;; --------------------------------------------------------------------------
