;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:USER; Base:10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.V-120.DISTRIBUTION]GBB-SYSTEM.LISP *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Last-Edit: Tuesday, January 23, 1990  15:49:50 *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 429) *-*
;;;; *-* Software: TI Common Lisp System 6.9 *-*
;;;; *-* Lisp: TI Common Lisp System 6.9  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                      GENERIC BLACKBOARD DEFSYSTEM
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  System definitions for GBB and UMass Extended Lisp.
;;;
;;;  01-08-86 File Created.  (Gallagher)
;;;  06-10-86 Modified for the Symbolics to load a mini extended-lisp.
;;;           (Johnson and Gallagher)
;;;  06-19-86 Load the compiler optimizers for some sequence functions at sites
;;;           other than UMass.  Also, changed the name of the package and the
;;;           system from "EXTENDED-LISP" to "UMASS-EXTENDED-LISP".
;;;           "EXTENDED-LISP" will be retained as a nickname for the package
;;;           for a short while to ease the transition.  (Gallagher)
;;;  09-08-86 Load in SAVE-BLACKBOARD functions.  (Johnson)
;;;  10-13-86 Load ACCESSORS.  (Gallagher)
;;;  10-24-86 Load LINKS.  (Gallagher)
;;;  12-16-86 Load PREAMBLE.  (Gallagher)
;;;  02-22-87 Load VARIABLES.  (Gallagher)
;;;  03-08-87 Added Defsystem for Symbolics Genera 7.0  (Gallagher)
;;;  01-27-88 Load REPORT.  (Gallagher)
;;;  09-15-88 Moved graphics files into GRAPHICS subdirectory.  (Cork)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

;; (provide '())

#+SYMBOLICS
(in-package "CL-USER")
#-SYMBOLICS
(in-package "USER")

(use-package '(lisp))

;; This isn't really the right place for this but ...
(provide "GBB")

(eval-when (compile load eval)

;;;; --------------------------------------------------------------------------
;;;;   File and Directory Variables
;;;; --------------------------------------------------------------------------

(defparameter *gbb-source-directory*
              (or
                #+TI         "vax: gbb.v-120.distribution;"
                #+SYMBOLICS  "vax: gbb;v-120;distribution;"
                #+VMS        "dis$disk:[gbb.v-120.distribution]"
                #+UNIX       "/anw/gallagher/gbb/"
                #+PICCL      "max:user1.dis.gbb;"
                #+:CORAL     "Internal:GBB:V-120:Distribution:"
                nil)
  "Directory where the GBB source and compiled files will be stored.")

(assert *gbb-source-directory*
        (*gbb-source-directory*)
        "*GBB-SOURCE-DIRECTORY* has no value.~@
         Please define it before proceeding.")

;;; --------------------------------------------------------------------

(defparameter *gbb-graphics-source-directory*
              (or
                #+TI         "vax: gbb.v-120.distribution.graphics;"
                #+SYMBOLICS  "vax: gbb;v-120;distribution;graphics;"
                nil)
  "Directory where the GBB graphics subsystem source and compiled files
will be stored.")

#+(or TI SYMBOLICS)
(assert *gbb-graphics-source-directory*
        (*gbb-graphics-source-directory*)
        "*GBB-GRAPHICS-SOURCE-DIRECTORY* has no value.~@
         Please define it before proceeding.")

;;; --------------------------------------------------------------------

(defparameter *gbb-directory-template*
              (or
                #+TI         "vax: gbb.v-120.distribution~{.~a~};"
                #+SYMBOLICS  "vax: gbb;v-120;distribution~{;~a~};"
                #+VMS        "dis$disk:[gbb.v-120.distribution~{.~a~}]"
                #+UNIX       "/anw/gallagher/gbb~{/~a~}/"
                #+PICCL      "max:user1.dis.gbb~{.~a~};"
                #+:CORAL     "Internal:GBB:V-120:Distribution~{:~a~}:"
                nil)
  "Format string used in constructing GBB subdirectories.")

(assert *gbb-directory-template*
        (*gbb-directory-template*)
        "*GBB-DIRECTORY-TEMPLATE* has no value.~@
         Please define it before proceeding.")

;;; --------------------------------------------------------------------

(defparameter *gbb-extensions-file*
              (or
                #+TI         "ti-extensions"
                #+SYMBOLICS  "symbolics-extensions"
                #+DEC        "dec-extensions"
                #+LUCID      "lucid-extensions"
                #+EXCL       "allegro-extensions"
                #+PICCL      "picl-extensions"
                #+:CORAL     "macl-extensions"
                "generic-extensions")
  "Implementation specific extensions required by GBB.")


;;; --------------------------------------------------------------------

(defparameter *source-file-type* "lisp"
  "File type for lisp source files.")

(defparameter *compiled-file-type*
              (or
                #+TI         "xld"
                #+(and SYMBOLICS 3600)  "bin"
                #+(and SYMBOLICS IMACH) "ibin"
                #+DEC        "fas"
                #+LUCID      "lbin"
                #+EXCL       "fasl"
                #+PICCL      "zoom"
                #+:CORAL     "fasl"
                nil)
  "File type for lisp compiled files.")

(assert *compiled-file-type*
        (*compiled-file-type*)
        "What is the file type for compiled lisp files?")


;;;; --------------------------------------------------------------------------
;;;;   File and Directory Functions
;;;; --------------------------------------------------------------------------

(defun GBB-SUBDIRECTORY (&rest subdirectories)

  "Return a pathname to the GBB subdirectory specified by SUBDIRECTORIES
   (i.e., The directory formed by appending the gbb root directory and
   the specified subdirectories)."

  (pathname (format nil *gbb-directory-template* subdirectories)))


(defun GBB-FILE (file &rest subdirectories)

  "Return a pathname to FILE in the GBB subdirectory specified by
   SUBDIRECTORIES.  The pathname will refer to the compiled file if
   one exists, otherwise it will refer to the source file."

  (let* ((directory (apply #'gbb-subdirectory subdirectories))
         (source-file (make-pathname :defaults directory
                                     :name file
                                     :type *source-file-type*))
         (compiled-file (make-pathname :defaults directory
                                     :name file
                                     :type *compiled-file-type*)))
    (if (probe-file compiled-file)
        compiled-file
        source-file)))

)  ;; End of Eval-when


;;;; --------------------------------------------------------------------------
;;;;   Common Lisp Extensions and Enhancements
;;;; --------------------------------------------------------------------------

;;; GBB requires some extensions to Common Lisp.  Some of these extensions
;;; are written in Common Lisp and so should work in any Common Lisp.
;;; These extensions are in the file "umass-extended-lisp".  Some of the
;;; necessary extensions are not written in Common Lisp -- they are
;;; specific to a particular implmentation.  By convention these
;;; extensions are in a file called "<lisp-name>-extensions" (e.g.,
;;; "dec-extensions").

#-UMASS   ;; The feature UMASS is true at U.Mass. where Extended Lisp is
          ;; loaded separately.

(progn

(unless (find-package "UMASS-EXTENDED-LISP")
  (make-package "UMASS-EXTENDED-LISP"
	        :use '(lisp)))

#+SYMBOLICS 
;; Genera 7.0 System Definition
(defsubsystem UMASS-EXTENDED-LISP
  (:pretty-name       "Mini Extended Lisp"
   :default-pathname  #.*gbb-source-directory*
   :default-package   UMASS-EXTENDED-LISP)
  (:serial "symbolics-extensions" "umass-extended-lisp"))


#+TI
;; `Old' style Defsystem
(defsystem UMASS-EXTENDED-LISP
  (:name "Mini Extended Lisp")
  (:pathname-default #.*gbb-source-directory*)
  (:package umass-extended-lisp)
  (:module extensions ("ti-extensions"))
  (:module user-functions ("umass-extended-lisp"))
  (:compile-load extensions)
  (:compile-load user-functions (:fasload extensions)))


;; List of file names for Lisps that don't have defsystem.
              
(defparameter *umass-extended-lisp-files*
              (list *gbb-extensions-file*
                    "umass-extended-lisp")
  "List of files that make up UMass Extended Lisp.  These files
   must be loaded before compiling or loading GBB.")

)  ;; End of Progn


;;;; --------------------------------------------------------------------------
;;;;   Core GBB
;;;; --------------------------------------------------------------------------

(unless (find-package "GBB")
  (make-package "GBB"
    :use '(lisp umass-extended-lisp)
    :nicknames '("GENERIC-BLACKBOARD")))


#+SYMBOLICS 
;; Genera 7.0 System Definition
(defsystem GBB
  (:pretty-name       "Generic Blackboard System"
   :default-pathname  #.*gbb-source-directory*
   :default-package   GBB
   :patchable         nil)
  #-UMASS
  (:module umass (umass-extended-lisp) (:type :system))
  (:serial
    #-UMASS umass
    (:parallel "preamble")
    (:parallel "structures" "macros" "variables")
    (:parallel "meter" "utilities" "accessors")
    (:parallel "space" "links")
    (:parallel "define-unit"
	       "index-structure"
	       "unit-mapping"
	       "find-unit"
	       "save-blackboard"
               "report")
    ))

#+TI
;; `Old' style Defsystem
(defsystem GBB
  (:name "Generic Blackboard System")
  (:pathname-default #.*gbb-source-directory*)
  (:package GBB)
  (:module first      ("preamble"))
  (:module macros     ("structures" "macros" "variables"))
  (:module utilities  ("meter" "utilities" "accessors"))
  (:module space-etc  ("space" "links"))
  (:module rest       ("define-unit"
		       "index-structure"
		       "unit-mapping"
		       "find-unit"
		       "save-blackboard"
                       "report"))
  (:compile-load first)
  (:compile-load macros     (:fasload first))
  (:compile-load utilities  (:fasload first macros))
  (:compile-load space-etc  (:fasload first macros utilities))
  (:compile-load rest       (:fasload first macros utilities space-etc)))


;; List of file names for Lisps that don't have defsystem.

(defparameter *gbb-files*
	'("preamble"
	  "structures"
	  "macros"
	  "variables"
	  "accessors"
          "meter"
	  "utilities"
	  "space"
	  "links"
	  "define-unit"
	  "index-structure"
	  "unit-mapping"
	  "find-unit"
	  "save-blackboard"
          "report")
  "List of files that make up GBB.")


;;; For Non-Explorer systems we have defined a simple DEFSYSTEM as part of
;;; UMass-Extended-Lisp. - Westy

#+(and UMASS (not TI))
(defsystem GBB
  :source-directory #.*gbb-source-directory*
  :files #.*gbb-files*)


;;;; --------------------------------------------------------------------------
;;;;   GBB Graphics Display System
;;;; --------------------------------------------------------------------------

(unless (find-package "GBB-GRAPHICS")
  #+SYMBOLICS
  (make-package "GBB-GRAPHICS" :use '(scl gbb umass-extended-lisp)
                               :nicknames '("GG"))
  #+TI
  (make-package "GBB-GRAPHICS" :use '(lisp ticl gbb umass-extended-lisp)
                               :nicknames '("GG")))

#+SYMBOLICS
(progn
  ;; Add W as a nickname for TV.
  (in-package "TV" :nicknames '("W"))
  (in-package "CL-USER"))

;; This will allow old style defmethods without any warnings.
;; #+SYMBOLICS (setq flavor::*defmethod-compatibility* t)

#+SYMBOLICS
(defsystem GBB-GRAPHICS
  (:pretty-name       "GBB Graphics Display"
   :default-pathname  #.*gbb-graphics-source-directory*
   :default-package   GBB
   :patchable         nil)
  (:serial
    "graphics-support"
    "window-support"
    ;; Note, no symbolics window patches (yet).
    "configurations"
    "symbolics-graphics"))

#+TI
(defsystem GBB-GRAPHICS
  (:name "GBB Graphics Display")
  (:pathname-default #.*gbb-graphics-source-directory*)
  (:package GBB)
  (:module gbb-support     ("graphics-support"))
  (:module window-support  ("window-support" "window-patches") :package w)
  (:module configurations  ("configurations"))
  (:module main            ("explorer-graphics"))
  (:compile-load gbb-support)
  (:compile-load window-support)
  (:compile-load configurations)
  (:compile-load main      (:fasload gbb-support
				     window-support
				     configurations)))

(defparameter *gbb-graphics-files*
    '("graphics-support"
      "window-support"
      #+TI "window-patches"
      "configurations"
      #+TI        "explorer-graphics"
      #+SYMBOLICS "symbolics-graphics")
  "List of files that make up GBB Graphics.")


;;;; --------------------------------------------------------------------------
;;;;   Simple Loading Functions
;;;; --------------------------------------------------------------------------

(defun LOAD-GBB ()

  "Load GBB.  If any compiled files exist this will load them;
   otherwise it will load the source files."

  (let ((defaults (pathname *gbb-source-directory*)))
    (flet ((load-file (file) (gbb_load file defaults)))
      #-UMASS
      (mapc #'load-file *umass-extended-lisp-files*)
      (mapc #'load-file *gbb-files*))
    nil))

(defun COMPILE-GBB (&optional recompile)

  "Compile and load GBB.  If a compiled file already exists it
   will be loaded.  If the optional argument RECOMPILE is true
   then all the files will be compiled regardless of whether a
   compiled file exists."

  (let ((defaults (pathname *gbb-source-directory*)))
    (flet ((load-file (file) (gbb_compile-and-load file defaults recompile)))
      #-UMASS
      (mapc #'load-file *umass-extended-lisp-files*)
      (mapc #'load-file *gbb-files*))
    nil))

(defun LOAD-SIMPLE-SHELL ()
  
  "Load the Simple Shell control shell. If any compiled files exist
   this will load them; otherwise it will load the source files."

  (load (gbb-file "queue"))
  (load (gbb-file "simple-shell" "simple-shell")))

(defun LOAD-GBB-GRAPHICS ()

  "Load GBB Graphics.  If any compiled files exist this will
   load them; otherwise it will load the source files."

  (let ((defaults (pathname (gbb-subdirectory "graphics"))))
    (flet ((load-file (file) (gbb_load file defaults)))
      (mapc #'load-file *gbb-graphics-files*))
    nil))

(defun COMPILE-GBB-GRAPHICS (&optional recompile)

  "Compile and load GBB Graphics.  If a compiled file already exists
   it will be loaded.  If the optional argument RECOMPILE is true
   then all the files will be compiled regardless of whether a
   compiled file exists."

  (let ((defaults (pathname (gbb-subdirectory "graphics"))))
    (flet ((load-file (file) (gbb_compile-and-load file defaults recompile)))
      (mapc #'load-file *gbb-graphics-files*))
    nil))


(defun GBB_COMPILE-AND-LOAD (file-name
                             &optional
                             (defaults *default-pathname-defaults*)
                             recompile)

  "Load a single compiled file.  If no compiled file exists or if
   RECOMPILE is true then the lisp source file will be compiled.

   [Note: To compile GBB, use the function COMPILE-GBB.]"

  (let ((source-file (make-pathname :name file-name
                                    :type *source-file-type*
                                    :defaults defaults))
        (compiled-file (make-pathname :name file-name
                                      :type *compiled-file-type*
                                      :defaults defaults)))
    (when (or recompile (not (probe-file compiled-file)))
      (format t "~&;;; Compiling ~a~%" (namestring source-file))
      (compile-file source-file :output-file compiled-file))
    (format t "~&;;; Loading ~a~%" (namestring compiled-file))
    (load compiled-file :verbose nil)))

(defun GBB_LOAD (file-name &optional (defaults *default-pathname-defaults*))

  "Load a single file.  If a compiled file exists it will be loaded
   otherwise the lisp source file will be loaded.

   [Note: To load GBB, use the function LOAD-GBB.]"

  (let* ((source-file (make-pathname :name file-name
                                     :type *source-file-type*
                                     :defaults defaults))
         (compiled-file (make-pathname :name file-name
                                       :type *compiled-file-type*
                                       :defaults defaults))
         (selected-file (if (probe-file compiled-file)
                            compiled-file
                            source-file)))
    (format t "~&;;; Loading ~a~%" (namestring selected-file))
    (load selected-file :verbose nil)))


;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
