;;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: USER; Base: 10 -*-
;;;; *-* File: VAX6:DIS$DISK:[GBB.UMASS-EXTENDED-LISP]EXTENSIONS-TEST.LISP *-*
;;;; *-* Last-Edit: Wednesday, September 27, 1989  14:51:16 *-*
;;;; *-* Edited-By: Gallagher *-*
;;;; *-* Machine: Gilgamesh (Explorer II, Microcode 429) *-*
;;;; *-* Software: TI Common Lisp System 6.9 *-*
;;;; *-* Lisp: TI Common Lisp System 6.9  *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                        Extensions Test File
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1989 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;; This file attempts to test the following extension functions (see the
;;; documentation with each function definitions for arguments and purpose).
;;; If no error messages are printed then the test has succeeded.
;;;
;;;     defstruct-p
;;;     defstruct-conc-name
;;;     structure-slot-names
;;;     structure-slot-p
;;;     get-structure-slot  (and corresponding setf method)
;;;     %pointer
;;;
;;; The following extensions are not tested.
;;; 
;;;     deftransform
;;;     delete-transform
;;;
;;;  01-05-89 File Created.  (Kevin Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'user
	    :use '(umass-extended-lisp lisp))

(use-package '(umass-extended-lisp lisp))

(proclaim '(optimize (speed 3) (safety 1)))


;; Simple test macro.  Reports an error if form returns nil.

(eval-when (compile load eval)
  (defmacro test (form msg &rest args)
    "If FORM returns nil then print MSG.  MSG is a format string.
     ARGS are additional arguments to format.  If FORM returns
     true then don't do anything."
    `(unless ,form
       (format *error-output* "~%>>> ~s~%" ',form)
       (format *error-output* ,msg ,@args)
       (terpri *error-output*))))

;; Define defstructs to test.

(defstruct (t1 (:conc-name "T1."))
  (slot1 1)
  slot2)

(defstruct (t2 (:include t1))
  slot3)

(defstruct (t3 (:conc-name t3->))
  (slot1 nil))

;; Test defstruct extensions capabilities.

(test (defstruct-p 't1)
      "DEFSTRUCT-P doesn't work.")

(test (defstruct-p 't2)
      "DEFSTRUCT-P doesn't work on including units.")

(test (not (defstruct-p 'cons))
      "DEFSTRUCT-P returns true on non-structure types.")

(test (string= (defstruct-conc-name 't1) "T1.")
      "DEFSTRUCT-CONC-NAME doesn't work.")

(test (string= (defstruct-conc-name 't2) "T2-")
      "DEFSTRUCT-CONC-NAME doesn't work.")

(test (string= (defstruct-conc-name 't3) "T3->")
      "DEFSTRUCT-CONC-NAME doesn't work.")

(defun same-name-list (l1 l2)
  (or (set-difference l1 l2 :test #'string=)
      (set-difference l1 l2 :test #'string=)))

(test (not (same-name-list (structure-slot-names 't1)
                           '(slot1 slot2)))
      "STRUCTURE-SLOT-NAMES doesn't work.")

(test (not (same-name-list (structure-slot-names 't2)
                           '(slot1 slot2 slot3)))
      "STRUCTURE-SLOT-NAMES doesn't work on including units.")

(test (and (structure-slot-p 't1 'slot1)
           (structure-slot-p 't1 'slot2)
           ;; Check package problems...
           (structure-slot-p 't1 :slot1)
           (structure-slot-p 't1 :slot2))
      "STRUCTURE-SLOT-P doesn't work.")

(test (and (structure-slot-p 't2 'slot1)
           (structure-slot-p 't2 'slot2)
           (structure-slot-p 't2 'slot3))
      "STRUCTURE-SLOT-P doesn't work on including units.")

(test (not (structure-slot-p 't1 'xyxxy))
      "STRUCTURE-SLOT-P returns true on non-slots.")

(test (not (structure-slot-p 't2 'xyxxy))
      "STRUCTURE-SLOT-P returns true on non-slots.")

(defvar x1)
(defvar x2)
(setf x1 (make-t1 :slot1 'one :slot2 'two))
(setf x2 (make-t2 :slot1 'one :slot3 'three))

(test (and (eq (get-structure-slot x1 'slot1) 'one)
           (eq (get-structure-slot x1 'slot2) 'two)
           ;; Check package problems...
           (eq (get-structure-slot x1 :slot1) 'one)
           (eq (get-structure-slot x1 :slot2) 'two))
      "GET-STRUCTURE-SLOT doesn't work.")

(test (and (eq (get-structure-slot x2 'slot1) 'one)
           (eq (get-structure-slot x2 'slot3) 'three))
      "GET-STRUCTURE-SLOT doesn't work on including units.")

(setf (get-structure-slot x1 'slot1) '(1 1 1))
(setf (get-structure-slot x2 'slot1) '(1 1 1))
(setf (get-structure-slot x2 'slot3) '(3 3 3))

(test (and (equal (get-structure-slot x1 'slot1) '(1 1 1))
           (equal (get-structure-slot x2 'slot1) '(1 1 1))
           (equal (get-structure-slot x2 'slot3) '(3 3 3)))
      "(SETF GET-STRUCTURE-SLOT) doesn't work.")

(setf (get-structure-slot x1 :slot1) '(1 1))
(setf (get-structure-slot x2 :slot1) '(1 1))
(setf (get-structure-slot x2 :slot3) '(3 3))

(test (and (equal (get-structure-slot x1 :slot1) '(1 1))
           (equal (get-structure-slot x2 :slot1) '(1 1))
           (equal (get-structure-slot x2 :slot3) '(3 3)))
      "(SETF GET-STRUCTURE-SLOT) doesn't work (slot name package problem).")

;; Other extensions.

(test (numberp (%pointer x1))
      "%POINTER returns a non-number.")

;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
