;;;; -*- Mode:Lisp; Syntax: Common-Lisp; Package:UMASS-EXTENDED-LISP; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]DEC-EXTENSIONS.LISP *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:31:10 *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *            VAX Lisp Implementation Dependent Extensions
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher/Philip Johnson/Daniel Corkill/Kelly Murray
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains extensions to Common Lisp needed by GBB.  The functions
;;;  in this file depend on the details of the VAXLisp implementation.  The
;;;  file Umass-Extended-Lisp.Lisp contains extensions to Common Lisp that are
;;;  written in Common Lisp.
;;;
;;;  03-25-87 File Created.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'umass-extended-lisp
	    :use '(lisp))

(export '(defstruct-p
	  defstruct-conc-name
	  structure-slot-names
	  structure-slot-p
	  get-structure-slot
	  delete-transform
	  %pointer))

(import '(system::%sp-structset
	  system::%sp-structref
	  system::defstruct-description-slot-data
	  system::defstruct-description
	  system::compiler-defstruct-description
	  system::clc-mumble
	  system::clc-warning
	  system::%pass%
	  system::deftransform
	  system::traced-definition
	  system::clc-transforms))

(export '(deftransform
	  %pass%))


(use-package '(lisp))

(proclaim '(optimize (speed 3) (safety 1)))

;;; The functions that must be defined in this file are:
;;;
;;;     defstruct-p
;;;     get-defstruct-description
;;;     defstruct-conc-name
;;;     structure-slot-names
;;;     structure-slot-p
;;;     get-structure-slot  (and corresponding setf method)
;;;     deftransform
;;;     %pointer
;;;
;;; See the documentation with each function for arguments and purpose.


;;;; ==========================================================================
;;;;   Encapsulations
;;;; ==========================================================================

;;; All this encapsulation code is so that we can get the name of a defstruct
;;; conc-name in Vaxlisp (which doesn't save the conc-name in the defstruct
;;; description).


(defmacro DEFINE-ENCAPSULATION ((function type) &BODY body)

  "DEFINE-ENCAPSULATION (function type) &BODY body

Encapsulates function for type. In the body, the symbols
argument-list and basic-definition are lexically bound."

  (let ((fname (make-symbol
                   (concatenate 'simple-string
                                (symbol-name function) "-"
                                (symbol-name type)
                                "-ENCAPSULATION"))))
    `(progn
       ;; Make this a function so it will get compiled.
       (defun ,fname (BASIC-DEFINITION ARGUMENT-LIST)
         ,@body)
       (eval-when (compile)
         (format t "~%~a compiled." ',fname))
       ;; Now when this is loaded in, the form that will be
       ;; the encapsulation is a call to the compiled function
       ;; above, passing in the arguments that get bound
       ;; at run time.
       (encapsulate ',function ',type
                    '(,fname BASIC-DEFINITION ARGUMENT-LIST)))))


(defun ENCAPSULATE (symbol type body)

  "ENCAPSULATE symbol type  body

Saves the current definition of symbol, and replaces it with a new
function which returns the result of evaluating the body form.
Type is used as an identifier to name the encapsulation.  If the symbol
already has an encapsulation of type, it is replaced.

When the new function is called, several LOCAL variables will be bound
while the body is evaled:

   argument-list:     A list of the arguments which the function
                      is currently being applied to.

   basic-definition:  A function object."

 (let ((def (get symbol 'traced-definition))
       (trace-def (symbol-function symbol)))
   ;; If the function is being traced, then we put back it's normal
   ;; definition for the encapsulation, and then restore the traced
   ;; one after we've don the encapusulation
   (when def (setf (symbol-function symbol) def))

  (let  ((macrop (macro-function symbol))
         (specialp (special-form-p symbol))
         (funp (functionp symbol))
         (redo nil)
         ;; these are used when adding a new encapsulation type.
         (new-encaps (make-symbol (symbol-name symbol)))
         (old-encaps (get symbol 'encapsulated-definition))
         (old-encaps-type (get symbol 'encapsulation-type)))

    ;; find if an existing encap. of type is defined
    (do ((sym symbol (get sym 'encapsulated-definition)))
	((or (null sym)
	     (eq (get sym 'encapsulation-type) type))
	 (unless (null sym)
	   ;; indicate were redoing an existing encapsulation
	   (setq redo t)
	   ;; Set the current "top level" thing we're encapsulating
	   ;; to be the function that has an encapsulation of type.
	   (setq symbol sym)
	   ;; make the new one encap to be the previous existing one.
	   (setq new-encaps (get sym 'encapsulated-definition)))))

    ;; Compute the new function from the body and make it the def.

    (cond
       (macrop
         ;; Make the new-encaps symbol hold the old previous definition
         ;; unless we already saved it previously.
         (unless redo
           (setf (macro-function new-encaps) (macro-function symbol)))
         ;; The symbol nows holds the new encapsulated definition.         
         (setf (macro-function symbol)
               `(lambda (ARGUMENT-LIST &optional ignore)
                  ; Must put these in the current package.
                  (let ((BASIC-DEFINITION
                          (macro-function ',new-encaps))
                        (ARGUMENT-LIST
                          (list ARGUMENT-LIST)))
                    ,body))))
       (specialp (error "Can't Encapsulate Special Forms - ~a" symbol))      
       (funp
         ;; Make the NewEncaps symbol hold the old previous definition
         (unless redo
           (setf (symbol-function new-encaps) (symbol-function symbol)))
         ;; The symbol nows holds the new encapsulated definition.
         (setf (symbol-function symbol)
               `(lambda (&REST ARGUMENT-LIST)
                  (let ((BASIC-DEFINITION    
                          (symbol-function ',new-encaps)))
                    ,body))))
       (t 
         (error "~S is not a valid function." symbol)))

    ;; Transfer the existing encapsulation to new-encaps ::
    
    (unless redo
      (when old-encaps
        (setf (get new-encaps 'encapsulated-definition)
              old-encaps))
      (when old-encaps-type
        (setf (get new-encaps 'encapsulation-type)
              old-encaps-type))
      (setf (get symbol 'encapsulated-definition) new-encaps)
      (setf (get symbol 'encapsulation-type) type))

    (when def
      ;; put the encaps def back on the traced property.
      (setf (get symbol 'traced-definition) (symbol-function symbol))
      ;; Restore the traced def as the def of the function.
      (setf  (symbol-function symbol) trace-def))
    ;; Return symbol as the value::
    symbol)))


(defun BASIC-DEFINITION (symbol)
  "Returns the symbol that is fbound to the primary definition of symbol"
  (cond((get symbol 'encapsulated-definition)
        (do ((def symbol (get def 'encapsulated-definition))
             (prev nil def))
            ((null def) prev)))
       (t symbol)))


(defun UNENCAPSULATE (symbol type)

  "UNENCAPSULATE symbol type

Removes symbol's encapsulation of the specified type."

 (let ((def (get symbol 'traced-definition))
       (trace-def (symbol-function symbol))
       (result nil))
   ;; Same as encapsulate, we fake like the function isn't being
   ;; traced, and then restore the traced stuff after were done.
   (cond (def (setf (symbol-function symbol) def)
              (setq result (internal-unencap symbol type))
              (setf (get symbol 'traced-definition)
                    (symbol-function symbol))
              (setf (symbol-function symbol) trace-def)
              result)
         (t (internal-unencap symbol type)))))


(defun internal-unencap (symbol type)
  (do ((sym symbol (get sym 'encapsulated-definition)))
      ((eq (get sym 'encapsulation-type) type)

       ;; Sym is the proper symbol to unencapsulate ::

       (let* ((cur-encaps (get sym 'encapsulated-definition))
	      (prev-encaps (get cur-encaps 'encapsulated-definition))
	      (prev-encaps-type (get cur-encaps 'encapsulation-type)))

	 ;; Make the previous encapsulation be the current encapsulation ::

         (cond
               ((macro-function symbol) ;; is it a macro??
                (setf (macro-function sym) (macro-function cur-encaps)))
               (t 
                 (setf (symbol-function sym) (symbol-function cur-encaps))))

	 (if prev-encaps
	     (setf (get sym 'encapsulated-definition) prev-encaps)
	     (remprop sym 'encapsulated-definition))
	 (if prev-encaps-type
	     (setf (get sym 'encapsulation-type) prev-encaps-type)
	     (remprop sym 'encapsulation-type)))

       T)                               ; return success.

    ;; If we run out of encapsulated-definitions while searching, 
    ;; return nil ::

    (unless sym
      (return nil))))


(defun ENCAPSULATED-P (symbol &optional (type nil))

  "ENCAPSULATED-P symbol &optional type

Returns T if symbol has an encapsulation, NIL otherwise.
If type is non-nil, then a check is made for the specific type
of encapsulation."

  (cond (type 
            (do ((sym symbol (get sym 'encapsulated-definition)))
                ((null sym) nil)
              (if (eq (get sym 'encapsulation-type) type)
                  (return t))))
        (t (not (eq symbol (basic-definition symbol))))))



;;;; --------------------------------------------------------------------------
;;;;   Generic Defstruct Functions
;;;; --------------------------------------------------------------------------

;;; It is a hole in Common Lisp that you can't access a slot in a structure
;;; via the slot name.  For example, if I have an instance of the following
;;; defstruct,
;;;
;;;    (defstruct (foo (:conc-name FOO->))
;;;      (a nil)
;;;      (b nil))
;;;
;;; I want to be able to get the value of slot A with a call like:
;;;
;;;    (get-structure-slot object 'A).
;;;
;;; This is because I may not know what the accessor function is for that
;;; slot.  Even if I did know the name of the accessor function, I wouldn't
;;; be able to use it to alter the value of the slot because Setf needs to
;;; know the function name at compile time.  This means that code such as
;;; the following won't work.
;;;
;;;    (defun set-structure-slot (object slot-accessor new-value)
;;;      (setf (funcall slot-accessor object) new-value))
;;;
;;; Obviously, setf shouldn't need to handle that as a place form.  This
;;; just points out the need for a general slot accessor function which
;;; will work as a place form for setf.

;;; GBB uses the functions Get-Structure-Slot and Defstruct-Conc-Name
;;; which are defined below.


(defun get-defstruct-description (name)

  "GET-DESFSTRUCT-DESCRIPTION name

   If `Name' has been defined as a structure then return its
   description.  Otherwise signal an error."

 (or (get name 'defstruct-description)
     (get name 'compiler-defstruct-description)
     (error "~s is not the name of a defstruct." name)))


(defun defstruct-p (name)

  "DEFSTRUCT-P name

   This predicate returns a non-nil value if `Name' is the name of a
   defstruct type; nil otherwise.  `Name' must be a symbol."
 
  (or (get name 'defstruct-description)
      (get name 'compiler-defstruct-description)))


(define-encapsulation (defstruct record-conc-name)
   ;; Record what prefix was used to construct the accessor functions.
   (let ((options (second (first argument-list)))
	 (name nil)
	 (conc-name nil))
      (cond
        ((symbolp options)
         (setq name options)
         (setq conc-name
               (concatenate 'simple-string (symbol-name name) "-")))
        (t (setq name (first options))
           (setq conc-name
                 (concatenate 'simple-string (symbol-name name) "-"))
           (mapc #'(lambda(opt)
                     (when (and (consp opt)
                                (eq (first opt) :CONC-NAME)
                                (second opt))
                       (setq conc-name (string (second opt)))))
                 (rest options))))
      ;; Return what the normal DEFSTRUCT would, with the added
      ;; recording of the conc-name.
      `(progn
         (eval-when (load eval compile)
           (setf (get ',name :defstruct-conc-name) ',(string conc-name)))
	 ,(apply basic-definition argument-list))))


(defun defstruct-conc-name (structure)

  "DEFSTRUCT-CONC-NAME structure

   Return a string which is the prefix for building defstruct slot
   accessors for this structure.  STRUCTURE must be a symbol which
   names a structure type."

  (or (get structure :defstruct-conc-name)
      (let ((conc-name (concatenate 'simple-string (symbol-name structure) "-")))
        (warn "The conc-name for the defstruct ~s was not recorded.~@
               ~s will be used."
              structure
              conc-name)
        (setf (get structure :defstruct-conc-name) conc-name))))


(defun structure-slot-names (type)

  "STRUCTURE-SLOT-NAMES type

   This function returns a list of structure slot names
   given the type (symbol) of the structure."

  (let* ((description (get-defstruct-description type))
	 (slot-data (defstruct-description-slot-data description)))
    (mapcar #'first slot-data)))


(defun structure-slot-p (type slot)

  "STRUCTURE-SLOT-P type slot

   This function returns true if `Slot' is the name of a slot in the
   defstruct type named by `Type' and nil if not."

  (and (structure-slot-index-1 type slot)
       t))


;;; Structure Slot Index Computation Function:
;;;
;;; This is common to both the access and the setting functions.  It
;;; computes the index into the internal data structure (usually a
;;; vector) where the slot value is stored.


(defun structure-slot-index (type slot)

  ;; Returns the index of the slot or signals an error
  ;; if the slot doesn't exist.
  
  (or (structure-slot-index-1 type slot)
      (error "~S is not a slot in ~S." slot type)))


(defun structure-slot-index-1 (type slot)

  ;; Returns the index of the slot or nil if the slot doesn't
  ;; exist.  Used by STRUCTURE-SLOT-P and STRUCTURE-SLOT-INDEX.

  (let* ((description (get-defstruct-description type)))

    (let* ((slot-data (defstruct-description-slot-data
                        description))
           (index (second (assoc slot slot-data
                                 ;; We use string= to avoid package
                                 ;; requirements.
                                 :TEST #'string=))))
      index)))


;;;
;;; Structure Slot Access Functions :::
;;;

(defun get-structure-slot (object slot)

  "GET-STRUCTURE-SLOT object slot

Returns the value of a slot in a structure
given the name of the slot.

This function may be used as a place form for SETF."

  (let ((type (type-of object)))
    (%sp-structref type object (structure-slot-index type slot))))


;;;
;;; Structure Slot Setting Functions :::
;;;

(defun set-structure-slot (object slot value)

  ;; SET-STRUCTURE-SLOT object slot value
  ;;
  ;; Sets the value of a slot in a structure
  ;; given the name of the slot."

  (let ((type (type-of object)))
    (%sp-structset
      type object (structure-slot-index type slot) value)))


(defsetf get-structure-slot set-structure-slot)


;;;; --------------------------------------------------------------------------
;;;;   Compiler Transforms.
;;;; --------------------------------------------------------------------------

;;; The body of the transform should return the symbol %PASS% if it
;;; doesn't apply.  If it does apply then it should return the
;;; transformed form.  For example, a common optimization is to do
;;; keyword analysis at compile time.
;;;
;;;     (defun foo (x &key a b)
;;;       ...)
;;;
;;;     (deftransform (foo keyword) (x &rest keyword-args)
;;;       (if (literal-keywords-in-arglist keyword-args)
;;;           (let ((a (getf keyword-args :a))
;;;                 (b (getf keyword-args :b)))
;;;             `(foo-internal ,x ,a ,b))
;;;           '%pass%))
;;;
;;;     (defun foo-internal (x a b)
;;;       ...)


;;; This ENCAPSULATION of DEFTRANSFORM changes the arguments
;;; to DEFTRANSFORM to attach a name for the transform.
;;; When re-evaling a deftransform, it will replace the
;;; named transform with the new one, instead of added a new
;;; one.

(define-encapsulation (DEFTRANSFORM umass-extended-lisp)
  (let* ((args (cdar argument-list))
	 (fnspec (car args))
	 (arglist (second args))
	 (body (cddr args)))
     (cond ((symbolp fnspec)
	    (apply basic-definition argument-list))
	   (t
	    `(progn
	       (check-and-remove-transform ',fnspec)
	       ,(funcall basic-definition
			 `(deftransform ,(car fnspec) ,arglist ,@body))))
	   )))

(defun check-and-remove-transform (fnspec)
  ;; This function will remove any transforms of the name given, if
  ;; any.  If none there, it will record the new named transform.
  ;; **NOTE**::  THis RELIES on the VaxLisp Deftransform putting the
  ;; transform on the FRONT of the clc-Transforms Plist.
  (let* ((fn (first fnspec))
         (transname (second fnspec))
         (pos nil)
         (transforms  (get fn 'system::clc-transforms))
         (transform-names (get fn 'clc-transform-names)))
    ;; see if we have this transform already
    (cond
      ((setq pos (position transname transform-names))
       ;; delete it from the transform list.
       (setf (get fn 'system::clc-transforms)
             ;; this is delete-nth!
             (delete-if #'identity transforms :START pos :END (1+ pos)))
       ;; delete the current one, and add it to the front,
       ;; since we RELY ON Dec's function to put the new one
       ;; one the FRONT of the transforms list.
       (setf (get fn 'clc-transform-names)
             (cons transname
                   (delete-if #'identity transforms :START pos :END (1+ pos)))))
      ;; otherwise, add this one
      (t (setf (get fn 'clc-transform-names)
               (cons transname transform-names))))
    ))


(defun delete-transform (function transform-name)

  "DELETE-TRANSFORM function transform-name

   This function will remove the compiler transform for FUNCTION
   designated by TRANSFORM-NAME."

  (check-and-remove-transform (list function transform-name))
  nil)


;;;; --------------------------------------------------------------------------
;;;;   Miscellaneous Non Common Lisp Functions
;;;; --------------------------------------------------------------------------


;;; This function is used when printing internal GBB objects.  If your
;;; implementation doesn't provide an easy way to get the address of
;;; an object it is ok to simply return zero.  GBB doesn't depend on the
;;; value of this function uniquely identifying an object.

(defun %pointer (x)

  "%POINTER x

   Returns the address of X.  This is only used in printing to easily 
   distiguish two objects.  Its value should not be relied on."

  (system::%sp-pointer->fixnum x))


;;; ---------------------------------------------------------------------------
;;;				  End of File
;;; ---------------------------------------------------------------------------
