;;;; -*- Mode:LISP; Syntax:COMMON-LISP; Package:GBB; Base:10 -*-
;;;; *-* File: VAX11:DIS$DISK:[GBB.V-120.LOCAL]ACCESSORS.LISP *-*
;;;; *-* Edited-By: Cork *-*
;;;; *-* Last-Edit: Thursday, September 15, 1988  12:31:30 *-*
;;;; *-* Machine: Caliban (Explorer II,  Microcode EXP2-UCODE 308 for the Explorer Lisp Microprocessor) *-*
;;;; *-* Software: TI Common Lisp System 4.61 *-*
;;;; *-* Lisp: TI Common Lisp System 4.61 (1.0) *-*

;;;; **************************************************************************
;;;; **************************************************************************
;;;; *
;;;; *                PSUEDO TYPES AND RANDOM ACCESSOR FUNCTIONS
;;;; *
;;;; **************************************************************************
;;;; **************************************************************************
;;;
;;; Written by: Kevin Gallagher
;;;             Department of Computer and Information Science
;;;             University of Massachusetts
;;;             Amherst, Massachusetts 01003.
;;;
;;; This code was written as part of the GBB (Generic Blackboard) system at
;;; the Department of Computer and Information Science (COINS), University of 
;;; Massachusetts, Amherst.
;;;
;;; Copyright (c) 1986, 1987, 1988 COINS.  
;;; All rights reserved.
;;;
;;; Development of this code was partially supported by:
;;;    NSF CER grant DCR-8500332;
;;;    Donations from Texas Instruments, Inc.;
;;;    ONR URI grant N00014-86-K-0764.
;;;
;;; Permission to copy this software, to redistribute it, and to use it for
;;; any purpose is granted, subject to the following restrictions and
;;; understandings.
;;;
;;; 1.  Title and copyright to this software and any material associated
;;; therewith shall at all times remain with COINS.  Any copy made of this
;;; software must include this copyright notice in full.
;;;
;;; 2.  The user acknowledges that the software and associated materials
;;; are provided as a research tool that remains under active development
;;; and is being supplied ``as is'' for the purposes of scientific
;;; collaboration aimed at further development and application of the
;;; software and the exchange of technical data.
;;;
;;; 3.  All software and materials developed as a consequence of the use of
;;; this software shall duly acknowledge such use, in accordance with the
;;; usual standards of acknowledging credit in academic research.
;;;
;;; 4.  Users of this software agree to make their best efforts to inform
;;; the COINS GBB Development Group of noteworthy uses of this software.
;;; The COINS GBB Development Group can be reached at:
;;;
;;;     GBB Development Group
;;;     C/O Dr. Daniel D. Corkill
;;;     Department of Computer and Information Science
;;;     Lederle Graduate Research Center
;;;     University of Massachusetts
;;;     Amherst, Massachusetts 01003
;;;
;;;     (413) 545-0156
;;;
;;; or via electronic mail:
;;;
;;;     GBB@CS.UMass.Edu
;;;
;;; Users are further encouraged to make themselves known to this group so
;;; that new releases, bug fixes, and tutorial information can be
;;; distributed as they become available.
;;;
;;; 5.  COINS makes no representations or warranties of the merchantability
;;; or fitness of this software for any particular purpose; that uses of
;;; the software and associated materials will not infringe any patents,
;;; copyrights, trademarks, or other rights; nor that the operation of this
;;; software will be error-free.  COINS is under no obligation to provide
;;; any services, by way of maintenance, update, or otherwise.  
;;;
;;; 6.  In conjunction with products or services arising from the use of
;;; this material, there shall be no use of the name of the Department of
;;; Computer and Information Science or the University of Massachusetts in
;;; any advertising, promotional, or sales literature without prior written
;;; consent from COINS in each case.
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
;;;
;;;  This file contains accessor functions, `type' predicates, and other
;;;  functions that provide a layer of abstraction between the
;;;  implementation of some information (usually lists) and its use.
;;;
;;;  10/13/86 File Created.  (Gallagher)
;;;
;;; * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

(in-package 'gbb :USE '(lisp umass-extended-lisp))

(use-package '(lisp umass-extended-lisp))

(proclaim `(optimize (speed ,*gbb-optimize-speed*)
                     (safety ,*gbb-optimize-safety*)))



;;; These range handlers are a relatively recent addition so aren't used
;;; everywhere they should be used.

(defun rangep (thing)
  "Returns true if THING a range as the user would enter it.  That is,
   if it is a two element list with each element being a number."
  (and (listp thing)
       (= (length thing) 2)
       (numberp (first thing))
       (numberp (second thing))))

(proclaim '(inline range-start range-end))

(defun range-start (range)
  (first range))

(defun range-end (range)
  (second range))

;;; Internally ranges are stored as a single cons.  To avoid confusion with
;;; ranges that are recognized by rangep the names are a little different.

(proclaim '(inline %range-start %range-end))

(defun %range-start (rg)
  (first rg))

(defun %range-end (rg)
  (rest rg))

(defun list-of-symbols-p (thing)
  "Returns true if THING is a list of symbols."
  (and (listp thing)
       (dolist (i thing t)
	 (unless (symbolp i) (return nil)))))

(defun two-element-list-p (x)
  "Returns true if `x' is a list of two elements."
  (and (listp x)
       (= (list-length x) 2)))



;;; Index Element Types are the primitive types understood by GBB.
;;;
;;; Types to be added really soon: :LINE.

(defconstant *index-element-types* '(:point :range :label))

(defun index-element-type-p (type)
  "Returns true if TYPE is an ``index element type''."
  (member type *index-element-types* :test #'eq))


;;; Functions for extracting info from the unit's stored indexes.

(proclaim '(inline index-element.element-type
		   index-element.i-s-type
		   index-element.value
		   index-element.point-value))

(defun index-element.element-type (x)
  "Return the element type (:point, :range) for an index element."
  (first x))

(defun index-element.i-s-type (x)
  "Return the index structure type (:set, :scalar, etc.)
   for an index element."
  (second x))

(defun index-element.value (x)
  "Return the value for an index element."
  (cddr x))

(defun index-element.point-value (x)
  "Return the value for an index element that is known to
   be a point."
  (cddr x))


;;; The functions for extracting values for an index are stored in the
;;; ALIST slot of the index-structure.  The format of each entry in the
;;; alist is:
;;;
;;;     (index-name index-type {function}+)
;;;

(proclaim '(inline index-structure-function.index-name
		   index-structure-function.index-type
		   index-structure-function.functions))

(defun index-structure-function.index-name (form)
  (first form))

(defun index-structure-function.index-type (form)
  (second form))

(defun index-structure-function.functions (form)
  (cddr form))


;;; Functions for manipulating patterns (for find-units)

(defun pattern-length (pattern-object)
  "Find the longest element in pattern-object."
  (let ((length 0))
    (dolist (element (pattern-object.c-data pattern-object))
      (setf length (max length (length element))))
    length))

(proclaim '(inline pattern-range-start
		   pattern-range-end))

(defun pattern-range-start (x)
  (first x))

(defun pattern-range-end (x)
  (second x))

(defun set-pattern-object-p (pattern-object)
  "Return true if `Pattern-Object' has composite indexes
   and they represent a set type.  This is indicated by the
   c-index slot being nil.  If c-index is not nil then it
   is the composite index for the composite index structure."
  (eq :set (pattern-object.c-type pattern-object)))

(defun composite-pattern-object-p (pattern-object)
  "Returns true if `patten-object' has composite indexes."
  (not (null (pattern-object.c-type pattern-object))))


;;; A search-pattern is either an instance of a search-pattern (a
;;; defstruct) or it is a list whose first element indicates how the
;;; component search-patterns will be combined, the second element is
;;; the number of component search-patterns, and the remaining elements
;;; are the components.

(defmacro simple-search-pattern-p (search-pattern)
  `(atom ,search-pattern))

(defmacro compound-search-pattern-p (search-pattern)
  `(listp ,search-pattern))

(defun make-compound-search-pattern (combination components)
  "Make a compound search pattern.
   COMBINATION indicates how the elements of the compound are
       combined.  This should be a keyword (e.g., :and, :or).
   COMPONENTS is a list of the simple search patterns tha
       make up the compound."
  (list* combination
	 (length components)
	 components))

(proclaim '(inline compound-search-pattern.combination
		   compound-search-pattern.length
		   compound-search-pattern.patterns
                   search-pattern-indexes))

(defun compound-search-pattern.combination (search-pattern)
  (and (compound-search-pattern-p search-pattern)
       (first search-pattern)))

(defun compound-search-pattern.length (search-pattern)
  (and (compound-search-pattern-p search-pattern)
       (second search-pattern)))

(defun compound-search-pattern.patterns (search-pattern)
  (and (compound-search-pattern-p search-pattern)
       (cddr search-pattern)))

(defsetf compound-search-pattern.patterns (search-pattern) (new-value)
  `(setf (cddr ,search-pattern) ,new-value))

(defun search-pattern-indexes (search-pattern)
  (unless (simple-search-pattern-p search-pattern)
    (error "SEARCH-PATTERN-INDEXES can only be used on simple search patterns"))
  (pattern-object.all-indexes (pattern.pattern-object search-pattern)))


;;; Each space instance can have several unit-mappings associated with it.
;;; The DATA slot of the space instance contains a list the unit-mappings
;;; and the storage for the unit instances on the space instance.
;;;
;;; If the unit-mapping is unstructured then the format is
;;;
;;;     (unit-mapping . <list-of-unit-instances>)
;;;
;;; Otherwise the format is
;;;
;;;     (unit-mapping . ((<list-of-index-symbols> . array) ... ))

(proclaim '(inline storage-entry.unit-mapping
                   storage-entry.data
                   storage-element.indexes
                   storage-element.array))

(defun storage-entry.unit-mapping (entry)
  (first entry))

(defun storage-entry.data (entry)
  (rest entry))

(defsetf storage-entry.data (entry) (new-value)
  `(setf (rest ,entry) ,new-value))

(defun storage-element.indexes (element)
  (first element))

(defun storage-element.array (element)
  (rest element))


(defstruct (find-options (:conc-name "FIND-OPTIONS."))
  (filter-before nil)
  (filter-after nil))


;;; On some systems you can't write hash tables to a file.  (More
;;; precisely, Common Lisp doesn't require hash tables to be able to be
;;; written out.  It turns out that you can do it on lisp machines but
;;; can't under Vaxlisp.)  So, I use these functions to allow flexibility
;;; in the implementation of label sets for enumerated types.  They
;;; implement an abstract data type that builds a table of labels and
;;; values.  The needed functions are these:
;;;
;;;    MAKE-LABEL-INDEX-TABLE labels &optional (test #'eq)
;;;    GET-LABEL-INDEX table label
;;;    LIST-OF-LABELS table
;;;    MAP-INDEX-TABLE function table
;;;
;;; `It is an error' to try to get a value from the table before setting a
;;; value for the label.

;;; On the lisp machine it is a hash table.

#+(or SYMBOLICS TI)
(defun make-label-index-table (labels &optional (test 'eq))
  "Create an index table."
  ;; On the Explorers you can't write out hash tables who's test
  ;; is #'eq, #'eql, or #'equal but you can write out tables if
  ;; the test is 'eq, 'eql, or 'equal (i.e., the symbols work but
  ;; the function objects themselves don't).  I will arbitrarily
  ;; enforce this restriction for all lisp machines here.
  (cond ((member test '(eq eql equal)) nil)
	((and (listp test)
	      (= (length test) 2)
	      (eq (first test) 'function)
	      (member (second test) '(eq eql equal)))
	 (setf test (second test)))
	(t (error "The test for an enumerated dimension must be~@
                   one of EQ, EQL, or EQUAL.~%For the labelset ~s~@
                   the test was ~s."
		  labels test)))
  (let ((table (make-hash-table :size (floor (* 1.5 (length labels)))
				:test test)))
    ;; Add the labels now so that I can use maphash to list them.
    (dolist (label labels table)
      (setf (gethash label table) :empty))))

#+TI
(defun get-label-index (table label)
  "Returns the index associated with LABEL."
  ;; The values are going to be numbers so I can use nil to
  ;; indicate that no entry was found.
  (multiple-value-bind (value foundp)
      (gethash label table)
    (if foundp
	value
	(error "~s is not member of the label set ~s."
	       label (list-of-labels table)))))
     
#+SYMBOLICS
;; Symbolics gethash only returns one value
(defun get-label-index (table label)
  "Returns the index associated with LABEL."
  ;; The values are going to be numbers so I can use nil to
  ;; indicate that no entry was found.
  (let ((value (gethash label table)))
    (or value
	(error "~s is not member of the label set ~s."
	       label (list-of-labels table)))))


#+TI
(defun set-label-index (table label index)
  (multiple-value-bind (value foundp)
      (gethash label table)
    (declare (ignore value))
    (if foundp
	(setf (gethash label table) index)
	(error "~s is not member of the label set ~s."
	       label (list-of-labels table)))))

#+SYMBOLICS
;; Symbolics gethash only returns one value
(defun set-label-index (table label index)
  (let ((value (gethash label table)))
    (if value
	(setf (gethash label table) index)
	(error "~s is not member of the label set ~s."
	       label (list-of-labels table)))))

#+(or SYMBOLICS TI) 
(defsetf get-label-index set-label-index)

#+(or SYMBOLICS TI) 
(defun list-of-labels (table)
  "Returns a list of the keys in a table."
  (let ((result nil))
    (maphash #'(lambda (key value)
		 (declare (ignore value))
		 (push key result))
	     table)
    result))

#+(or SYMBOLICS TI) 
(defun map-index-table (fn table)
  "Maps a function over the elements of an index table.
   FN is called with two arguments, a label and its index, for
   each element in the table."
  (maphash fn table))



;;; Under Vaxlisp (and any other implementation), it's an alist;
;;; the label is the key and the array index is the data.

#-LISPM
(defstruct (labelset-table (:conc-name labelset-))
  (test #'eq)
  (alist nil))

#-LISPM
(defun make-label-index-table (labels &optional (test #'eq))
  "Create an index table."
  ;; Add all the entries now for simplicity later.
  (make-labelset-table :test test
		       :alist (mapcar #'list labels)))

#-LISPM
(defun get-label-index (table label)
  "Returns the index associated with LABEL."
  (or (cdr (assoc label (labelset-alist table)
		  :test (labelset-test table)))
      (error "~s is not member of the label set ~s."
	     label (list-of-labels table))))

#-LISPM
(defun set-label-index (table label index)
  (let ((entry (assoc label (labelset-alist table)
		      :test (labelset-test table))))
    (if entry
	(setf (cdr entry) index)
	(error "~s is not member of the label set ~s."
	       label (list-of-labels table)))))

#-LISPM
(defsetf get-label-index set-label-index)

#-LISPM
(defun list-of-labels (table)
  "Returns a list of the keys in a table."
  (mapcar #'car (labelset-alist table)))

#-LISPM
(defun map-index-table (fn table)
  "Maps a function over the elements of an index table.
   FN is called with two arguments, a label and its index, for
   each element in the table."
  (dolist (entry table)
    (funcall fn (car entry) (cdr entry))))



;;; --------------------------------------------------------------------------
;;;                                End of File
;;; --------------------------------------------------------------------------
