/* Interpreter op-codes for Primordial Soup.
 * by Marc de Groot.
 * Copyright (c) 1992 by Marc de Groot.  All rights reserved.
 *
 * Modification log:
 * 20Jan92 MdG	0.2a	File created.
 */

/* Op-codes */
#define	JUMP	(0x0)
#define	SPWN	(0x1)
#define	PCR1	(0x2)
#define	PCR2	(0x3)
#define	PCR3	(0x4)
#define	PCR4	(0x5)
#define	R2R1	(0x6)
#define	R3R1	(0x7)
#define	R4R1	(0x8)
#define R1R2	(0x9)
#define	R1R3	(0xa)
#define	R1R4	(0xb)
#define	ADD1	(0xc)
#define	ADD2	(0xd)
#define	ADD3	(0xe)
#define	ADD4	(0xf)
#define	SUB1	(0x10)
#define	SUB2	(0x11)
#define	SUB3	(0x12)
#define	SUB4	(0x13)
#define	R2M1	(0x14)
#define	R3M1	(0x15)
#define	R4M1	(0x16)
#define	R1M2	(0x17)
#define	R3M2	(0x18)
#define	R4M2	(0x19)
#define	M1R2	(0x1a)
#define	M1R3	(0x1b)
#define	M1R4	(0x1c)
#define	M2R1	(0x1d)
#define	M2R3	(0x1e)
#define	M2R4	(0x1f)
#define	JPZ1	(0x20)
#define	JPZ2	(0x21)
#define	JPZ3	(0x22)
#define	JPZ4	(0x23)
#define	NNR1	(0x24)
#define	NNR2	(0x25)
#define	NNR3	(0x26)
#define	NNR4	(0x27)
#define	INC1	(0x28)
#define	INC2	(0x29)
#define	INC3	(0x2a)
#define	INC4	(0x2b)
#define	DEC1	(0x2c)
#define	DEC2	(0x2d)
#define	DEC3	(0x2e)
#define	DEC4	(0x2f)
#define	JMPF	(0x30)
#define	JMPB	(0x31)
#define	PSHP	(0x32)
#define	PSH1	(0x33)
#define PSH2	(0x34)
#define	PSH3	(0x35)
#define	PSH4	(0x36)
#define	POP1	(0x37)
#define	POP2	(0x38)
#define	POP3	(0x39)
#define	POP4	(0x3a)
#define	CLLF	(0x3b)
#define	CLLB	(0x3c)
#define	RETN	(0x3d)
#define	SCF1	(0x3e)
#define	SCF2	(0x3f)
#define	SCF3	(0x40)
#define	SCF4	(0x41)
#define	SCB1	(0x42)
#define	SCB2	(0x43)
#define	SCB3	(0x44)
#define	SCB4	(0x45)
/* All opcodes below are no-ops */
#define LBL0	(0xf5)
#define LBL1	(0xf6)
#define	LBL2	(0xf7)
#define	LBL3	(0xf8)
#define	LBL4	(0xf9)
#define	LBL5	(0xfa)
#define	LBL6	(0xfb)
#define LBL7	(0xfc)
#define LBL8	(0xfd)
#define	LBL9	(0xfe)
#define	NOOP	(0xff)
