/* macinterface.c
 *                         Copyright (1993)
 *
 *          Rik Belew.  University of California, San Diego
 *        Greg Linden.  University of California, San Diego
 *
 *        This software may be redistributed without charge;
 *                 this notice should be preserved.
 */




#include "defs.h"





void HandleMenuChoice (menuChoice)
	long int		menuChoice;
{
	Str255 		accName;
	int			dummy, menuItem, accNumber;
	boolean		isSystemEdit;
	
	if (menuChoice!=0) {
		menuItem = LoWord(menuChoice);
	
		switch (HiWord(menuChoice)) {
			case APPLE_MENU_ID: 
				switch (menuItem) {
					case ABOUT_CHOICE:
						Alert(400,NIL_POINTER);
						break;
					default:
						GetItem(GetMHandle(APPLE_MENU_ID),menuItem,accName);
						accNumber = OpenDeskAcc(accName);
						break;
				}
				break;
			case FILE_MENU_ID:  
				switch (menuItem) {
					case QUIT_CHOICE: 
						gDone = TRUE;
						verbose = 0;
						break;
					default:
						break;
				}
				break;
			case EDIT_MENU_ID: 
				isSystemEdit = SystemEdit(menuItem - 1);
				break;
			case OPTIONS_MENU_ID:
				switch (menuItem) {
					case DISPLAY_CHOICE:
						if (gInteractive == FALSE) {
							gInteractive = TRUE;
							CheckItem(gOptionsMenu, DISPLAY_CHOICE, TRUE);
							ShowWindow(gTheWindow);
							SelectWindow(gTheWindow);
							initDrawWorld();
							updateGeneration();
						}
						else {
							gInteractive = FALSE;
							CheckItem(gOptionsMenu, DISPLAY_CHOICE, FALSE);
							FillRect(&(gTheWindow->portRect), white);
							HideWindow(gZoomCellWindow);
							HideWindow(gTheWindow);
						}
						break;
					case LASSO_CHOICE:
						if (gLassoOn == FALSE) {
							gLassoOn = TRUE;
							CheckItem(gOptionsMenu, LASSO_CHOICE, TRUE);
						}
						else {
							gLassoOn = FALSE;
							CheckItem(gOptionsMenu, LASSO_CHOICE, FALSE);
						}
						break;
					case PAUSE_CHOICE:
						if (gPaused == FALSE) {
							gPaused = TRUE;
							CheckItem(gOptionsMenu, PAUSE_CHOICE, TRUE);
						}
						else {
							gPaused = FALSE;
							CheckItem(gOptionsMenu, PAUSE_CHOICE, FALSE);
						}
						break;
					default:
						break;
				}
				break;
			case GRAPH_MENU_ID:
				break;
		}
		HiliteMenu(0);
	}
}




void UpdateZoomWindow() {
	int		counter;
	cell	*theCell = world[gCurrentZoomCell.h][gCurrentZoomCell.v];
	boolean	resetCell = FALSE;
	
	if ((gInteractive) && (FrontWindow() == gZoomCellWindow)) {
		counter = gCurrentZoomItem;
		while (counter>0) {
			if (theCell->next==NULL) {
				counter = 0;
				resetCell = TRUE;
			}
			else {
				theCell = theCell->next;
				counter--;
			}
		}
	
		if (resetCell)
			gCurrentZoomItem = 0;
			
		SelectCell (gCurrentZoomCell.h, gCurrentZoomCell.v, gCurrentZoomItem);
	}
}


void	HandleInContent (globalPoint, theWindow)
Point		globalPoint;
WindowPtr	theWindow;
{
	Point			Where;
	Rect			r;
	GrafPtr			oldPort;
	cell			*theCell;
	int				counter, top, bottom, left, right;
	PenState		thePen;


	GetPort(&oldPort);
	SetPort(theWindow);
	Where = globalPoint;
	GlobalToLocal(&Where);
	SetPort(oldPort);

	
	if (gTheWindow == theWindow) {
		if ((Where.v>=START_Y) && (Where.h>=START_X) && (Where.v<=SQUARE_SIZE*YMAX+START_Y) && (Where.h<=SQUARE_SIZE*XMAX+START_X)) 
		{
			if ((gCurrentZoomCell.h!=(Where.h-START_X) / SQUARE_SIZE) || (gCurrentZoomCell.v!=(Where.v-START_Y) / SQUARE_SIZE)) {
				if ((gCurrentZoomCell.h!=-1) && (gCurrentZoomCell.v!=-1)) {
					GetPenState(&thePen);
					PenPat(white);
					SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
					SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
					FrameRect(&r);
					SetPenState(&thePen);
				}
				
				gCurrentZoomCell.h = (Where.h-START_X) / SQUARE_SIZE;
				gCurrentZoomCell.v = (Where.v-START_Y) / SQUARE_SIZE;
				gCurrentZoomItem = 0;
			}
			drawCell(gCurrentZoomCell.h, gCurrentZoomCell.v);
			
			GetPenState(&thePen);
			SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
			SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
			FrameRect(&r);
			SetPenState(&thePen);
			
			if (!(FrontWindow() == gZoomCellWindow))
				SelectCell(gCurrentZoomCell.h, gCurrentZoomCell.v, gCurrentZoomItem);
		}
		else
			SysBeep(5);
	}
	else if (gZoomCellWindow == theWindow) {
		top = gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top - ARROW_OFFSET_BOTTOM;
		left = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) / 2 - ARROW_SIZE - ARROW_OFFSET_MIDDLE;
		bottom = top + ARROW_SIZE;
		right = left + ARROW_SIZE;
		SetRect(&r, left , top, right, bottom);
		if ((PtInRect(Where, &r)) && (gCurrentZoomItem>0)) {
			gCurrentZoomItem--;
			SelectCell(gCurrentZoomCell.h, gCurrentZoomCell.v, gCurrentZoomItem);
		}
		else {
			top = gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top - ARROW_OFFSET_BOTTOM;
			left = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) / 2 + ARROW_OFFSET_MIDDLE;
			bottom = top + ARROW_SIZE;
			right = left + ARROW_SIZE;
			SetRect(&r, left , top, right, bottom);
			counter = gCurrentZoomItem;
			theCell = world[gCurrentZoomCell.h][gCurrentZoomCell.v];
			while (counter>0) {
				theCell = theCell->next;
				counter--;
			}
			if ((PtInRect(Where, &r)) && (theCell->next!=NIL_POINTER)) {
				gCurrentZoomItem++;
				SelectCell(gCurrentZoomCell.h, gCurrentZoomCell.v, gCurrentZoomItem);
			}
			else
				SysBeep(5);
		}
	}
}




void	HandleMouseDown (theEvent)
EventRecord		theEvent;
{
	WindowPtr		whichWindow;
	Rect			r;
	PenState		thePen;

	switch (FindWindow(theEvent.where, &whichWindow)) {
		case inMenuBar: 
			HandleMenuChoice(MenuSelect(theEvent.where));
			break;
		case inSysWindow: 
			SystemClick(&theEvent, whichWindow);
			break;
		case inContent: 
			if (gInteractive)
				HandleInContent(theEvent.where, whichWindow);
			else
				SysBeep(5);
			break;
		case inDrag:
			if (whichWindow==gZoomCellWindow)
				DragWindow(gZoomCellWindow, theEvent.where, &(screenBits.bounds));
			else if (whichWindow==gTheWindow) {
				if (FrontWindow()==gZoomCellWindow) {
					HideWindow(gZoomCellWindow);
					
					GetPenState(&thePen);
					PenPat(white);
					SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
					SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
					FrameRect(&r);
					SetPenState(&thePen);
				}
				DragWindow(gTheWindow, theEvent.where, &(screenBits.bounds));
			}
			break;
		case inGoAway:
			if (whichWindow==gZoomCellWindow)
				if (TrackGoAway(gZoomCellWindow, theEvent.where)) {
					HideWindow(gZoomCellWindow);
					
					GetPenState(&thePen);
					PenPat(white);
					SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
					SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
					FrameRect(&r);
					SetPenState(&thePen);
				}
			break;
		case inDesk:
			SysBeep(5);
			break;
	}
}




void HandleUpdate (theWindow)
WindowPtr theWindow;
{
	GrafPtr	oldPort;
	PenState thePen;
	Rect 	r;
	
	GetPort(&oldPort);
	
	SetPort(theWindow);
	BeginUpdate(theWindow);
	if (theWindow == gTheWindow) {
		if (gInteractive) {
			initDrawWorld();
			if ((gCurrentZoomCell.h!=-1) && (gCurrentZoomCell.v!=-1) && (FrontWindow() == gZoomCellWindow)) {
				GetPenState(&thePen);
				PenPat(black);
				SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
				SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
				FrameRect(&r);
				SetPenState(&thePen);
			}
			updateGeneration();
		}
	}
	else if (theWindow == gZoomCellWindow) {
		if (gInteractive)
			UpdateZoomWindow();
	}
	EndUpdate(theWindow);
	
	SetPort(oldPort);
}



void	HandleEvent () 
{
	EventRecord		theEvent;
	char			theChar;
	Point			aPoint = {100,100};
	PenState		thePen;
	Rect			r;
	
	if (WaitNextEvent(everyEvent, &theEvent, 1L, NIL_POINTER))
		switch (theEvent.what) {
			case nullEvent:
				break;
			case updateEvt: 
				HandleUpdate((WindowPtr)theEvent.message);
				break;
			case mouseDown: 
				HandleMouseDown(theEvent);
				break;
			case keyDown:
			case autoKey: 
				theChar = theEvent.message & charCodeMask;
				if ((theEvent.modifiers & cmdKey) != 0) 
					HandleMenuChoice(MenuKey(theChar));
				break;
			case activateEvt: 
				if (((theEvent.modifiers & activeFlag)==0) && ((WindowPtr)theEvent.message == gZoomCellWindow)){
					HideWindow(gZoomCellWindow);
					
					GetPenState(&thePen);
					PenPat(white);
					SetRect(&r, START_X+gCurrentZoomCell.h*SQUARE_SIZE, START_Y+gCurrentZoomCell.v*SQUARE_SIZE, START_X+(gCurrentZoomCell.h+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(gCurrentZoomCell.v+1)*SQUARE_SIZE-GAP_SIZE);
					SetRect(&r, r.left-2, r.top-2,r.right+2, r.bottom+2);
					FrameRect(&r);
					SetPenState(&thePen);
				}
				break;
			case diskEvt:
				if (HiWord(theEvent.message)!=noErr)
					(void) DIBadMount(aPoint, theEvent.message);
				break;
			default:
				break;
		}
}




