/* macdisplay.c    
 *                         Copyright (1993)
 *
 *          Rik Belew.  University of California, San Diego
 *        Greg Linden.  University of California, San Diego
 *
 *        This software may be redistributed without charge;
 *                 this notice should be preserved.
 */





#include "defs.h"


#define		NEURAL_BOX_OFFSET	10
#define		NEURAL_BOX_TOP		0.2
#define		NEURAL_BOX_LEFT		0.4
#define		NEURAL_BOX_BOTTOM	0.7
#define		NEURAL_BOX_RIGHT	0.9
#define		NEURAL_NODE_SIZE	5
#define		BIAS_COLOR			1.0







void ToolBoxInit() 
{
	InitGraf(&thePort);
	InitFonts();
	FlushEvents(everyEvent, 0);
	InitWindows();
	InitMenus();
	TEInit();
	InitDialogs(NIL_POINTER);
	InitCursor();
}





/*	Initialize and set up the window used for display.  */



void InitWindow() {	
	Rect	r;
		
	gZoomCellWindow = GetNewWindow(ZOOM_CELL_WIND, NIL_POINTER, NIL_POINTER); 
	SetWTitle(gZoomCellWindow,"\pZooming...");
	gCurrentZoomCell.v = -1;
	gCurrentZoomCell.h = -1;
	gCurrentZoomItem = -1;
	gTheWindow = GetNewWindow(WINDOW_ID, NIL_POINTER, (WindowPtr)-1);
	SetWTitle(gTheWindow, "\pLEE");
	ShowWindow(gTheWindow);
	SetPort(gTheWindow);
	
	TextSize(14);
	
	SetRect(&r, START_X - BORDER_OFFSET, START_Y - BORDER_OFFSET, START_X + BORDER_OFFSET + XMAX * SQUARE_SIZE, START_Y + BORDER_OFFSET + YMAX * SQUARE_SIZE);
	FrameRect(&r);
}




/*	Load menu resources and set up menu bar.  */

void InitMenuBar () {
	Handle		menuBar;


	menuBar = GetNewMBar(MENU_BAR_ID);
	SetMenuBar(menuBar);

	gAppleMenu = GetMHandle(APPLE_MENU_ID);
	gFileMenu = GetMHandle(FILE_MENU_ID);
	gEditMenu = GetMHandle(EDIT_MENU_ID);
	gOptionsMenu = GetMHandle(OPTIONS_MENU_ID);
	gGraphsMenu = GetMHandle(GRAPH_MENU_ID);

	AddResMenu(gAppleMenu, 'DRVR');

	DrawMenuBar();
}




/*	Draw world as grid of cells.  Used for initialization and to
	redraw screen for updates.   */

int	initDrawWorld () 
{
	int		x,y;
	Rect	r;
	
	SetRect(&r, START_X - BORDER_OFFSET, START_Y - BORDER_OFFSET, START_X + BORDER_OFFSET + XMAX * SQUARE_SIZE, START_Y + BORDER_OFFSET + YMAX * SQUARE_SIZE);
	FrameRect(&r);
	
	for (y=0; y<YMAX; y++) 
		for (x=0; x<XMAX; x++) 
			drawCell(x,y);
}





void DrawNode (x,y,bias) 
int	x,y;
float bias;
{
	Rect	r;
	int		left, top, right, bottom;
		
	left = x - NEURAL_NODE_SIZE;
	top = y - NEURAL_NODE_SIZE;
	right = x + NEURAL_NODE_SIZE;
	bottom = y + NEURAL_NODE_SIZE;
	SetRect(&r, left, top, right, bottom);
	
	if (bias>BIAS_COLOR*2) 
		FillOval(&r, black);
	else if (bias>BIAS_COLOR) {
		FillOval(&r, dkGray);
		FrameOval(&r);
	}
	else if (bias>-BIAS_COLOR) {
		FillOval(&r, ltGray);
		FrameOval(&r);
	}
	else if (bias>-BIAS_COLOR*2) {
		FillOval(&r, white);
		FrameOval(&r);
	}
	else {
		FillOval(&r, gray);
		FrameOval(&r);
	}
}



	

void SelectCell (x,y, item)
int	x,y, item;
{
	char		tempString[255];
	GrafPtr		oldPort;
	cell 		*theCell = world[x][y];
	Rect		r;
	int			counter, foodType, top, bottom, left, right, level;
	int			upperNode, lowerNode, startX, startY, endX, endY;
	Handle		theIcon;
	PenState	thePen;
	float		NNetLevel, NNetLevelSize, theWeight, *weights;
		
		
	counter = item;
	while (counter>0) {
		theCell = theCell->next;
		counter--;
	}
	
	GetPort(&oldPort);
	
	SetPort(gZoomCellWindow);
	
	sprintf(tempString, "Cell %d x %d", x, y);
	SetWTitle(gZoomCellWindow, CtoPstr(tempString));
	FillRect(&(gZoomCellWindow->portRect), white);
	SelectWindow(gZoomCellWindow);
	ShowWindow(gZoomCellWindow);
	
	if (theCell == NIL_POINTER) {
		TextSize(24);
		MoveTo(10,50);
		DrawString("\pEMPTY.");
	}
	else {
		if (theCell->type == food) {
			SetRect(&r,10,10,50,50);
			switch (theCell->datum.atom) {
				case 0:
					FillRect(&r,ltGray);
					break;
				case 1:
					FillRect(&r,dkGray);
					break;
				default:
					FillRect(&r,gray);
					break;
			}
			TextSize(9);
			MoveTo(10,80);
			sprintf(tempString, "Item #%d", item);
			DrawString(CtoPstr(tempString));
			MoveTo(10,90);
			foodType = theCell->datum.atom;
			sprintf(tempString, "Food Type:  %d", foodType);
			DrawString(CtoPstr(tempString));
		}
		else {
			SetRect(&r,10,10,50,50);
			switch (theCell->datum.ap->direction) {
				case UP:
					FillArc(&r, 180+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case LEFT:
					FillArc(&r, 270+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case RIGHT:
					FillArc(&r, 90+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case DOWN:
					FillArc(&r, ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
			}
			TextSize(9);
			MoveTo(10,80);
			sprintf(tempString, "Item #%d", item);
			DrawString(CtoPstr(tempString));
			MoveTo(10,90);
			sprintf(tempString, "Energy:  %d", (int) theCell->datum.ap->energy);
			DrawString(CtoPstr(tempString));

			top = (gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top) * NEURAL_BOX_TOP;
			bottom = (gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top) * NEURAL_BOX_BOTTOM;
			left = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) * NEURAL_BOX_LEFT;
			right = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) * NEURAL_BOX_RIGHT;
			SetRect(&r, left - NEURAL_BOX_OFFSET, top - NEURAL_BOX_OFFSET, right + NEURAL_BOX_OFFSET, bottom + NEURAL_BOX_OFFSET);
			FrameRect(&r);
			
			GetPenState(&thePen);
			counter = 0;
			for (level = 0; level<nlayers-1; level++) {
				weights = *(theCell->datum.ap->weightp + level);
				for (upperNode=0; upperNode<*(layer_descp+1+level); upperNode++)
					for (lowerNode=0; lowerNode<*(layer_descp+level); lowerNode++) {
						theWeight = *(weights + counter);
						startX = left+(right-left)*upperNode/(*(layer_descp+level+1)-1);
						endX = left+(right-left)*lowerNode/(*(layer_descp+level)-1);
						startY = top+(bottom-top)*(nlayers-level-2)/(nlayers-1);
						endY = top+(bottom-top)*(nlayers-level-1)/(nlayers-1);
						if (theWeight>weight_limit*2/3) {
							PenSize(2,2);
							PenPat(black);
							MoveTo(startX, startY);
							LineTo(endX,endY);
						}
						if (theWeight<-weight_limit/3) {
							PenSize(1,1);
							PenPat(black);
							MoveTo(startX, startY);
							LineTo(endX,endY);
						}
						if (theWeight>weight_limit/3) {
							PenSize(1,1);
							PenPat(gray);
							MoveTo(startX, startY);
							LineTo(endX,endY);
						}
						if (theWeight<-weight_limit*2/3) {
							PenSize(2,2);
							PenPat(gray);
							MoveTo(startX, startY);
							LineTo(endX,endY);
						}
						counter++;
					}
			}
			SetPenState(&thePen);
			
			for (level = 0; level<nlayers; level++)
				for (counter = 0; counter<*(layer_descp+level); counter++) 
					DrawNode(left+(right-left)*counter/(*(layer_descp+level) - 1), top+(bottom-top)*(nlayers-level-1)/(nlayers-1), *(*(theCell->datum.ap->biasp + level)+counter));
			SetPenState(&thePen);
				
		}
		
		top = gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top - ARROW_OFFSET_BOTTOM;
		left = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) / 2 - ARROW_SIZE - ARROW_OFFSET_MIDDLE;
		bottom = top + ARROW_SIZE;
		right = left + ARROW_SIZE;
		SetRect(&r, left , top, right, bottom);
		theIcon = GetIcon(PREV_ICON);
		if (theIcon == NIL_POINTER)
			exit(1);
		PlotIcon(&r, theIcon);
		if (item==0) {
			GetPenState(&thePen);
			PenMode(patBic);
			PenPat(ltGray);
			PaintRect(&r);
			SetPenState(&thePen);
		}
			
		
		top = gZoomCellWindow->portRect.bottom - gZoomCellWindow->portRect.top - ARROW_OFFSET_BOTTOM;
		left = (gZoomCellWindow->portRect.right - gZoomCellWindow->portRect.left) / 2 + ARROW_OFFSET_MIDDLE;
		bottom = top + ARROW_SIZE;
		right = left + ARROW_SIZE;
		SetRect(&r, left , top, right, bottom);
		theIcon = GetIcon(NEXT_ICON);
		if (theIcon == NIL_POINTER)
			exit(1);
		PlotIcon(&r, theIcon);
		if (theCell->next==NIL_POINTER) {
			GetPenState(&thePen);
			PenMode(patBic);
			PenPat(ltGray);
			PaintRect(&r);
			SetPenState(&thePen);
		}
	}
	
		
	SetPort(oldPort);
}




/*	Erases the old generation count and replaces it.  */

updateGeneration() {
	char	genString[255];
	Rect	r;

	SetRect(&r, 300,20,450,60);
	FillRect(&r, white);
	
	MoveTo(310,50);
	sprintf(genString, "Generation:  %d", gen);
	DrawString(CtoPstr(genString));
}







/*	Draws the contents of a given cell.  Will draw top item in 
	cells with multiple items, with organisms taking precidence
	over food.   */

drawCell (x,y)
	int	x,y;
{
	boolean	isOrg, isFood;
	cell	*currentCell;
	Rect	r;
	int		org_direction, food_type;
	PenState thePen;

	
	isOrg = FALSE;
	isFood = FALSE;
	currentCell = world[x][y];
	
	if (gInteractive) {
		/* Find what is in the cell.  */
	
		while (currentCell!=NIL_POINTER) {
			if (currentCell->type==org) {
				isOrg = TRUE;
				org_direction = currentCell->datum.ap->direction;
			}
			else if (currentCell->type==food) {
				isFood = TRUE;
				food_type = currentCell->datum.atom;
			}
/********** FIL DEBUGGING: above {} and "else" were missing ***********/
			currentCell = currentCell->next;
		}
				
	
		/* Draw contents of cell in appropriate location  */
	
		SetRect(&r, START_X+x*SQUARE_SIZE, START_Y+y*SQUARE_SIZE, START_X+(x+1)*SQUARE_SIZE - GAP_SIZE, START_Y+(y+1)*SQUARE_SIZE-GAP_SIZE);
		if (isOrg) {
			FillRect(&r, white);
			switch (org_direction) {
				case UP:
					FillArc(&r, 180+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case LEFT:
					FillArc(&r, 270+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case RIGHT:
					FillArc(&r, 90+ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
				case DOWN:
					FillArc(&r, ORG_MOUTH, 365-2*ORG_MOUTH, black);
					break;
			}
		}
		else if (isFood)
			switch (food_type) {
				case 0:
					FillRect(&r,ltGray);
					break;
				case 1:
					FillRect(&r,dkGray);
					break;
				default:
					FillRect(&r,gray);
					break;
			}
		else 
			FillRect(&r, white);
	}
	
	if ((x==gCurrentZoomCell.h) && (y==gCurrentZoomCell.v)) 
		UpdateZoomWindow();
}
			
