static char rcsid[] = "$Id: xinit.c,v 1.1 1992/12/11 19:08:26 dhb Exp $";

/*
** $Log: xinit.c,v $
** Revision 1.1  1992/12/11  19:08:26  dhb
** Initial revision
**
*/

#include "xo_head.h"
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include "xodus_defs.h"

extern float Atof();
int	x_status;
Display	*display;
static XtAppContext	app_context;
XFontStruct *graph_font;
static void CvtStringToFloat();
static void CvtStringToFunction();
static void CvtFloatToFloat();
extern	void	XEventLoop();


/*
** x_init:  Turn on X11 toplevel window and have some fun.
**
*/
x_init()
{
	Widget  logo, init_command_w();
	int argc, n;
	char **argv;
	Arg	arg[10];

	static XrmOptionDescRec options[] = {
		{"-override_redirect", XtNoverrideRedirect,
				XrmoptionSepArg, "TRUE"},
		{"allow_shell_resize", XtNallowShellResize,
				XrmoptionSepArg, "TRUE"},
		{"-geometry", XtNgeometry, XrmoptionSepArg,
				"100x100+100+100"},
	};
	printf("\n");
printf(" *****************************************************************************\n\n");
printf("                                   X O D U S\n");
printf("               X-based Output and Display Utility for Simulators\n");
printf("                                  version 1.2\n\n");
printf("                Written by: Upinder S. Bhalla and John D. Uhley\n\n");
printf("                        Copyright 1988, 1989, 1990, 1991\n");
printf("                       California Institute of Technology\n");
printf(" *****************************************************************************\n\n");

	argc = 3;
	argv = (char **) malloc( 10 * sizeof(char *));
	argv[0] = "XoDuS"; 
	argv[1] = "-geometry";
	argv[2] = "100x100+100+100";
	argv[3] = NULL;

	XtToolkitInitialize();
	app_context = (XtAppContext)XtCreateApplicationContext();
	XtDisplayInitialize(app_context, display, 
		"xodus", "XOdus", options, XtNumber(options),
			&argc, argv);

	/*
	** Register the much-needed String to Float converter 
	*/
	XtAppAddConverter(app_context,XtRString,XtRFloat,
		CvtStringToFloat,NULL,0);
	/*
	** Register the Float to Float converter 
	*/
	XtAppAddConverter(app_context,XtRFloat,XtRFloat,
		CvtFloatToFloat,NULL,0);
	/*
	** Register a String to Func converter to 
	** handle a hash table of functions that get switched around 
	** First, initialise the hash table, then register the 
	** converter.
	*/
	XoInitFuncTable();
	XtAppAddConverter(app_context,XtRString,XtRFunction,
		CvtStringToFunction,NULL,0);

	/*
	** Set The Monochrome "Colors" Here in case we're just B/W
	*/
	set_monochrome_colors();

	graph_font_init(display);
	xodus_init_def_args();
	AddJob(XEventLoop, 1);
}

/*
** 
/*
** do_xon:	The user can pop open an X window for control.  This is
**		a toggle which an only be executed if "x_status" is false.
**
*/

do_xon(argc,argv)
	int		argc;
	char	**argv;
{
	switch (x_status) {
		case 0:
			display = XOpenDisplay("");
			if (display == NULL) {
				fprintf(stderr,
					"%s:	DISPLAY not set\n", argv[0]);
				fprintf(stderr,
					"	setenv DISPLAY & reissue %s\n",
					argv[0]);
				break;
			}
			x_status = 1;
			x_init();
			break;
		case 1:
			printf("%s: X windows already enabled.\n", argv[0]);
			break;
		case (-1):
			x_map_toplevel();
			x_status = 1;
			break;
		default:
			fprintf(stderr,
				"do_xon: unknown xstatus value %d\n", x_status);
			break;
	}
}


/*
** x_global_init:	CALL THIS *BEFORE* doing an Xon!!
**
*/
x_global_init()
{
	x_status = 0;
	x_init_toplevel();
}


/* 
**
** The x fall-through event loop which cleans up pending X events 
** when called by the Simulator main event loop
**
*/

void
XEventLoop()
{
	XEvent	event;

	while (XtAppPending(app_context) != 0) {
		XtAppNextEvent(app_context, &event);
		XtDispatchEvent(&event);
	}
}

static void CvtStringToFloat(args,num_args,from,to)
	XrmValue	*args;
	Cardinal	*num_args;
	XrmValue	*from;
	XrmValue	*to;
{
	static float	val;

	val = Atof(from->addr);
	to->addr = (caddr_t)&val;
	to->size = sizeof(float);
}

static void CvtFunctionToString(args,num_args,from,to)
	XrmValue	*args;
	Cardinal	*num_args;
	XrmValue	*from;
	XrmValue	*to;
{
	char *FuncTableFindName();
	static char *name;

	name = (caddr_t)fillstr(FuncTableFindName(from->addr));
	to->addr = (caddr_t)&name;
	to->size = sizeof(char *);
}

static void CvtStringToFunction(args,num_args,from,to)
	XrmValue	*args;
	Cardinal	*num_args;
	XrmValue	*from;
	XrmValue	*to;
{
	char *FuncTableFindFunc();
	static char *func;

	func = (caddr_t)FuncTableFindFunc(from->addr);
	to->addr = (caddr_t)&func;
	to->size = sizeof(char *);
}

static void CvtFloatToFloat(args,num_args,from,to)
	XrmValue	*args;
	Cardinal	*num_args;
	XrmValue	*from;
	XrmValue	*to;
{
	static float	val;

	val = *((float *)from->addr);
	to->addr = (caddr_t)&val;
	to->size = sizeof(float);
}
