static char rcsid[] = "$Id: psdriver.c,v 1.1 1992/12/11 19:08:24 dhb Exp $";

/*
** $Log: psdriver.c,v $
** Revision 1.1  1992/12/11  19:08:24  dhb
** Initial revision
**
*/

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <signal.h>

typedef struct {
    short x,y;
} Coord;

#define XOUT	0
#define PSOUT	1

int	output_flag = XOUT;
static int	SCREEN_DOTS_PER_INCH = 100;
static FILE 	*PSfp;
static int 	global_window_height;
static int 	global_window_width;
static float 	pix_scale;
static float 	page_scale;
static short 	file_output = 0;
static char 	*ps_filename;
static int 	current_gray = -1;
static int 	current_line = -1;
static int 	max_gray = 256;
static int 	min_gray = 0;
static int	inverse = 1;

do_psparms(argc,argv)
int argc;
char **argv;
{
int nxtarg;
		if(argc < 2){
		printf("usage: %s [-maxgray maxgray(0-256)][-mingray mingray][-inverse 0/1]\n",argv[0]);
		printf("[-dpi screendpi][-filename name][-printer]\n");
		printf("status : maxgray = %d, mingray = %d, inverse = %d, dpi = %d\n",
			max_gray, min_gray, inverse, SCREEN_DOTS_PER_INCH);
		if(file_output){
		    printf("output to file '%s'\n", ps_filename);
		} else {
		    printf("output to printer\n");
		}
		return(0);
		}
		nxtarg = 0;
		while(++nxtarg < argc){
				if(strcmp(argv[nxtarg],"-maxgray") == 0){
						SetMaxGray(atoi(argv[++nxtarg]));
				} else
				if(strcmp(argv[nxtarg],"-mingray") == 0){
						SetMinGray(atoi(argv[++nxtarg]));
				} else
				if(strcmp(argv[nxtarg],"-dpi") == 0){
						SCREEN_DOTS_PER_INCH = atoi(argv[++nxtarg]);
				} else
				if(strcmp(argv[nxtarg],"-filename") == 0){
				    SetPSFileOutput(1);
				    SetPSFilename(CopyString(argv[++nxtarg]));
				} else
				if(strcmp(argv[nxtarg],"-printer") == 0){
				    SetPSFileOutput(0);
				} else
				if(strcmp(argv[nxtarg],"-inverse") == 0){
						SetPSInverse(atoi(argv[++nxtarg]));
				} 
		}
}

SetPSInverse(state)
int state;
{
    inverse = state;
}

SetPSFilename(name)
char *name;
{
    ps_filename = name;
}

SetPSFileOutput(state)
int state;
{
    file_output = state;
}

SetMaxGray(val)
int	val;
{
    max_gray = val;
}

SetMinGray(val)
int	val;
{
    min_gray = val;
}

float ComputeGray(pixel)
int pixel;
{
    if(inverse){
	return(1.0-(float)(pixel - min_gray)/(max_gray -min_gray));
    } else {
	return((float)(pixel - min_gray)/(max_gray -min_gray));
    }
}

PSSetPixel(display,pixel)
Display *display;
int pixel;
{
XColor color;
int intensity;

    if(pixel != current_gray){
	/*
	color.pixel = pixel;
	XQueryColor(display,DefaultColormap(display,XDefaultScreen(display)),&color);
	intensity = (color.red + color.green + color.blue)/3;
	*/
	current_gray = pixel;
	if(pixel == XBlackPixel(display,XDefaultScreen(display))){
	    fprintf(PSfp,"%d setgray\n",inverse);
	} else 
	if(pixel == XWhitePixel(display,XDefaultScreen(display))){
	    fprintf(PSfp,"%d setgray\n",!inverse);
	} else {
	    fprintf(PSfp,"%f setgray\n",ComputeGray(pixel));
	}
    }
}

PSSetLineWidth(width)
int width;
{
    if(width == 0) width = 1;
    if(current_line != width){ 
	current_line = width;
	fprintf(PSfp,"%f setlinewidth\n",current_line/pix_scale);
    }
}

PSClosefill()
{
    fprintf(PSfp,"closepath fill\n");
}

PSNewpath()
{
    fprintf(PSfp,"newpath\n");
}

PSStroke()
{
    fprintf(PSfp,"stroke\n");
}

PSMoveto(x,y)
int x,y;
{
    fprintf(PSfp,"%d %d moveto\n", x, global_window_height - y);
}

PSLineto(x,y)
int x,y;
{
    fprintf(PSfp,"%d %d lineto\n", x, global_window_height - y);
}

PSShow(s)
char *s;
{
    fprintf(PSfp,"(%s) show\n",s);
}

PSFont(height)
int height;
{
    fprintf(PSfp,"/Helvetica findfont %d scalefont setfont\n",height);
}

XPSDrawText(display,drawable,context,x,y,s)
Display 	*display;
Drawable	drawable;
GC		context;
int 		x, y;
char 		*s;
{
XFontStruct *finfo;
int	height;

    if(output_flag == XOUT){
	XDrawImageString(display,drawable,context,x,y,s,strlen(s));
    } else{
	/*
	** get the current foreground color from the graphics context
	*/
	PSSetPixel(display,context->values.foreground);
	finfo  = XQueryFont(display,context->gid);
	height = finfo->ascent + finfo->descent;
	PSFont(height);
	PSMoveto(x,y);
	PSShow(s);
    }
}

XPSDrawLine (display, drawable, context, x1, y1, x2, y2)
Display	*display;
Drawable drawable;
GC 	context;
int 	x1,y1,x2,y2;
{
int	pixel;

    if(output_flag == XOUT){
	XDrawLine (display, drawable, context, x1,y1,x2,y2);
    } else {
	/*
	** get the current foreground color from the graphics context
	*/
	PSSetPixel(display,context->values.foreground);
	PSSetLineWidth(context->values.line_width);
	PSNewpath();
	PSMoveto(x1,y1);
	PSLineto(x2,y2);
	PSStroke();
    }
}

#define MAXCHUNK 10000

XPSDrawLines(display,drawable,context,coord,ncoords,mode)
Display *display;
Drawable drawable;
GC context;
Coord   *coord;
int     ncoords;
int     mode;
{
int	i;
int	pcount;
int	nchunks;
int	chunksize;

    if(output_flag == XOUT){
	/*
	** avoid the limit on the length of a multiple line vector
	** by doing it in multiple calls
	*/
	nchunks = ncoords/MAXCHUNK + 1;
	for(i=0;i<nchunks;i++){
	    if((chunksize = ncoords - i*MAXCHUNK) > MAXCHUNK){
		chunksize = MAXCHUNK;
	    }
	    /*
	    ** draw one point past to connect this chunk with the 
	    ** next. Dont do it for the last chunk
	    */
	    if(i < nchunks-1) chunksize++;
	    XDrawLines(display,drawable,context,
	    coord + i*MAXCHUNK,chunksize,mode);
	}
    } else {
	if(ncoords <= 0 ){
	    return;
	}
	PSNewpath();
	PSSetPixel(display,context->values.foreground);
	PSSetLineWidth(context->values.line_width);
	PSMoveto(coord[0].x,coord[0].y);
	pcount = 0;
	for(i=1;i<ncoords;i++){
	    PSLineto(coord[i].x,coord[i].y);
	    /*
	    * break it up into managable cuhnks
	    */
	    if(pcount > 200){
		PSStroke();
		PSNewpath();
		PSMoveto(coord[i].x,coord[i].y);
		pcount = 0;
	    }
	    pcount++;
	}
	PSStroke();
    }
}

XPSDrawRectangle(display,drawable,context,x,y,w,h)
Display *display;
Drawable drawable;
GC context;
int     x,y,w,h;
{
    if(output_flag == XOUT){
	XDrawRectangle(display,drawable,context,x,y,w,h);
    } else {
	PSSetPixel(display,context->values.foreground);
	PSSetLineWidth(context->values.line_width);
	PSNewpath();
	PSMoveto(x,y);
	PSLineto(x+w,y);
	PSLineto(x+w,y+h);
	PSLineto(x,y+h);
	PSLineto(x,y);
	PSStroke();
    }
}

XPSFillRectangle(display,drawable,context,x,y,w,h)
Display *display;
Drawable drawable;
GC context;
int     x,y,w,h;
{
    if(output_flag == XOUT){
	XFillRectangle(display,drawable,context,x,y,w,h);
    } else {
	PSSetPixel(display,context->values.foreground);
	PSNewpath();
	PSMoveto(x,y);
	PSLineto(x+w,y);
	PSLineto(x+w,y+h);
	PSLineto(x,y+h);
	PSClosefill();
    }
}

XPSFillPolygon(display,drawable,context,coord,ncoords,shape,mode)
Display *display;
Drawable drawable;
GC context;
Coord   *coord;
int     ncoords;
int     shape;
int     mode;
{
int	i;
int	pcount;

    if(output_flag == XOUT){
	XFillPolygon(display,drawable,context,coord,ncoords,shape,mode);
    } else{
	if(ncoords <= 0){
	    return;
	}
	PSNewpath();
	PSSetPixel(display,context->values.foreground);
	PSMoveto(coord[0].x,coord[0].y);
	pcount = 0;
	for(i=1;i<ncoords;i++){
	    PSLineto(coord[i].x,coord[i].y);
	    /*
	    * break it up into managable cuhnks
	    */
	    if(pcount > 200){
		PSClosefill();
		PSMoveto(coord[i].x,coord[i].y);
		pcount = 0;
	    }
	    pcount++;
	}
	PSClosefill();
    }
}

PSHeader(info,requested_scale)
XWindowAttributes	*info;
float		requested_scale;
{
float	scale,scalex,scaley;

    fprintf(PSfp,"%%!\n");
    fprintf(PSfp,"initgraphics\n");

    global_window_width = info->width;
    global_window_height = info->height;

    scalex = 8.5/global_window_width;
    scaley = 11.0/global_window_height;
    /*
    * use the min scale
    * but only use 90 percent so that it doesnt completely fill the page
    */
    scale = requested_scale*((scalex < scaley) ? scalex : scaley);
    /*
    * convert to dots/pixel
    */
    pix_scale = scale*SCREEN_DOTS_PER_INCH;
    /*
    * convert to points/pixel
    */
    page_scale = scale*72;
    fprintf(PSfp,"%f %f scale\n",page_scale,page_scale);
    fprintf(PSfp,"%f %f translate\n",
    72*(scalex-scale)*global_window_width/2.0,
    72*(scaley-scale)*global_window_height/2.0);
}

PSTrailer()
{
    fprintf(PSfp,"showpage ");
}


int PreparePS(display,window,scale)
Display	*display;
Window 	window;
float	scale;
{
char command[80];
XWindowAttributes	info;
char *printer;

    XGetWindowAttributes(display,window,&info);
    if(file_output){
	PSfp = fopen(ps_filename,"w");
    } else {
	if((printer = (char *)getenv("PRINTER")) == NULL){
	    printer = "lw";
	}
	sprintf(command,"lpr -h -P%s",printer);
	PSfp = popen(command,"w");
	if (!PSfp) {
		fprintf(stderr,"could not open pipe to printer '%s'\n",printer);
		return(0);
	}
    }
    PSHeader(&info,scale);
    output_flag = PSOUT;
	return(1);
}

FinishPS()
{
	if (output_flag == XOUT && !file_output)
		return;
    PSTrailer();
    output_flag = XOUT;
    current_line = -1;
    current_gray = -1;
    if(file_output){
	fclose(PSfp);
    } else {
	pclose(PSfp);
    }
}

/*
** sample :
**
** your code
** PreparePS(display,window);
** refresh_window(window);
** FinishPS();
**
*/

XPSDrawImageString(display,window,gc,x,y,str, len)
	Display *display;
	Window	window;
	GC	gc;
	int	x,y;
	char	*str;
	int	len;
{
	if (output_flag == XOUT)
		XDrawImageString(display,window,gc,x,y,str, len);
	else
		XPSDrawString (display, window, gc, x, y, str, len);
}

XPSDrawString (display, w, gc, x, y, str, len)
	Display	*display;
	Window w;
	GC	gc;
	int x, y;
	char *str;               /* NOT necessarily null-terminated */
	int len;                 /* string length */
{
XGCValues	values;
XFontStruct *finfo;
Font	 font;
int	i;
int	height, width;
char string[200];

	if(output_flag == XOUT){
		XDrawString (display, w, gc, x, y, str, len);
	} else{
		for(i=0;i<len;i++){
			string[i] = str[i];
		}
		string[len] = '\0';
	/*
	** get the current foreground color from the graphics context
	*/
	PSSetPixel(display,gc->values.foreground);
	finfo = XQueryFont(display, gc->gid);
	height = finfo->max_bounds.ascent + finfo->max_bounds.descent;
	width = finfo->max_bounds.rbearing - finfo->min_bounds.lbearing;
		fprintf(PSfp,"/Helvetica findfont %d scalefont setfont\n",
		height);
		fprintf(PSfp,"%d %d moveto\n",x+width,
		global_window_height - (y /* + height */));
		fprintf(PSfp,"(%s) show\n",str);
	}
}

XPSDrawPoint(display, window, gc, x, y)
	Display *display;
	Window	window;
	GC	gc;
	int	x,y;
{
	if (output_flag == XOUT)
		XDrawPoint(display, window, gc, x,y);
	else
		XPSDrawLine(display,window,gc,x,y,x,y);
}

XPSDrawPoints(display, window, gc, pts, npts, mode)

	Display *display;
	Window	window;
	GC	gc;
	XPoint	*pts;
	int	npts;
	int	mode;
{
	int	i;
	static	int	lastx, lasty;
	if (output_flag == XOUT)
		XDrawPoints(display, window, gc, pts, npts, mode);
	else
	  {
	    lastx = lasty = 0;
	    for (i = 0; i <npts; i++) {
		    if (mode == CoordModePrevious) {
			    XPSDrawPoint(display,window, gc, pts[i].x+lastx,
				     pts[i].y+lasty);
			    lastx =pts[i].x;
			    lasty =pts[i].y;
		    } else {
			    XPSDrawPoint(display,window, gc, pts[i].x, pts[i].y);
		    }
	    }
	  }
}

XPSDrawSegments(display,window,gc,segs,nsegs)
	Display *display;
	Window	window;
	GC	gc;
	XSegment	*segs;
	int	nsegs;
{
	int	i;
	if (output_flag == XOUT) 
		XDrawSegments(display,window,gc,segs,nsegs);
	else
		for (i =0 ; i < nsegs; i++)
			XPSDrawLine(display,window,gc,segs[i].x1,
				segs[i].y1, segs[i].x2,
				segs[i].y2);
}
XPSDrawRectangles(display,window,gc,rects,nrects)
	Display *display;
	Window	window;
	GC	gc;
	XRectangle	*rects;
	int	nrects;
{
	int	i;
	if (output_flag == XOUT) 
		XDrawRectangles (display,window,gc,rects,nrects);
	else
		for (i =0; i < nrects; i++)
			XPSDrawRectangle(display,window,gc,
				rects[i].x, rects[i].y, 
				rects[i].width, rects[i].height);
		
}
