static char rcsid[] = "$Id: new_x_toplevel.c,v 1.1 1992/12/11 19:08:22 dhb Exp $";

/*
** $Log: new_x_toplevel.c,v $
** Revision 1.1  1992/12/11  19:08:22  dhb
** Initial revision
**
*/

/*
** x_toplevel:	Keep a list of toplevel widgets so we can map/upmap
**		on demand.
**
*/

#include "xo_head.h"
#include "header.h"
#include "sim_defs.h"
#include "sim_struct.h"
#include "widget_struct.h"

extern	Widget	x_ntw_get();

typedef	struct	x_widget_list {
	Widget	w;
	struct	x_widget_list	*next;
	struct	x_widget_list	*last;
} X_WIDGET_LIST;
static	X_WIDGET_LIST	*toplevel_list;

/*
** x_init_topevel
**
*/
x_init_toplevel()
{
	toplevel_list = NULL;
}

	
/*
** x_add_toplevel:	A a new toplevel widget 
*/
x_add_toplevel(w)
	Widget	w;
{
	X_WIDGET_LIST	*traverse = toplevel_list;

	while (traverse != NULL && traverse->next != NULL) {
		if (traverse->w == w)
			return;
		traverse = traverse->next;
	}
	if (traverse == NULL ) {
		toplevel_list = (X_WIDGET_LIST *)malloc(sizeof(X_WIDGET_LIST));
		toplevel_list->next = NULL;
		toplevel_list->last= NULL;
		toplevel_list->w = w;
		return;
	}
	traverse->next = (X_WIDGET_LIST *)malloc(sizeof(X_WIDGET_LIST));
	traverse->next->last  = traverse;
	traverse = traverse->next;
	traverse->next = NULL;
	traverse->w = w;
	return;
}

/*
** remove a toplevel widget & destroy it
**
*/
x_remove_toplevel(w)
	Widget	w;
{
	X_WIDGET_LIST	*traverse = toplevel_list;
	/*
	Display	*XtDisplay();
	*/

	while (traverse != NULL)  {
		if (traverse->w == w)  {
			if (traverse->last == NULL) {
				free(traverse);
				toplevel_list = NULL;
			} else {
				traverse->last->next = traverse->next;
				if (traverse->next != NULL)
					traverse->next->last = 
						traverse->last;
				free(traverse);
			}
			XtUnmapWidget(w);
			XtDestroyWidget(w);
			return(1);
		}
		traverse = traverse->next;
	}
	return(0);
}

/*
** tell if a widget is a toplevel widget
*/
int	is_toplevel(w)
	Widget	w;
{
	X_WIDGET_LIST	*l = toplevel_list;
	Arg		arg[4];
	int		n;

	while(l != NULL) {
		if (l->w == w)
			return(1);
		l = l->next;
	}
		return(0);
}

/*
** resize_toplevel:	I don't know...
**
*/
int	realize_toplevel()
{
	X_WIDGET_LIST	*traverse = toplevel_list;

	if (traverse == NULL) {
		return;
	}
	while (traverse != NULL) {
		if (traverse->w != NULL)
			XtRealizeWidget(traverse->w);
		traverse = traverse->next;
	}
	
}

/*
** x_unmap_toplevel:	Unmap all toplevel widgets (but don't destroy them)
**
*/
x_unmap_toplevel()
{
	X_WIDGET_LIST	*traverse = toplevel_list;

	if (traverse == NULL) {
		return;
	}
	while (traverse != NULL) {
		if (traverse->w != NULL)
			XtUnmapWidget(traverse->w);
		traverse = traverse->next;
	}
}

/*
** x_map_toplevel:	Map all toplevel widgets 
**
*/
x_map_toplevel()
{
	X_WIDGET_LIST	*traverse = toplevel_list;

	if (traverse == NULL)
		return;
	while (traverse != NULL) {
		if (traverse->w != NULL)
			XtMapWidget(traverse->w);
		traverse = traverse->next;
	}
	
}

/*
** new_x_ntw_get:		The matt version
**
*/
Widget
x_ntw_get(path)
	char	*path;
{
	struct widget_type *elm;
	elm = (struct widget_type *)GetElement(path);
	if (elm == NULL) {
		fprintf(stderr,"x_ntw_get: failed on %s\n", path);
		return(NULL);
	}
	/* could check type for widget here...*/
	return(elm->widget);
}

/*
** x_ntw_add:	Nothing right now
**
*/
x_ntw_add()
{
}

Element 
*x_wte_get(w)
	Widget w;
{
	Widget parent;
	struct widget_type	*elm;
	static char path[200];
	static char temp[200];

	path[0] = '\0';
	for (parent = w ; !(is_toplevel(parent)) ;
		parent = XtParent(parent)) {
		sprintf(temp,"/%s%s",parent->core.name,path);
		strcpy(path,temp);
		/*
		if (is_toplevel(parent))
			break;
		*/
	}
	elm = (struct widget_type *)GetElement(path);
	if (elm && elm->widget == w) {
		return((Element *)elm);
	} else {
		printf("could not find element corresponding to '%s'\n",path);
		return(NULL);
	}
}
