static char rcsid[] = "$Id: name_to_color.c,v 1.1 1992/12/11 19:08:20 dhb Exp $";

/*
** $Log: name_to_color.c,v $
** Revision 1.1  1992/12/11  19:08:20  dhb
** Initial revision
**
*/

#include "xo_head.h"
#include "xodus_ext.h"

typedef struct {
	char	*name;
	int	pixel;
} NAMED_COLOR_STRUCT;

static	int named_color_count = 0;
static	NAMED_COLOR_STRUCT named_colors[255];

extern char *g_copy();

/*
** name_to_color:	Take a name 
**
*/
name_to_color(str)
	char	*str;
{
	XColor	v_ret, h_ret;
	int	i, ret;

	if (str == NULL) {
		/*
		fprintf(stderr,"name_to_color passed a null string\n");
		*/
		return(XWhitePixel(display, 0));
	}

	ret = (int)str;
	if (ret >= 0 && ret < 256) /* Probably a direct pixvalue */
		return (ret);

	for (i = 0; i < named_color_count; i++) {
		if (strcmp(named_colors[i].name, str) == 0)
			return(named_colors[i].pixel);
	}
 
	if (XDisplayCells(display,XDefaultScreen(display)) < 255) {
		if (strcmp(str, "black") == 0 ||
			strcmp(str, "Black") == 0)
			return(XBlackPixel(display, 0));
		else
			return(XWhitePixel(display, 0));
	}	

	ret = XParseColor(display, DefaultColormap(display, 0), str, &v_ret);
	if (ret ==0  || ret == BadColor) {
		printf("name_to_color: unknown color name '%s'\n", str);
		return(XWhitePixel(display, 0));
	}

	ret = XAllocNamedColor(display, DefaultColormap(display, 0),
		 str, &v_ret, &h_ret) ;
	if (ret == BadColor || ret == BadName || ret == BadAlloc){
		printf("name_to_color: XallocNamedColor failed for '%s'\n",str);
		return(XWhitePixel(display, 0));
	}
	named_color_count++;
	if (named_color_count > 127) {
		fprintf(stderr,"name_to_color: too many colors assigned\n");
		named_color_count = 127;
		return(XWhitePixel(display, 0));
	}
	named_colors[i].name = NULL;
	named_colors[i].name = (char *)g_copy(str);
	named_colors[i].pixel = v_ret.pixel;
	return(v_ret.pixel);
}

add_named_color(str,pixel)
	char	*str;
	long	pixel;
{
	int i;

	for (i = 0; i < named_color_count; i++) {
		if (strcmp(named_colors[i].name, str) == 0)
			return;
	}
	named_colors[named_color_count].name = str;
	named_colors[named_color_count].pixel = pixel;
	named_color_count++;
}
