static char rcsid[] = "$Id: elm_pix_set.c,v 1.1 1992/12/11 19:08:20 dhb Exp $";

/*
** $Log: elm_pix_set.c,v $
** Revision 1.1  1992/12/11  19:08:20  dhb
** Initial revision
**
*/

#include "xo_head.h"

#include "header.h"
#include "sim_defs.h"
#include "sim_struct.h"
#include "draw_struct.h"
#include "draw_w.h"
#include "widget_struct.h"

char	*XoGetPixName();
/*
** XoCreatePix : takes the element, an argc-argv list and the pix
** creation  function. 
** 	Checks the arglist 
**	creates the new pix ith the valid fields. 
**	Gets all the resource values for pix and puts into the element
*/
int XoCreateElmPix(element,w,argc,argv,func)
	struct xpix_type *element;
	Widget	w;
	int		argc;
	char	**argv;
	Pix		*(*func)();
{
	Pix		*pix;
	int		i;
	Arg		args[5];
	int		len = 0;
	Cardinal	n = 0;
	char	*str;
	char 	*pixname;

	if (!w) {
		fprintf(stderr,"parent widget not found for element '%s'\n",
			element->name);
		return(0);
	}

	n = 0;
	if (argc > 1 && (pixname = XoGetPixName(argv[1])))
		XtSetArg(args[n],XtNpixname,pixname); n++;

	element->pix = (char *)func(w,args,n);

	return(XoSetElmPix2(element,w,argc -2,argv + 2));
}

char *
XoGetPixName(path)
	char *path;
{
	int		len,n;
	char	*str;
	char	*fillstr();

	str = path;
	for (str = path, n = 0, len = 0 ; *str ; str++, n++)
		if (*str == '/') len = n;
	if (len > 0) str = &(path[len + 1]);
	else str = path;

	if (!str || strlen(str) == 0)
		return(NULL);

	return(fillstr(str));
}

int XoSetElmPix(element,argc,argv)
	struct xpix_type	*element;
	int			argc;
	char		**argv;
{
	Widget		w;

	if (!element->parent) {
		fprintf(stderr,"parent not found for element '%s' in XoSetElmPix\n",
			element->name);
		return(0);
	}

	if (!(w = ((struct xdraw_type *)element->parent)->widget )) {
		fprintf(stderr,"parent widget not found for element '%s' in XoSetElmPix\n",
			element->name);
		return(0);
	}

	return(XoSetElmPix2(element,w,argc,argv));
}

int XoSetElmPix2(element,w,argc,argv)
	struct xpix_type	*element;
	Widget		w;
	int			argc;
	char		**argv;
{
	Pix		*pix;
	int		i;
	Arg		args[50];
	int		n = 0;
	char	*field;
	char	*value;


	if (!w) {
		fprintf(stderr,"parent widget not found for element '%s'\n",
			element->name);
		return(0);
	}

	if (!(pix = (Pix *)element->pix)) {
		fprintf(stderr,"pix not found on element %s\n",element->name);
		return(0);
	}

	XtSetArg(args[n],XtNpixchoose,fillstr(pix->name)); n++;

	for ( i = 0 ; i < argc ; i++) {
		field = argv[i]; 
		if (field[0] == '-' )
			field++;
			i++; 
			if (i >= argc) {
				fprintf(stderr,"no value for '%s'\n",field);
				return;
			}
			value = argv[i];
		if (XoIsPixResource(pix,field)) {
			XtSetArg(args[n],field,value); n++;
		} else {
			fprintf(stderr,"field '%s' not known\n",field);
		}
	}

	XoSetValuesFromStrings(w,args,n);

	XoGetAllPixValues(w,pix,args,&n);
	for ( i = 0 ; i < n; i++) {
		SetField(element,element->object->type, args[i].name, 
			args[i].value);
	}
	return(1);
}
