static char rcsid[] = "$Id: color.c,v 1.1 1992/12/11 19:08:19 dhb Exp $";

/*
** $Log: color.c,v $
** Revision 1.1  1992/12/11  19:08:19  dhb
** Initial revision
**
*/

#include "xo_head.h"
#include "xodus_ext.h"
#include "color_ext.h"

int dialog_background_color;
int dialog_foreground_color;
int toggle_background_color;
int label_background_color;
int label_foreground_color;
int form_background_color; 
int form_title_background_color;
int graph_background_color;
int	draw_background_color;

int xbutton_up_fg;
int xbutton_up_bg;
int xbutton_hilight;
int xbutton_unhilight;
int xbutton_down_fg;
int xbutton_down_bg;

int xtoggle_on_bg;
int xtoggle_on_fg;
int xtoggle_off_bg;
int xtoggle_off_fg;
int xtoggle_hilight;
int xtoggle_unhilight;


int	graph_fg;
int	graph_fg_error;
int	graph_bg;

static	Colormap	cmap;

unsigned long colorscale[NICONS];

int	RedColor, OrangeColor, YellowColor, GreenColor;
int	BlueColor, VioletColor, PurpleColor;
int	WhiteColor, BlackColor;


/*
** set_fixed_colors: Return the RGB entries for the ten default colors.
**
*/
set_fixed_colors()
{
	RedColor = name_to_color("red");
	OrangeColor = name_to_color("coral");
	YellowColor = name_to_color("yellow");
	GreenColor = name_to_color("green");
	BlueColor = name_to_color("blue");
	VioletColor = name_to_color("BlueViolet");
	PurpleColor = name_to_color("orchid");
}

/*
** SetColorScale:	Called when the user does an "xcolorscale".
**			This function branches on the argv[1] to 
**			the desired colorscale routine if the display
**			is color.
**
**			Also resets the global color_int's to 
**			the correct pixel value.
**
*/
void SetColorScale(scalename)
	char	*scalename;
{
	static char	*argv[] = {"xlogo"};
	int		i;
	Widget	x_ntw_get();


	if (XDisplayCells(display,XDefaultScreen(display)) < 255) {
		return;
	}
	for (i = 0 ; i < NICONS ; i++)
		colorscale[i] = 0;
	colorscale[0] = 256;
	set_fixed_colors();

	dialog_background_color = YellowColor;
	dialog_foreground_color = BlackColor;
	toggle_background_color = RedColor;
	label_background_color = BlueColor;
	label_foreground_color = BlackColor;
	form_background_color = VioletColor; 
	form_title_background_color = GreenColor;
	graph_background_color = WhiteColor;
	draw_background_color = WhiteColor;

	read_default_colors();
	if (!scalename) scalename = "hot";
	make_cmap(scalename);
}

/*
** read_default_colors:	Read in .Xdefault overrides on colors and/or
**			set the default values of various colors
**
*/
read_default_colors()
{
	char	*str;

	str = (char *)XGetDefault(display, "genesis","xbuttonForeground_up");
	if (str == NULL) 
		xbutton_up_fg = BlackColor;
	else 
		xbutton_up_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xbuttonForeground_down");
	if (str == NULL) 
		xbutton_down_fg = BlackColor;
	else 
		xbutton_down_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xbuttonBackground_up");
	if (str == NULL) 
		xbutton_up_bg = RedColor;
	else 
		xbutton_up_bg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xbuttonBackground_down");
	if (str == NULL) 
		xbutton_down_bg = OrangeColor;
	else 
		xbutton_down_bg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xbuttonHilight");
	if (str == NULL) 
		xbutton_hilight = GreenColor;
	else 
		xbutton_hilight = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xbuttonUnhilight");
	if (str == NULL) 
		xbutton_unhilight = BlackColor;
	else 
		xbutton_unhilight = name_to_color(str);

	/* toggle */
	str = (char *)XGetDefault(display, "genesis","xtoggleForeground_off");
	if (str == NULL) 
		xtoggle_off_fg = BlackColor;
	else 
		xtoggle_off_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xtoggleForeground_on");
	if (str == NULL) 
		xtoggle_on_fg = WhiteColor;
	else 
		xtoggle_on_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xtoggleBackground_off");
	if (str == NULL) 
		xtoggle_off_bg = RedColor;
	else 
		xtoggle_off_bg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xtoggleBackground_on");
	if (str == NULL) 
		xtoggle_on_bg = BlueColor;
	else 
		xtoggle_on_bg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xtoggleHilight");
	if (str == NULL) 
		xtoggle_hilight = GreenColor;
	else 
		xtoggle_hilight = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","xtoggleUnhilight");
	if (str == NULL) 
		xtoggle_unhilight = BlackColor;
	else 
		xtoggle_unhilight = name_to_color(str);

	/* graph */
	str = (char *)XGetDefault(display, "genesis","graphBackground");
	if (str == NULL) 
		graph_bg = WhiteColor;
	else 
		graph_bg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","graphForeground");
	if (str == NULL) 
		graph_fg = BlackColor;
	else 
		graph_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","graphForegroundError");
	if (str == NULL) 
		graph_fg_error = BlueColor;
	else 
		graph_fg = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","formBackground");
	if (str == NULL) 
		form_background_color = PurpleColor;
	else 
		form_background_color = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","formtitleBackground");
	if (str == NULL) 
		form_title_background_color = GreenColor;
	else 
		form_title_background_color = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","labelBackground");
	if (str == NULL) 
		label_background_color = GreenColor;
	else 
		label_background_color = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","labelForeground");
	if (str == NULL) 
		label_foreground_color = BlackColor;
	else 
		label_foreground_color = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","dialogBackground");
	if (str == NULL) 
		dialog_background_color = YellowColor;
	else 
		dialog_background_color = name_to_color(str);
	str = (char *)XGetDefault(display, "genesis","dialogForeground");
	if (str == NULL) 
		dialog_foreground_color = BlackColor;
	else 
		dialog_foreground_color = name_to_color(str);

	str = (char *)XGetDefault(display, "genesis","drawBackground");
	if (str == NULL) 
		draw_background_color = WhiteColor;
	else 
		draw_background_color = name_to_color(str);
}

/*
** make_cmap:	Build our colormap from the rgb table set up in the
** mapname file. 
**
*/
make_cmap(mapname)
	char	*mapname;
{
	int		screen;
	XColor		rgb[256],color[NICONS];
	double		sqrt();		/* for lint */
	int		ncolors;
	int		col,seg;
	float		scol,dcol;
	Window		root_window;
	Visual		*vis;
	FILE		*fp, *SearchForNonScript();
	int		i,j,r,g,b;
	char	str[40];

	screen = XDefaultScreen(display);
	if (XDisplayCells(display,screen) < 2)
		return;
	root_window = XDefaultRootWindow(display);
	vis = XDefaultVisual(display,screen);
	/*
	cmap = (Colormap)XCreateColormap(display,root_window,
		vis,AllocAll);
	*/
	cmap = DefaultColormap(display,0);

	fp = SearchForNonScript(mapname,"r");
	if (fp == NULL) {
		fprintf(stderr,"colormap file '%s' not found\n",mapname);
		return;
	}
	for (i = 0 ; i < 256 ; i++)  {
		if (!fscanf(fp,"%d%d%d",&r,&g,&b))
			break;
		if (feof(fp))
			break;
		rgb[i].red = r;
		rgb[i].green = g;
		rgb[i].blue = b;
	}
	for (j = 0 ; j < NICONS ; j++)
		color[j] = rgb[(i * j)/NICONS];

	/* Hack : checks if any colorscale has been allocated as yet */
	if (colorscale[0] != 256)
		XFreeColors(display,cmap,colorscale,NICONS,0);
	for (i = 0 ; i < NICONS ; i++) {
		if (XAllocColor(display,cmap,&color[i]) == 0) {
			fprintf(stderr,"Cannot allocate any more colors at i = %d. Try killing other applications\n",i);
			return;
		}
	}
	for (i = 0 ; i < NICONS ; i++) {
		colorscale[i] = color[i].pixel;
		sprintf(str,"%s%d",mapname,i);
		add_named_color(fillstr(str),colorscale[i]);
	}
}



/* this is a hack to get the monochrome colors set up. Sometime this 
** has to be cleaned up. 
*/
set_monochrome_colors()
{
	int i;

	WhiteColor = XWhitePixel(display,0);
	BlackColor = XBlackPixel(display,0);
	RedColor = WhitePixel(display, 0);
	OrangeColor = WhitePixel(display, 0);
	YellowColor = WhitePixel(display, 0);
	GreenColor = WhitePixel(display, 0);
	BlueColor = WhitePixel(display, 0);
	VioletColor = WhitePixel(display, 0);
	PurpleColor = WhitePixel(display, 0);

	dialog_background_color = WhiteColor;
	toggle_background_color = WhiteColor;
	label_background_color = WhiteColor;
	form_background_color = WhiteColor;
	form_title_background_color = WhiteColor;
	graph_background_color = WhiteColor;
	draw_background_color = WhiteColor;
	xbutton_up_fg = BlackColor;
	xbutton_up_bg = WhiteColor;
	xbutton_hilight = BlackColor;
	xbutton_unhilight = BlackColor;
	xbutton_down_fg = WhiteColor;
	xbutton_down_bg = BlackColor;
	xtoggle_on_bg = BlackColor;
	xtoggle_on_fg= WhiteColor;
	xtoggle_off_bg= WhiteColor;
	xtoggle_off_fg = BlackColor;
	xtoggle_hilight = BlackColor;
	xtoggle_unhilight= BlackColor;
	graph_fg = BlackColor;
	graph_fg_error = BlackColor;
	graph_bg = WhiteColor;
	form_background_color = BlackColor;
	label_background_color = WhiteColor;
	dialog_background_color = WhiteColor;
	toggle_background_color = WhiteColor;
	draw_background_color = WhiteColor;
	for (i = 0 ; i < NICONS/2 ; i++)
		colorscale[i] = BlackColor;
	for (i = NICONS/2 ; i < NICONS ; i++)
		colorscale[i] = WhiteColor;
}

