static char rcsid[] = "$Id: XoSetValues.c,v 1.3 1993/07/16 21:53:11 dhb Exp $";

/*
** $Log: XoSetValues.c,v $
** Revision 1.3  1993/07/16  21:53:11  dhb
** Replaced call to XtGetValues in XoGetAllPixValues to XtGetSubValues.  This
** fixes a problem related to resources of the same name in both the draw and
** the pix causing an error in DrawGetValuesHook.  We probably wanted to call
** the subresources routine anyways since we really want the pix resources!
**
** Revision 1.2  1993/06/29  23:02:01  dhb
** X11R5 patches
**
** Revision 1.1  1992/12/11  19:08:17  dhb
** Initial revision
**
*/

#include "xo_head.h"
#ifdef X11R5
#include <X11/Xresource.h>
#endif
#include <X11/StringDefs.h>
#ifndef X11R5
#include <X11/Quarks.h>
#endif
#include "xodus_defs.h"

#include "header.h"
#include "sim_defs.h"
#include "sim_struct.h"
#include "draw_struct.h"
#include "draw_w.h"

extern float Atof();
#define GENESIS TRUE

Widget XoGetWidgetFromString(name)
	char	*name;
{
	Widget w, x_ntw_get();
	Widget parent_w;
	char	*class;
	static 	path[200];

#ifdef GENESIS
	
#endif GENESIS

	if (!(parent_w = x_ntw_get(name))) {
		printf ("Could not find widget '%s'\n",name);
		return(NULL);
	}
	class = (XtClass(parent_w))->core_class.class_name;
	if (strcmp(class,"Layout") == 0) {
		w = XtNameToWidget(parent_w,"draw");
		if (!w)
			w = XtNameToWidget(parent_w,"graph");
	} else {
		w = parent_w;
	}
	if (!w) {
		printf ("Could not find subwidget of '%s'\n",name);
		return(NULL);
	}
	return(w);
}


XoSetValues(argc,argv)
	int	argc;
	char	**argv;
{
	Widget w, XoGetWidgetFromString();
	Arg		args[30];
	int		i;
	int		n = 0;

#ifdef  GENESIS
		char	path[100];
#endif

	if (argc < 2) {
		printf ("Usage: %s widgetname <-field value>.....\n",argv[0]);
        printf("<-viewpt x y z> <-center x y z> <-window w h>\n");
        printf("<-pos x y wid ht> <-range xmin xmax ymin ymax>\n");
		return;
	}

	if (!(w = XoGetWidgetFromString(argv[1]))) return;

    for (i = 2; i < argc ; i++) {
        if (argv[i][0] == '-') {
            XtSetArg(args[n],&(argv[i][1]),argv[i + 1]); n++ ; i++;
        }
    }
    XoSetValuesFromStrings(w,args,n);
}

int XoSetValuesFromStrings(w,args,nargs)
	Widget	w;
	ArgList	args;
	int		nargs;
{
	int		i,j = 0;
	XrmResourceList	*rl;
	int		num_resources;
	XrmQuark	xrm_name;
	char		*name;
	int		ret;

	if (!w) {
		fprintf(stderr,"widget null in XoSetValuesFromStrings\n");
		return(0);
	}
	rl = (XrmResourceList *)((XtClass(w))->core_class.resources);
	num_resources = (XtClass(w))->core_class.num_resources ; 

	ret = 0;
	for (i = 0 ; i < nargs; i++) {
		/* find if the field is defined in the resources */
		name = args[i].name;
		xrm_name = XrmStringToQuark(name);
		for (j = 0 ; j < num_resources ; j++) {
			if (rl[j]->xrm_name == xrm_name) {
				ret =1;
				break;
			}
		}
		/* If field is defined, convert it to the correct type */
		if (j < num_resources) {
			XoCvtStringToThings(rl[j]->xrm_type,args[i].value,
				&(args[i]));
		}
	}
	/* Set the widget values for all the fields , including the
	** subresource fields which remain in the form of strings. they
	** will be converted in the set-values-hook procedures using
	** a similar resource lookup mechanism to that used here.
	*/
	XtSetValues(w,args,nargs);
	/*
	** ret will be 0 if none of the arg fields (usually just a single) 
	** matched fields in the widget's resource records...
	*/
	return(ret);
}


		
XoCvtStringToThings(type,from,arg)
	XrmQuark	type;
	char	*from;
	Arg	*arg;
{
	char	*FuncTabelFindFunc();
	static int initialised = 0;
	float	*cheat;
	XtArgVal	temp;
#ifdef X11R5
	/* DKS -- instead of doing all those conversions every
	   time we want to compare (I'm assuming this routine will
	   be called fairly often to get widget attributes), we
	   arrange to compute the values once */

	static XrmQuark XtQBool;
	static XrmQuark XtQBoolean;
	static XrmQuark XtQDimension;
	static XrmQuark XtQFloat;
	static XrmQuark XtQFunction;
	static XrmQuark XtQInt;
	static XrmQuark XtQPosition;
	static XrmQuark XtQShort;
	static XrmQuark XtQString;

	if (!initialised) {
		initialised = 1;
		XtQBool = XrmStringToQuark(XtRBool) ;
		XtQBoolean = XrmStringToQuark(XtRBoolean) ;
		XtQDimension = XrmStringToQuark(XtRDimension) ;
		XtQFloat = XrmStringToQuark(XtRFloat) ;
		XtQFunction = XrmStringToQuark(XtRFunction) ;
		XtQInt = XrmStringToQuark(XtRInt) ;
		XtQPosition = XrmStringToQuark(XtRPosition) ;
		XtQShort = XrmStringToQuark(XtRShort) ;
		XtQString = XrmStringToQuark(XtRString) ;
	}
#else
	static XrmQuark XtQFloat;
	static XrmQuark XtQFunction;

	if (!initialised) {
		initialised = 1;
		XtQFloat = XrmStringToQuark(XtRFloat) ;
		XtQFunction = XrmStringToQuark(XtRFunction) ;
	}
#endif X11R5

	if(!from) {
		arg->value = NULL;
		return;
	}

	if (type == XrmStringToQuark(XtRBool)
	    || type == XrmStringToQuark(XtRBoolean) ) 
		arg->value = (from[0] == 't' || from[0] == 'T');
	else if (type == XrmStringToQuark(XtRFloat) )  {
		cheat = (float *)&(arg->value);
		*cheat = (float)Atof(from);
	}
	else if (type == XrmStringToQuark(XtRDimension)
		|| type == XrmStringToQuark(XtRInt)
		|| type == XrmStringToQuark(XtRPosition)
		|| type == XrmStringToQuark(XtRShort) )
		arg->value = atoi(from);
	else if (type == XrmStringToQuark(XtRString) ) 
		arg->value = (XtArgVal)fillstr(from);
	else if (type == XrmStringToQuark(XtRFunction) ) {
		temp = (XtArgVal)FuncTableFindFunc(from);
		if (temp)
			arg->value = temp;
		else {
			fprintf(stderr, "function '%s' not found\n",arg->name);
			arg->name = "invalid_func";
		}
	} 
}

#define MAXARGS 100



XoGetValues(argc,argv)
	int	argc;
	char	**argv;
{
	Widget w, XoGetWidgetFromString();
	char	*names[MAXARGS];
	Arg		args[MAXARGS];
	int		i,j;
	int		n = 0;
	int		allflag = 0;

	if (argc < 2) {
		printf ("Usage: %s widgetname <field>.....\n",argv[0]);
		printf("<viewpt> <center> <window>\n");
		printf("<pos> <range> <all>\n");
		return;
	}

	if (!(w = XoGetWidgetFromString(argv[1]))) return;

	for (i = 2; i < argc ; i++) {
		if (strcmp(argv[i], "all") == 0) {
			allflag = 1;
			break;
		}
	}
	if (allflag)
		XoGetAllValuesToStrings(w,args,&n);
	else
		XoGetValuesToStrings(w,names,args,&n);

	printf("Fields found for widget %s : \n",argv[1]);
	for (i = 0 ; i < n ; i++)
		printf("%20s ... %s\n",args[i].name, args[i].value);
}

/* 
** Takes a list of names and returns a list of valid args from those
** names with the values of the args as strings.
*/
XoGetValuesToStrings(w,names,args,nargs)
	Widget	w;
	char	**names;
	ArgList	args;
	int		*nargs;
{
	int		i,j = 0;
	int		n = 0;
	int		n_on_resource_list = 0;
	int		index_on_resource_list[50];
	XrmResourceList	*rl;
	int		num_resources;
	XrmQuark	xrm_name;
	char		*name;
	int		argsize = sizeof(XtArgVal);
	static XrmQuark xrm_type[50];

/*
** Looking up resource list for names
*/
	rl = (XrmResourceList *)((XtClass(w))->core_class.resources);
	num_resources = (XtClass(w))->core_class.num_resources ; 

	for (i = 0 ; i < *nargs; i++) {
		/* find if the field is defined in the resources */
		name = names[i];
		xrm_name = XrmStringToQuark(name);
		for (j = 0 ; j < num_resources ; j++) {
/* 
** checking for two things : if name is on list and if the size of
** the object is small enough to fit into the args.value.
*/
			if (rl[j]->xrm_name == xrm_name) {
				if (rl[j]->xrm_size <= argsize) {
					/* If field is ok, add it to args */
					XtSetArg(args[n],name,&(args[n].value));
					xrm_type[n] = rl[j]->xrm_type;
					index_on_resource_list[n_on_resource_list] = n;
					n_on_resource_list++;
					n++;
				}
				break;
			}
		}
		/* If field is not on resource list it is hopefully a 
		** subresource which should be of the valid types
		**
		** We are not going to take chances with this any
		** more, instead a separate routine should get subresources
		if (j >= num_resources) {
			XtSetArg(args[n],name,&(args[n].value)); n++;
		}
		*/
	}

	*nargs = n;
/*
** Get the widget values for all the fields which passed the test,
** including the subresource fields 
*/
	XtGetValues(w,args,n);

	for (i = 0 ; i < n_on_resource_list ; i++) {
		n = index_on_resource_list[i];
		XoCvtThingsToStrings(xrm_type[n],args[n].value,&(args[n]));
	}
}

/*
** Looks for all the valid fields in the resource list and 
** returns their names and values (converted to strings) in args
*/
XoGetAllValuesToStrings(w,args,nargs)
	Widget	w;
	ArgList	args;
	int		*nargs;
{
	int		i;
	int		n = 0;
	XrmResourceList	*rl;
	int		num_resources;
	XrmQuark	xrm_name;
	int		argsize = sizeof(XtArgVal);
	char		*name;
	static XrmQuark xrm_type[100];

/*
** Find all the names of the resources
*/
	rl = (XrmResourceList *)((XtClass(w))->core_class.resources);
	num_resources = (XtClass(w))->core_class.num_resources ; 

	for (i = 0 ; i < num_resources ; i++) {
		if (rl[i]->xrm_size <= argsize) {
			XtSetArg(args[n], XrmNameToString(rl[i]->xrm_name),
				&(args[n].value));
			xrm_type[n] = rl[i]->xrm_type;
			n++;
		}
	}

	*nargs = n;
/*
** Get the widget values for all the fields found from the 
** resources.
*/
	XtGetValues(w,args,num_resources);

/*
** Convert the values to strings
*/
	for (i = 0 ; i < n; i++) {
		XoCvtThingsToStrings(xrm_type[i],args[i].value,&(args[i]));
	}
}


XoCvtThingsToStrings(type,from,arg)
	XrmQuark	type;
	XtArgVal	from;
	Arg	*arg;
{
	static int initialised = 0;
	static	char  valstring[100];
	char	*temp, *FuncTableFindName();
#ifdef X11R5
	/* DKS -- instead of doing all those conversions every
	   time we want to compare (I'm assuming this routine will
	   be called fairly often to get widget attributes), we
	   arrange to compute the values once */

	static XrmQuark XtQBool;
	static XrmQuark XtQBoolean;
	static XrmQuark XtQDimension;
	static XrmQuark XtQFloat;
	static XrmQuark XtQFunction;
	static XrmQuark XtQInt;
	static XrmQuark XtQPosition;
	static XrmQuark XtQShort;
	static XrmQuark XtQString;

	if (!initialised) {
		initialised = 1;
		XtQBool = XrmStringToQuark(XtRBool) ;
		XtQBoolean = XrmStringToQuark(XtRBoolean) ;
		XtQDimension = XrmStringToQuark(XtRDimension) ;
		XtQFloat = XrmStringToQuark(XtRFloat) ;
		XtQFunction = XrmStringToQuark(XtRFunction) ;
		XtQInt = XrmStringToQuark(XtRInt) ;
		XtQPosition = XrmStringToQuark(XtRPosition) ;
		XtQShort = XrmStringToQuark(XtRShort) ;
		XtQString = XrmStringToQuark(XtRString) ;
	}
#else
	static XrmQuark XtQFloat;
	static XrmQuark XtQFunction;

	if (!initialised) {
		initialised = 1;
		XtQFloat = XrmStringToQuark(XtRFloat) ;
		XtQFunction = XrmStringToQuark(XtRFunction) ;
	}
#endif X11R5

	if (type == XrmStringToQuark(XtRBoolean) ) {
		temp = (char *)&(arg->value);
		temp = (*(Boolean *)(&from)) ? "TRUE" : "FALSE" ;
	} else if (type == XrmStringToQuark(XtRBool) ) {
		temp = (char *)&(arg->value);
		temp = (*(Bool *)(&from)) ? "TRUE" : "FALSE" ;
	} else if (type == XrmStringToQuark(XtRFloat) ) {
		sprintf(valstring,"%f",*(float *)(&from)) ;
		arg->value = (XtArgVal)fillstr(valstring);
	} else if (type == XrmStringToQuark(XtRDimension)) {
		sprintf(valstring,"%i",*(Dimension *)(&from));
		arg->value = (XtArgVal)fillstr(valstring);
	} else if (type == XrmStringToQuark(XtRInt)) {
		sprintf(valstring,"%i",*(int *)(&from));
		arg->value = (XtArgVal)fillstr(valstring);
	} else if (type == XrmStringToQuark(XtRPosition)) {
		sprintf(valstring,"%i",*(Position *)(&from));
		arg->value = (XtArgVal)fillstr(valstring);
	} else if (type == XrmStringToQuark(XtRShort)) {
		sprintf(valstring,"%i",*(short *)(&from));
		arg->value = (XtArgVal)fillstr(valstring);
	} else if (type == XrmStringToQuark(XtRString) ) {
		if (from)
			arg->value = (XtArgVal)fillstr(from);
		else {
			temp = (char *)&(arg->value);
			temp =  "nil";
		}
	} else if (type == XrmStringToQuark(XtRFunction) ) {
		temp = FuncTableFindName(from);
		if (temp)
			arg->value = (XtArgVal)fillstr(temp);
		else  {
			temp = (char *)&arg->value;
			temp = "Func not known";
		}
	} else {
		sprintf(valstring,"Unknown type '%s'",XrmQuarkToString(type)) ;
			arg->value = (XtArgVal)fillstr(valstring);
	}
}

XoCreateWidget(argc,argv)
	int	argc;
	char	**argv;
{
	
	if (argc < 3) {
		printf("Usage : %s widget_type widgetname \n",argv[0]);
        printf("<-field field>.......\n");
        printf("<-viewpt x y z> <-center x y z> <-window w h>\n");
        printf("<-pos x y wid ht> <-range xmin xmax ymin ymax>\n");
		return;
	}
	printf("Not yet implemented\n");
}


/* swiped from Xtoolkit source : I need the func, and they had
** static'ed it. */
void XoCopyFromArg(src, dst, size)
    XtArgVal src, dst;
    register unsigned int size;
{
    if (size == sizeof(XtArgVal))
    *(XtArgVal *)dst = src;
    else if (size == sizeof(short)) 
    *(short *)dst = (short)src;
    else if (size == sizeof(char))
        *(char *)dst = (char)src;
    else if (size < sizeof(XtArgVal))
    bcopy((char *) &src, (char *) dst, (int) size);
    else
    bcopy((char *) src, (char *) dst, (int) size);
}



/* 
** Something very weird happens with the resources here.
** Instead of the XrmResourceList * that I have for the rl's of the
** widgets, I have to use XrmResourceList without the pointer.
** One of you X Guru's out there please explain this to me.. I am just
** a poor Bio student who can't delve into the assembly code and figure
** it all out, I just want to get the bloody thing to work !!!
*/

int XoPixSet(pix,field,value)
	Pix	*pix;
	char	*field;
	char	*value;
{
	int		i,j;
	int		n = 0;
	XrmResourceList	rl;
	XrmQuark	xrm_name;
	int		argsize = sizeof(XtArgVal);
	char		*name;
	static XrmQuark xrm_type[100];
	Arg			arg;

/*
** Find all the names of the resources
*/
	rl = (XrmResourceList)pix->resources;

/* Resource lists are assumed to be in compiled form already via the
   initial XtGetSubresources calls */

	xrm_name = XrmStringToQuark(field);
	for (j = 0 ; j < pix->num_resources ; j++) {
		if (xrm_name == rl[j].xrm_name) {
			XoCvtStringToThings(rl[j].xrm_type,arg.value,
				&arg);
			XoCopyFromArg(arg.value,
				(XtArgVal) pix - rl[j].xrm_offset - 1,
				rl[j].xrm_size);
			return(1); /* Success */
		}
	}
	return(0);	/* Failure */
}

int XoIsPixResource(pix,field)
	Pix	*pix;
	char **field;
{
	int		i,j;
	XrmResourceList	rl;
	XrmQuark	xrm_name;

/*
** Find all the names of the resources
*/
	rl = (XrmResourceList)pix->resources;

/* Resource lists are assumed to be in compiled form already via the
   initial XtGetSubresources calls */

	xrm_name = XrmStringToQuark(field);
	for (j = 0 ; j < pix->num_resources ; j++) {
		if (xrm_name == rl[j].xrm_name) {
			return(1); /* Success */
		}
	}
	return(0);	/* Failure */
}

XoGetAllPixValues(w,pix,args,nargs)
	Widget w;
	Pix	*pix;
	ArgList	args;
	int		*nargs;
{
	int		i,j;
	XrmResourceList	rl;

/*
** Find all the names of the resources
*/
	rl = (XrmResourceList)pix->resources;

/* Resource lists are assumed to be in compiled form already via the
   initial XtGetSubresources calls */

	for (j = 0 ; j < pix->num_resources ; j++) {
		XtSetArg(args[j],XrmNameToString(rl[j].xrm_name),
			&(args[j].value));
	}
	*nargs = pix->num_resources;
	/*XtGetValues(w,args,pix->num_resources);*/
	XtGetSubvalues(pix,rl,pix->num_resources, args, *nargs);
	for (i = 0 ; i < pix->num_resources ; i++) {
		XoCvtThingsToStrings(rl[i].xrm_type,args[i].value,&(args[i]));
	}
}

