static char rcsid[] = "$Id: toggle_w.c,v 1.1 1992/12/11 19:07:53 dhb Exp $";

/*
** $Log: toggle_w.c,v $
** Revision 1.1  1992/12/11  19:07:53  dhb
** Initial revision
**
*/

#include "widg_ext.h"
#include "XoWhen.h"
#include "toggle_wP.h"
#include "LayoutP.h"


static XtResource resources[] = {
	{XtNcallback,  XtCCallback,  XtRCallback,  sizeof(caddr_t), 
		XtOffset(ToggleWidget,  toggle.my_callback_list), 
		XtRCallback,  (caddr_t)NULL
	}, 
	{XtNstate,  XtCState,  XtRInt,  sizeof(int), 
		XtOffset(ToggleWidget,  toggle.state), 
		XtRString,  (caddr_t)NULL
	}, 
	{XtNlabel0,  XtCLabel,  XtRString,  sizeof(char *), 
		XtOffset(ToggleWidget,  toggle.label0), 
		XtRString,  (caddr_t)NULL
	}, 
	{XtNlabel1,  XtCLabel,  XtRString,  sizeof(char *), 
		XtOffset(ToggleWidget,  toggle.label1), 
		XtRString,  (caddr_t)NULL
	}, 
	{XtNwhen,  XtCWhen,  XtRPointer,  sizeof(caddr_t), 
		XtOffset(ToggleWidget,  toggle.when), 
		XtRString,  (caddr_t)NULL
	}, 
};


static void Destroy();
void toggleNotify();
static void Set(),  Unset(),  Highlight(),  Unhighlight();

void toggleDisplay();

static char translations[] = "<EnterWindow>:Highlight()\n\
							<LeaveWindow>:Unhighlight()\n\
							<BtnDown>:	Set()\n\
							<BtnUp>:	toggleNotify() Unset()";

static XtActionsRec actionsList[] = {
		{"Highlight",  Highlight}, 
		{"Unhighlight",  Unhighlight}, 
		{"Set",  Set}, 
		{"Unset",  Unset}, 
		{"toggleNotify",  toggleNotify}, 
};

#ifdef X11R3
ToggleClassRec toggleClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &labelClassRec, 
    /* class_name		*/	"Toggle", 
    /* widget_size		*/	sizeof(ToggleRec), 
    /* class_initialize		*/	NULL, 
    /* class_part_initialize	*/	NULL, 
    /* class_inited		*/	FALSE, 
    /* initialize		*/	NULL, 
    /* initialize_hook		*/	NULL, 
    /* realize			*/	XtInheritRealize, 
    /* actions			*/	actionsList, 
    /* num_actions		*/	XtNumber(actionsList), 
    /* resources		*/	resources, 
    /* num_resources		*/	XtNumber(resources), 
    /* xrm_class		*/	NULLQUARK, 
    /* compress_motion		*/	TRUE, 
    /* compress_exposure	*/	TRUE, 
    /* compress_enterleave	*/	TRUE, 
    /* visible_interest		*/	FALSE, 
    /* destroy			*/	Destroy, 
    /* resize			*/	XtInheritResize, 
    /* expose			*/	toggleDisplay, 
    /* set_values		*/	NULL, 
    /* set_values_hook		*/	NULL, 
    /* set_values_almost	*/	XtInheritSetValuesAlmost, 
    /* get_values_hook		*/	NULL, 
    /* accept_focus		*/	NULL, 
    /* version			*/	XtVersion, 
    /* callback_private		*/	NULL, 
    /* tm_table			*/	translations, 
    /* query_geometry		*/	XtInheritQueryGeometry, 
    /* display_accelerator	*/	XtInheritDisplayAccelerator, 
    /* extension		*/	NULL
  }, 
  { /* template fields */
    /* empty			*/	0
  }
};
#else
ToggleClassRec genesisToggleClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &labelClassRec, 
    /* class_name		*/	"Toggle", 
    /* widget_size		*/	sizeof(ToggleRec), 
    /* class_initialize		*/	NULL, 
    /* class_part_initialize	*/	NULL, 
    /* class_inited		*/	FALSE, 
    /* initialize		*/	NULL, 
    /* initialize_hook		*/	NULL, 
    /* realize			*/	XtInheritRealize, 
    /* actions			*/	actionsList, 
    /* num_actions		*/	XtNumber(actionsList), 
    /* resources		*/	resources, 
    /* num_resources		*/	XtNumber(resources), 
    /* xrm_class		*/	NULLQUARK, 
    /* compress_motion		*/	TRUE, 
    /* compress_exposure	*/	TRUE, 
    /* compress_enterleave	*/	TRUE, 
    /* visible_interest		*/	FALSE, 
    /* destroy			*/	Destroy, 
    /* resize			*/	XtInheritResize, 
    /* expose			*/	toggleDisplay, 
    /* set_values		*/	NULL, 
    /* set_values_hook		*/	NULL, 
    /* set_values_almost	*/	XtInheritSetValuesAlmost, 
    /* get_values_hook		*/	NULL, 
    /* accept_focus		*/	NULL, 
    /* version			*/	XtVersion, 
    /* callback_private		*/	NULL, 
    /* tm_table			*/	translations, 
    /* query_geometry		*/	XtInheritQueryGeometry, 
    /* display_accelerator	*/	XtInheritDisplayAccelerator, 
    /* extension		*/	NULL
  },   /* CoreClass fields initialization */
  {
    XtInheritChangeSensitive	/* change_sensitive */
  },   /* SimpleClass fields initialization */
  {
    /* empty			*/	0
  },   /* LabelClass fields initialization */
  { /* template fields */
    /* empty			*/	0
  }    /* ButtonClass fields initialization */
};
#endif X11R3

#ifdef X11R3
WidgetClass toggleWidgetClass = (WidgetClass)&toggleClassRec;
#else
WidgetClass genesisToggleWidgetClass = (WidgetClass)&genesisToggleClassRec;
#endif X11R3

/*
** toggleNotify:	Called to change the toggle state.  
**			Calls any LayoutWidget callbacks which might
**			have been tagged onto this toggle and then
**			executes the desired script.
**
*/ 
void toggleNotify(w,  event)
	ToggleWidget w;
	XEvent *event;
{
	int		i;
	XtCallbackRec	*callback;
	w->toggle.state = !(w->toggle.state);

	toggleDisplay(w, event);
	if (((LayoutConstraints)(w->core.constraints))->layout.layout_callback 
		!= NULL) {
			callback = (XtCallbackRec *)
				(((LayoutConstraints)
				(w->core.constraints))->
				layout.layout_callback);
			i = 0;
			while (callback[i].callback != NULL) {
				(callback[i].callback)(w,
				callback[i].closure, NULL);
				i++;
			}
	}
	XtCallCallbacks(w,  XtNcallback,  w->toggle.state);
	XoExecuteButton(w,event);
}

/*
** Destroy:	Called when this widget is destroyed.
**
*/
static void Destroy(w)
		 Widget w;
{
	if (XtHasCallbacks(w, XtNcallback) == XtCallbackHasSome)
		XtRemoveAllCallbacks(w,  XtNcallback);
	XtDestroyWidget(w);
}

/*
** toggleDisplay:	Called to redisplay a toggle widget.
**			can be called Publically.
**
*/
void
toggleDisplay(w, event)
	ToggleWidget	w;
	XEvent	*event;
{
	GC	gc;
	XGCValues	values;
	int		x;
	int		font_wid = 6,  font_ht = 12;
	Display	*display;
	unsigned long WhiteColor, BlackColor;

	display = XtDisplay(w);

	gc = XtGetGC((Widget)w, GCForeground,  &values) ;

    BlackColor = XBlackPixel(display,XDefaultScreen(display));
    WhiteColor = XWhitePixel(display,XDefaultScreen(display));

    if (XDisplayCells(display,XDefaultScreen(display)) > 254) {
		if (w->toggle.state) {
			XSetForeground(display, gc, xtoggle_off_fg);
			XSetBackground(display, gc, xtoggle_off_bg);
		} else {
			XSetForeground(display, gc, xtoggle_on_fg);
			XSetBackground(display, gc, xtoggle_on_bg); 
		}
	} else {
		if (w->toggle.state) {
			XSetForeground(display, gc, WhiteColor);
			XSetBackground(display, gc, BlackColor);
		} else {
			XSetForeground(display, gc, BlackColor);
			XSetBackground(display, gc, WhiteColor); 
		}
	}

	if (w->toggle.label0 && w->toggle.state == 0) {
		x = (w->core.width/2) - (font_wid * strlen(w->toggle.label0)/2);
 		XPSDrawImageString(XtDisplay(w),  XtWindow(w),  gc, x, font_ht, 
	 		w->toggle.label0, strlen(w->toggle.label0));
	} else if (w->toggle.label1 && w->toggle.state == 1) {
		x = (w->core.width/2) - (font_wid * strlen(w->toggle.label1)/2);
 		XPSDrawImageString(XtDisplay(w),  XtWindow(w),  gc, x, font_ht, 
	 		w->toggle.label1, strlen(w->toggle.label1));
	} else {
		x = (w->core.width/2) - (font_wid * strlen(w->label.label)/2);
 		XPSDrawImageString(XtDisplay(w),  XtWindow(w),  gc, x, font_ht, 
	 		w->label.label, strlen(w->label.label));
	}
	if (XDisplayCells(display,XDefaultScreen(display)) > 254) {
		XSetForeground(display, gc, xtoggle_on_fg);
		XSetBackground(display, gc, xtoggle_on_bg); 
	} else {
		XSetForeground(display, gc, BlackColor);
		XSetBackground(display, gc, WhiteColor); 
	}
}


static void Highlight(w,event)
	ToggleWidget	w;
	XEvent	*event;
{
	Arg args[3];
	XWindowChanges	wcs;
	int n = 0;

	if (XDisplayCells(XtDisplay(w),XDefaultScreen(XtDisplay(w))) > 254){
		XtSetArg(args[n], XtNborderWidth, 2); n++;
		XtSetArg(args[n], XtNborderColor, xbutton_hilight); n++;
		XtSetValues(w,args,n);
	} else {
		wcs.border_width = 2;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}
}

static void Unhighlight(w,event)
	ToggleWidget	w;
	XEvent	*event;
{
	Arg args[3];
	XWindowChanges	wcs;

	int n = 0;
	if (XDisplayCells(XtDisplay(w),XDefaultScreen(XtDisplay(w))) > 254){
		XtSetArg(args[n], XtNborderWidth, 1); n++;
		XtSetArg(args[n], XtNborderColor, xbutton_unhilight); n++;
		XtSetValues(w,args,n);
	} else {
		wcs.border_width = 1;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}
}

static void Set(w,event)
	ToggleWidget	w;
	XEvent	*event;
{
	int	n;
	Arg	args[3];
	GC gc;
	XWindowChanges	wcs;
	XGCValues	values;
	unsigned long WhiteColor, BlackColor;

	n = 0;

    BlackColor = XBlackPixel(XtDisplay(w),XDefaultScreen(XtDisplay(w)));
    WhiteColor = XWhitePixel(XtDisplay(w),XDefaultScreen(XtDisplay(w)));
	if (XDisplayCells(XtDisplay(w),XDefaultScreen(XtDisplay(w))) > 254){
		XtSetArg(args[n], XtNbackground, xtoggle_on_bg); n++;
		XtSetValues(w,args,n);
	} else {
		gc = XtGetGC((Widget)w, GCForeground,  &values) ;
		XtSetArg(args[n], XtNbackground, BlackColor); n++;
		XtSetArg(args[n], XtNforeground, WhiteColor); n++;
		XSetForeground(XtDisplay(w), gc, WhiteColor);
		XSetBackground(XtDisplay(w), gc, BlackColor);
		XtSetValues(w,args,n);
		wcs.border_width = 2;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}	
}

static void Unset(w,event)
	ToggleWidget	w;
	XEvent	*event;
{
	int	n;
	Arg	args[3];
	GC gc;
	XWindowChanges	wcs;
	XGCValues	values;
	unsigned long WhiteColor, BlackColor;

	n = 0;

    BlackColor = XBlackPixel(XtDisplay(w),XDefaultScreen(XtDisplay(w)));
    WhiteColor = XWhitePixel(XtDisplay(w),XDefaultScreen(XtDisplay(w)));
	if (XDisplayCells(XtDisplay(w),XDefaultScreen(XtDisplay(w))) > 254){
		XtSetArg(args[n], XtNbackground, xtoggle_off_bg); n++;
		XtSetValues(w,args,n);
	} else {
		gc = XtGetGC((Widget)w, GCForeground,  &values) ;
		XtSetArg(args[n], XtNbackground, WhiteColor); n++;
		XtSetArg(args[n], XtNforeground, BlackColor); n++;
		XSetBackground(XtDisplay(w), gc, WhiteColor);
		XSetForeground(XtDisplay(w), gc, BlackColor);
		XtSetValues(w,args,n);
		wcs.border_width = 2;
		XConfigureWindow(XtDisplay(w), XtWindow(w),
			CWBorderWidth, &wcs);
	}
}


