static char rcsid[] = "$Id: graph_utils.c,v 1.1 1992/12/11 19:07:49 dhb Exp $";

/*
** $Log: graph_utils.c,v $
** Revision 1.1  1992/12/11  19:07:49  dhb
** Initial revision
**
*/

#include "widg_ext.h"
#ifdef X11R3
#include <X11/LabelP.h>
#else
#include <X11/Xaw/LabelP.h>
#endif X11R3
#include "graph_wP.h"
#include "innergraph_wP.h"

/*
** x_set_axis_graph_range:	Set the range on the graph specified.
**
*/
x_set_axis_graph_range(name, xmin, ymin, xmax, ymax)
	char	*name;
	float	xmin, ymin, xmax, ymax;
{
	Widget			w;
	GraphWidget	outer_gw;
	InnerGraphWidget		gw;

	outer_gw = (GraphWidget)x_ntw_get(name);
	if (outer_gw == NULL) {
		fprintf(stderr,"x_set_graph_range: bogus widget named %s\n",
			name);
		return;
	}
	gw = (InnerGraphWidget)XtNameToWidget(outer_gw, "internal_graph");
	if (gw == NULL) {
		fprintf(stderr,"x_set_graph_range: no internal graph widget\n");
		return;
	}
	
	outer_gw->graph.xmin = xmin;
	outer_gw->graph.ymin = ymin;
	outer_gw->graph.xmax = xmax;
	outer_gw->graph.ymax = ymax;
	gw->graph.xmin = xmin;
	gw->graph.ymin = ymin;
	gw->graph.xmax = xmax;
	gw->graph.ymax = ymax;

	graph_rescale(outer_gw);
}


/*
** x_set_simple_graph_range:	Set the range on the graph specified.
**
*/
x_set_simple_graph_range(name, xmin, ymin, xmax, ymax)
	char	*name;
	float	xmin, ymin, xmax, ymax;
{
}
/*
** get_graph_maxname:	Search through a linked list of graph curves
**			and return the char-length of the largest curve name.
**
*/
get_graph_maxname(info)
	GraphInfo	*info;
{
	int	ret = 0;
	while (info != NULL) {
		if (info->name != NULL && strlen(info->name) > ret)
			ret = strlen(info->name);
		info = info->next;
	}
	return(ret);
}

/*
** simple_graph_get_range:	sprintf the current range into the
**				strings passed.
**
*/
simple_graph_get_range(name, xmin, ymin, xmax, ymax)
	char	*name;
	char	*xmin, *ymin, *xmax, *ymax;
{
	InnerGraphWidget	gw;
	gw = (InnerGraphWidget)x_ntw_get(name);
	if (gw == NULL) {
		fprintf(stderr,"simple_graph_get_range: widget %s not found\n",
			name);
		return(0);
	}
	sprintf(xmin, "%f", gw->graph.xmin);
	sprintf(ymin, "%f", gw->graph.ymin);
	sprintf(xmax, "%f", gw->graph.xmax);
	sprintf(ymax, "%f", gw->graph.ymax);
	return(1);
}

/*
** axis_graph_get_range:	sprintf the current range into the
**				strings passed.
**
*/
axis_graph_get_range(name, xmin, ymin, xmax, ymax)
	char	*name;
	char	*xmin, *ymin, *xmax, *ymax;
{
	GraphWidget	ogw;
	InnerGraphWidget	gw;
	ogw = (GraphWidget)x_ntw_get(name);
	if (ogw == NULL) {
		fprintf(stderr,"axis_graph_get_range: widget %s not found\n",
			name);
		return(0);
	}
	gw = (InnerGraphWidget)XtNameToWidget(ogw, "internal_graph");
	if (gw == NULL ) {
		fprintf(stderr,"axis_graph_get_range: no internal graph\n");
		return(0);
	}
	sprintf(xmin, "%f", gw->graph.xmin);
	sprintf(ymin, "%f", gw->graph.ymin);
	sprintf(xmax, "%f", gw->graph.xmax);
	sprintf(ymax, "%f", gw->graph.ymax);
	return(1);
}
/*
** axis_graph_reset:	
*/
axis_graph_reset(name)
	char	*name;
{
	InnerGraphWidget	gw;
	GraphWidget	ogw;
	ogw = (GraphWidget)x_ntw_get(name);
	if (ogw == NULL) {
		fprintf(stderr,"axis_graph_refresh: couldn't find widget named '%s'\n", name);
		return;
	}
	gw = (InnerGraphWidget)XtNameToWidget(ogw, "internal_graph");
	if (gw == NULL) {
		fprintf(stderr,"axis_graph_refresh: couldn't find internal graph\n");
		return;
	}
	XClearArea(XtDisplay(gw), XtWindow(gw), 0,0,0,0,False);
	inner_graph_reset(gw);
}
