static char rcsid[] = "$Id: graph_fonts.c,v 1.1 1992/12/11 19:07:48 dhb Exp $";

/*
** $Log: graph_fonts.c,v $
** Revision 1.1  1992/12/11  19:07:48  dhb
** Initial revision
**
*/

#include "widg_ext.h"

XFontStruct	*graph_title_font;
XFontStruct	*graph_axis_font;
int		axis_width;
int		axis_height;
int		title_width;
int		title_height;

/*
** graph_font_init:	Set up the fonts used by our graph widgets
**			and a few width & height globals.
**
*/
graph_font_init(d)
	Display	*d;
{
	graph_title_font = (XFontStruct *)XLoadQueryFont(d, "6x10");
	if (graph_title_font == NULL) {
		fprintf(stderr,"graph_title_font failed\n");
		return;
	}

	title_width = graph_title_font->max_bounds.rbearing -
		graph_title_font->min_bounds.lbearing;
	title_height = graph_title_font->max_bounds.ascent + 
		graph_title_font->max_bounds.descent;

	graph_axis_font = (XFontStruct *)XLoadQueryFont(d, "6x10");
	if (graph_axis_font == NULL) {
		fprintf(stderr,"graph_axis_font failed\n");
		return;
	}

	axis_width = graph_axis_font->max_bounds.rbearing -
		graph_axis_font->min_bounds.lbearing;
	axis_height = graph_axis_font->max_bounds.ascent + 
		graph_axis_font->max_bounds.descent;
}
