static char rcsid[] = "$Id: dbut_w.c,v 1.2 1993/06/29 23:03:09 dhb Exp $";

/*
** $Log: dbut_w.c,v $
** Revision 1.2  1993/06/29  23:03:09  dhb
** X11R5 patches
**
** Revision 1.1  1992/12/11  19:07:47  dhb
** Initial revision
**
*/

#include "widg_ext.h"
#ifdef X11R3
#include <X11/AsciiText.h>
#else
#include <X11/Xaw/AsciiText.h>
#endif X11R3
#include "XoWhen.h"
#include "LayoutP.h"
#include "button_w.h"
#include "dbut_wP.h"
#define FONT_TEST

static XtResource resources[] = {
	{XtNcallback, XtCCallback, XtRCallback, sizeof(caddr_t),
		XtOffset(DbutWidget, dbut.callback),
		XtRCallback, (caddr_t)NULL
	},
	{XtNlabel, XtCLabel, XtRString, sizeof(String),
		XtOffset(DbutWidget, dbut.label),
		XtRString, (caddr_t)NULL
	},
	{XtNdefstring, XtCDefstring, XtRString, sizeof(String),
		XtOffset(DbutWidget, dbut.value),
		XtRString, (caddr_t)NULL
	},
	{XtNwhen, XtCWhen, XtRPointer, sizeof(caddr_t),
		XtOffset(DbutWidget, dbut.when),
		XtRString, (caddr_t)NULL
	},
	{XtNfontname, XtCFontname, XtRString, sizeof(String),
		XtOffset(DbutWidget, dbut.font),
		XtRString, (caddr_t)NULL
	},
};


static void Destroy();
static void ReturnEvent();
static void Resize();
static void dbutInitialise();
static void dbutClassPartInitialise();

static XtActionsRec DbutActList[] = {
	{"ReturnEvent", ReturnEvent},
};


DbutClassRec dbutClassRec = {
  { /* core fields */
    /* superclass		*/	(WidgetClass) &constraintClassRec,
    /* class_name		*/	"Dbut",
    /* widget_size		*/	sizeof(DbutRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	dbutInitialise,
    /* initialize_hook		*/	NULL,
    /* realize			*/	XtInheritRealize,
    /* actions			*/	DbutActList,
    /* num_actions		*/	XtNumber(DbutActList),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber(resources),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	Resize,
    /* expose			*/	XtInheritExpose,
    /* set_values		*/	NULL,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	NULL,
    /* query_geometry		*/	XtInheritQueryGeometry,
    /* display_accelerator	*/	XtInheritDisplayAccelerator,
    /* extension		*/	NULL,
  },
	{	XtInheritGeometryManager,
		XtInheritChangeManaged,
		XtInheritInsertChild,
		XtInheritDeleteChild,
	}
};

WidgetClass dbutWidgetClass = (WidgetClass)&dbutClassRec;

/*
** ReturnEvent:	This routine is called whenever the user hits return
**		or when the button is pressed.
**
**		It calls the appropriate callback and then calls any
**		callbacks specified if this dbut lives within a layout
**		widget.
*/
static void ReturnEvent(w,event)
	Widget	w;
	XEvent	*event;
{
	Widget	parent;
	Widget layoutparent;
#ifdef X11R3
	AsciiStringWidget	tw;
#else
	AsciiWidget	tw;
#endif X11R3
	Arg		arg[4];
	int		i;
	XtCallbackRec	*callback;
	int		n;
	char	*defstring;
	static XButtonEvent xbe = {ButtonPress, 0,FALSE, 
		NULL,NULL,NULL,NULL,0,0,0,0,0,Button1Mask,Button1,TRUE};

	layoutparent = XtParent(w);
	parent = XtParent((Widget)layoutparent);

#ifdef X11R3
	tw = (AsciiStringWidget)(XtNameToWidget(layoutparent,"text"));
#else
	tw = (AsciiWidget)(XtNameToWidget(layoutparent,"text"));
#endif X11R3
	if (tw==NULL) {
		fprintf(stderr,"dbut.ReturnEvent no text widget\n");
		return;
	}
	if (((LayoutConstraints)
		(parent->core.constraints))->layout.layout_callback 
		!= NULL) {
			callback = (XtCallbackRec *)
				(((LayoutConstraints)
				(parent->core.constraints))->
				layout.layout_callback);
			i = 0;
			while (callback[i].callback != NULL) {
				(callback[i].callback)(parent,
				callback[i].closure, NULL);
				i++;
			}
	}
	n = 0;
	XtSetArg(arg[n], XtNstring, &defstring);n++;
	XtGetValues(tw,arg,n);
	XtCallCallbacks(parent,XtNcallback,defstring);
	XoExecuteButton(parent,&xbe);
}

/*
** ButtonEvent:	Called when the user hits the button.  Do CallForwarding
**		to ReturnEvent.
**
*/
static void ButtonEvent(w,client_data,call_data)
	Widget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	ReturnEvent(w,(XEvent *)NULL);
}

/*
** Destroy:	Called when this widget is destroyed.
**
*/
static void Destroy(w)
	Widget w;
{
	if (XtHasCallbacks(w, XtNcallback) == XtCallbackHasSome)
		XtRemoveAllCallbacks(w,XtNcallback);
}


/*
**
** dbutInitialise: Create all the subwindows which comprise this Dbut.
**
*/
static void dbutInitialise(request,new)
	Widget request,new;
{
	char		*dbutname;
	char		*defstring;
	XtCallbackRec	*callback;
	DbutWidget	dw; 
	Widget		top;
	Widget	 	dialog_name, text;
	XtTranslations	parsed_translation;
	Dimension	width, label_width, label_ht;
	XFontStruct *font;
	Arg		arg[32];
	int		n;

	static String transtable = "\
		<Key>0xff0d: ReturnEvent()";

	static XtActionsRec actionTable[] = {
		{"ReturnEvent",	ReturnEvent},
	};

	
	dw = (DbutWidget)new;
	dbutname = dw->dbut.label;
	defstring = (char *) malloc(100 * sizeof(char));
	sprintf(defstring,"%s",dw->dbut.value);

	callback = (XtCallbackRec *) malloc(3 * sizeof(XtCallbackRec));

/* --------------------------------------------- */

	callback[1].callback = (XtCallbackProc)NULL ;
	callback[1].closure = (caddr_t)NULL ;

	width = dw->core.width;

	n = 0;
	XtSetArg(arg[n], XtNx, 0); n++;
	XtSetArg(arg[n], XtNy, 0); n++;
	XtSetArg(arg[n], XtNwidth, dw->core.width); n++;
	XtSetArg(arg[n], XtNheight, dw->core.height); n++;
	XtSetArg(arg[n], XtNbackground, dialog_background_color); n++;
	top = XtCreateManagedWidget("dbut_top", layoutWidgetClass,
		new, arg, n);

/*
**	Creating a label widget for the dialog 
*/
	callback[0].callback = ButtonEvent;
	callback[0].closure = (caddr_t)NULL ;
	n=0;
	XtSetArg(arg[n], XtNlayout_x, 5); n++;
	XtSetArg(arg[n], XtNlayout_y, 1); n++;
	XtSetArg(arg[n], XtNlayout_w, (strlen(dbutname)+3) * 7); n++;
	XtSetArg(arg[n], XtNlayout_h, 26); n++;
	XtSetArg(arg[n], XtNytype, LAYOUT_RELATIVE); n++;
	XtSetArg(arg[n], XtNlabel, dbutname);n++;
	XtSetArg(arg[n], XtNbackground, xbutton_up_bg);n++;
	XtSetArg(arg[n], XtNcallback, callback);n++;
	dialog_name = XtCreateManagedWidget(dbutname, buttonWidgetClass,
		top, arg, n);

	n=0;
	XtSetArg(arg[n], XtNlayout_x, 10 + (strlen(dbutname)+3) * 7); n++;
	XtSetArg(arg[n], XtNlayout_y, 1); n++;
	XtSetArg(arg[n], XtNlayout_w, 10); n++;
	XtSetArg(arg[n], XtNlayout_h, dw->core.height-2); n++;
	XtSetArg(arg[n], XtNlayout_ww,"NULL.right"); n++; /* to end of form*/

	XtSetArg(arg[n], XtNytype, LAYOUT_RELATIVE); n++;
	XtSetArg(arg[n], XtNwidthtype, LAYOUT_RIGHT); n++;
#ifdef FONT_TEST
	if (dw->dbut.font && strlen(dw->dbut.font) > 1) {
		font=XLoadQueryFont(XtDisplay(dw),dw->dbut.font);
		if (font) {
			XtSetArg(arg[n], XtNfont, font); n++;
		} else {
			printf("Could not find font %s\n",dw->dbut.font);
		}
	}
#endif
	
#ifdef X11R3
	XtSetArg(arg[n], XtNeditType, XttextEdit);n++;
	XtSetArg(arg[n], XtNtextOptions, editable);n++;
#else
#ifdef X11R5
	XtSetArg(arg[n], XtNeditType, XawtextEdit);n++;
	/* XtSetArg(arg[n], XtNuseStringInPlace, True);n++; */
#else
	XtSetArg(arg[n], XtNeditType, XtEtextEdit);n++;
#endif X11R5
#endif X11R3
	XtSetArg(arg[n], XtNlength, 100);n++;
	XtSetArg(arg[n], XtNstring, defstring);n++;
	XtSetArg(arg[n], XtNinsertPosition, strlen(defstring));n++;
	XtSetArg(arg[n], XtNleftMargin, 4);n++;
	XtSetArg(arg[n], XtNbackground, dialog_background_color);n++;
#ifdef X11R3
	text = XtCreateManagedWidget("text", asciiStringWidgetClass,
		top, arg, n);
#else
	text = XtCreateManagedWidget("text", asciiTextWidgetClass,
		top, arg, n);
#endif X11R3
	XtAddActions(actionTable,1);
	parsed_translation = XtParseTranslationTable(transtable);
	XtOverrideTranslations(text,parsed_translation);
}

/*
** Resize:	Called when a dbut is resized
**
*/
static void Resize(w)
	Widget	w;
{
	Widget	top;
	top = XtNameToWidget(w, "dbut_top");
	if (top == NULL)
		return;
	XtResizeWidget(top, w->core.width, w->core.height,
		 w->core.border_width);
}

/*
**	Public routine for getting string value of text window
*/
char *DbutGetString(w)
	Widget	w;
{
	Widget	text;
	Widget	top;
	Arg		arg[4];
	int		n;
	char	*value;
#ifdef RICH_MURPHEY_FIX
	char	*s;
#endif

	top = XtNameToWidget(w, "dbut_top");
	text = XtNameToWidget(top,"text");

	n=0;
	XtSetArg(arg[n], XtNstring, &value);n++;
	XtGetValues(text,arg,n);

#ifdef RICH_MURPHEY_FIX
	/* XXX This shouldn't be needed and is a memory leak. Rich */
	s = (char*) malloc((strlen(value)+1) * sizeof(char));
	strcpy(s, value);
#else
	return(value);
#endif
}

/*
** DbutSetString:	Public routine to let users set contents of a dbut.
**
*/
int DbutSetString(w,string)
	Widget	w;
	char	*string;
{
	char	*oldstring;
	Arg		arg[4];
	int		n, oldlength;
	Widget	text;
	Widget	top;
#ifdef X11R3
	XtTextBlock	tblock;
#else
	XawTextBlock	tblock;
#endif X11R3

	if (!string)
		return(0);
	top = XtNameToWidget(w,"dbut_top");
	text = XtNameToWidget(top,"text");
	if (text == NULL) {
		fprintf(stderr,"DbutSetString: \"text\" not found\n");
		return(0);
	}

	tblock.firstPos = 0;
	tblock.ptr = string;
	tblock.length = strlen(tblock.ptr);
	tblock.format = FMT8BIT;

#ifdef X11R3
	XtTextReplace(text,0,90,&tblock);
#else
#ifdef X11R5
	XtSetArg(arg[0], XtNstring, &oldstring);
	XtGetValues(XawTextGetSource(text), arg, 1);
	oldlength = strlen(oldstring);
	/* fprintf(stderr, "string: %s\n", string); */
	if (XawTextReplace(text, 0, oldlength, &tblock) != XawEditDone)
	    fprintf(stderr, "DbutSetString: XawTextReplace failed.\n");
#else
	XawTextReplace(text,0,90,&tblock);
#endif X11R5
#endif X11R3

	/*
	n = 0;
	XtSetArg(arg[n], XtNstring, &newstring);n++;
	XtGetValues(text,arg,n);
	sprintf(newstring,"%s",string);
	n = 0;
	XtSetArg(arg[n], XtNinsertPosition, strlen(newstring));n++;
	XtSetValues(text,arg,n);
	if (text->core.visible)  {
		XClearArea(XtDisplay(text),XtWindow(text),0,0,0,0,True);
		XFlush(XtDisplay(text));
	}
	*/
	return(1);
}

/*
** DbutSetValue:	Set contents of a dbut widget by name.
**
*/
DbutSetValue(wname,value)
char *wname;
char *value;
{
	Widget w;
	Widget x_ntw_get();

	if(w = x_ntw_get(wname)) {
		DbutSetString(w,value);
	}
}
