/*
** $Id: LayoutP.h,v 1.1 1992/12/11 19:07:58 dhb Exp $
** $Log: LayoutP.h,v $
** Revision 1.1  1992/12/11  19:07:58  dhb
** Initial revision
**
*/

#ifndef _LayoutP_h
#define _LayoutP_h

#include "Layout.h"
#include <X11/ConstrainP.h>

typedef struct {int empty;} LayoutClassPart;

typedef struct _LayoutClassRec {
    CoreClassPart	core_class;
    CompositeClassPart	composite_class;
    ConstraintClassPart	constraint_class;
    LayoutClassPart	layout_class;
} LayoutClassRec;

extern LayoutClassRec layoutClassRec;

typedef struct _LayoutPart {
    Dimension   last_width;
    Dimension   last_height;
    XtCallbackList layout_callback;
    caddr_t	layout_element;
} LayoutPart;

typedef struct _LayoutRec {
    CorePart		core;
    CompositePart	composite;
    ConstraintPart	constraint;
    LayoutPart		layout;
} LayoutRec;

typedef struct _LayoutConstraintsPart {
    Boolean append;	/* add to next available y position	*/
    int	xtype;		/* abs or relative 			*/
    int	ytype;		/* abs or relative 			*/
    int	widthtype;	/* abs or relative 			*/
    int	heightype;	/* abs or relative 			*/
    int		layout_x;
    int		layout_y;
    int		layout_w;
    int		layout_h;
    char	*layout_wx;
    char	*layout_wy;
    char	*layout_ww;
    char	*layout_wh;
    XtCallbackList layout_callback;
    caddr_t	layout_element;
} LayoutConstraintsPart;

typedef struct _LayoutConstraintsRec {
    LayoutConstraintsPart	layout;
} LayoutConstraintsRec, *LayoutConstraints;

#endif _LayoutP_h
