static char rcsid[] = "$Id: Layout.c,v 1.1 1992/12/11 19:07:45 dhb Exp $";

/*
** $Log: Layout.c,v $
** Revision 1.1  1992/12/11  19:07:45  dhb
** Initial revision
**
*/

/*#define DEBUG/**/
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>
#ifdef X11R3
#include <X11/Xmu.h>
#else
#include <X11/Xmu/Xmu.h>
#endif X11R3
#include "LayoutP.h"
#include <X11/CoreP.h>

#ifdef X11R3
#include <X11/LabelP.h>
#else
#include <X11/Xaw/LabelP.h>
#endif X11R3

#include <stdio.h>
#include <math.h>

static 	Boolean	defappend = FALSE;
static 	int	deftype = LAYOUT_ABSOLUTE;
static 	Position defcoord = 0;
static 	Dimension	defdimen = 100;
static	char	*defstr = NULL;

#define Offset(field) XtOffset(LayoutWidget, layout.field)
static XtResource layoutResources[] = {
	{XtNlayout_callback, XtCCallback, XtRCallback, sizeof(caddr_t),
		Offset(layout_callback), XtRCallback, (caddr_t)NULL},
	{XtNlayout_element, XtCLayoutElement, XtRPointer, sizeof(caddr_t),
		Offset(layout_element), XtRPointer, (caddr_t)NULL},
};
#undef Offset

#define Offset(field) XtOffset(LayoutConstraints, layout.field)

static XtResource layoutConstraintResources[] = {
	{XtNappend, XtCBoolean, XtRBoolean, sizeof(Boolean),
		Offset(append), XtRBoolean, (caddr_t)&defappend },

	{XtNxtype, XtCThickness, XtRInt, sizeof(int),
		Offset(xtype), XtRInt, (caddr_t)&deftype },
	{XtNytype, XtCThickness, XtRInt, sizeof(int),
		Offset(ytype), XtRInt, (caddr_t)&deftype },
	{XtNwidthtype, XtCThickness, XtRInt, sizeof(int),
		Offset(widthtype), XtRInt, (caddr_t)&deftype },
	{XtNheightype, XtCThickness, XtRInt, sizeof(int),
		Offset(heightype), XtRInt, (caddr_t)&deftype },

	{XtNlayout_x, XtCThickness, XtRInt, sizeof(int),
		Offset(layout_x), XtRInt, (caddr_t)&defcoord },
	{XtNlayout_y, XtCThickness, XtRInt, sizeof(int),
		Offset(layout_y), XtRInt, (caddr_t)&defcoord },
	{XtNlayout_w, XtCThickness, XtRInt, sizeof(int),
		Offset(layout_w), XtRInt, (caddr_t)&defdimen },
	{XtNlayout_h, XtCThickness, XtRInt, sizeof(int),
		Offset(layout_h), XtRInt, (caddr_t)&defdimen },

	{XtNlayout_wx, XtCWidgetString, XtRWidgetString, sizeof(char *),
		Offset(layout_wx), XtRWidgetString, (caddr_t)&defstr},
	{XtNlayout_wy, XtCWidgetString, XtRWidgetString, sizeof(char *),
		Offset(layout_wy), XtRWidgetString, (caddr_t)&defstr},
	{XtNlayout_ww, XtCWidgetString, XtRWidgetString, sizeof(char *),
		Offset(layout_ww), XtRWidgetString, (caddr_t)&defstr},
	{XtNlayout_wh, XtCWidgetString, XtRWidgetString, sizeof(char *),
		Offset(layout_wh), XtRWidgetString, (caddr_t)&defstr},

	{XtNlayout_callback, XtCCallback, XtRCallback, sizeof(caddr_t),
		Offset(layout_callback), XtRCallback, (caddr_t)NULL},

	{XtNlayout_element, XtCLayoutElement, XtRPointer, sizeof(caddr_t),
		Offset(layout_element), XtRPointer, (caddr_t)NULL},
};
#undef Offset

static void Initialize(), Resize(), Resize2();
static void ConstraintInitialize(), ClassInit();
static Boolean SetValues(), ConstraintSetValues();
static XtGeometryResult GeometryManager();
static void ChangeManaged();

LayoutClassRec layoutClassRec = {
  { /* core_class fields */
	/* superclass		*/	(WidgetClass) &constraintClassRec,
	/* class_name		*/	"Layout",
	/* widget_size		*/	sizeof(LayoutRec),
	/* class_initialize	*/	ClassInit,
	/* class_part_init	*/	NULL,
	/* class_inited		*/	FALSE,
	/* initialize		*/	Initialize,
	/* initialize_hook	*/	NULL,
	/* realize		*/	XtInheritRealize,
	/* actions		*/	NULL,
	/* num_actions		*/	0,
	/* resources		*/	layoutResources,
	/* num_resources	*/	XtNumber(layoutResources),
	/* xrm_class		*/	NULLQUARK,
	/* compress_motion	*/	TRUE,
	/* compress_exposure 	*/	TRUE,
	/* compress_enterleave	*/	TRUE,
	/* visible_interest   	*/	FALSE,
	/* destroy		*/	NULL,
	/* resize		*/	Resize,
	/* expose		*/	XtInheritExpose,
	/* set_values		*/	SetValues,
	/* set_values_hook	*/	NULL,
	/* set_values_almost  	*/	XtInheritSetValuesAlmost,
	/* get_values_hook	*/	NULL,
	/* accept_focus	   	*/	NULL,
	/* version		*/	XtVersion,
	/* callback_private   	*/	NULL,
	/* tm_table		*/	NULL,
	/* query_geometry	*/	XtInheritQueryGeometry,	/* fix this! */
	/* display_accelerator	*/	XtInheritDisplayAccelerator,
	/* extension		*/	NULL
  },
  { /* composite_class fields	*/
	/* geometry_manager   	*/   GeometryManager,
	/* change_managed	*/   ChangeManaged,
	/* insert_child	   	*/   XtInheritInsertChild,
	/* delete_child	   	*/   XtInheritDeleteChild,
	/* extension		*/   NULL
  },
  { /* constraint_class fields	*/
	/* subresourses	   	*/   layoutConstraintResources,
	/* subresource_count  	*/   XtNumber(layoutConstraintResources),
	/* constraint_size	*/   sizeof(LayoutConstraintsRec),
	/* initialize		*/   ConstraintInitialize,
	/* destroy		*/   NULL,
	/* set_values		*/   ConstraintSetValues,
	/* extension		*/   NULL
  },
  { /* layout_class fields */
	/* empty		*/   0
  }
};

WidgetClass layoutWidgetClass = (WidgetClass)&layoutClassRec;

/****************************************************************
 *
 * Private Procedures
 *
 ****************************************************************/

static void ClassInit()
{
    static XtConvertArgRec parentCvtArgs[] = {
	{XtBaseOffset, (caddr_t)XtOffset(Widget, core.parent), sizeof(Widget)}
    };
    XtAddConverter( XtRString, XtRWidgetString, XmuCvtStringToWidget,
			parentCvtArgs, XtNumber(parentCvtArgs));
}

static void Initialize(request, new)
	LayoutWidget request, new;
{
#ifdef DEBUG
	fprintf(stderr,"Entering Initialize on widget %s\n",
		new->core.name);
#endif DEBUG
	new->layout.last_width = -1;
	new->layout.last_height = -1;
	Resize2(new, 0);
}



static void Resize(w)
	LayoutWidget w;
{
	Resize2(w, 0);
}
	
static void Resize2(w, flag)
	LayoutWidget w;
	int	flag;
{
	int		i;
	int		xtype, ytype, widthtype, heightype, frombottom;
	Dimension	p_width, p_height;
	Position	x, y;
	Dimension	width, height;
	Widget		child;
	float		layout_x, layout_y, layout_w, layout_h;
	char		*layout_wx, *layout_wy, *layout_ww, *layout_wh;
	LayoutWidget	widget_x, widget_y, widget_w, widget_h;
	Boolean		height_changed, width_changed;
	XtCallbackRec	*callback;
	XtCallbackProc	callback_proc;
	caddr_t		callback_closure;

#ifdef DEBUG
	fprintf(stderr,"Entering Resize on widget %s -[%d x %d]-\n",
		w->core.name, w->core.height, w->core.width);
#endif DEBUG
	height_changed = width_changed = FALSE;


	p_width = w->core.width;
	p_height = w->core.height;

	if (p_width != w->layout.last_width)
		width_changed = TRUE;
	if (p_height != w->layout.last_height)
		height_changed = TRUE;

	w->layout.last_width = p_width;
	w->layout.last_height = p_height;

	/* If a LayoutWidget changes size then resize it.  If a callback
	** has been registered for this widget then call it... 
	*/
	if (height_changed || width_changed) {
		XtResizeWidget(w, p_width, p_height, w->core.border_width);
		if (w->layout.layout_callback != NULL)
#ifdef mips
		xform_callback(w, NULL, NULL);
#else
		XtCallCallbacks(w, XtNlayout_callback, "NULL");
#endif mips
	}
	

	for (i = 0; i < w->composite.num_children; i++) {
		child = w->composite.children[i];
		if (XtIsRealized(child))
			XRaiseWindow(XtDisplay(child), XtWindow(child));
		xtype = ((LayoutConstraints)(child->core.constraints))->
			layout.xtype;
		ytype = ((LayoutConstraints)(child->core.constraints))->
			layout.ytype;
		widthtype = ((LayoutConstraints)(child->core.constraints))->
			layout.widthtype;
		heightype = ((LayoutConstraints)(child->core.constraints))->
			layout.heightype;
		layout_x =  (float)(
			((LayoutConstraints)(child->core.constraints))->
			layout.layout_x);
		layout_y = (float)(
			((LayoutConstraints)(child->core.constraints))->
			layout.layout_y);
		layout_w = (float)(
			((LayoutConstraints)(child->core.constraints))->
			layout.layout_w);
		layout_h = (float)(
			((LayoutConstraints)(child->core.constraints))->
			layout.layout_h);
		
		layout_wx =  ((LayoutConstraints)(child->core.constraints))->
			layout.layout_wx;
		layout_wy = ((LayoutConstraints)(child->core.constraints))->
			layout.layout_wy;
		layout_ww = ((LayoutConstraints)(child->core.constraints))->
			layout.layout_ww;
		layout_wh = ((LayoutConstraints)(child->core.constraints))->
			layout.layout_wh;

		layout_convert_widget(layout_wx, &widget_x, &xtype, w);	
		layout_convert_widget(layout_wy, &widget_y, &ytype, w);	
		layout_convert_widget(layout_ww, &widget_w, &widthtype, w);	
		layout_convert_widget(layout_wh, &widget_h, &heightype, w);	

#ifdef DEBUG
	fprintf(stderr,"the strings are: %s/%s/%s/%s\n",
		layout_wx, layout_wy, layout_ww, layout_wh);


		fprintf(stderr,"CHILD %s\n", child->core.name);
		fprintf(stderr,"\tlayouts: %f %f %f %f\n",
			layout_x, layout_y, layout_w, layout_h);
		fprintf(stderr,"\ttypes: %d %d %d %d\n",
			xtype, ytype, widthtype, heightype);
		if (widget_x != NULL)
			fprintf(stderr,"\t\twx = %s\n", widget_x->core.name);
		if (widget_y != NULL)
			fprintf(stderr,"\t\twy = %s\n", widget_y->core.name);
		if (widget_w != NULL)
			fprintf(stderr,"\t\tww = %s\n", widget_w->core.name);
		if (widget_h != NULL)
			fprintf(stderr,"\t\twh = %s\n", widget_h->core.name);
#endif DEBUG
		x = child->core.x;
		y = child->core.y;
		width = child->core.width;
		height = child->core.height;
#ifdef DEBUG
		fprintf(stderr,"\tcurrents: %d %d %d %d\n",
			x, y, width,height);
#endif

		if (width_changed || flag) {
			switch (xtype) {
				case (LAYOUT_ABSOLUTE):
				case (LAYOUT_LEFT):
					x = layout_x;
					break;
				case (LAYOUT_RIGHT):
					x = p_width - layout_x;
					break;
				case (LAYOUT_RELATIVE):
					x = (Position)(((float)(p_width)) * 
						((float)(layout_x)/100.0));
					break;
				case (LAYOUT_WIDGET):
				case (LAYOUT_WIDGET | LAYOUT_RIGHT):
					x = (Position)(
						widget_x->core.x +
						widget_x->core.width + 
						layout_x);
					break;
				case (LAYOUT_WIDGET | LAYOUT_LEFT):
					x = (Position)(
						widget_x->core.x -
						layout_x);
					break;
				default:
					fprintf(stderr,
						"Invalid Layout [xtype %d]\n",
						 xtype);
					break;
			}
			switch (widthtype)  {
				case (LAYOUT_ABSOLUTE):
				case (LAYOUT_ABSOLUTE | LAYOUT_WIDTH):
					width = (Dimension)( layout_w );
					break;
				case (LAYOUT_RELATIVE):
				case (LAYOUT_RELATIVE | LAYOUT_WIDTH):
					width = (Dimension)(((float)(p_width))* 
						((float)(layout_w)/100.0));
					break;
				case (LAYOUT_RIGHT): /* remaining space */
					width = (Dimension)(p_width - x - 
						layout_w);
					break;
				case (LAYOUT_RIGHT | LAYOUT_RELATIVE): /*%rem*/
					width = (Dimension)(((float)
						(p_width - x))* 
						((float)(layout_w)/100.0));
					break;
				case (LAYOUT_WIDGET):
				case (LAYOUT_WIDGET | LAYOUT_WIDTH):
					width = (Dimension)(
						widget_w->core.width +
						layout_w);
					break;
				case (LAYOUT_WIDGET | LAYOUT_RELATIVE):
				case (LAYOUT_WIDGET |
					 LAYOUT_RELATIVE | LAYOUT_WIDTH):
					width = (Dimension)(
						((float)(widget_w->core.width))
						* ((float)(layout_w)/100.0));
					break;
				case (LAYOUT_WIDGET | LAYOUT_RIGHT):
					width = (Dimension)( 
						abs(widget_w->core.x - x) + 
						layout_w);
					break;
				case (LAYOUT_WIDGET | LAYOUT_RIGHT | 
					LAYOUT_RELATIVE):
					width = (Dimension)(
						((float)
						(widget_w->core.width - x))
						* ((float)(layout_w)/100.0));
					break;
				default:
					fprintf(stderr,
						"Invalid Layout [wtype %d]\n",
						 widthtype);

			 }
		 }
		if (height_changed || flag) {
			switch (ytype) {
				case (LAYOUT_ABSOLUTE | LAYOUT_TOP):
				case (LAYOUT_ABSOLUTE):
					y = layout_y;
					break;
				case (LAYOUT_BOTTOM):
					y = (Position)( p_height - layout_y);
					break;
				case (LAYOUT_RELATIVE):
				case (LAYOUT_RELATIVE | LAYOUT_TOP):
					y = (Position)(((float)(p_height)) * 
						((float)(layout_y)/100.0));
					break;
				case (LAYOUT_RELATIVE | LAYOUT_BOTTOM):
					y = p_height - 
						(Position)(((float)(p_height))
						 * ((float)(layout_y)/100.0));
					break;
				case (LAYOUT_WIDGET):
				case (LAYOUT_WIDGET | LAYOUT_BOTTOM):
					y = (Position)(
						widget_y->core.y +
						widget_y->core.height + 
						layout_y);
					break;
				case (LAYOUT_WIDGET | LAYOUT_TOP):
					y = (Position)(
						widget_y->core.y -
						layout_y);
					break;
				default:
					fprintf(stderr,
						"Invalid Layout [ytype %d]\n",
						 ytype);
					break;
			}
			switch (heightype)  {
				case (LAYOUT_ABSOLUTE):
				case (LAYOUT_ABSOLUTE | LAYOUT_HEIGHT):
					height = (Dimension)layout_h;
					break;
				case (LAYOUT_RELATIVE):
				case (LAYOUT_RELATIVE | LAYOUT_HEIGHT):
					height = (Dimension)(((float)(p_height))
						* ((float)(layout_h)/100.0));
					break;
				case (LAYOUT_BOTTOM):
					height = (Dimension)(p_height - y - 
						layout_h);
					break;
				case (LAYOUT_BOTTOM | LAYOUT_RELATIVE):
					height = (Dimension)(((float)
						(p_height - y))* 
						((float)(layout_h)/100.0));
					break;
				case (LAYOUT_WIDGET):
				case (LAYOUT_WIDGET | LAYOUT_HEIGHT):
					height = (Dimension)(
						widget_h->core.height +
						layout_h);
					break;
				case (LAYOUT_WIDGET | LAYOUT_RELATIVE):
				case (LAYOUT_WIDGET |
					 LAYOUT_RELATIVE | LAYOUT_HEIGHT):
					height = (Dimension)(
						((float)(widget_h->core.height))
						* ((float)(layout_h)/100.0));
					break;
				case (LAYOUT_WIDGET | LAYOUT_TOP):
					height = (Dimension)( 
						widget_h->core.y - y - 
						layout_h);
					break;
				case (LAYOUT_WIDGET | LAYOUT_TOP | 
					LAYOUT_RELATIVE):
					height = (Dimension)(
						((float)
						(widget_h->core.y - y))
						* ((float)(layout_h)/100.0));
					break;
				case (LAYOUT_WIDGET | LAYOUT_BOTTOM):
					height = (Dimension)( 
						abs(widget_h->core.y + 
						widget_h->core.height - y) + 
						layout_h);
					break;
				case (LAYOUT_WIDGET | LAYOUT_BOTTOM | 
					LAYOUT_RELATIVE):
					height = (Dimension)(
						((float)
						(widget_h->core.y +
						widget_h->core.height - y))
						* ((float)(layout_h)/100.0));
					break;
				default:
					fprintf(stderr,
						"Invalid Layout [wtype %d]\n",
						 heightype);

			 }
		}
#ifdef DEBUG
		fprintf(stderr,"child %s -> [%d, %d x %d %d] %d\n",
			child->core.name, x, y, width, height,
			child->core.border_width);
#endif DEBUG
		if (width == 0) {
			fprintf(stderr,"WIDTH is ZERO\n");
			width = 10;
		}
		if (height == 0) {
			fprintf(stderr,"HEIGHT is ZERO\n");
			height = 10;
		}
		if (x != child->core.x || y != child->core.y ||
			width != child->core.width || height != 
			child->core.height) {
			XtConfigureWidget(child, x, y, width, height, 
				child->core.border_width);
			if (((LayoutConstraints)
			(child->core.constraints))->layout.layout_callback 
			!= NULL) {
				callback = (XtCallbackRec *)
					(((LayoutConstraints)
					(child->core.constraints))->
					layout.layout_callback);
				i = 0;
				while (callback[i].callback != NULL) {
					(callback[i].callback)(child,
					callback[i].closure, NULL);
					i++;
				}
			}
		} else {
			XtConfigureWidget(child, x, y, width, height, 
				child->core.border_width);
			
		}
	}
}


static XtGeometryResult GeometryManager(w, request, reply)
	Widget w;
	XtWidgetGeometry *request;
	XtWidgetGeometry *reply;	/* RETURN */
{
#ifdef DEBUG
	fprintf(stderr,"Entering GeometryManager on widget %s\n",
		w->core.name);
#endif
	return XtGeometryYes;
}



static Boolean SetValues(current, request, new)
	Widget current, request, new;
{
#ifdef DEBUG
	fprintf(stderr,"Entering SetValues on widget %s\n",
		new->core.name);
#endif
	return( FALSE );
}


static void ConstraintInitialize(request, new)
	LayoutWidget request, new;
{
	Widget		w_shell;
	LayoutWidget	w, child;
	Dimension	p_width, p_height;
	Position	y;
	int	i;
	int	append, xtype, ytype, widthtype, heightype;
#ifdef DEBUG
	fprintf(stderr,"Entering ConstraintInitialize on widget %s\n",
		new->core.name);
	fprintf(stderr,"\tBooleans are %d [%d, %d, %d, %d]\n",
		((LayoutConstraints)(new->core.constraints))->layout.append,
		((LayoutConstraints)(new->core.constraints))->layout.xtype,
		((LayoutConstraints)(new->core.constraints))->layout.ytype,
		((LayoutConstraints)(new->core.constraints))->layout.widthtype,
		((LayoutConstraints)(new->core.constraints))->layout.heightype);

#endif
	append=	((LayoutConstraints)(new->core.constraints))->layout.append;
	xtype = ((LayoutConstraints)(new->core.constraints))->layout.xtype;
	ytype = ((LayoutConstraints)(new->core.constraints))->layout.ytype;
	widthtype=
		((LayoutConstraints)(new->core.constraints))->layout.widthtype;
	heightype=
		((LayoutConstraints)(new->core.constraints))->layout.heightype;

	w = (LayoutWidget)XtParent(new);
	p_width = w->core.width;
	p_height = w->core.height;
#ifdef DEBUG
	fprintf(stderr,"\tparent has %d %d %d %d\n",
		w->core.x, w->core.y, p_width, p_height);
#endif
	/* 
	** If this child exceeds parents' width or height resize parent
	*/
	if ( append != TRUE) {
#ifdef DEBUG
		fprintf(stderr,"ConstratintInit: new-> %d %d %d %d\n",
			new->core.x, new->core.y, new->core.width, 
			new->core.height);
		fprintf(stderr,"ConstratintInit: request-> %d %d %d %d\n",
			request->core.x, request->core.y, request->core.width, 
			request->core.height);
#endif DEBUG
		if ((xtype & LAYOUT_WIDGET)==0 && 
			(widthtype & LAYOUT_WIDGET)==0) {
			if ((xtype & LAYOUT_RELATIVE)==0 && 
				(widthtype & LAYOUT_RELATIVE)==0)
				if (new->core.x + new->core.width + 5 > 
				p_width) 
					p_width = new->core.x + 
						new->core.width + 5;
		}
		if ((ytype & LAYOUT_WIDGET)==0 && 
			(heightype & LAYOUT_WIDGET)==0) {
			if ((ytype&LAYOUT_RELATIVE)==0 && 
				(heightype&LAYOUT_RELATIVE)==0)
				if (new->core.y + new->core.height + 5 > 
				p_height) 
					p_height = new->core.y + 
					new->core.height + 5;
			if (p_height != w->core.height || 
				p_width != w->core.width) {
				XtConfigureWidget(w, w->core.x, w->core.y, 
					p_width, p_height, w->core.border_width);
				w_shell = (Widget)XtParent(w);
				XtConfigureWidget(w_shell, w_shell->core.x,
					w_shell->core.y, p_width, p_height,
					w_shell->core.border_width);
			}
		}
		Resize(w); /* resize parent as needed */
		return;
	}
#ifdef DEBUG
	fprintf(stderr,"APPENDING\n");
#endif
	/*
	** If we've entered with append TRUE then we're need to find the
	** maximum and expand our parent widget to fit.  Modify new->core.y
	** to reflect our size
	**
	*/

	y = 0;
	for (i = 0; i < w->composite.num_children; i++) {
		child = (LayoutWidget)w->composite.children[i];
		if (child->core.y + child->core.height + 5 > y)
			y = child->core.y + child->core.height + 5;
	}
	if (!(widthtype & LAYOUT_RELATIVE))
		if (new->core.width + 5> p_width)
			p_width = new->core.width + 5;
	if (!(heightype & LAYOUT_RELATIVE))
		if (y + new->core.height + 5 > p_height)
			p_height = y + new->core.height + 5;

	if (p_height != w->core.height || p_width != w->core.width) {
#ifdef DEBUG
		fprintf(stderr,"RESIZING PARENT TO FIT %d %d\n",
			p_width, p_height);
#endif
		XtConfigureWidget(w, w->core.x, w->core.y, p_width, p_height,
		 w->core.border_width);
		w_shell = (Widget)XtParent(w);
		XtConfigureWidget(w_shell, w_shell->core.x, w_shell->core.y,
			 p_width, p_height, w_shell->core.border_width);
		if (w->layout.layout_callback != NULL) 
#ifdef mips
		xform_callback(w, NULL, NULL);
#else
		XtCallCallbacks(w, XtNlayout_callback, "NULL");
#endif mips
	}
	/* parent is now big enough to hold child */
	((LayoutConstraints)(new->core.constraints))->layout.xtype |=
		LAYOUT_RELATIVE;
	((LayoutConstraints)(new->core.constraints))->layout.ytype |=
		LAYOUT_ABSOLUTE;
	((LayoutConstraints)(new->core.constraints))->layout.widthtype |= 
		LAYOUT_RELATIVE;
	((LayoutConstraints)(new->core.constraints))->layout.heightype |= 
		LAYOUT_ABSOLUTE;
	((LayoutConstraints)(new->core.constraints))->layout.layout_x = 2;
	((LayoutConstraints)(new->core.constraints))->layout.layout_y = y;
	((LayoutConstraints)(new->core.constraints))->layout.layout_w = 96;
	((LayoutConstraints)(new->core.constraints))->layout.layout_h = 
		new->core.height;
	((LayoutConstraints)(new->core.constraints))->layout.layout_wx = NULL;
	((LayoutConstraints)(new->core.constraints))->layout.layout_wy = NULL;
	((LayoutConstraints)(new->core.constraints))->layout.layout_ww = NULL;
	((LayoutConstraints)(new->core.constraints))->layout.layout_wh = NULL;

	XtConfigureWidget(new, (Position)(0.02 * (float)p_width), y, 
		(Dimension)(0.96 * (float)p_width),
		new->core.height, new->core.border_width);
	Resize(w);
}


static Boolean ConstraintSetValues(current, request, new)
	Widget current, request, new;
{
	LayoutWidget	w;
	/* if were here we are the child of a form ... so do a forced
	** resize of the form to make everything right 
	*/
#ifdef DEBUG
	fprintf(stderr,"Entering ConstraintSetValues on widget %s\n",
		current->core.name);
#endif	
	w = (LayoutWidget)XtParent(new);
	if (w == NULL)  {
		fprintf(stderr,
			"Layout Constraint Set Values - no layout parent\n");
		return( FALSE );
	}
#ifdef NOFLASH
	Resize2(w, 1);
#endif
	return( FALSE );
}

static void ChangeManaged(w)
	LayoutWidget w;
{
#ifdef DEBUG
	fprintf(stderr,"Entering ChangeManaged on widget %s\n",
		w->core.name);
#endif
	Resize2(w, 1);
}

XtResizeLayout(w)
	Widget	w;
{
	Resize2(w, 1);
}

/*
** layout_convert_widget:	take a -widget string and use it to
**				update the widget_type and widget
**				parameters.  The type is already
**				set for RELATIVE or ABSOLUTE,
**				but the tail end of the string will be
**				used to feed in LEFT,RIGHT,TOP,BOTTOM,
**				WIDTH, or HEIGHT.   The head of the string
**				names the widget and should be looked up.
**				"NULL" is a special head and returns NULL
**				widget.
**
*/
layout_convert_widget(in_str, w, widget_type, parent_w)
	char	*in_str;
	LayoutWidget	*w;
	int	*widget_type;
	LayoutWidget	parent_w;
{
	char	*name, *tail, *type_str, *str;
	int	ok;

	*w = NULL;

	if (in_str == NULL || *in_str == NULL || strcmp(in_str, "NULL") == 0) 
		return;

	str = (char *)malloc(strlen(in_str)+1);
	strcpy(str, in_str);

	/* if no string, null string, or "NULL"  return */
	if (str == NULL || *str == NULL || strcmp(str,"NULL") == 0) {
		free(str);
		return;
	}


	name = tail = str;
	tail = tail + strlen(str);

	while (tail != name && *tail != '.')
		tail--;
	ok = 0;

	if (*tail == '.') { /* We have a tail... update widget_type */
		*tail = NULL; /* ready for name stuff if any */
		type_str = tail+1;
		if (strcmp(type_str, "top") == 0)  {
			*widget_type = *widget_type | LAYOUT_TOP;
			ok = 1;
		}
		if (strcmp(type_str, "bottom") == 0)  {
			*widget_type = *widget_type | LAYOUT_BOTTOM;
			ok = 1;
		}
		if (strcmp(type_str, "left") == 0)  {
			*widget_type = *widget_type | LAYOUT_LEFT;
			ok = 1;
		}
		if (strcmp(type_str, "right") == 0)  {
			*widget_type = *widget_type | LAYOUT_RIGHT;
			ok = 1;
		}
		if (strcmp(type_str, "width") == 0)  {
			*widget_type = *widget_type | LAYOUT_WIDTH;
			ok = 1;
		}
		if (strcmp(type_str, "height") == 0)  {
			*widget_type = *widget_type | LAYOUT_HEIGHT;
			ok = 1;
		}
		if (!ok)
		fprintf(stderr,"layout_convert: unknown type '%s'\n",
			type_str);
	}
	if (*name == NULL || tail == name || strcmp(name, "NULL") == 0){
		free(str);
		*w = parent_w;
		return;
	}
	*w = (LayoutWidget)XtNameToWidget(parent_w, name);
	if (*w == NULL) {
		*w = (LayoutWidget)x_ntw_get(name);
		if (*w == NULL) {
		fprintf(stderr,"layout_convert: unable to find widget at all '%s'\n",
			name);
			free(str);
			return;
		}
	}
	*widget_type = *widget_type | LAYOUT_WIDGET;
#ifdef DEBUG
	fprintf(stderr,"layout_convert_widget returns: %s %d\n",
		(*w)->core.name, *widget_type);
#endif
	free(str);
}
