static char rcsid[] = "$Id: genesis_xtoggle.c,v 1.1 1992/12/11 19:07:37 dhb Exp $";

/*
** $Log: genesis_xtoggle.c,v $
** Revision 1.1  1992/12/11  19:07:37  dhb
** Initial revision
**
*/

#include "gen_ext.h"
#include "xodus_args.h"
#include "XoWhen.h"
#include "toggle_wP.h"

extern	XtCallbackProc	xtoggle_callback();
extern char *fillstr();

extern	char *g_copy();
static int xtoggle_parser();

/*
** xtoggle_func:	
**
*/
xtoggle_func(element,action)
	struct xtoggle_type 	*element;
	Action			*action;
{
	LayoutWidget		widget;
	ToggleWidget		tw;
	char			*field;
	char			**argv;
	int			argc;
	char			*value;
	char			*script;
	struct xtoggle_type 	*new;
	Position		x, y;

	static	XtCallbackRec	callback[2];
	static struct valid_arg xtoggle_args[] = {
		{"state", 0, 2},
		{"label0", 0, 2},
		{"label1", 0, 2},
		{"END", -1, -1}
	};

	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	callback[0].callback = (XtCallbackProc)xtoggle_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;


	switch(action->type) {
    		case CREATE: 
			widget = (LayoutWidget)do_toggle(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			if (script = (char *)x_arg(ARG_SCRIPT)) {
				do_add_script(widget,script);
			}
			element->state = atoi(x_arg(ARG_STATE));
			break;
    		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
    		case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		argc = action->argc;
		XoParseCoords(&argc, action->argv, argv);
			if (x_parse_set(argc, argv, xtoggle_args))
			xfunc_parse_set(element, argc, argv,
				xtoggle_parser);
			free(argv);
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
	}
	return(1);
}
/*
** xtoggle_callback:	When xtoggle is changed from the screen this is 
**			called.
**
*/
XtCallbackProc
xtoggle_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	ToggleWidget	tw = (ToggleWidget)w;
	XtCallbackRec	*callback_ptr;
	struct xtoggle_type *element;
	element = (struct xtoggle_type *)
		(((LayoutConstraints)(w->core.constraints))->
			layout.layout_element);
	if (element == NULL) {
			fprintf(stderr,"xtoggle_callback: null element\n");
			return;
	}
	if (element->name  == NULL || *element->name == NULL) 
		return;	/* just a realize call */
	element->state = tw->toggle.state;

	xodus_core_set(element, w);
}

static int xtoggle_parser(element, i, argc, argv)
	struct xtoggle_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	ToggleWidget	tw;
	char	*field, *value;
	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	value = argv[i];
	
	/*
	if (strcmp(field,"script") == 0) {
		if (element->script != NULL) {
			free(element->script);
			element->script = NULL;
		}
		if (value != NULL) 
			element->script = g_copy(value);
		return(2);
	}
	*/
	if (strcmp(field,"state") == 0) {
		tw = (ToggleWidget)element->widget;
		tw->toggle.state = atoi(value);
		toggleDisplay(tw, NULL);
		SetField(element,element->object->type, 
			field,value);
		return(2);
	}
	if (strcmp(field,"label0") == 0) {
		tw = (ToggleWidget)element->widget;
		if (value && strlen(value) > 1) {
			if (tw->toggle.label0)
				free(tw->toggle.label0);
			tw->toggle.label0 = fillstr(value);
		}
		toggleDisplay(tw, NULL);
		SetField(element,element->object->type, 
			field,value);
		return(2);
	}
	if (strcmp(field,"label1") == 0) {
		tw = (ToggleWidget)element->widget;
		if (value && strlen(value) > 1) {
			if (tw->toggle.label1)
				free(tw->toggle.label1);
			tw->toggle.label1 = fillstr(value);
		}
		toggleDisplay(tw, NULL);
		SetField(element,element->object->type, 
			field,value);
		return(2);
	}
	return(0);
}
