static char rcsid[] = "$Id: genesis_xlabel.c,v 1.1 1992/12/11 19:07:36 dhb Exp $";

/*
** $Log: genesis_xlabel.c,v $
** Revision 1.1  1992/12/11  19:07:36  dhb
** Initial revision
**
*/

#include "gen_ext.h"

extern	XtCallbackProc	xlabel_callback();

extern	char *g_copy();
extern	char *set_form();


/*
** xlabel_func:	Pass off to correct routines based on actions
**
*/
xlabel_func(element,action)
	struct xlabel_type 	*element;
	Action			*action;
{
	LayoutWidget	widget;
	char		*field;
	char		**argv;
	int		argc;
	char		*value;
	Position	x, y;
	struct xlabel_type 	*new;

	static	XtCallbackRec	callback[2];
	static struct valid_arg xlabel_args[] = {
		{"END", -1, -1}
	};


	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	callback[0].callback = (XtCallbackProc)xlabel_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;


	switch(action->type) {
    		case CREATE: 
			widget = (LayoutWidget)do_label(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			break;
    		case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		argc = action->argc;
		XoParseCoords(&argc, action->argv, argv);
			if (x_parse_set(argc, argv, xlabel_args))
			xfunc_parse_set(element, argc, 
				argv, NULL);
			free(argv);
			break;
		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
	}
	return(1);
}

/*
** xlabel_callback:	When xlabel is changed from the screen this is 
**			called.
**
*/
XtCallbackProc
xlabel_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	struct xlabel_type *element;
	element = (struct xlabel_type *)
		(((LayoutConstraints)(w->core.constraints))->
			layout.layout_element);
	if (element == NULL) {
			fprintf(stderr,"xlabel_callback: null element\n");
			return;
	}
	if (element->name == NULL || *element->name == NULL)
		return;	/* just a realize call */
	xodus_core_set(element, w);
}
