static char rcsid[] = "$Id: genesis_xbutton.c,v 1.1 1992/12/11 19:07:32 dhb Exp $";

/*
** $Log: genesis_xbutton.c,v $
** Revision 1.1  1992/12/11  19:07:32  dhb
** Initial revision
**
*/

#include "gen_ext.h"
#include "xodus_args.h"

extern	XtCallbackProc	xbutton_callback();

extern	char *g_copy();
extern	char *set_form();


/*
** xbutton_func:	
**
*/
xbutton_func(element,action)
	struct xbutton_type 	*element;
	Action			*action;
{
	LayoutWidget		widget;
	char			*field;
	char	**argv;
	int	argc;
	char			*value;
	char			*script;
	Position		x, y;
	struct xbutton_type 	*new;

	static	XtCallbackRec	callback[2];
	static struct valid_arg xbutton_args[] = {
		{"END", -1, -1}
	};

	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	callback[0].callback = (XtCallbackProc)xbutton_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;


	switch(action->type) {
    	case CREATE: 
			widget = (LayoutWidget)do_xbutton(action->argc,
				 action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			if (script = (char *)x_arg(ARG_SCRIPT)) {
				do_add_script(widget,script);
			}
			break;
    	case DELETE:
			genesis_destroy_widget(element);
			break;
    	case SET:
		argv = (char **) calloc(action->argc + 2,sizeof(char *));
		argc = action->argc;
		XoParseCoords(&argc, action->argv, argv);
			if (x_parse_set(argc, argv,
				 xbutton_args))
				xfunc_parse_set(element, argc,
					argv,  NULL);
			free(argv);
			break;
	case	COPY:
		genesis_no_copy();
		return(0);
	}
	return(1);
}
XtCallbackProc
/*
** xbutton_callback:	When xbutton is changed from the screen this is 
**			called.
**
*/
xbutton_callback(w, client_data, call_data)
	LayoutWidget	w;
	caddr_t	client_data;
	caddr_t	call_data;
{
	struct xbutton_type *element;

	element = (struct xbutton_type *)
		(((LayoutConstraints)(w->core.constraints))->
			layout.layout_element);
	if (element == NULL) {
			fprintf(stderr,"xbutton_callback: null element\n");
			return;
	}
	if (element->name == NULL || *element->name == NULL) 
		return;	/* just a realize call */
	xodus_core_set(element, w);
}

/*
static int xbutton_parser(element, i, argc, argv)
	struct xbutton_type	*element;
	int			i;
	int			argc;
	char			**argv;
{
	char	*field, *value;
	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	value = argv[i];
	
	if (strcmp(field,"script") == 0) {
		if (element->script != NULL) {
			free(element->script);
			element->script = NULL;
		}
		if (value != NULL) 
			element->script = g_copy(value);
		return(2);
	}
	return(0);
}
*/
