static char rcsid[] = "$Id: genesis_text.c,v 1.1 1992/12/11 19:07:30 dhb Exp $";

/*
** $Log: genesis_text.c,v $
** Revision 1.1  1992/12/11  19:07:30  dhb
** Initial revision
**
*/

#include "gen_ext.h"
#include "xodus_args.h"
#ifdef X11R3
#include <X11/AsciiText.h>
#include <X11/LabelP.h>
#else
#include <X11/Xaw/LabelP.h>
#include <X11/Xaw/AsciiText.h>
#include <X11/StringDefs.h>
#endif X11R3
#include "XoWhen.h"
#include "draw_wP.h"

static void xfunc_text_create();
static int xtext_parser();

void xtext_callback(w, client, call)
	DrawWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xtext_type	*element;

	element = (struct xtext_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xtextcallback: null element\n");
		return;
	}
	xodus_core_set(element, w);
#ifdef NOTDEF
	SetField(element, element->object->type, "value", w->draw.pixvalue);
	SetField(element, element->object->type, "pixchoose", w->draw.pixname);
#endif NOTDEF
}

xtext_func(element,action)
	struct xtext_type *element;
	Action		*action;
{
	char	*field, *value;
	char	**argv;
	int	argc;
	LayoutWidget	widget;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xtext_args[] = {
		{"file", 0, 2},
		{"END", -1, -1}
	};


	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}
	if(debug > 1){
		ActionHeader("Xtext",element,action);
	}

	callback[0].callback = (XtCallbackProc)xtext_callback;
	callback[0].closure = (caddr_t)NULL;
	callback[1].callback = (XtCallbackProc)NULL;
	callback[1].closure = (caddr_t)NULL;

	switch(action->type) {
   		case CREATE: 
			widget = (LayoutWidget)do_xtext(action->argc,
				action->argv);
			if (widget == NULL)
				return(0);
			element->widget = (Widget)widget;
			xfunc_core_create(element, callback);
			/*
			xfunc_parse_set(element, action->argc - 2,
				action->argv + 2, xtext_parser);
			xfunc_text_create(element);
			*/
			break;
   		case DELETE:
			genesis_destroy_widget(element);
			free(element->title);
			break;
   		case SET:
			argv =(char **)calloc(action->argc + 2,sizeof(char *));
			argc = action->argc;
			XoParseCoords(&argc, action->argv, argv);
			if (x_parse_set(argc, argv, xtext_args))
			xfunc_parse_set(element, argc,
				argv, xtext_parser);
			free(argv);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xtext",element,action);
			break;
	}
	return(1);
}

static void xfunc_text_create(elm)
	struct xtext_type	*elm;
{
	Widget	w = elm->widget;
	char		*field;
	int			i;
	char	*names[MAXARGS];
	Arg		args[MAXARGS];
	int			n;

	n = 0;
	names[n] = XtNfile; n++;

	XoGetValuesToStrings(w,names,args,&n);

	for (i = 0 ; i < n ; i++)
		SetField(elm,elm->object->type,args[i].name,args[i].value);
}


static int xtext_parser(element, i, argc, argv)
	struct xtext_type	*element;
	int			i;
	int			argc;
	char		**argv;
{
	char	*field, *value, *g_copy();
	Arg	args[5];
	int	n;
	TextWidget widget;
	/*
	char	oldfile[80];
	XtTextSource oldsrc,newsrc;
	*/

	field = argv[i];
	i++;
	if (i > argc) {
		fprintf(stderr,"SET: must specify a value field for '%s'\n",
			 argv[i]);
		return(-1);
	}
	if (!(value = argv[i]))
		return(0);

	/*
	widget = (Widget)XoGetWidgetFromString(Pathname(element));
	if (!widget) {
		fprintf(stderr,"could not find widget %s' in xtext_parser\n",
			Pathname(element));
		return(0);
	}
	*/
	
	if (strcmp(field,"file") == 0) {
		widget = (TextWidget)element->widget;
		if (value && strlen(value) > 1) {
			/*
			n = 0;
			XtSetArg(args[n],XtNfile,oldfile); n++;
			XtGetValues(widget,args,n);
			if (strcmp(oldfile,value) == 0)
				return(2);
			oldsrc = XtTextGetSource(widget);
			n = 0;
			XtSetArg(args[n],XtNfile,g_copy(value)); n++;
			XtSetValues(widget,args,n);
			newsrc = XtDiskSourceCreate(widget,args,n);
			XtTextSetSource(widget,newsrc,0);
			XtDiskSourceDestroy(oldsrc);
			*/
			n = 0;
			XtSetArg(args[n],XtNfile,g_copy(value)); n++;
			XtSetValues(widget,args,n);
		}
		SetField(element,element->object->type,field,value);
		return(2);
	}
	return(0);
}
