static char rcsid[] = "$Id: genesis_funcs.c,v 1.1 1992/12/11 19:07:28 dhb Exp $";

/*
** $Log: genesis_funcs.c,v $
** Revision 1.1  1992/12/11  19:07:28  dhb
** Initial revision
**
*/

#include "gen_ext.h"
#include <X11/StringDefs.h>
#include "xodus_args.h"

extern	XtCallbackProc	xdialog_callback();

extern	char *g_copy();
extern	char *set_form();

do_widget_move(element)
	struct widget_type	*element;
{
	Position	x, y;
	Widget		w, parent;
	Arg		arg[10];
	int		n;
	
	x = (Position)element->x;
	y = (Position)element->y;
	w = (Widget)element->widget;

	parent = XtParent(w);
	if (is_xform_type(element)) {
		if (parent != NULL)
			XtMoveWidget(parent, x, y);
		return;
	}
	n = 0;
	XtSetArg(arg[n], XtNlayout_x, w->core.x + 1); n++; /* force recomp */
	XtSetArg(arg[n], XtNlayout_x, x); n++;
	XtSetArg(arg[n], XtNlayout_y, y); n++;
	XtSetValues(w, arg, n);
	if (parent != NULL)
		XtResizeLayout(XtParent(w));
}

do_widget_resize(element)
	struct widget_type	*element;
{
	Widget		w, parent;
	Arg		arg[10];
	int		n;
	
	Position	x, y;
	x = (Position)element->x;
	y = (Position)element->y;
	w = (Widget)element->widget;
	parent  = XtParent(w);

	if (is_xform_type(element)) {
		if (parent != NULL) 
		XtConfigureWidget(parent, x,y, element->width, element->height,
			parent->core.border_width);
		return;
	}

	n = 0;
	XtSetArg(arg[n], XtNwidth, w->core.width + 1); n++; /* force recomp */
	XtSetArg(arg[n], XtNlayout_w, element->width); n++;
	XtSetArg(arg[n], XtNlayout_h, element->height); n++;
	XtSetArg(arg[n], XtNwidthtype, element->widthtype); n++;
	XtSetArg(arg[n], XtNheightype, element->heightype); n++;
	XtSetValues(w, arg, n);
	if (parent != NULL)
		XtResizeLayout(XtParent(w));
}

/*
** is_xform_type
**
*/
is_xform_type(element)
	struct widget_type	*element;
{
	if (strcmp(element->object->type, "xform_type") == 0)
		return(1);
	else
		return(0);
}

/*
** 
**	xfunc_percent_hack(value): scan the 'value' string, replacing 
**					% with NULL and returning 1 if
**					% was found.
**
*/
xfunc_percent_hack(value)
	char	*value;
{
	int	ret = 0;
	while (*value != NULL && *value != '%')
		value++;
	if (*value == '%')
		ret = 1;
	*value = NULL;
	return(ret);
}

/*
** g_copy
**
*/
char *
g_copy(str)
	char	*str;
{
	char	*ret;
	if (str == NULL)
		return(str); 
	ret = (char *)malloc(strlen(str)+1);
	strcpy(ret, str);
	return(ret);
}

genesis_copy_widget_core(old, new)
	struct widget_type	*old, *new;
{
	new->title = (char *)g_copy(old->title);
	new->form = (char *)g_copy(old->form);
	new->xwidget = (char *)g_copy(old->xwidget);
	new->ywidget = (char *)g_copy(old->ywidget);
	new->wwidget = (char *)g_copy(old->wwidget);
	new->hwidget = (char *)g_copy(old->hwidget);

	new->xtype = old->xtype;
	new->ytype = old->ytype;
	new->widthtype = old->widthtype;
	new->heightype = old->heightype;

	new->x = old->x;
	new->y = old->x;
	new->width = old->width;
	new->height = old->height;
}

/*
** set_form;	MATT, Get yer joe code working so I *have* a parent.
**
*/
char *
set_form(new)
	struct widget_type	*new;
{
	Element	*element = (Element *)new->parent;
	int	class = ClassID("form");
	if (element == NULL)
		return(NULL);
	for (;element;element=element->parent) {
		if (CheckClass(element, class)) {
			fprintf(stderr,"--->%s\n", Pathname(element));
			return(Pathname(element));
		}
	}
	fprintf(stderr,"set_form: no parent of class form found\n");
	return(NULL);
}

xfunc_core_create(element, callback)
	struct	widget_type	*element;
	XtCallbackRec	*callback;
{
	int	n;
	Arg	arg[4];
	LayoutConstraints	widget_const;
	LayoutWidget			widget;

	widget = (LayoutWidget)element->widget;

	element->form = g_copy(x_arg(ARG_FORM));
	element->title = g_copy(x_arg(ARG_TITLE));
	element->xwidget = g_copy(x_arg(ARG_XWIDGET));
	element->ywidget = g_copy(x_arg(ARG_YWIDGET));
	element->wwidget = g_copy(x_arg(ARG_WWIDGET));
	element->hwidget = g_copy(x_arg(ARG_HWIDGET));
	element->absolute_x = (unsigned short )widget->core.x;
	element->absolute_y = (unsigned short )widget->core.y;
	element->absolute_width = (unsigned short)widget->core.width;
	element->absolute_height =(unsigned short)widget->core.height;
	element->border_width =(int)widget->core.border_width;
	widget_const = (LayoutConstraints)widget->core.constraints;
	element->x = (float)widget_const->layout.layout_x;
	element->y = (float)widget_const->layout.layout_y;
	element->width = (Dimension)widget_const->layout.layout_w;
	element->height =(Dimension)widget_const->layout.layout_h;
	element->xtype = widget_const->layout.xtype;
	element->ytype = widget_const->layout.ytype;
	element->widthtype = widget_const->layout.widthtype;
	element->heightype = widget_const->layout.heightype;

	n = 0;
	XtSetArg(arg[n], XtNlayout_callback, callback); n++;
	XtSetArg(arg[n], XtNlayout_element, (char *)element); n++;
	XtSetValues(element->widget, arg, n);
}

xfunc_core_copy(old, new, callback)
	struct widget_type	*old;
	struct widget_type	*new;
	XtCallbackRec	*callback;
{
	Arg	arg[3];
	int	n;

	n = 0;
	XtSetArg(arg[n], XtNlayout_callback, callback); n++;
	XtSetArg(arg[n], XtNlayout_element, (char *)new); n++;
	XtSetValues(new->widget, arg, n);

}

/*
** xodus_core_set:	Update widget_core based on current widget values
**			ONLY values which the user can change via
**			the window manager (x, y, w, h) are checked.
**
*/
xodus_core_set(element, w)
	struct widget_type	*element;
	Widget	w;
{
	int	x, y, width, height;
	x = (((LayoutConstraints)(w->core.constraints))-> layout.layout_x);
	y = (((LayoutConstraints)(w->core.constraints))-> layout.layout_y);
	width = (((LayoutConstraints)(w->core.constraints))->layout.layout_w);
	height = (((LayoutConstraints)(w->core.constraints))->layout.layout_h);
	element->x = (float)x;
	element->y = (float)y;
	element->width = width;
	element->height = height;
	element->absolute_x = w->core.x;
	element->absolute_y = w->core.y;
	element->absolute_width = w->core.width;
	element->absolute_height = w->core.height;
}

genesis_destroy_widget(element)
	struct widget_type	*element;
{
	Widget	parent;
	Widget w = element->widget;

	/*  If the widget is a form we want to remove the appshell
	**  above it as well 
	*/
	if (w == NULL)
		return;

	if (is_xform_type(element)) {
		parent = XtParent(w);
		XtUnmapWidget(w);
		if (parent != NULL)
			XtUnmapWidget(parent);
		XFlush(XtDisplay(w));
		if (parent != NULL)
			XtDestroyWidget(parent);
	} else { /* isn't a form ... blow it away */
		XtUnmapWidget(w);
		XFlush(XtDisplay(w));
		XtDestroyWidget(w);
	}
	x_ntw_add(Pathname(element),NULL);
}

genesis_no_copy()
{
	fprintf(stderr,"X-Elements cannot (currently) be copied\n");
}

axis_graph_add_pts(name,plotname,colorname,x,y)
	char		*name;
	char		*plotname;
	char		*colorname;
	float		x,y;
{
	struct widget_type 	*element;
	element = (struct widget_type *)GetElement(name);
	
	if (element == NULL) {
		fprintf(stderr,"Element '%s' does not exist\n", name);
		return;
	}
	graph_add_pts(element->widget, plotname, colorname, x,y);
}
