static char rcsid[] = "$Id: genesis_elmtree.c,v 1.1 1992/12/11 19:07:26 dhb Exp $";

/*
** $Log: genesis_elmtree.c,v $
** Revision 1.1  1992/12/11  19:07:26  dhb
** Initial revision
**
*/

#include "gen_ext.h"
#include "draw_w.h"

int	XoCreateElmtree();

void xelmtree_callback(w, client, call)
	LayoutWidget	w;
	caddr_t	client;
	caddr_t	call;
{
	struct xelmtree_type	*element;

	element = (struct xelmtree_type *)
		(((LayoutConstraints)(w->core.constraints))->
				layout.layout_element);
	if (element == NULL) {
		fprintf(stderr,"xelmtree_callback: null element\n");
		return;
	}
	xodus_core_set(element, w);
}

xelmtree_func(element,action)
	struct xelmtree_type *element;
	Action		*action;
{
	char	*field, *value;
	LayoutWidget	widget;
	static	XtCallbackRec	callback[2];
	static struct valid_arg xelmtree_args[] = {
		{"pix", 0, 2},
		{"pixname", 0, 2},
		{"linkmode", 0, 2},
		{"hlhistmode", 0, 2},
		{"hldispmode", 0, 2},
		{"path", 0, 2},
		{"value", 0, 2},
		{"END", -1, -1}
	};

	if(debug > 1){
		ActionHeader("Xelmtree",element,action);
	}
	if (x_status != 1) {
		fprintf(stderr,"X is not currently enabled.\n");
		fprintf(stderr,"  Please execute the 'xon' command.\n");
		return(0);
	}

	switch(action->type) {
    	case CREATE: 
            XoCreateElmPix(element,
                ((struct xdraw_type *)action->data)->widget,
                action->argc,action->argv, XoCreateElmtree);
			break;
    	case DELETE:
	        drop_pix(Pathname(element->parent),
                         ((Pix *)(element->pix))->name);
                drop_pix(Pathname(element->parent),"stems");
                drop_pix(Pathname(element->parent),"msgs");
		break;
    	case SET:
		if (x_parse_set(action->argc, action->argv, xelmtree_args))
			XoSetElmPix(element, action->argc, action->argv);
			break;
		case RESET:
			break;
		case	COPY:
			genesis_no_copy();
			return(0);
		default:
			InvalidAction("Xelmtree",element,action);
			break;
	}
	return(1);
}
