static char rcsid[] = "$Id: load_draw.c,v 1.1 1992/12/11 19:06:57 dhb Exp $";

/*
** $Log: load_draw.c,v $
** Revision 1.1  1992/12/11  19:06:57  dhb
** Initial revision
**
*/

/* --------------------------------------------- */
/* The routines for loading numbers into a draw
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "shape_w.h"


#define DRAW_TEXT_HEIGHT 30
#define DRAW_VERT_SPACE 5

#ifndef EPSILON
#define EPSILON		1.0e-60
#endif EPSILON

extern	Widget x_ntw_get();

/* --------------------------------------------- */

add_image(parent,pix)
	Widget	parent;
	Pix		*pix;
{
	Arg	args[2];
	int	n;
	Pix		*im;

	n = 0;
	XtSetArg(args[n],XtNimages,&im);
	XtGetValues(parent,args,n);
	
	if (im) {
		while(im->next)
			im = im->next;
		im->next = pix;
	} else {
		n = 0;
		XtSetArg(args[n],XtNimages,pix);
		XtSetValues(parent,args,n);
	}
}

add_icon(parent,pix)
	Widget	parent;
	Pix		*pix;
{
	Arg	args[2];
	int	n;
	Pix		*ic;

	n = 0;
	XtSetArg(args[n],XtNicons,&ic);
	XtGetValues(parent,args,n);
	
	if (ic) {
		while(ic->next)
			ic = ic->next;
		ic->next = pix;
	} else {
		n = 0;
		XtSetArg(args[n],XtNicons,pix);
		XtSetValues(parent,args,n);
	}
}

add_pix(drawname,pixname,pixfunc,pixsize)
	char	*drawname;
	char	*pixname;
	int		(*pixfunc)();
	int		pixsize;
{
	DrawWidget	dw;
	Pix			*pix;

	dw = (DrawWidget)x_ntw_get(drawname);
	if (dw == NULL) {
		fprintf(stderr,"couldnt find draw with name '%s'\n",
			drawname);
		return;
	}

	if (!(pix = add_pix2(dw,pixname,pixsize)))
		return;
	pix->refresh_func = pixfunc;
}

Pix * 
add_pix2(dw,pixname,pixsize)
	DrawWidget	dw;
	char	*pixname;
	int		pixsize;
{
	Pix			**pix;


	if (pixsize < sizeof(Pix))
		pixsize = sizeof(Pix);

	if (strcmp(&(pixname[strlen(pixname) - 4]),"icon") == 0)
		pix = &(dw->draw.icons);
	else
		pix = &(dw->draw.images);
	while(TRUE) {
		if (*pix == NULL) {
			*pix = (Pix *)calloc (1, pixsize);
			(*pix)->name = (char *) malloc ((strlen(pixname) + 1) *
				sizeof(char));
			strcpy((*pix)->name,pixname);
			break;
		}
		if ((*pix)->name == NULL) {
			fprintf(stderr,"null pixname encountered in add_pix()\n");
		} else if (strcmp((*pix)->name,pixname) == 0)  {
			break;
		}
		pix = &((*pix)->next);
	}

	return(*pix);
}

Pix	*find_pix2(parent,pixname)
	DrawWidget	parent;
	char	*pixname;
{
	Pix		*pix;

	if (pixname == NULL){
		/*
		fprintf(stderr,"cannot find pix with NULL name in find_pix2\n");
		*/
		return(NULL);
	}

	if (strcmp(&(pixname[strlen(pixname) - 4]),"icon") == 0) {
		pix = parent->draw.icons;
	} else {
		pix = parent->draw.images;
	}

	while(pix) {
		if (pix->name == NULL) {
			fprintf(stderr,"null pixname encountered in find_pix()\n");
		} else if (strcmp(pix->name,pixname) == 0)  {
			break;
		}
		pix = pix->next;
	}
	/*
	if (!pix)
		fprintf(stderr,"cannot find pix with name '%s' in find_pix2\n",
			pixname);
	*/
	return(pix);
}

Pix	*find_pix(drawname,pixname)
	char	*drawname;
	char	*pixname;
{
	DrawWidget	dw;
	Pix			*pix;

	if (pixname == NULL){
		fprintf(stderr,"findpix fails on draw '%s', pix '%s'\n", 
			drawname, pixname);
		return(NULL);
	}

	dw = (DrawWidget)x_ntw_get(drawname);
	if (dw == NULL) {
		fprintf(stderr,"couldnt find draw with name '%s'\n",
			drawname);
		return(NULL);
	}
	return(find_pix2(dw,pixname));
}

load_pix_coords(drawname,pixname,coords,ncoords)
	char	*drawname;
	char	*pixname;
	Coord	*coords;
	int		ncoords;
{
	Pix		*pix;

	if (!(pix = find_pix(drawname,pixname))) return;

	load_pix_coords2(pix,coords,ncoords);
}

load_pix_coords2(pix,coords,ncoords)
	Pix		*pix;
	Coord	*coords;
	int		ncoords;
{
	int		i;
	Element	**elm;
	Coord	*tempcoords;
	CoordRescale	*rescale;

	if (rescale = (CoordRescale *)(pix->rescale)) {
		if (rescale->coords && ncoords > pix->npts)
			free(rescale->coords);
	} else 
		pix->rescale = (Rescale *) calloc(1,sizeof(CoordRescale));

/* Assume we use UseCoords since we are dealing with coords in this
** func anyway */
	pix->rescale->func = UseCoords;
	pix->rescale->offset.x = 0.0;
	pix->rescale->offset.y = 0.0;
	pix->rescale->offset.z = 0.0;

	if (ncoords > pix->npts) {
		tempcoords = ((CoordRescale *)(pix->rescale))->coords =
			(Coord *) malloc (ncoords * sizeof(Coord));
	} else {
		tempcoords = ((CoordRescale *)(pix->rescale))->coords;
	}
	bcopy((char *)coords, (char *)tempcoords,
		ncoords * sizeof(Coord));

	if (pix->npts < ncoords) {
		if (pix->pts)
			free(pix->pts);
		pix->pts = (XPoint *) malloc(ncoords * sizeof(XPoint));
	}
	pix->npts = ncoords;
}

append_pix(dw,pix,is_icon)
	DrawWidget	dw;
	Pix			*pix;
	int			is_icon;
{
	if (!(pix && dw)) {
		fprintf(stderr,"cannot append null pix to null widget\n");
		return;
	}
	if (is_icon) {
		pix->next = dw->draw.icons;
		dw->draw.icons = pix;
	} else {
		pix->next = dw->draw.images;
		dw->draw.images = pix;
	}
}

copy_pix(fromdraw,frompix,todraw,topix)
	char	*fromdraw;
	char	*frompix;
	char	*todraw;
	char	*topix;
{
	Pix	*pix, *new;
	Coord	*coords;
	int		i;
	Widget	fw,tw,XoGetWidgetFromString();

	if (!(fw = XoGetWidgetFromString(fromdraw))) return;
	if (!(tw = XoGetWidgetFromString(todraw))) return;
	if ((copy_pix2(fw,frompix,tw,topix) == NULL)) return;
}

Pix *
copy_pix2(fromdraw,frompix,todraw,topix)
	Widget	fromdraw;
	char	*frompix;
	Widget	todraw;
	char	*topix;
{
	Pix	*pix, *new;
	Coord	*coords;
	int		i;

	if (!(pix = find_pix2(fromdraw,frompix))) {
		fprintf(stderr,"couldnt find pix '%s' in copy_pix\n");
		return(NULL);
	}
	if (!(new = add_pix2(todraw,topix,sizeof(Pix)))) return(NULL);
	new->refresh_func = pix->refresh_func;
	new->color = pix->color;

	coords = ((CoordRescale *)pix->rescale)->coords;
	load_pix_coords2(new,coords,pix->npts);

	if (strlen(topix) > 5 && strcmp(&(topix[strlen(topix) - 4]),"icon") == 0)
		(pix->rescale->func)(todraw,new,1);
	else
		(pix->rescale->func)(todraw,new,0);

	update_pix(todraw,new);
	return(new);
}

Pix *
ScaleAndCopyPix(drawname,iconname,scale,offset)
	char		*drawname;
	char		*iconname;
	Coord	scale,offset;
{
	Pix	*pix, *new;
	Coord	*coords;
	int		i;
	char	*fillstr();

	if (!(pix = find_pix(drawname,iconname))) {
		fprintf(stderr,"couldnt find pix '%s' in ScaleAndCopyIcon\n");
		return(NULL);
	}
	new = (Pix *) calloc(1,sizeof(Pix));
	new->refresh_func = pix->refresh_func;
	new->color = pix->color;
	new->name = fillstr(iconname);

	coords = ((CoordRescale *)pix->rescale)->coords;
	load_pix_coords2(new,coords,pix->npts);
	coords = ((CoordRescale *)new->rescale)->coords;
	for (i = 0 ; i < pix->npts ; i++ ) {
		coords[i].x = coords[i].x * scale.x + offset.x;
		coords[i].y = coords[i].y * scale.y + offset.y;
		coords[i].z = coords[i].z * scale.z + offset.z;
	}
	return(new);
}

Pix *
ScaleAndCopyIcon(iconname,scale,offset)
	char		*iconname;
	Coord	scale,offset;
{
	Pix	*pix;
	Coord	*coords, *tempcoords;
	Pix	*ret;

	if (!(pix = find_pix("/xproto/draw",iconname)))
		return(NULL);
    if (pix->refresh_func == DrawShape) { /* modify the pix to be 
											** an ordinary pix */
        if (!(pix = find_pix("/xproto/draw",iconname))) {
            fprintf(stderr,"Could not find icon '%s'\n",iconname);
            return;
        }
        pix->refresh_func = ((ShapePix *)pix)->drawmode;
		pix->npts--;
		tempcoords = ((CoordRescale *)pix->rescale)->coords;
		((CoordRescale *)pix->rescale)->coords = &(tempcoords[1]);
		ret = (ScaleAndCopyPix("/xproto/draw",iconname,scale,offset));
		pix->refresh_func = DrawShape;
		pix->npts++;
		((CoordRescale *)pix->rescale)->coords = tempcoords;
    }
	return(ret);
}

drop_pix(drawname,pixname)
	char	*drawname;
	char	*pixname;
{
	DrawWidget	dw;
	Pix			*pix;

	dw = (DrawWidget)x_ntw_get(drawname);
	if (dw == NULL) {
		fprintf(stderr,"couldnt find draw with name '%s'\n",
			drawname);
		return;
	}
	drop_pix2(dw,pixname);
}

drop_pix2(parent,pixname)
	DrawWidget	parent;
	char	*pixname;
{
	Pix		**pix;
	Pix		*temp;

	if (pixname == NULL){
		fprintf(stderr,"cannot find pix with NULL name in drop_pix2\n");
		return(NULL);
	}

	if (strcmp(&(pixname[strlen(pixname) - 4]),"icon") == 0) {
		pix = &(parent->draw.icons);
	} else {
		pix = &(parent->draw.images);
	}

	while(*pix) {
		if ((*pix)->name == NULL) {
			fprintf(stderr,"null pixname encountered in find_pix()\n");
		} else if (strcmp((*pix)->name,pixname) == 0)  {
			break;
		}
		pix = &((*pix)->next);
	}
	if (!drop_pix3(pix))
		fprintf(stderr,"pix '%s' not found in drop_pix2\n",pixname);
	if (strcmp(parent->draw.refresh_flag,"TRUE") == 0)
		XClearArea(XtDisplay(parent),XtWindow(parent),0,0,0,0,True);
}

/*
** drop_pix3 takes the address of the pointer to the pix, cleans out
** the pix being pointed to and returns the next pix in the pointer.
** The routine could do with a bit more careful work, and really
** to be object oriented each pix should have its own delete routine,
** but for now.....
*/
drop_pix3(pix)
	Pix		**pix;
{
	Pix		*temp;

	if (*pix) { /* clean out the pix */
		temp = *pix;
		*pix = (*pix)->next;

		if (temp->name) free(temp->name);
		if (temp->pts) free(temp->pts);
		if (temp->update) free(temp->update);
		if (temp->rescale) {
			if (temp->rescale->func == UseCoords) {
				if (((CoordRescale *)temp->rescale)->coords)
					free(((CoordRescale *)temp->rescale)->coords);
			}
			if (temp->rescale->func == UseElms) {
				if (((ElmRescale *)temp->rescale)->elms)
					free(((ElmRescale *)temp->rescale)->elms);
			}
			free(temp->rescale);
		}
		if (temp->hilight) free(temp->hilight);
		if (temp->resources) free(temp->resources);
		free(temp);
		return(1);
	} 
	return(0);
}


XoCopyPix(argc,argv)
	int		argc;
	char	**argv;
{
	if (argc < 6) {
		printf("usage: %s source_widget source_pix to dest_wiget dest_pix\n",
			argv[0]);
			return;
	}
	if (strcmp(argv[3],"to") != 0) {
		printf("usage: %s source_widget source_pix to dest_wiget dest_pix\n",
			argv[0]);
	}
	copy_pix(argv[1],argv[2],argv[4],argv[5]);
}

XoDropPix(argc,argv)
	int		argc;
	char	**argv;
{
	if (argc < 3) {
		printf("usage: %s widget pix\n", argv[0]);
		return;
	}
	drop_pix(argv[1],argv[2]);
}

XoScalePix(pix,center,size)
	Pix	*pix;
	int	center;
	Coord	size;
{
	Coord	*coords, *tempcoords;
	Coord	maxrange,minrange;
	float	scale_factor;
	Coord	delta;
	int		i;

	coords = ((CoordRescale *)pix->rescale)->coords;

	for (i = 0 ; i < pix->npts ; i++ ) {
		if (maxrange.x < coords[i].x)
			maxrange.x = coords[i].x;
		if (maxrange.y < coords[i].y)
			maxrange.y = coords[i].y;
		if (maxrange.z < coords[i].z)
			maxrange.z = coords[i].z;

		if (minrange.x > coords[i].x)
			minrange.x = coords[i].x;
		if (minrange.y > coords[i].y)
			minrange.y = coords[i].y;
		if (minrange.z > coords[i].z)
			minrange.z = coords[i].z;
	}

	if (center) {
		delta.x = (maxrange.x + minrange.x) /2.0;
		delta.y = (maxrange.y + minrange.y) /2.0;
		delta.z = (maxrange.z + minrange.z) /2.0;
		scale_factor = maxrange.x - minrange.x;
		if (scale_factor > EPSILON) {
			scale_factor = size.x / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].x = (coords[i].x - delta.x) * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].x = 0.0 ;
		}
		if (scale_factor > EPSILON) {
			scale_factor = size.y / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].y = (coords[i].y - delta.y) * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].y = 0.0 ;
		}
		if (scale_factor > EPSILON) {
			scale_factor = size.z / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].z = (coords[i].z - delta.z) * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].z = 0.0 ;
		}
	} else {
		scale_factor = maxrange.x - minrange.x;
		if (scale_factor > EPSILON) {
			scale_factor = size.x / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].x = coords[i].x * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].x = 0.0 ;
		}
		if (scale_factor > EPSILON) {
			scale_factor = size.y / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].y = coords[i].y * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].y = 0.0 ;
		}
		if (scale_factor > EPSILON) {
			scale_factor = size.z / scale_factor;
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].z = coords[i].z * scale_factor ;
		} else {
			for (i = 0 ; i < pix->npts ; i++ )
				coords[i].z = 0.0 ;
		}
	}
}
