static char rcsid[] = "$Id: image.c,v 1.1 1992/12/11 19:06:55 dhb Exp $";

/*
** $Log: image.c,v $
** Revision 1.1  1992/12/11  19:06:55  dhb
** Initial revision
**
*/

/* --------------------------------------------- */
/* The init routine for setting up a image pix.
 *
 *	By Upi Bhalla Feb 1990.
 *  If this code does not work it is not my fault.
 *	You may hack this code if the acknowledgement
 *	remains intact.
 *	Parts of the code are taken from xgif, by
 *	John Bradley, University of Pennsylvania, who in turn got
 *	portions of code from Patrick J. Naughton.
 *
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "imageP.h"
#include "xodus_defs.h"

Boolean ImageSetHook();
void ImageGetHook();
static char	*GetImageValue();
static int CleanImageHl();
int	DrawImage();

/* --------------------------------------------- */

static XtResource ImageResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,name),
        XtRString, "image"
    },
    {XtNfilename, XtCFilename, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,filename),
        XtRString, "image.gif"
    },
    {XtNfileformat, XtCFileformat, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,fileformat),
        XtRString, "gif"
    },
    {XtNstoremode, XtCStoremode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,storemode),
        XtRString, "mem"
    },
    {XtNrescaleable, XtCRescaleable, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,rescaleable),
        XtRString, "FALSE"
    },
    {XtNvalue, XtCValue, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,value),
        XtRString, "none"
    },
    {XtNox, XtCOx, XtRFloat, sizeof(float),
        XtOffset(ImagePixPtr,ox),
        XtRString, "0.0000000000"
    },
    {XtNoy, XtCOy, XtRFloat, sizeof(float),
        XtOffset(ImagePixPtr,oy),
        XtRString, "0.0000000000"
    },
    {XtNoz, XtCOz, XtRFloat, sizeof(float),
        XtOffset(ImagePixPtr,oz),
        XtRString, "0.0000000000"
    },
    {XtNsrcx, XtCSrcx, XtRInt, sizeof(int),
        XtOffset(ImagePixPtr,srcx),
        XtRString, "10"
    },
    {XtNsrcy, XtCSrcy, XtRInt, sizeof(int),
        XtOffset(ImagePixPtr,srcy),
        XtRString, "10"
    },
    {XtNwx, XtCWx, XtRInt, sizeof(int),
        XtOffset(ImagePixPtr,wx),
        XtRString, "10"
    },
    {XtNwy, XtCWy, XtRInt, sizeof(int),
        XtOffset(ImagePixPtr,wy),
        XtRString, "10"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(ImagePixPtr,hldispmode),
        XtRString, "star"
    },
};

static void Destroy();
void ImageDisplay();

static char translations[] = "";

static XtActionsRec actions[] = {
};

ImageClassRec imageClassRec = {
  { /* core fields */
    /* superclass       */  (WidgetClass) &widgetClassRec,
    /* class_name       */  "Image",
    /* widget_size      */  sizeof(ImageRec),
    /* class_initialize     */  NULL,
    /* class_part_initialize    */  NULL,
    /* class_inited     */  FALSE,
    /* initialize       */  ImageInitialise,
    /* initialize_hook      */  NULL,
    /* realize          */  ImageRealise,
    /* actions          */  actions,
    /* num_actions      */  XtNumber(actions),
    /* resources        */  ImageResources,
    /* num_resources        */  XtNumber(ImageResources),
    /* xrm_class        */  NULLQUARK,
    /* compress_motion      */  TRUE,
    /* compress_exposure    */  TRUE,
    /* compress_enterleave  */  TRUE,
    /* visible_interest     */  FALSE,
    /* destroy          */  NULL,
    /* resize           */  ImageResize,
    /* expose           */  NULL,
    /* set_values       */  NULL,
    /* set_values_hook      */  NULL,
    /* set_values_almost    */  XtInheritSetValuesAlmost,
    /* get_values_hook      */  NULL,
    /* accept_focus     */  NULL,
    /* version          */  XtVersion,
    /* callback_private     */  NULL,
    /* tm_table         */  translations,
    /* query_geometry       */  XtInheritQueryGeometry,
    /* display_accelerator  */  XtInheritDisplayAccelerator,
    /* extension        */  NULL
  },
  { /* image fields */
    /* empty            */  0
  }
};


WidgetClass imageWidgetClass = (WidgetClass)&imageClassRec;


static void ImageRealise(w,value_mask,attributes)
	ImageWidget w;
    XtValueMask *value_mask;
    XSetWindowAttributes *attributes;
{
    Window parent_window;

    parent_window = XtWindow(XtParent(w));
}
	

static void ImageInitialise(request,new)
    ImageWidget request,new;
{
}


void ImageResize(w)
	ImageWidget	w;
{
}

static void ImageExpose(w,event,region)
		ImageWidget w;
		XEvent	*event;
		Region	region;
{
}



static Boolean ImageSetValues(current,request,new)
	ImageWidget	current;
	ImageWidget	request;
	ImageWidget	new;
{
	Boolean do_redraw = FALSE;
	Boolean do_rescale = FALSE;

	if (strcmp(current->image.fileformat,request->image.fileformat) != 0 ||
	strcmp(current->image.filename,request->image.filename) != 0 ||
	strcmp(current->image.storemode,request->image.storemode) != 0 ||
/*
	strcmp(current->image.rescaleable,request->image.rescaleable)!=0 ||
	strcmp(current->image.value,request->image.value) != 0 ||
*/
	current->image.ox != request->image.ox ||
	current->image.oy != request->image.oy ||
	current->image.oz != request->image.oz ||
	current->image.srcx != request->image.srcx ||
	current->image.srcy != request->image.srcy ||
	current->image.wx != request->image.wx ||
	current->image.wy != request->image.wy)
		return(TRUE);
	else
		return(FALSE);
}

static void	ImageGetValues(pix,rl,args,nargs)
	ImagePix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

DrawImage(pict,pix)
	DrawPart	*pict;
	ImagePix	*pix;
{
	int dstx,dsty;

	dstx = pix->pts[0].x - atoi(pix->wx)/2;
	dsty = pix->pts[0].y - atoi(pix->wy)/2;

	if (pict->display && pict->d && pict->gc && pix->image)
		XPutImage(pict->display,pict->d,pict->gc,pix->image,
			atoi(pix->srcx),atoi(pix->srcy),dstx,dsty,
			atoi(pix->wx),atoi(pix->wy));
}

RescaleImage(pict,pix)
	DrawPart	*pict;
	ImagePix	*pix;
{
}

static char *
GetImageValue(pict,pix,index)
	DrawPart	*pict;
	ImagePix		*pix;
	int			index;
{
	char		*fillstr();

	if (pix->value)
		return(fillstr(pix->value));
	return(NULL);
}

static int CleanImageHl(pict,pix,index)
	DrawPart	*pict;
	ImagePix 	*pix;
	int			index;
{
	(pix->refresh_func)(pict,pix);
}

LoadImage(dw,pix)
	DrawWidget	dw;
	ImagePix	*pix;
{
	XImage	*UpiLoadGIF();

	int	screen;

	screen = XDefaultScreen(dw->draw.display);

	pix->image = UpiLoadGIF(pix->filename,dw->draw.display,	
		screen, XDefaultDepth(dw->draw.display,screen));
}

SetStoreMode()
{
}

ImageRescale()
{
}
