static char rcsid[] = "$Id: fileview_w.c,v 1.1 1992/12/11 19:06:53 dhb Exp $";

/*
** $Log: fileview_w.c,v $
** Revision 1.1  1992/12/11  19:06:53  dhb
** Initial revision
**
*/

/***************************************************************
**                                                            ** 
**                     fileview_w.c                           ** 
**                                                            ** 
**             By Upinder S. Bhalla 1988 Caltech              ** 
**                                                            ** 
**     Bugfixes by Bruce P. Graham JCSMR, ANU  16-5-91        ** 
**                                                            ** 
***************************************************************/

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "xodus_defs.h"
#include "xodus_ext.h"
#include "drawview_w.h"
#include "fileview_w.h"


char	*fillstr();
int 	FileViewUpdateFunc();

static char *GetFileViewValue();
static Boolean FileViewSetHook();
static void	FileViewGetHook();


/* --------------------------------------------- */

static XtResource FileViewResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, name),
        XtRString, "fileview"
    },
    {XtNpixcolor, XtCPixcolor, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, pixcolor),
        XtRString, "Black"
    },
    {XtNviewmode, XtCViewmode, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, viewmode),
        XtRString, "colorview"
    },
    {XtNviewicon, XtCViewicon, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, viewicon),
        XtRString, "fillbox.icon"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, hldispmode),
        XtRString, "star"
    },
    {XtNtime, XtCTime, XtRFloat, sizeof(float),
        XtOffset(FileViewPixPtr, time),
        XtRString, "0.0"
    },
    {XtNpath, XtCPath, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, path),
        XtRString, "/"
    },
    {XtNvmin, XtCVmin, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, vmin),
        XtRString, "0.0000000000000"
    },
    {XtNvmax, XtCVmax, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, vmax),
        XtRString, "100.0000000000000"
    },
    {XtNautoscale, XtCAutoscale, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, autoscale),
        XtRString, "TRUE"
    },
    {XtNnx, XtCNx, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, nx),
        XtRString, "10        "
    },
    {XtNny, XtCNy, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, ny),
        XtRString, "10            "
    },
    {XtNautospace, XtCAutospace, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, autospace),
        XtRString, "TRUE"
    },
    {XtNox, XtCOx, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, ox),
        XtRString, "0.00000000000000"
    },
    {XtNoy, XtCOy, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, oy),
        XtRString, "0.00000000000000"
    },
    {XtNoz, XtCOz, XtRString, sizeof(char *),
        XtOffset(FileViewPixPtr, oz),
        XtRString, "0.00000000000000"
    },
};


/*
** XoCreateFileView. This deals with creating a fileview
*/
Pix * 
XoCreateFileView(parent,args,num_args)
	DrawWidget	parent;
	ArgList	args;
	Cardinal	num_args;
{
	FileViewPix			*pix;
	Pix				*image,*icon;

	parent->draw.pixvalue = (char *) calloc(200,sizeof(char));
	pix = (FileViewPix *) calloc(1,sizeof(FileViewPix));
	
	image = parent->draw.images;
	icon = parent->draw.icons;

	XtGetSubresources(parent,pix,XtNimages,XtCPix,FileViewResources,
		XtNumber(FileViewResources),args,num_args);

	parent->draw.pixname = fillstr(pix->name);

	parent->draw.images = (Pix *)pix;
	pix->next = image;
	parent->draw.icons = icon;

	pix->resources = FileViewResources;
	pix->num_resources = XtNumber(FileViewResources);

	SetFileViewPix(parent,pix);
/*
** Now we can finally step in and set up the values as specified
** by args, since the resources and all have been set up
*/
	XoSetValuesFromStrings(parent,args,num_args);

	/*
	SetFileViewPath(parent,pix);
	*/
	if (!SetCoordViewRescale(parent,pix)) {
		fprintf(stderr,"Error in creating FileView Rescale\n");
		return(NULL);
	}
	if (!SetFileViewUpdate(parent,pix)) {
		fprintf(stderr,"Error in creating FileView update\n");
		return(NULL);
	}

	SetViewIcons(parent,pix);

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);

	pix->hilight->get_value = GetFileViewValue;
	pix->hilight->hl_clean_disp = CleanViewHl;

	SetPixColor(pix,pix->pixcolor);
	

	RescaleDraw(parent);
	(((CoordViewUpdate *)(pix->update))->func)(parent,pix);
	return((Pix *)pix);
}

SetFileViewPix(parent,pix)
	Widget	parent;
	FileViewPix	*pix;
{
	CoordViewUpdate		*update;
	CoordRescale		*rescale;

	pix->rescale = (Rescale *) calloc(1,sizeof(CoordRescale));
	pix->update = (Update *) calloc(1,sizeof(CoordViewUpdate));
	pix->refresh_func = ViewIcons;
	pix->set_hook = FileViewSetHook;
	pix->get_hook = FileViewGetHook;
}

int SetFileViewPath(parent,pix)
	Widget	parent;
	FileViewPix	*pix;
{
	CoordRescale	*rescale;
	Coord			*coords;
	int				ncoords = 0;

	if (!MattsGetCoordRoutine(pix->path,&coords,&ncoords))
		return;
	if (ncoords <= 0) return(0);

	if (pix->npts < ncoords) {
		if (pix->value) free(pix->value);
		pix->value = (int *) calloc(ncoords, sizeof(int));
	}

	load_pix_coords2(pix,coords,ncoords);
	rescale = (CoordRescale *)pix->rescale;
	sscanf(pix->ox,"%f",&(rescale->offset.x));
	sscanf(pix->oy,"%f",&(rescale->offset.y));
	sscanf(pix->oz,"%f",&(rescale->offset.z));
	return(1);
}

int SetFileViewUpdate(parent,pix)
	Widget	parent;
	FileViewPix	*pix;
{
	int		type = 0,offset = 0,nptrs = 0;
	CoordViewUpdate		*update;

	update = (CoordViewUpdate *) pix->update;
	update->func = FileViewUpdateFunc;
	update->vmin = Atof(pix->vmin);
	update->vmax = Atof(pix->vmax);
	update->autoscale = (strcmp(pix->autoscale,"TRUE") == 0);
	return(1);
}

int FileViewUpdateFunc(parent,pix)
	DrawWidget	parent;
	FileViewPix	*pix;
{
	int i;
	CoordViewUpdate *update;
	float	*value;
	int		*pixvalue;
	float	vmin,vmax;
	float	scale;
	int		offset;
	char	*e;

	if (pix->npts <= 0) return;
	value = (float *) malloc(pix->npts * sizeof(float));
	if (!MattsGetValuesRoutine(pix->path,pix->time,value))
		return;

	update = (CoordViewUpdate *)pix->update;

	if (update->autoscale) {
		vmax = vmin = value[0];
		for (i = 0 ; i < pix->npts; i++) {
			if (vmin > value[i])
				vmin = value[i];
			else if (vmax < value[i])
				vmax = value[i];
		}
		update->vmin = vmin;
		update->vmax = vmax;
		sprintf(pix->vmin,"%f",vmin);
		sprintf(pix->vmax,"%f",vmax);
	}

	if ((scale = update->vmax - update->vmin) < EPSILON) {
		free(value);
		return;
	}

	vmin = update->vmin;
	scale = (float)NICONS / scale;
	pixvalue = pix->value;
	for (i = 0 ; i < pix->npts; i++) {
		pixvalue[i] = (value[i] - vmin) * scale;
	}
	free(value);
	/*
	(pix->refresh_func)(&(parent->draw),pix);
	*/
	return(1);
}

SetCoordViewRescale(parent,pix)
	Widget	parent;
	FileViewPix		*pix;
{
	CoordRescale	*rescale;
	Coord			*coords;
	int			nptrs = pix->npts;
	int	i;
	float	xmax,ymax,zmax,xmin,ymin,zmin;
	float	x,y,z;
	float	dx,dy;
	float	lastx,lasty,lastz;
	float	stepx,stepy;
	int		nx,ny;

	if (!(rescale = (CoordRescale *)(pix->rescale))) return;
	coords = rescale->coords;

	if (nptrs > 0) {
		lastx = xmax = xmin = coords[0].x;
		lasty = ymax = ymin = coords[0].y;
		lastz = zmax = zmin = coords[0].z;
	} else {
		xmax = ymax = zmax = xmin = ymin = zmin = 0.0;
	}
/* Fix so that single elements are displayed ok (BPG 16-5-91) */
	/*stepx = stepy = BIG;*/
        if (nptrs == 1)
	  stepx = stepy = 1;
	else
	  stepx = stepy = BIG;
/* End of fix (BPG 2-5-91) */
	for (i = 1 ; i < nptrs ; i++) {
		x = coords[i].x;
		y = coords[i].y;
		z = coords[i].z;
		if (xmax < x)
			xmax = x;
		else if (xmin > x)
			xmin = x;
		if (ymax < y)
			ymax = y;
		else if (ymin > y)
			ymin = y;
		if (zmax < z)
			zmax = z;
		else if (zmin > z)
			zmin = z;
		dx = fabs(lastx - x);
		dy = fabs(lasty - y);
		if (dx > EPSILON && dx < stepx)
			stepx = dx;
		if (dy > EPSILON && dy < stepy)
			stepy = dy;
		lastx = x;
		lasty = y;
	}
	if (strcmp(pix->autospace,"TRUE") == 0) {
		nx = 1 + (xmax - xmin)/stepx;
		ny = 1 + (ymax - ymin)/stepy;
		if (nx * ny  < nptrs) {
			if (nx > ny)
				ny = 1 + nptrs/nx ;
			else
				nx = 1 + nptrs/ny ;
		}
		sprintf(pix->nx,"%d",nx);
		sprintf(pix->ny,"%d",ny);
	} else {
		sscanf(pix->nx,"%d",&nx);
		sscanf(pix->ny,"%d",&ny);
	}

/* Code imported from drawview_w.c to make it work (BPG 16-5-91) */
	if (fabs(xmax - xmin) < EPSILON) {
		if (stepy > EPSILON) {
			xmax += stepy/2.0;
			xmin -= stepy/2.0;
		} else
			xmax += 1.0;
	}
	if (fabs(ymax - ymin) < EPSILON) {
		if (stepx > EPSILON) {
			ymax += stepx/2.0;
			ymin -= stepx/2.0;
		} else
			ymax += 1.0;
	}
	if (xmax == xmin && stepy > EPSILON) {
		xmax += stepy/2.0;
		xmin -= stepy/2.0;
	}
	if (ymax == ymin && stepx > EPSILON) {
		ymax += stepx/2.0;
		ymin -= stepx/2.0;
	}
/* End of imported code */

	rescale->nx = nx;
	rescale->ny = ny;
	rescale->xmax = xmax; 
	rescale->xmin = xmin;
	rescale->ymax = ymax; 
	rescale->ymin = ymin;
	rescale->zmax = zmax; 
	rescale->zmin = zmin;
	return(1);
}

static char *
GetFileViewValue(pict,pix,index)
	DrawPart	*pict;
	FileViewPix	*pix;
	int		index;
{
	static char	path[20];

	sprintf(path,"%d",index);
	return(fillstr(path));
}

static Boolean FileViewSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	FileViewPix	*pix;
	char	**argnames;
	int		nargs;
{
	int		i;
	Boolean do_update = FALSE;
	Boolean do_rescale = FALSE;
	Boolean do_viewpath = FALSE;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpixcolor) == 0) {
			SetPixColor(parent,pix);
		} else if (strcmp(argnames[i],XtNviewmode) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNviewicon) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNpath) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNtime) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmin) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNvmax) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNautoscale) == 0) {
			do_update = TRUE;
		} else if (strcmp(argnames[i],XtNnx) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNny) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNautospace) == 0) {
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNox) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoy) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		} else if (strcmp(argnames[i],XtNoz) == 0) {
			do_viewpath = TRUE;
			do_rescale = TRUE;
		}
	}
	if (do_viewpath) {
		if (!SetFileViewPath(parent,pix)) return(FALSE);
	}
	if (do_rescale) {
		SetCoordViewRescale(parent,pix);
		SetViewIcons(parent,pix);
		RescaleDraw(parent);
	}
	if (do_update) {
		SetFileViewUpdate(parent,pix);
		FileViewUpdateFunc(parent,pix);
	}
	return(TRUE);
}

static void	FileViewGetHook(pix,rl,args,nargs)
	ViewPix	*pix;
	XrmResourceList	rl;
	ArgList	args;
	Cardinal	nargs;
{
}

#ifdef DUMMY
MattsGetCoordRoutine(filepath,coords,ncoords)
	char	*filepath;
	Coord	**coords;
	int		*ncoords;
{
}

MattsGetValuesRoutine(filepath,time,value)
	char	*filepath;
	float	time;
	float	*value;
{
}
#endif
