static char rcsid[] = "$Id: elmtree_w.c,v 1.1 1992/10/29 20:03:15 dhb Exp $";

/*
** $Log: elmtree_w.c,v $
 * Revision 1.1  1992/10/29  20:03:15  dhb
 * Initial revision
 *
*/

/* --------------------------------------------- */
/* The routine for setting up an element tree
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "elmtree_w.h"

#define	SINGLEELM 1
#define	ELMPLANE 2
#define MAXNLEAVES	500
#define MAXNSTEMS	1000
#define MAXDEPTH	50

extern	Widget x_ntw_get();
static Boolean ElmtreeSetHook();
static void ElmtreeGetHook();
char	*ElmtreeGetValue();



/* --------------------------------------------- */

static XtResource ElmtreeResources[] = {
    {XtNlinkmode, XtCLinkmode, XtRString, sizeof(char *),
        XtOffset(TreePixPtr, linkmode),
        XtRString, "both"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(TreePixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(TreePixPtr, hldispmode),
        XtRString, "star"
    },
    {XtNpath, XtCPath, XtRString, sizeof(char *),
        XtOffset(TreePixPtr, path),
        XtRString, "/"
    },
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(TreePixPtr, name),
        XtRString, "leaves"
    },
};


/* --------------------------------------------- */


typedef struct leaf_struct {
	Element	*elm;
	int		x,y;
	char	*type;
} Leaf ;

/**************************************************************/

Pix *
XoCreateElmtree(parent,args,num_args)
	DrawWidget  parent;
	ArgList args;
	Cardinal	num_args;
{
	TreePix		*pix;
	Pix			*image,*icon;
	char		*fillstr();

	pix = (TreePix *) calloc(1,sizeof(TreePix));

	image = parent->draw.images;
	icon = parent->draw.icons;

	XtGetSubresources(parent,pix,XtNimages,XtCPix,ElmtreeResources,
		XtNumber(ElmtreeResources),args,0);

	parent->draw.pixname = fillstr(pix->name);

	parent->draw.images = (Pix *)pix;
	pix->next = image;
	parent->draw.icons = icon;

	pix->resources = ElmtreeResources;
	pix->num_resources = XtNumber(ElmtreeResources);

	pix->text = (char **) calloc(MAXNLEAVES, sizeof(char *));
	pix->elms = (Element **) calloc(MAXNLEAVES, sizeof(Element *));
	pix->icons = (Pix **) calloc(MAXNLEAVES, sizeof(Pix *));
	pix->tree = (char *) calloc(MAXNLEAVES, sizeof(Leaf));
	pix->trunc = (Element **) calloc(MAXNLEAVES, sizeof(Element *));
	/* pix->rescale is set automatically by load_pix_coords */
	pix->update = (Update *) calloc(1,sizeof(Update));
	pix->update->func = UseCoords;
	pix->set_hook = ElmtreeSetHook;
	pix->get_hook = ElmtreeGetHook;
	pix->refresh_func = DrawTree;
	pix->color = "black";

	SetHlHistMode(pix,pix->hlhistmode);
	SetHlDispMode(pix,pix->hldispmode);
	pix->hilight->get_value = ElmtreeGetValue;
	pix->hilight->hl_clean_disp = CleanTreeHl;
	MakeElmtreeIcons(parent);

	DrawElmTree(parent,pix);
	
	return((Pix *)pix);
}


DrawElmTree(parent,pix)
	Widget	parent;
	TreePix	*pix;
{
	Element	*elm, *GetElement();
	Leaf	*tree;
	int		nleaves = 0;
	int		*widths;
	char	*iconname,*getobjenv();
	int	i;

	tree = (Leaf *) pix->tree;
	widths = (int *) calloc(MAXDEPTH, sizeof(int));

	elm = GetElement(pix->path);
	if(!elm) return;

	iconname = getobjenv(elm->object,"ICON");
	if (!iconname)
		iconname = "fillbox.icon";

	tree[nleaves].type = iconname;
	tree[nleaves].elm = elm;
	tree[nleaves].x = 0;
	tree[nleaves].y = 0;

	widths[0] = 1;
	nleaves = 1;

	if (IsOnList(elm,pix->trunc,pix->ntrunc) >= pix->ntrunc)
		CreateElmTree(elm->child,tree,&nleaves,widths,1,
			pix->trunc,pix->ntrunc);

	pix->nleaves = nleaves;

	/* find the depth of the tree */
	for (i = 0 ; i < MAXDEPTH && widths[i] != 0 ; i++);
	ArrangeTree(parent,tree,nleaves,widths,i);

	RescaleDraw(parent);
	free(widths);
}

MakeElmtreeIcons(parent)
	DrawWidget	parent;
{
    Coord   scale,offset, coords[5];
    Pix     *ScaleAndCopyIcon();
    Pix     *pix;
	DrawWidget	w;
	Widget	XoGetWidgetFromString();

    scale.x = 70; scale.y = 45 ; scale.z = 0;
    offset.x = 0; offset.y = 0 ; offset.z = 0;

	if (!(w = (DrawWidget)XoGetWidgetFromString("/xproto/draw")))
		return;
	for (pix = w->draw.icons ; pix ; pix = pix->next) {
    	append_pix(parent,ScaleAndCopyIcon(pix->name,scale,offset),1);  
	}
	if (!(pix = find_pix2(parent,"box.icon"))) { 
/* Creating box icon from scratch */
		pix = add_pix2(parent,"box,icon",sizeof(Pix));
		coords[0].x = -scale.x; coords[0].y = -scale.y;
		coords[0].z = -scale.z;
		coords[1] = scale; coords[1].x = -scale.x;
		coords[2] = scale; 
		coords[3] = scale; coords[3].y = -scale.y;
		coords[4] = coords[0];
		XoSetSimplePix2(parent,pix,coords,5,DrawLines,"Black");
	}
}

CreateElmTree(root_elm,tree,nleaves,width,depth,trunc,ntrunc)
	Element	*root_elm;
	Leaf	*tree;
	int		*nleaves;
	int		*width;
	int		depth;
	Element	**trunc;
	int		ntrunc;
{
	Element	*elm;
	char	*lastname = "";
	char	*iconname;

	elm = root_elm;
	while (elm != NULL) {
		if (strcmp(elm->name,lastname) == 0) {
			elm = elm->next;
			continue;
		}
		lastname = elm->name;
		iconname = getobjenv(elm->object,"ICON");
		if (!iconname)
			iconname = "fillbox.icon";

		if (elm->next != NULL) {
			if (elm->next->name != NULL) {
				if (strcmp(elm->next->name,lastname) == 0) {
					iconname = "plane.icon";
				}
			}
		} 

		tree[*nleaves].type = iconname;
		tree[*nleaves].elm = elm;
		tree[*nleaves].x = width[depth];
		tree[*nleaves].y = depth;

		width[depth]++;
		(*nleaves)++;
		if (IsOnList(elm,trunc,ntrunc) >= ntrunc)
			CreateElmTree(elm->child,tree,nleaves,width,depth + 1,
				trunc,ntrunc);

		elm = elm->next;
	}
}

ArrangeTree(w,tree,nleaves,width,depth)
	Widget	w;
	Leaf	*tree;
	int		nleaves;
	int		*width;
	int		depth;
{
	TreePix	*pix;
	Pix		*stempix,*msgpix;
	Coord	coords[MAXNLEAVES];
	Coord	stems[MAXNSTEMS];
	int		nstems = 0;
	Coord	msgs[MAXNSTEMS];
	int		nmsgs = 0;
	char	**labels;
	Pix		**icons;
	Element **elms;
	Element *find_elm;
	MsgOut	*msgout;
	Leaf	*parent;
	int		i,j;
	int		nx;
	float	dy,arrow_offset;

	if (depth <= 0) { /* should never happen */
		fprintf(stderr, "Tree has depth zero\n");
		return;
	}
	dy = 1000.0 / (float)depth;

	if (!(pix = (TreePix *)find_pix2(w,"leaves"))) {
		fprintf(stderr,"could not find pix 'leaves' on '%s'\n",
			w->core.name);
		return;
	}

	/* These have been set up (albeit with a fixed size) when the 
	** widget was created */
	labels = pix->text;
	icons = pix->icons;
	elms = pix->elms;
	/* This loop is slower than some of the nifty tricks I have
	** used before, but it is far more understandable.
	**
	** Finding the coords for the icons of the elements
	*/
	for (i = 0 ; i < nleaves ; i++) {
		/* nx is the number of leaves at the depth of this leaf. */
		nx = width[tree[i].y];
		if (nx <= 0) { /* should never happen !!!! */
			fprintf(stderr, "No leaves at depth %d\n",tree[i].y);
			continue;
		}
		coords[i].x = ((float)tree[i].x + 0.5) * 1000.0 /(float)nx;
		coords[i].y = ((float)tree[i].y + 0.5) * dy;
		coords[i].z = 0;

		if (IsOnList(tree[i].elm,pix->trunc,pix->ntrunc) < pix->ntrunc)
			icons[i] = find_pix2(w,"trunc.icon");
		else
			icons[i] = find_pix2(w,tree[i].type);
		if (!icons[i])
			icons[i] = find_pix2(w,"box.icon");

		labels[i] = tree[i].elm->name;
		elms[i] = tree[i].elm;
	}
	load_pix_coords2(pix,coords,nleaves);

	/*
	** Finding the coords for the stems in the tree
	*/
	stempix = add_pix2(w,"stems",sizeof(Pix));
	if (strcmp(pix->linkmode,"stems") == 0 ||
		strcmp(pix->linkmode,"both") == 0 ) {
		for (i = 0 ; i < nleaves ; i++) {
			/* Using a linear search since hashing is inefficient for 
			** small numbers. */
			find_elm = tree[i].elm->parent;
			for (j = 0 ; j < nleaves ; j++) {
				if (tree[j].elm == find_elm)
					break;
			}
			if (j < nleaves) {
				parent = &(tree[j]);
				stems[nstems].x = coords[i].x;
				stems[nstems].y = coords[i].y - 20;
				nstems++;
				stems[nstems].x =
					((float)parent->x + 0.5) * 1000.0 /
						(float)(width[parent->y]);
				stems[nstems].y = 30 + ((float)parent->y + 0.5) * dy;
				stems[nstems].z = 0;
				nstems++;
			} 
		}
		if (nstems > 0) {
			XoSetSimplePix2(w,stempix,stems,nstems,DrawSegs,"Black");
		} else {
			stempix->npts = 0;
		}
	} else
		stempix->npts = 0;

	/*
	** Finding the coords for the messages in the tree
	*/
	msgpix = add_pix2(w,"msgs",sizeof(Pix));
	if (strcmp(pix->linkmode,"msgs") == 0 ||
		strcmp(pix->linkmode,"both") == 0 ) {
		for (i = 0 ; i < nleaves ; i++) {
			for (msgout = tree[i].elm->msg_out ; msgout ;
				msgout = msgout->next) {
				find_elm = msgout->dst;
				for (j = 0 ; j < nleaves ; j++) {
					if (tree[j].elm == find_elm)
						break;
				}
				if (j < nleaves) {
					parent = &(tree[j]);
					arrow_offset = 60;
					if (parent->y >= tree[i].y)
						arrow_offset = -arrow_offset;
					msgs[nmsgs].x = coords[i].x;
					msgs[nmsgs].y = coords[i].y - arrow_offset;
					nmsgs++;
					if (parent->y == tree[i].y)
						arrow_offset = -arrow_offset;
					msgs[nmsgs].x = ((float)parent->x + 0.5) * 1000.0 /
						(float)(width[parent->y]);
					msgs[nmsgs].y =
						((float)parent->y + 0.5) * dy + arrow_offset;
					msgs[nmsgs].z = 0;
					nmsgs++;
				} 
			}
		}
		if (nmsgs > 0) {
			XoSetSimplePix2(w,msgpix,msgs,nmsgs,DrawArrows,"Blue");
		} else {
			msgpix->npts = 0;
		}
	} else
		msgpix->npts = 0;
}

/* --------------------------------------------- */


DrawTree(pict,pix)
	DrawPart	*pict;
	TreePix		*pix;
{
	Display	*display;
	Drawable	d = pict->d;
	GC		gc = pict->gc;
	int 		i;
	char		**text;
	XPoint	*pts;

	display = pict->display;
	text	 = pix->text;
	pts = pix->pts;
	DrawIcons(pict,pix);
	XSetForeground(display,gc,name_to_color(pix->color));
	XSetBackground(display,gc,
		XWhitePixel(display,XDefaultScreen(display)));
	for (i = 0 ; i < pix->npts; i++)
		XoFillCenteredString(display,d,gc,text[i],pts[i].x,pts[i].y);

	if (pix->hilight && pix->hilight->hl_refresh)
		(pix->hilight->hl_refresh)(pict,pix);
}

static Boolean ElmtreeSetHook(parent,pix,argnames,nargs)
	DrawWidget  parent;
	TreePix *pix;
	char	**argnames;
	int	 nargs;
{
	int	 i;

	if (nargs == 0) 
		return(FALSE);

	for (i = 0 ; i < nargs ; i++) {
		if (strcmp(argnames[i],XtNpath) == 0) {
			DrawElmTree(parent,pix);
		} else if (strcmp(argnames[i],XtNhlhistmode) == 0) {
			SetHlHistMode(pix,pix->hlhistmode);
		} else if (strcmp(argnames[i],XtNhldispmode) == 0) {
			SetHlDispMode(pix,pix->hldispmode);
		} else if (strcmp(argnames[i],XtNlinkmode) == 0) {
			DrawElmTree(parent,pix);
		}
	}
	return(TRUE);
}

static void ElmtreeGetHook(pix,rl,args,nargs)
	TreePix *pix;
	XrmResourceList rl;
	ArgList args;
	Cardinal	nargs;
{
}


char *
ElmtreeGetValue(pict,pix,index)
	DrawPart	*pict;
	TreePix	*pix;
	int		index;
{
	static char path[100];

	strcpy (path,Pathname(pix->elms[index]));

	return(fillstr(path));
}

int IsOnList(elm,elms,nelms)	/* finds if the elm is on the list */
	Element	*elm;
	Element	**elms;
	int		nelms;
{
	int		i;
	for (i = 0 ; i < nelms; i++)
		if (elm == elms[i])
			return(i);
	return(nelms);
}
	


XoTreeTrunc(argc,argv)
	int		argc;
	char	**argv;
{
	TreePix	*pix;
	Widget	w,XoGetWidgetFromString();
	int		i,j;
	int		ntrunc;
	Leaf	*tree;
	Element	*elm;
	Widget	XoGetWidgetFromString();

	if (argc < 3) {
		printf("usage : %s drawname element\n",argv[0]);
		return;
	}
	if (!(pix = (TreePix *)find_pix(argv[1],"leaves"))) {
		printf("could not find pix at '%s'\n",argv[1]);
		return;
	}
	w = XoGetWidgetFromString(argv[1]);
	if (!(elm = GetElement(argv[2]))) {
		printf("could not find element at '%s'\n",argv[2]);
		return;
	}
	tree = (Leaf *)pix->tree;
	for (i = 0 ; i < pix->nleaves ; i++) {
		if (tree[i].elm == elm) {
			if ((ntrunc = IsOnList(elm,pix->trunc,pix->ntrunc)) <
				pix->ntrunc) { /* Take it off list */
				pix->ntrunc--;
				for (j = ntrunc ; j < pix->ntrunc ; j++)
					pix->trunc[j] = pix->trunc[j + 1];
			} else { /* add it to list */
				pix->trunc[pix->ntrunc] = elm;
				pix->ntrunc++;
			}
			DrawElmTree(w,pix);
			XClearArea(XtDisplay(w),XtWindow(w),0,0,0,0,True);
			break;
		}
	}
	if (i >= pix->nleaves)
		printf("element '%s' not found on tree\n",argv[2]);
}
