static char rcsid[] = "$Id: drawtext_w.c,v 1.2 1993/06/29 23:00:25 dhb Exp $";

/*
** $Log: drawtext_w.c,v $
** Revision 1.2  1993/06/29  23:00:25  dhb
** X11R5 patches
**
** Revision 1.1  1992/12/11  19:06:50  dhb
** Initial revision
**
*/

/* --------------------------------------------- */
/* The init routine for setting up a drawpix.
 * Drawpixes let the user specify the contents of a 
 * draw widget from the text interface.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"
#include "xodus_defs.h"
#include "drawtext_w.h"


char	*fillstr();
static Boolean TextSetHook();
static void TextGetHook();
static char	*GetTextValues();
static int CleanTextHl();
int XoDrawText();
Boolean XoSetText2();



/* --------------------------------------------- */


static XtResource TextResources[] = {
    {XtNpixname, XtCPixname, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, name),
        XtRString, "texts"
    },
    {XtNhlhistmode, XtCHlhistmode, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, hlhistmode),
        XtRString, "lastone"
    },
    {XtNhldispmode, XtCHldispmode, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, hldispmode),
        XtRString, "star"
    },
    {XtNtextno, XtCTextno, XtRInt, sizeof(int),
        XtOffset(TextPixPtr, textno),
        XtRString, "0"
    },
    {XtNtextmode, XtCTextmode, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, textmode),
        XtRString, "draw"
    },
    {XtNtext, XtCText, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, text),
        XtRString, "Hello!!"
    },
    {XtNtextvalue, XtCTextvalue, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, textvalue),
        XtRString, "0"
    },
    {XtNiconname, XtCIconname, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, iconname),
        XtRString, ""
    },
    {XtNtextcolor, XtCTextcolor, XtRString, sizeof(char *),
        XtOffset(TextPixPtr, textcolor),
        XtRString, "Black"
    },
    {XtNlx, XtCLx, XtRFloat, sizeof(float),
        XtOffset(TextPixPtr, lx),
        XtRString, "0"
    },
    {XtNly, XtCLy, XtRFloat, sizeof(float),
        XtOffset(TextPixPtr, ly),
        XtRString, "0"
    },
    {XtNlz, XtCLz, XtRFloat, sizeof(float),
        XtOffset(TextPixPtr, lz),
        XtRString, "0"
    },
};




Pix *
XoCreateTextPix(parent,args,num_args)
	DrawWidget	parent;
#ifdef X11R5
	ArgList		args;
#else
	Arglist		args;
#endif
	Cardinal	num_args;
{
	TextPix	*pix;
	Pix	*image,*icon;
	CoordRescale	*rescale;
	int			i;

	pix = (TextPix *)calloc(1,sizeof(TextPix));

    image = parent->draw.images;
    icon = parent->draw.icons;

    XtGetSubresources(parent,pix,XtNimages,XtCPix,TextResources,
        XtNumber(TextResources),args,num_args);

    parent->draw.pixname = fillstr(pix->name);

    parent->draw.images = (Pix *)pix;
    pix->next = image;
    parent->draw.icons = icon;

    pix->resources = TextResources;
    pix->num_resources = XtNumber(TextResources);

    pix->textlist = (char **) calloc(MAXNLABELS, sizeof(char *));
    pix->textmodelist = (int *) calloc(MAXNLABELS, sizeof(int));
    pix->valuelist = (char **) calloc(MAXNLABELS, sizeof(char *));
    pix->iconlist = (Pix **) calloc(MAXNLABELS, sizeof(Pix *));
    pix->colorlist = (int *) calloc(MAXNLABELS, sizeof(int));
	/* Hack to make the initial colors be black */
	for (i = 0 ; i < MAXNLABELS ; i++)
	pix->colorlist[i] = 1;

	rescale = (CoordRescale *) calloc(1,sizeof(CoordRescale));
	rescale->func = UseCoords;
	rescale->coords = (Coord *) calloc(MAXNLABELS, sizeof(Coord));
	rescale->offset.x = rescale->offset.y = rescale->offset.z = 0.0;
	pix->pts = (XPoint *) calloc(MAXNLABELS, sizeof(XPoint));
	pix->rescale = (Rescale *) rescale;

    pix->update = (Update *) calloc(1,sizeof(Update));
    pix->update->func = UseCoords;
	pix->refresh_func = XoDrawText;
    pix->set_hook = TextSetHook;
    pix->get_hook = TextGetHook;

    SetHlHistMode(pix,pix->hlhistmode);
    SetHlDispMode(pix,pix->hldispmode);
    pix->hilight->get_value = GetTextValues;
    pix->hilight->hl_clean_disp = CleanTextHl;
	
	return((Pix *)pix);
}

#define TEXTMASK 1 << 1
#define TEXTMODEMASK 1 << 2
#define TEXTCOLORMASK 1 << 3
#define COORDMASK 1 << 4
#define VALUEMASK 1 << 5
#define HLHISTMODEMASK 1 << 6
#define HLDISPMODEMASK 1 << 7
#define TEXTNOMASK 1 << 8
#define ICONNAMEMASK 1 << 9
#define XCOORDMASK 1 << 10
#define YCOORDMASK 1 << 11
#define ZCOORDMASK 1 << 12


XoAddText(argc,argv)
	int		argc;
	char	**argv;
{
	Coord		coord;
	char		*textmode;
	char		*textcolor;
	int			textno;
	char		*drawname;
	char		*pixname;
	char		*text;
	int			color;
	char		*icon;
	char		*hlhistmode;
	char		*hldispmode;
	char		*field;
	char		*value;
	int			i,j;
	DrawWidget	dw;
	Widget		x_ntw_get();
	Pix			*pix;
	Arg			args[2];
	int			set_mask = 0;

	if (argc < 3) {
		printf("Usage : %s drawname pixname <-coord x y z>\n",argv[0]);
		printf("<-text text> <-textmode mode> <-textcolor colorname> \n");
		printf("<-textvalue value> <-iconname icon>\n");
		printf("<-hlhistmode hlhistmode> <-hldispmode hldispmode>\n");
		printf("<-textno text#> <-findname text>\n\n");
		printf("textmodes : draw, fill, nodraw. Colors : 1 - 255\n");
		printf("hlhistmodes : lastone, lasttwo, fwbf, fwbl\n");
		printf("hldispmodes : star, index, count, border, inverse\n");
		printf("\n");
		return;
	}

	drawname = argv[1];
	pixname = argv[2];
	text = "";
	textmode = "draw";
	color = 1;
	icon = NULL;
	hlhistmode = NULL;
	hldispmode = NULL;
	value = NULL;
	coord.x = coord.y = coord.z = 0.0;
	textno = 0;

	for (j = 3 ; j < argc ; j++) {
		if (argv[j][0] == '-') 
			field = argv[j] + 1;
		else 
			field = argv[j];
		if (strcmp(field,"coord") == 0) {
			set_mask |= COORDMASK;
			j++; sscanf(argv[j],"%f",&coord.x);
			j++; sscanf(argv[j],"%f",&coord.y);
			j++; sscanf(argv[j],"%f",&coord.z);
			continue;
		}
		if (strcmp(field,XtNtext) == 0) {
			set_mask |= TEXTMASK;
			j++;
			text = argv[j];
			continue;
		}
		if (strcmp(field,XtNtextmode) == 0) {
			set_mask |= TEXTMODEMASK;
			j++;
			textmode = argv[j];
			continue;
		}
		if (strcmp(field,XtNtextcolor) == 0) {
			set_mask |= TEXTCOLORMASK;
			j++;
			textcolor = argv[j];
			continue;
		}
		if (strcmp(field,XtNiconname) == 0) {
			set_mask |= ICONNAMEMASK;
			j++;
			icon = argv[j];
			continue;
		}
		if (strcmp(field,XtNhlhistmode) == 0) {
			set_mask |= HLHISTMODEMASK;
			j++;
			hlhistmode = argv[j];
			continue;
		}
		if (strcmp(field,XtNhldispmode) == 0) {
			set_mask |= HLDISPMODEMASK;
			j++;
			hldispmode = argv[j];
			continue;
		}
		if (strcmp(field,XtNtextvalue) == 0) {
			set_mask |= VALUEMASK;
			j++;
			value = argv[j];
			continue;
		}
		if (strcmp(field,XtNtextno) == 0) {
			set_mask |= TEXTNOMASK;
			j++;
			sscanf(argv[j],"%d",&textno);
			continue;
		}
	}
	XoSetText(drawname,pixname, textno,text,coord,textmode,
		textcolor,icon,hlhistmode,hldispmode,value,set_mask);
}

XoSetText(drawname,pixname, textno,text,coord,textmode,
	textcolor,icon,hlhistmode,hldispmode,value,set_mask)
	char		*drawname;
	char		*pixname;
	Coord		coord;
	char		*text;
	char		*textmode;
	char		*textcolor;
	char		*icon;
	char		*hlhistmode;
	char		*hldispmode;
	char		*value;
	int			textno;
	int			set_mask;
{
	DrawWidget	dw;
	Pix			*pix;
	Arg			args[2];

	if (!(dw = (DrawWidget)x_ntw_get(drawname))) return(FALSE);
	if (!(pix = find_pix2(dw,pixname))) {
		if (!set_mask)
			return;
		set_mask |= COORDMASK ;
		if (!(pix = XoCreateTextPix(dw,args,0)))
			return;
		else
			pix->name = fillstr(pixname);
	}
	if (XoSetText2(dw,pix,textno,text,coord,textmode,
		textcolor,icon,hlhistmode,hldispmode,value,set_mask)) {
		/*
		if (strlen(pixname) > 5 && 
			(strcmp(&(pixname[strlen(pixname) - 4]), "icon") == 0) )
			UseCoords(dw,pix,1);
		else 
			UseCoords(dw,pix,0);
	*/

		if (dw->draw.w && dw->draw.display && dw->draw.d && dw->draw.gc)
			XoDrawText(&(dw->draw),pix);
		return;
	} else {
		printf("could not set text for %s\n",text);
	}
}

Boolean XoSetText2(dw,pix,textno,text,coord,textmode,
	textcolor,icon,hlhistmode,hldispmode,value,set_mask)
	DrawWidget	dw;
	TextPix	*pix;
	Coord		coord;
	char		*text;
	char		*textmode;
	char		*textcolor;
	char		*icon;
	char		*hlhistmode;
	char		*hldispmode;
	char		*value;
	int			textno;
	int			set_mask;
{

	CoordRescale	*rescale;
	int			(*pixfunc)();
	int			i;

/* 
** Decide which text to operate on. If textno is < 0 then 
** use the text string to look for a text. If no text is 
** found, then create a new one.
*/
	if (!set_mask) return(FALSE);
	if (!(set_mask & TEXTNOMASK)) { /* use the text to find it */
		/* if no text search string, assume the last entry */
		if (!(set_mask & TEXTMASK)) {
			textno = pix->npts - 1;
			if (textno < 0) textno = 0;
		} else {
			for (i = 0 ; i < pix->npts ; i++)
				if ((strlen(pix->textlist[i]) > 0) &&
					(strcmp(pix->textlist[i],text) == 0))
					break;
			textno = i;
		}
	}
	if (textno >= pix->npts) {
		textno = pix->npts;
		if (textno >= (MAXNLABELS - 1)) {
			fprintf(stderr, "Max no of texts reached.\n");
			fprintf(stderr, "Flexible limit will be implemented soon\n");
		} else 
			pix->npts++;
	}

/*
** Set the actual text values. 
*/
	if (set_mask & TEXTMASK) {
		if (pix->textlist[textno]) free(pix->textlist[textno]);
		pix->textlist[textno] = fillstr(text);
	}

	if (set_mask & COORDMASK) 
		((CoordRescale *)(pix->rescale))->coords[textno] = coord;

	if (set_mask & XCOORDMASK) 
		((CoordRescale *)(pix->rescale))->coords[textno].x = coord.x;

	if (set_mask & YCOORDMASK) 
		((CoordRescale *)(pix->rescale))->coords[textno].y = coord.y;

	if (set_mask & ZCOORDMASK) 
		((CoordRescale *)(pix->rescale))->coords[textno].z = coord.z;

	if (set_mask & TEXTMODEMASK) {
		if (strcmp(textmode,"fill") == 0) 
			pix->textmodelist[textno] = 1;
		else if (strcmp(textmode,"draw") == 0) 
			pix->textmodelist[textno] = 0;
		else pix->textmodelist[textno] = -1;
	}
	
	if (set_mask & TEXTCOLORMASK)  {
		pix->colorlist[textno] = name_to_color(textcolor);
		pix->textcolor = (char *)g_copy(textcolor);
	}
	
	if (set_mask & ICONNAMEMASK)
		pix->iconlist[textno] = find_pix2(dw,icon);
	
	if (set_mask & HLHISTMODEMASK) {
		pix->hlhistmode = fillstr(hlhistmode);
		SetHlHistMode(pix,pix->hlhistmode);
	}
	if (set_mask & HLDISPMODEMASK) {
		pix->hldispmode = fillstr(hldispmode);
		SetHlDispMode(pix,pix->hldispmode);
	}
	if (set_mask & VALUEMASK)
		pix->valuelist[textno] = fillstr(value);


	pix->textno = textno;
	pix->color = (char *)g_copy(textcolor);
	/*pix->colorlist[textno]; - JDU*/
	switch (pix->textmodelist[textno]) {
		case -1 : pix->textmode = "nodraw";
			break;
		case 1 : pix->textmode = "fill";
			break;
		default : pix->textmode = "draw";
			break;
	}
	pix->text = pix->textlist[textno];
	pix->textvalue = pix->valuelist[textno];
	if (pix->iconlist[textno])
		pix->iconname = pix->iconlist[textno]->name;
	pix->lx = ((CoordRescale *)(pix->rescale))->coords[textno].x;
	pix->ly = ((CoordRescale *)(pix->rescale))->coords[textno].y;
	pix->lz = ((CoordRescale *)(pix->rescale))->coords[textno].z;

	if (strlen(pix->name) > 5 && 
		(strcmp(&(pix->name[strlen(pix->name) - 4]), "icon") == 0) )
		UseCoords(dw,pix,1);
	else 
		UseCoords(dw,pix,0);
	return(set_mask != 0);
}


int XoDrawText(pict,pix)
	DrawPart	*pict;
	TextPix	*pix;
{
	int i;

	for ( i = 0 ; i < pix->npts ; i++) {
		if (pix->iconlist[i]) {
			DrawOneIcon(pict,pix->iconlist[i],pix->pts[i].x,
				pix->pts[i].y);
		}
		XSetForeground(pict->display,pict->gc,pix->colorlist[i]);
		XSetBackground(pict->display,pict->gc,0);
		if (pix->textlist[i]) {
			if (pix->textmodelist[i] == 0)
				XoDrawCenteredString(pict->display,pict->d,pict->gc,
					pix->textlist[i],pix->pts[i].x,pix->pts[i].y);
			else if (pix->textmodelist[i] == 1)
				XoFillCenteredString(pict->display,pict->d,pict->gc,
					pix->textlist[i],pix->pts[i].x,pix->pts[i].y);
		}
	}
}

int DrawOneIcon(pict,pixicon,x,y)
	DrawPart		*pict;
	Pix				*pixicon;
	int				x,y;
{
	int i,j;
	Pix **icons,*icon;
	int niconpts = 0;
	XPoint  *pts,*oldpts,*pixpts;
	short   h;

	h = pict->w->core.height;

	niconpts = pixicon->npts;
	pts = (XPoint *) malloc(niconpts * sizeof(XPoint));

	oldpts = pixicon->pts;
	for (j = 0 ; j < niconpts ; j++) {
		pts[j].x = oldpts[j].x + x;
		pts[j].y = oldpts[j].y + y - h;
	}
	pixicon->pts = pts;
	XSetForeground(pict->display,pict->gc,name_to_color(pixicon->color));
	(pixicon->refresh_func)(pict,pixicon);
	pixicon->pts = oldpts;

	free(pts);
}

static Boolean TextSetHook(parent,pix,argnames,nargs)
	DrawWidget	parent;
	TextPix	*pix;
	char		**argnames;
	int			nargs;
{
	Coord		coord;
	char		*field;
	int			j;
	int			set_mask = 0;

	coord.x = pix->lx;
	coord.y = pix->ly;
	coord.z = pix->lz;

	for (j = 0 ; j < nargs ; j++) {
		field = argnames[j];
		if (strcmp(field,XtNlx) == 0) {
			set_mask |= XCOORDMASK;
			continue;
		}
		if (strcmp(field,XtNly) == 0) {
			set_mask |= YCOORDMASK;
			continue;
		}
		if (strcmp(field,XtNlz) == 0) {
			set_mask |= ZCOORDMASK;
			continue;
		}
		if (strcmp(field,XtNtext) == 0) {
			set_mask |= TEXTMASK;
			continue;
		}
		if (strcmp(field,XtNtextmode) == 0) {
			set_mask |= TEXTMODEMASK;
			continue;
		}
		if (strcmp(field,XtNtextcolor) == 0) {
			set_mask |= TEXTCOLORMASK;
			continue;
		}
		if (strcmp(field,XtNiconname) == 0) {
			set_mask |= ICONNAMEMASK;
			continue;
		}
		if (strcmp(field,XtNhlhistmode) == 0) {
			set_mask |= HLHISTMODEMASK;
			continue;
		}
		if (strcmp(field,XtNhldispmode) == 0) {
			set_mask |= HLDISPMODEMASK;
			continue;
		}
		if (strcmp(field,XtNtextvalue) == 0) {
			set_mask |= VALUEMASK;
			continue;
		}
		if (strcmp(field,XtNtextno) == 0) {
			set_mask |= TEXTNOMASK;
			continue;
		}
	}

	return(XoSetText2(parent,pix,pix->textno,pix->text,
		coord,pix->textmode,pix->textcolor,pix->iconname,
		pix->hlhistmode,pix->hldispmode,pix->textvalue,set_mask));
}

static void TextGetHook(pix,rl,args,nargs)
	TextPix	*pix;
	XrmResourceList	rl;
	Arglist	args;
	Cardinal	nargs;
{
}

static char *
GetTextValues(pict,pix,index)
	DrawPart	*pict;
	TextPix	*pix;
	int			index;
{
	if (index >= 0 && index < pix->npts) {
		if (pix->valuelist[index]) {

			pix->textno = index;
			if (pix->textmodelist[index] == 0)
				pix->textmode = "draw";
			else if (pix->textmodelist[index] == 1)
				pix->textmode = "fill";
			else 
				pix->textmode = "nodraw";
			pix->text = pix->textlist[index];
/*	JDU		pix->textcolor = pix->colorlist[index];*/
			pix->textvalue = pix->valuelist[index];
			if (pix->iconlist[index])
				pix->iconname = pix->iconlist[index]->name;
			pix->lx =((CoordRescale *)(pix->rescale))->coords[index].x;
			pix->ly =((CoordRescale *)(pix->rescale))->coords[index].y;
			pix->lz =((CoordRescale *)(pix->rescale))->coords[index].z;

			return(pix->valuelist[index]);
		} else
			fprintf(stderr,"No value specified for text '%d'\n",index);
	}
	fprintf(stderr,"Hilight index '%d' out of range\n",index);
	return("");
}

static int CleanTextHl(pict,pix,index)
	DrawPart	*pict;
	TextPix	*pix;
	int			index;
{
	if (pix->iconlist[index]) {
		DrawOneIcon(pict,pix->iconlist[index],pix->pts[index].x,
			pix->pts[index].y);
	}
	XSetForeground(pict->display,pict->gc,pix->colorlist[index]);
	XSetBackground(pict->display,pict->gc,0);
	if (pix->textlist[index]) {
		if (pix->textmodelist[index] == 0)
			XoDrawCenteredString(pict->display,pict->d,pict->gc,
				pix->textlist[index],pix->pts[index].x,pix->pts[index].y);
		else if (pix->textmodelist[index] == 1)
			XoFillCenteredString(pict->display,pict->d,pict->gc,
				pix->textlist[index],pix->pts[index].x,pix->pts[index].y);
	}
}

XoListText(argc,argv)
	int		argc;
	char	**argv;
{
	Coord	coord;
	int		i;
	TextPix	*pix;

	if (argc < 3) {
        printf("usage : %s drawname pixname\n",argv[0]);
        return;
    }
	if (!(pix = (TextPix *)find_pix(argv[1],argv[2]))) return;

	if (pix->refresh_func != XoDrawText) 
		fprintf(stderr,"pix '%s' is not a text pix\n",argv[2]);

    printf("Texts for pix '%s' on widget '%s' : \n",argv[2],argv[1]);
    for (i = 0 ; i < pix->npts ; i++) {
		coord = ((CoordRescale *)(pix->rescale))->coords[i];
		if (pix->iconlist[i])
        	printf("text[%d] = '%s' at (%f,%f,%f), icon = '%s'\n",
				i,pix->textlist[i],coord.x,coord.y,coord.z,
				pix->iconlist[i]->name);
		else
        	printf("text[%d] = '%s' at (%f,%f,%f), no icon \n",
				i,pix->textlist[i],coord.x,coord.y,coord.z);
	}
}

