static char rcsid[] = "$Id: drawpix_w.c,v 1.1 1992/12/11 19:06:48 dhb Exp $";

/*
** $Log: drawpix_w.c,v $
** Revision 1.1  1992/12/11  19:06:48  dhb
** Initial revision
**
*/

/* --------------------------------------------- */
/* The init routine for setting up a drawpix.
 * Drawpixes let the user specify the contents of a 
 * draw widget from the text interface.
 *
 *	By Upi Bhalla
 */
/* --------------------------------------------- */

/* All the necessary include files */

#include "draw_ext.h"
#include "draw_funcs.h"

char	*fillstr();

/* --------------------------------------------- */

/*
**	Allowed modes are ..
** DrawPoints();
** DrawLines();
** DrawRects();
** DrawSegs();
** DrawArrows();
** FillRects();
** FillPoly();
** CFillPoly();
** DrawColoredLines();
** DrawFatLines();
	* We have an array of subpixes which tell the draw routine 
	* the range of Xpoints  which they refer to and the values
	* for text, icons, value, mode and color. This is ugly, and
	* I would have preferred to use separate pixes for each, but
	* space is at a premium and it is an easier hack?
*/


XoAddDrawPix(argc,argv)
	int		argc;
	char	**argv;
{
	char	*drawname;
	char	*pixname;
	char	*mode;
	char	*colorname;

	Coord	*coords;
	int		ncoords = 0;
	int		(*pixfunc)() = DrawLines;
	int		color;
	int		i,j;
	DrawWidget	dw;
	Pix			*pix;

	if (argc < 3) {
		printf("Usage : %s drawname pixname \n",argv[0]);
		printf("<-coords x y z <, x y z> <, x y z>....>\n");
		printf("<-mode mode> <-color colorname>\n");
		printf("Spaces must be left around the commas\n");
		printf("modes : DrawPoints DrawLines DrawRects DrawSegs\n");
		printf(" DrawArrows FillRects FillPoly CFillPoly\n");
		return;
	}

	drawname = argv[1];
	pixname = argv[2];
	mode = NULL;
	colorname = NULL;
	color = -1;


	for (j = 3 ; j < argc ; j++) {
		if (argv[j][0] == '-') {
			if (strcmp(&(argv[j][1]),"coords") == 0) {
				j++;
				ncoords = 1;
				for (i = j + 3 ; i < argc ; i++)
					if (argv[i][0] == ',') ncoords ++;
				coords = (Coord *) calloc(ncoords,sizeof(Coord));

				for (i = 0 ; i < ncoords ; i++) {
					if (i > 0) {
						if (argv[j][0] == ',') j++ ;
						else break;
					}
					if (sscanf(argv[j],"%f",&coords[i].x)) j++ ;
					else break;
					if (sscanf(argv[j],"%f",&coords[i].y)) j++ ;
					else break;
					if (sscanf(argv[j],"%f",&coords[i].z)) j++ ;
					else break;
				}
				if (i < ncoords) {
					fprintf(stderr,"coordinate syntax incorrect: '%s'\n",argv[j]);
					printf("Spaces must be left around the commas\n");
					return;
				}
				j--;
				continue;
			}
			if (strcmp(&(argv[j][1]),"mode") == 0) {
				j++;
				mode = argv[j];
				continue;
			}
			if (strcmp(&(argv[j][1]),"color") == 0) {
				j++;
				colorname = argv[j];
				continue;
			}
		}
	}
	XoSetSimplePix(drawname,pixname,coords,ncoords,mode,colorname);
}

Xo2dAddPts(argc,argv)
	int		argc;
	char	**argv;
{
	if (argc < 6) {
		printf("Usage : %s drawname pixname x y <,x y> <,x y>....\n",argv[0]);
		printf("<-mode mode> <-color colorname>\n");
		return;
	}
}

XoSetSimplePix(drawname,pixname,coords,ncoords,mode,colorname)
	char	*drawname;
	char	*pixname;
	Coord	*coords;
	int		ncoords;
	char	*mode;
	char	*colorname;
{
	DrawWidget	dw;
	Pix			*pix;
	int			(*pixfunc)();
	int			len, is_icon = 0;
	int		color;

	dw = (DrawWidget)x_ntw_get(drawname);
	pix = add_pix2(dw,pixname,sizeof(Pix));
	if (!dw || !pix ) {
		fprintf(stderr,"error in XoSetSimplePix\n");
		return(0);
	}
	if ((!pix->pts || pix->npts == 0) &&
		(!coords || ncoords == 0)) {
		fprintf(stderr,"error in XoSetSimplePix\n");
		return(0);
	}

	if (mode) {
		if (strcmp(mode,"DrawPoints") == 0 ||
			strcmp(mode,"DrawLines") == 0 ||
			strcmp(mode,"DrawRects") == 0 ||
			strcmp(mode,"DrawSegs") == 0 ||
			strcmp(mode,"DrawArrows") == 0  || 
			strcmp(mode,"FillRects") == 0 ||
			strcmp(mode,"FillPoly") == 0 ||
			strcmp(mode,"CFillPoly") == 0)
				pix->refresh_func = (PFI)(FuncTableFindFunc(mode));
		else 
			fprintf(stderr,"draw mode `%s` not valid\n",mode);
	}
	if (!(pix->refresh_func)) { /* this is a new drawpix */
		pix->refresh_func = DrawLines;
	}
	
	color = name_to_color(colorname);
	if (color >= 0 && color < 256) /* always true here JDU*/
		pix->color = (char *)g_copy(colorname); 
	else if (!pix->pts || pix->npts == 0) /* this is a new drawpix */
		pix->color = (char *)g_copy("Black");

	if (ncoords > 0)
		load_pix_coords2(pix,coords,ncoords);
	/* should really be setting these values from XtSetValues so
	** we dont have to worry about refreshes */
	if ((len = strlen(pixname)) > 5)
		if (strcmp(&(pixname[len-4]),"icon") == 0)
			is_icon = 1;
	UseCoords(dw,pix,is_icon);
	XClearWindow(XtDisplay(dw),XtWindow(dw));
}

XoSetSimplePix2(dw,pix,coords,ncoords,pixfunc,colorname)
	DrawWidget	dw;
	Pix			*pix;
	int			(*pixfunc)();
	Coord	*coords;
	int		ncoords;
	char	*colorname;
{
	int	color;
	if (!dw || !pix || !pixfunc || !coords || ncoords == 0) {
		fprintf(stderr,"error in XoSetSimplePix2\n");
		return(0);
	}

	pix->refresh_func = pixfunc;

	color = name_to_color(colorname);
	if (color >= 0 && color < 256)
		pix->color = (char *)g_copy(colorname);

	if (ncoords > 0)
		load_pix_coords2(pix,coords,ncoords);
}

XoShowDrawPix(argc,argv)
	int		argc;
	char	**argv;
{
	char	*drawname;
	char	*pixname;
	Pix		*pix;
	Coord	*coords;
	int		npts;
	int		i;

	if (argc < 3) {
		printf("Usage : %s drawname pixname \n",argv[0]);
		printf("<-coords n>\n");
		return;
	}

	drawname = argv[1];
	pixname = argv[2];

	pix = find_pix(drawname,pixname);

	printf("name		: %s\n",pix->name);
	printf("mode		: %d\n",pix->refresh_func);
	printf("color		: %s\n",pix->color);

	if (argc == 5) {
		sscanf(argv[4],"%d",&npts);
	} else {
		npts = pix->npts;
	}
	if (npts <= 0) return;
	if (npts > pix->npts) 
		npts = pix->npts;

	coords = ((CoordRescale *)pix->rescale)->coords;
	printf("coords : \n");
	printf("%6s : (%10s,%10s,%10s)\n","index","x","y","z");
	for (i = 0 ; i < npts ; i++)
		printf("%6d : (%10f,%10f,%10f)\n",i,
			coords[i].x, coords[i].y, coords[i].z);
}
